/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.lakefs.clients.sdk.JSON;
import io.lakefs.clients.sdk.model.StagingLocation;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StagingMetadata {
    public static final String SERIALIZED_NAME_STAGING = "staging";
    @SerializedName(value="staging")
    private StagingLocation staging;
    public static final String SERIALIZED_NAME_CHECKSUM = "checksum";
    @SerializedName(value="checksum")
    private String checksum;
    public static final String SERIALIZED_NAME_SIZE_BYTES = "size_bytes";
    @SerializedName(value="size_bytes")
    private Long sizeBytes;
    public static final String SERIALIZED_NAME_USER_METADATA = "user_metadata";
    @SerializedName(value="user_metadata")
    private Map<String, String> userMetadata = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_CONTENT_TYPE = "content_type";
    @SerializedName(value="content_type")
    private String contentType;
    public static final String SERIALIZED_NAME_FORCE = "force";
    @SerializedName(value="force")
    private Boolean force = false;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public StagingMetadata staging(StagingLocation staging) {
        this.staging = staging;
        return this;
    }

    @Nonnull
    public StagingLocation getStaging() {
        return this.staging;
    }

    public void setStaging(StagingLocation staging) {
        this.staging = staging;
    }

    public StagingMetadata checksum(String checksum) {
        this.checksum = checksum;
        return this;
    }

    @Nonnull
    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public StagingMetadata sizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    @Nonnull
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public StagingMetadata userMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    public StagingMetadata putUserMetadataItem(String key, String userMetadataItem) {
        if (this.userMetadata == null) {
            this.userMetadata = new HashMap<String, String>();
        }
        this.userMetadata.put(key, userMetadataItem);
        return this;
    }

    @Nullable
    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    public StagingMetadata contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public StagingMetadata force(Boolean force) {
        this.force = force;
        return this;
    }

    @Nullable
    public Boolean getForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public StagingMetadata putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StagingMetadata stagingMetadata = (StagingMetadata)o;
        return Objects.equals(this.staging, stagingMetadata.staging) && Objects.equals(this.checksum, stagingMetadata.checksum) && Objects.equals(this.sizeBytes, stagingMetadata.sizeBytes) && Objects.equals(this.userMetadata, stagingMetadata.userMetadata) && Objects.equals(this.contentType, stagingMetadata.contentType) && Objects.equals(this.force, stagingMetadata.force) && Objects.equals(this.additionalProperties, stagingMetadata.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.staging, this.checksum, this.sizeBytes, this.userMetadata, this.contentType, this.force, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StagingMetadata {\n");
        sb.append("    staging: ").append(this.toIndentedString(this.staging)).append("\n");
        sb.append("    checksum: ").append(this.toIndentedString(this.checksum)).append("\n");
        sb.append("    sizeBytes: ").append(this.toIndentedString(this.sizeBytes)).append("\n");
        sb.append("    userMetadata: ").append(this.toIndentedString(this.userMetadata)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    force: ").append(this.toIndentedString(this.force)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StagingMetadata is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        StagingLocation.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STAGING));
        if (!jsonObj.get(SERIALIZED_NAME_CHECKSUM).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `checksum` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHECKSUM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `content_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE).toString()));
        }
    }

    public static StagingMetadata fromJson(String jsonString) throws IOException {
        return (StagingMetadata)JSON.getGson().fromJson(jsonString, StagingMetadata.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_STAGING);
        openapiFields.add(SERIALIZED_NAME_CHECKSUM);
        openapiFields.add(SERIALIZED_NAME_SIZE_BYTES);
        openapiFields.add(SERIALIZED_NAME_USER_METADATA);
        openapiFields.add(SERIALIZED_NAME_CONTENT_TYPE);
        openapiFields.add(SERIALIZED_NAME_FORCE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_STAGING);
        openapiRequiredFields.add(SERIALIZED_NAME_CHECKSUM);
        openapiRequiredFields.add(SERIALIZED_NAME_SIZE_BYTES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!StagingMetadata.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StagingMetadata.class));
            return new TypeAdapter<StagingMetadata>(){

                public void write(JsonWriter out, StagingMetadata value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public StagingMetadata read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    StagingMetadata.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    StagingMetadata instance = (StagingMetadata)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

