/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.model.ExternalPrincipal;
import io.lakefs.clients.sdk.model.ExternalPrincipalCreation;
import io.lakefs.clients.sdk.model.ExternalPrincipalList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ExternalApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ExternalApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExternalApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createUserExternalPrincipalCall(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ExternalPrincipalCreation localVarPostBody = externalPrincipalCreation;
        String localVarPath = "/auth/users/{userId}/external/principals".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (principalId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("principalId", principalId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createUserExternalPrincipalValidateBeforeCall(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createUserExternalPrincipal(Async)");
        }
        if (principalId == null) {
            throw new ApiException("Missing the required parameter 'principalId' when calling createUserExternalPrincipal(Async)");
        }
        return this.createUserExternalPrincipalCall(userId, principalId, externalPrincipalCreation, _callback);
    }

    private ApiResponse<Void> createUserExternalPrincipalWithHttpInfo(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation) throws ApiException {
        Call localVarCall = this.createUserExternalPrincipalValidateBeforeCall(userId, principalId, externalPrincipalCreation, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call createUserExternalPrincipalAsync(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createUserExternalPrincipalValidateBeforeCall(userId, principalId, externalPrincipalCreation, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcreateUserExternalPrincipalRequest createUserExternalPrincipal(String userId, String principalId) {
        return new APIcreateUserExternalPrincipalRequest(userId, principalId);
    }

    private Call deleteUserExternalPrincipalCall(String userId, String principalId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/external/principals".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (principalId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("principalId", principalId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUserExternalPrincipalValidateBeforeCall(String userId, String principalId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteUserExternalPrincipal(Async)");
        }
        if (principalId == null) {
            throw new ApiException("Missing the required parameter 'principalId' when calling deleteUserExternalPrincipal(Async)");
        }
        return this.deleteUserExternalPrincipalCall(userId, principalId, _callback);
    }

    private ApiResponse<Void> deleteUserExternalPrincipalWithHttpInfo(String userId, String principalId) throws ApiException {
        Call localVarCall = this.deleteUserExternalPrincipalValidateBeforeCall(userId, principalId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteUserExternalPrincipalAsync(String userId, String principalId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteUserExternalPrincipalValidateBeforeCall(userId, principalId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIdeleteUserExternalPrincipalRequest deleteUserExternalPrincipal(String userId, String principalId) {
        return new APIdeleteUserExternalPrincipalRequest(userId, principalId);
    }

    private Call getExternalPrincipalCall(String principalId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/external/principals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (principalId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("principalId", principalId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExternalPrincipalValidateBeforeCall(String principalId, ApiCallback _callback) throws ApiException {
        if (principalId == null) {
            throw new ApiException("Missing the required parameter 'principalId' when calling getExternalPrincipal(Async)");
        }
        return this.getExternalPrincipalCall(principalId, _callback);
    }

    private ApiResponse<ExternalPrincipal> getExternalPrincipalWithHttpInfo(String principalId) throws ApiException {
        Call localVarCall = this.getExternalPrincipalValidateBeforeCall(principalId, null);
        Type localVarReturnType = new TypeToken<ExternalPrincipal>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getExternalPrincipalAsync(String principalId, ApiCallback<ExternalPrincipal> _callback) throws ApiException {
        Call localVarCall = this.getExternalPrincipalValidateBeforeCall(principalId, _callback);
        Type localVarReturnType = new TypeToken<ExternalPrincipal>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetExternalPrincipalRequest getExternalPrincipal(String principalId) {
        return new APIgetExternalPrincipalRequest(principalId);
    }

    private Call listUserExternalPrincipalsCall(String userId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/external/principals/ls".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUserExternalPrincipalsValidateBeforeCall(String userId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listUserExternalPrincipals(Async)");
        }
        return this.listUserExternalPrincipalsCall(userId, prefix, after, amount, _callback);
    }

    private ApiResponse<ExternalPrincipalList> listUserExternalPrincipalsWithHttpInfo(String userId, String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listUserExternalPrincipalsValidateBeforeCall(userId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<ExternalPrincipalList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUserExternalPrincipalsAsync(String userId, String prefix, String after, Integer amount, ApiCallback<ExternalPrincipalList> _callback) throws ApiException {
        Call localVarCall = this.listUserExternalPrincipalsValidateBeforeCall(userId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<ExternalPrincipalList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUserExternalPrincipalsRequest listUserExternalPrincipals(String userId) {
        return new APIlistUserExternalPrincipalsRequest(userId);
    }

    public class APIlistUserExternalPrincipalsRequest {
        private final String userId;
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistUserExternalPrincipalsRequest(String userId) {
            this.userId = userId;
        }

        public APIlistUserExternalPrincipalsRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public APIlistUserExternalPrincipalsRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistUserExternalPrincipalsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExternalApi.this.listUserExternalPrincipalsCall(this.userId, this.prefix, this.after, this.amount, _callback);
        }

        public ExternalPrincipalList execute() throws ApiException {
            ApiResponse localVarResp = ExternalApi.this.listUserExternalPrincipalsWithHttpInfo(this.userId, this.prefix, this.after, this.amount);
            return (ExternalPrincipalList)localVarResp.getData();
        }

        public ApiResponse<ExternalPrincipalList> executeWithHttpInfo() throws ApiException {
            return ExternalApi.this.listUserExternalPrincipalsWithHttpInfo(this.userId, this.prefix, this.after, this.amount);
        }

        public Call executeAsync(ApiCallback<ExternalPrincipalList> _callback) throws ApiException {
            return ExternalApi.this.listUserExternalPrincipalsAsync(this.userId, this.prefix, this.after, this.amount, _callback);
        }
    }

    public class APIgetExternalPrincipalRequest {
        private final String principalId;

        private APIgetExternalPrincipalRequest(String principalId) {
            this.principalId = principalId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExternalApi.this.getExternalPrincipalCall(this.principalId, _callback);
        }

        public ExternalPrincipal execute() throws ApiException {
            ApiResponse localVarResp = ExternalApi.this.getExternalPrincipalWithHttpInfo(this.principalId);
            return (ExternalPrincipal)localVarResp.getData();
        }

        public ApiResponse<ExternalPrincipal> executeWithHttpInfo() throws ApiException {
            return ExternalApi.this.getExternalPrincipalWithHttpInfo(this.principalId);
        }

        public Call executeAsync(ApiCallback<ExternalPrincipal> _callback) throws ApiException {
            return ExternalApi.this.getExternalPrincipalAsync(this.principalId, _callback);
        }
    }

    public class APIdeleteUserExternalPrincipalRequest {
        private final String userId;
        private final String principalId;

        private APIdeleteUserExternalPrincipalRequest(String userId, String principalId) {
            this.userId = userId;
            this.principalId = principalId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExternalApi.this.deleteUserExternalPrincipalCall(this.userId, this.principalId, _callback);
        }

        public void execute() throws ApiException {
            ExternalApi.this.deleteUserExternalPrincipalWithHttpInfo(this.userId, this.principalId);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ExternalApi.this.deleteUserExternalPrincipalWithHttpInfo(this.userId, this.principalId);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ExternalApi.this.deleteUserExternalPrincipalAsync(this.userId, this.principalId, _callback);
        }
    }

    public class APIcreateUserExternalPrincipalRequest {
        private final String userId;
        private final String principalId;
        private ExternalPrincipalCreation externalPrincipalCreation;

        private APIcreateUserExternalPrincipalRequest(String userId, String principalId) {
            this.userId = userId;
            this.principalId = principalId;
        }

        public APIcreateUserExternalPrincipalRequest externalPrincipalCreation(ExternalPrincipalCreation externalPrincipalCreation) {
            this.externalPrincipalCreation = externalPrincipalCreation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExternalApi.this.createUserExternalPrincipalCall(this.userId, this.principalId, this.externalPrincipalCreation, _callback);
        }

        public void execute() throws ApiException {
            ExternalApi.this.createUserExternalPrincipalWithHttpInfo(this.userId, this.principalId, this.externalPrincipalCreation);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ExternalApi.this.createUserExternalPrincipalWithHttpInfo(this.userId, this.principalId, this.externalPrincipalCreation);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ExternalApi.this.createUserExternalPrincipalAsync(this.userId, this.principalId, this.externalPrincipalCreation, _callback);
        }
    }
}

