/*
 * lakeFS API
 * lakeFS HTTP API
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.lakefs.clients.sdk;

import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.ProgressRequestBody;
import io.lakefs.clients.sdk.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.lakefs.clients.sdk.model.ACL;
import io.lakefs.clients.sdk.model.AuthenticationToken;
import io.lakefs.clients.sdk.model.Credentials;
import io.lakefs.clients.sdk.model.CredentialsList;
import io.lakefs.clients.sdk.model.CredentialsWithSecret;
import io.lakefs.clients.sdk.model.CurrentUser;
import io.lakefs.clients.sdk.model.Error;
import io.lakefs.clients.sdk.model.ErrorNoACL;
import io.lakefs.clients.sdk.model.Group;
import io.lakefs.clients.sdk.model.GroupCreation;
import io.lakefs.clients.sdk.model.GroupList;
import io.lakefs.clients.sdk.model.LoginInformation;
import io.lakefs.clients.sdk.model.Policy;
import io.lakefs.clients.sdk.model.PolicyList;
import io.lakefs.clients.sdk.model.User;
import io.lakefs.clients.sdk.model.UserCreation;
import io.lakefs.clients.sdk.model.UserList;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call addGroupMembershipCall(String groupId, String userId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/groups/{groupId}/members/{userId}"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()))
            .replace("{" + "userId" + "}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call addGroupMembershipValidateBeforeCall(String groupId, String userId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling addGroupMembership(Async)");
        }

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling addGroupMembership(Async)");
        }

        return addGroupMembershipCall(groupId, userId, _callback);

    }


    private ApiResponse<Void> addGroupMembershipWithHttpInfo(String groupId, String userId) throws ApiException {
        okhttp3.Call localVarCall = addGroupMembershipValidateBeforeCall(groupId, userId, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call addGroupMembershipAsync(String groupId, String userId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = addGroupMembershipValidateBeforeCall(groupId, userId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIaddGroupMembershipRequest {
        private final String groupId;
        private final String userId;

        private APIaddGroupMembershipRequest(String groupId, String userId) {
            this.groupId = groupId;
            this.userId = userId;
        }

        /**
         * Build call for addGroupMembership
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> membership added successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return addGroupMembershipCall(groupId, userId, _callback);
        }

        /**
         * Execute addGroupMembership request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> membership added successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            addGroupMembershipWithHttpInfo(groupId, userId);
        }

        /**
         * Execute addGroupMembership request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> membership added successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return addGroupMembershipWithHttpInfo(groupId, userId);
        }

        /**
         * Execute addGroupMembership request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> membership added successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return addGroupMembershipAsync(groupId, userId, _callback);
        }
    }

    /**
     * add group membership
     * 
     * @param groupId  (required)
     * @param userId  (required)
     * @return APIaddGroupMembershipRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> membership added successfully </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIaddGroupMembershipRequest addGroupMembership(String groupId, String userId) {
        return new APIaddGroupMembershipRequest(groupId, userId);
    }
    private okhttp3.Call attachPolicyToGroupCall(String groupId, String policyId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/groups/{groupId}/policies/{policyId}"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()))
            .replace("{" + "policyId" + "}", localVarApiClient.escapeString(policyId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call attachPolicyToGroupValidateBeforeCall(String groupId, String policyId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling attachPolicyToGroup(Async)");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling attachPolicyToGroup(Async)");
        }

        return attachPolicyToGroupCall(groupId, policyId, _callback);

    }


    private ApiResponse<Void> attachPolicyToGroupWithHttpInfo(String groupId, String policyId) throws ApiException {
        okhttp3.Call localVarCall = attachPolicyToGroupValidateBeforeCall(groupId, policyId, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call attachPolicyToGroupAsync(String groupId, String policyId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = attachPolicyToGroupValidateBeforeCall(groupId, policyId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIattachPolicyToGroupRequest {
        private final String groupId;
        private final String policyId;

        private APIattachPolicyToGroupRequest(String groupId, String policyId) {
            this.groupId = groupId;
            this.policyId = policyId;
        }

        /**
         * Build call for attachPolicyToGroup
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> policy attached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return attachPolicyToGroupCall(groupId, policyId, _callback);
        }

        /**
         * Execute attachPolicyToGroup request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> policy attached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            attachPolicyToGroupWithHttpInfo(groupId, policyId);
        }

        /**
         * Execute attachPolicyToGroup request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> policy attached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return attachPolicyToGroupWithHttpInfo(groupId, policyId);
        }

        /**
         * Execute attachPolicyToGroup request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> policy attached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return attachPolicyToGroupAsync(groupId, policyId, _callback);
        }
    }

    /**
     * attach policy to group
     * 
     * @param groupId  (required)
     * @param policyId  (required)
     * @return APIattachPolicyToGroupRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> policy attached successfully </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIattachPolicyToGroupRequest attachPolicyToGroup(String groupId, String policyId) {
        return new APIattachPolicyToGroupRequest(groupId, policyId);
    }
    private okhttp3.Call attachPolicyToUserCall(String userId, String policyId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/users/{userId}/policies/{policyId}"
            .replace("{" + "userId" + "}", localVarApiClient.escapeString(userId.toString()))
            .replace("{" + "policyId" + "}", localVarApiClient.escapeString(policyId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call attachPolicyToUserValidateBeforeCall(String userId, String policyId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling attachPolicyToUser(Async)");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling attachPolicyToUser(Async)");
        }

        return attachPolicyToUserCall(userId, policyId, _callback);

    }


    private ApiResponse<Void> attachPolicyToUserWithHttpInfo(String userId, String policyId) throws ApiException {
        okhttp3.Call localVarCall = attachPolicyToUserValidateBeforeCall(userId, policyId, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call attachPolicyToUserAsync(String userId, String policyId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = attachPolicyToUserValidateBeforeCall(userId, policyId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIattachPolicyToUserRequest {
        private final String userId;
        private final String policyId;

        private APIattachPolicyToUserRequest(String userId, String policyId) {
            this.userId = userId;
            this.policyId = policyId;
        }

        /**
         * Build call for attachPolicyToUser
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> policy attached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return attachPolicyToUserCall(userId, policyId, _callback);
        }

        /**
         * Execute attachPolicyToUser request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> policy attached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            attachPolicyToUserWithHttpInfo(userId, policyId);
        }

        /**
         * Execute attachPolicyToUser request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> policy attached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return attachPolicyToUserWithHttpInfo(userId, policyId);
        }

        /**
         * Execute attachPolicyToUser request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> policy attached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return attachPolicyToUserAsync(userId, policyId, _callback);
        }
    }

    /**
     * attach policy to user
     * 
     * @param userId  (required)
     * @param policyId  (required)
     * @return APIattachPolicyToUserRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> policy attached successfully </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIattachPolicyToUserRequest attachPolicyToUser(String userId, String policyId) {
        return new APIattachPolicyToUserRequest(userId, policyId);
    }
    private okhttp3.Call createCredentialsCall(String userId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/users/{userId}/credentials"
            .replace("{" + "userId" + "}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createCredentialsValidateBeforeCall(String userId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createCredentials(Async)");
        }

        return createCredentialsCall(userId, _callback);

    }


    private ApiResponse<CredentialsWithSecret> createCredentialsWithHttpInfo(String userId) throws ApiException {
        okhttp3.Call localVarCall = createCredentialsValidateBeforeCall(userId, null);
        Type localVarReturnType = new TypeToken<CredentialsWithSecret>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call createCredentialsAsync(String userId, final ApiCallback<CredentialsWithSecret> _callback) throws ApiException {

        okhttp3.Call localVarCall = createCredentialsValidateBeforeCall(userId, _callback);
        Type localVarReturnType = new TypeToken<CredentialsWithSecret>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcreateCredentialsRequest {
        private final String userId;

        private APIcreateCredentialsRequest(String userId) {
            this.userId = userId;
        }

        /**
         * Build call for createCredentials
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> credentials </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return createCredentialsCall(userId, _callback);
        }

        /**
         * Execute createCredentials request
         * @return CredentialsWithSecret
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> credentials </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public CredentialsWithSecret execute() throws ApiException {
            ApiResponse<CredentialsWithSecret> localVarResp = createCredentialsWithHttpInfo(userId);
            return localVarResp.getData();
        }

        /**
         * Execute createCredentials request with HTTP info returned
         * @return ApiResponse&lt;CredentialsWithSecret&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> credentials </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<CredentialsWithSecret> executeWithHttpInfo() throws ApiException {
            return createCredentialsWithHttpInfo(userId);
        }

        /**
         * Execute createCredentials request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> credentials </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<CredentialsWithSecret> _callback) throws ApiException {
            return createCredentialsAsync(userId, _callback);
        }
    }

    /**
     * create credentials
     * 
     * @param userId  (required)
     * @return APIcreateCredentialsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> credentials </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIcreateCredentialsRequest createCredentials(String userId) {
        return new APIcreateCredentialsRequest(userId);
    }
    private okhttp3.Call createGroupCall(GroupCreation groupCreation, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = groupCreation;

        // create path and map variables
        String localVarPath = "/auth/groups";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createGroupValidateBeforeCall(GroupCreation groupCreation, final ApiCallback _callback) throws ApiException {
        return createGroupCall(groupCreation, _callback);

    }


    private ApiResponse<Group> createGroupWithHttpInfo(GroupCreation groupCreation) throws ApiException {
        okhttp3.Call localVarCall = createGroupValidateBeforeCall(groupCreation, null);
        Type localVarReturnType = new TypeToken<Group>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call createGroupAsync(GroupCreation groupCreation, final ApiCallback<Group> _callback) throws ApiException {

        okhttp3.Call localVarCall = createGroupValidateBeforeCall(groupCreation, _callback);
        Type localVarReturnType = new TypeToken<Group>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcreateGroupRequest {
        private GroupCreation groupCreation;

        private APIcreateGroupRequest() {
        }

        /**
         * Set groupCreation
         * @param groupCreation  (optional)
         * @return APIcreateGroupRequest
         */
        public APIcreateGroupRequest groupCreation(GroupCreation groupCreation) {
            this.groupCreation = groupCreation;
            return this;
        }

        /**
         * Build call for createGroup
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> group </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return createGroupCall(groupCreation, _callback);
        }

        /**
         * Execute createGroup request
         * @return Group
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> group </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public Group execute() throws ApiException {
            ApiResponse<Group> localVarResp = createGroupWithHttpInfo(groupCreation);
            return localVarResp.getData();
        }

        /**
         * Execute createGroup request with HTTP info returned
         * @return ApiResponse&lt;Group&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> group </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Group> executeWithHttpInfo() throws ApiException {
            return createGroupWithHttpInfo(groupCreation);
        }

        /**
         * Execute createGroup request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> group </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Group> _callback) throws ApiException {
            return createGroupAsync(groupCreation, _callback);
        }
    }

    /**
     * create group
     * 
     * @return APIcreateGroupRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> group </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIcreateGroupRequest createGroup() {
        return new APIcreateGroupRequest();
    }
    private okhttp3.Call createPolicyCall(Policy policy, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = policy;

        // create path and map variables
        String localVarPath = "/auth/policies";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createPolicyValidateBeforeCall(Policy policy, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'policy' is set
        if (policy == null) {
            throw new ApiException("Missing the required parameter 'policy' when calling createPolicy(Async)");
        }

        return createPolicyCall(policy, _callback);

    }


    private ApiResponse<Policy> createPolicyWithHttpInfo(Policy policy) throws ApiException {
        okhttp3.Call localVarCall = createPolicyValidateBeforeCall(policy, null);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call createPolicyAsync(Policy policy, final ApiCallback<Policy> _callback) throws ApiException {

        okhttp3.Call localVarCall = createPolicyValidateBeforeCall(policy, _callback);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcreatePolicyRequest {
        private final Policy policy;

        private APIcreatePolicyRequest(Policy policy) {
            this.policy = policy;
        }

        /**
         * Build call for createPolicy
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> policy </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Resource Conflicts With Target </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return createPolicyCall(policy, _callback);
        }

        /**
         * Execute createPolicy request
         * @return Policy
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> policy </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Resource Conflicts With Target </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public Policy execute() throws ApiException {
            ApiResponse<Policy> localVarResp = createPolicyWithHttpInfo(policy);
            return localVarResp.getData();
        }

        /**
         * Execute createPolicy request with HTTP info returned
         * @return ApiResponse&lt;Policy&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> policy </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Resource Conflicts With Target </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Policy> executeWithHttpInfo() throws ApiException {
            return createPolicyWithHttpInfo(policy);
        }

        /**
         * Execute createPolicy request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> policy </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Resource Conflicts With Target </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Policy> _callback) throws ApiException {
            return createPolicyAsync(policy, _callback);
        }
    }

    /**
     * create policy
     * 
     * @param policy  (required)
     * @return APIcreatePolicyRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> policy </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Resource Conflicts With Target </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIcreatePolicyRequest createPolicy(Policy policy) {
        return new APIcreatePolicyRequest(policy);
    }
    private okhttp3.Call createUserCall(UserCreation userCreation, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = userCreation;

        // create path and map variables
        String localVarPath = "/auth/users";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createUserValidateBeforeCall(UserCreation userCreation, final ApiCallback _callback) throws ApiException {
        return createUserCall(userCreation, _callback);

    }


    private ApiResponse<User> createUserWithHttpInfo(UserCreation userCreation) throws ApiException {
        okhttp3.Call localVarCall = createUserValidateBeforeCall(userCreation, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call createUserAsync(UserCreation userCreation, final ApiCallback<User> _callback) throws ApiException {

        okhttp3.Call localVarCall = createUserValidateBeforeCall(userCreation, _callback);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcreateUserRequest {
        private UserCreation userCreation;

        private APIcreateUserRequest() {
        }

        /**
         * Set userCreation
         * @param userCreation  (optional)
         * @return APIcreateUserRequest
         */
        public APIcreateUserRequest userCreation(UserCreation userCreation) {
            this.userCreation = userCreation;
            return this;
        }

        /**
         * Build call for createUser
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> user </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> validation error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Resource Conflicts With Target </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return createUserCall(userCreation, _callback);
        }

        /**
         * Execute createUser request
         * @return User
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> user </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> validation error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Resource Conflicts With Target </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public User execute() throws ApiException {
            ApiResponse<User> localVarResp = createUserWithHttpInfo(userCreation);
            return localVarResp.getData();
        }

        /**
         * Execute createUser request with HTTP info returned
         * @return ApiResponse&lt;User&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> user </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> validation error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Resource Conflicts With Target </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<User> executeWithHttpInfo() throws ApiException {
            return createUserWithHttpInfo(userCreation);
        }

        /**
         * Execute createUser request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> user </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> validation error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Resource Conflicts With Target </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<User> _callback) throws ApiException {
            return createUserAsync(userCreation, _callback);
        }
    }

    /**
     * create user
     * 
     * @return APIcreateUserRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> user </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> validation error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Resource Conflicts With Target </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIcreateUserRequest createUser() {
        return new APIcreateUserRequest();
    }
    private okhttp3.Call deleteCredentialsCall(String userId, String accessKeyId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/users/{userId}/credentials/{accessKeyId}"
            .replace("{" + "userId" + "}", localVarApiClient.escapeString(userId.toString()))
            .replace("{" + "accessKeyId" + "}", localVarApiClient.escapeString(accessKeyId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteCredentialsValidateBeforeCall(String userId, String accessKeyId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteCredentials(Async)");
        }

        // verify the required parameter 'accessKeyId' is set
        if (accessKeyId == null) {
            throw new ApiException("Missing the required parameter 'accessKeyId' when calling deleteCredentials(Async)");
        }

        return deleteCredentialsCall(userId, accessKeyId, _callback);

    }


    private ApiResponse<Void> deleteCredentialsWithHttpInfo(String userId, String accessKeyId) throws ApiException {
        okhttp3.Call localVarCall = deleteCredentialsValidateBeforeCall(userId, accessKeyId, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call deleteCredentialsAsync(String userId, String accessKeyId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteCredentialsValidateBeforeCall(userId, accessKeyId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIdeleteCredentialsRequest {
        private final String userId;
        private final String accessKeyId;

        private APIdeleteCredentialsRequest(String userId, String accessKeyId) {
            this.userId = userId;
            this.accessKeyId = accessKeyId;
        }

        /**
         * Build call for deleteCredentials
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> credentials deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return deleteCredentialsCall(userId, accessKeyId, _callback);
        }

        /**
         * Execute deleteCredentials request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> credentials deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            deleteCredentialsWithHttpInfo(userId, accessKeyId);
        }

        /**
         * Execute deleteCredentials request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> credentials deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return deleteCredentialsWithHttpInfo(userId, accessKeyId);
        }

        /**
         * Execute deleteCredentials request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> credentials deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return deleteCredentialsAsync(userId, accessKeyId, _callback);
        }
    }

    /**
     * delete credentials
     * 
     * @param userId  (required)
     * @param accessKeyId  (required)
     * @return APIdeleteCredentialsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> credentials deleted successfully </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIdeleteCredentialsRequest deleteCredentials(String userId, String accessKeyId) {
        return new APIdeleteCredentialsRequest(userId, accessKeyId);
    }
    private okhttp3.Call deleteGroupCall(String groupId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/groups/{groupId}"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteGroupValidateBeforeCall(String groupId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling deleteGroup(Async)");
        }

        return deleteGroupCall(groupId, _callback);

    }


    private ApiResponse<Void> deleteGroupWithHttpInfo(String groupId) throws ApiException {
        okhttp3.Call localVarCall = deleteGroupValidateBeforeCall(groupId, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call deleteGroupAsync(String groupId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteGroupValidateBeforeCall(groupId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIdeleteGroupRequest {
        private final String groupId;

        private APIdeleteGroupRequest(String groupId) {
            this.groupId = groupId;
        }

        /**
         * Build call for deleteGroup
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> group deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return deleteGroupCall(groupId, _callback);
        }

        /**
         * Execute deleteGroup request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> group deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            deleteGroupWithHttpInfo(groupId);
        }

        /**
         * Execute deleteGroup request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> group deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return deleteGroupWithHttpInfo(groupId);
        }

        /**
         * Execute deleteGroup request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> group deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return deleteGroupAsync(groupId, _callback);
        }
    }

    /**
     * delete group
     * 
     * @param groupId  (required)
     * @return APIdeleteGroupRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> group deleted successfully </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIdeleteGroupRequest deleteGroup(String groupId) {
        return new APIdeleteGroupRequest(groupId);
    }
    private okhttp3.Call deleteGroupMembershipCall(String groupId, String userId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/groups/{groupId}/members/{userId}"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()))
            .replace("{" + "userId" + "}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteGroupMembershipValidateBeforeCall(String groupId, String userId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling deleteGroupMembership(Async)");
        }

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteGroupMembership(Async)");
        }

        return deleteGroupMembershipCall(groupId, userId, _callback);

    }


    private ApiResponse<Void> deleteGroupMembershipWithHttpInfo(String groupId, String userId) throws ApiException {
        okhttp3.Call localVarCall = deleteGroupMembershipValidateBeforeCall(groupId, userId, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call deleteGroupMembershipAsync(String groupId, String userId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteGroupMembershipValidateBeforeCall(groupId, userId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIdeleteGroupMembershipRequest {
        private final String groupId;
        private final String userId;

        private APIdeleteGroupMembershipRequest(String groupId, String userId) {
            this.groupId = groupId;
            this.userId = userId;
        }

        /**
         * Build call for deleteGroupMembership
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> membership deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return deleteGroupMembershipCall(groupId, userId, _callback);
        }

        /**
         * Execute deleteGroupMembership request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> membership deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            deleteGroupMembershipWithHttpInfo(groupId, userId);
        }

        /**
         * Execute deleteGroupMembership request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> membership deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return deleteGroupMembershipWithHttpInfo(groupId, userId);
        }

        /**
         * Execute deleteGroupMembership request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> membership deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return deleteGroupMembershipAsync(groupId, userId, _callback);
        }
    }

    /**
     * delete group membership
     * 
     * @param groupId  (required)
     * @param userId  (required)
     * @return APIdeleteGroupMembershipRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> membership deleted successfully </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIdeleteGroupMembershipRequest deleteGroupMembership(String groupId, String userId) {
        return new APIdeleteGroupMembershipRequest(groupId, userId);
    }
    private okhttp3.Call deletePolicyCall(String policyId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/policies/{policyId}"
            .replace("{" + "policyId" + "}", localVarApiClient.escapeString(policyId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deletePolicyValidateBeforeCall(String policyId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling deletePolicy(Async)");
        }

        return deletePolicyCall(policyId, _callback);

    }


    private ApiResponse<Void> deletePolicyWithHttpInfo(String policyId) throws ApiException {
        okhttp3.Call localVarCall = deletePolicyValidateBeforeCall(policyId, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call deletePolicyAsync(String policyId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deletePolicyValidateBeforeCall(policyId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIdeletePolicyRequest {
        private final String policyId;

        private APIdeletePolicyRequest(String policyId) {
            this.policyId = policyId;
        }

        /**
         * Build call for deletePolicy
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> policy deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return deletePolicyCall(policyId, _callback);
        }

        /**
         * Execute deletePolicy request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> policy deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            deletePolicyWithHttpInfo(policyId);
        }

        /**
         * Execute deletePolicy request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> policy deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return deletePolicyWithHttpInfo(policyId);
        }

        /**
         * Execute deletePolicy request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> policy deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return deletePolicyAsync(policyId, _callback);
        }
    }

    /**
     * delete policy
     * 
     * @param policyId  (required)
     * @return APIdeletePolicyRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> policy deleted successfully </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIdeletePolicyRequest deletePolicy(String policyId) {
        return new APIdeletePolicyRequest(policyId);
    }
    private okhttp3.Call deleteUserCall(String userId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/users/{userId}"
            .replace("{" + "userId" + "}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteUserValidateBeforeCall(String userId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteUser(Async)");
        }

        return deleteUserCall(userId, _callback);

    }


    private ApiResponse<Void> deleteUserWithHttpInfo(String userId) throws ApiException {
        okhttp3.Call localVarCall = deleteUserValidateBeforeCall(userId, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call deleteUserAsync(String userId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteUserValidateBeforeCall(userId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIdeleteUserRequest {
        private final String userId;

        private APIdeleteUserRequest(String userId) {
            this.userId = userId;
        }

        /**
         * Build call for deleteUser
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> user deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return deleteUserCall(userId, _callback);
        }

        /**
         * Execute deleteUser request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> user deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            deleteUserWithHttpInfo(userId);
        }

        /**
         * Execute deleteUser request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> user deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return deleteUserWithHttpInfo(userId);
        }

        /**
         * Execute deleteUser request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> user deleted successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return deleteUserAsync(userId, _callback);
        }
    }

    /**
     * delete user
     * 
     * @param userId  (required)
     * @return APIdeleteUserRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> user deleted successfully </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIdeleteUserRequest deleteUser(String userId) {
        return new APIdeleteUserRequest(userId);
    }
    private okhttp3.Call detachPolicyFromGroupCall(String groupId, String policyId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/groups/{groupId}/policies/{policyId}"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()))
            .replace("{" + "policyId" + "}", localVarApiClient.escapeString(policyId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call detachPolicyFromGroupValidateBeforeCall(String groupId, String policyId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling detachPolicyFromGroup(Async)");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling detachPolicyFromGroup(Async)");
        }

        return detachPolicyFromGroupCall(groupId, policyId, _callback);

    }


    private ApiResponse<Void> detachPolicyFromGroupWithHttpInfo(String groupId, String policyId) throws ApiException {
        okhttp3.Call localVarCall = detachPolicyFromGroupValidateBeforeCall(groupId, policyId, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call detachPolicyFromGroupAsync(String groupId, String policyId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = detachPolicyFromGroupValidateBeforeCall(groupId, policyId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIdetachPolicyFromGroupRequest {
        private final String groupId;
        private final String policyId;

        private APIdetachPolicyFromGroupRequest(String groupId, String policyId) {
            this.groupId = groupId;
            this.policyId = policyId;
        }

        /**
         * Build call for detachPolicyFromGroup
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> policy detached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return detachPolicyFromGroupCall(groupId, policyId, _callback);
        }

        /**
         * Execute detachPolicyFromGroup request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> policy detached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            detachPolicyFromGroupWithHttpInfo(groupId, policyId);
        }

        /**
         * Execute detachPolicyFromGroup request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> policy detached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return detachPolicyFromGroupWithHttpInfo(groupId, policyId);
        }

        /**
         * Execute detachPolicyFromGroup request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> policy detached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return detachPolicyFromGroupAsync(groupId, policyId, _callback);
        }
    }

    /**
     * detach policy from group
     * 
     * @param groupId  (required)
     * @param policyId  (required)
     * @return APIdetachPolicyFromGroupRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> policy detached successfully </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIdetachPolicyFromGroupRequest detachPolicyFromGroup(String groupId, String policyId) {
        return new APIdetachPolicyFromGroupRequest(groupId, policyId);
    }
    private okhttp3.Call detachPolicyFromUserCall(String userId, String policyId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/users/{userId}/policies/{policyId}"
            .replace("{" + "userId" + "}", localVarApiClient.escapeString(userId.toString()))
            .replace("{" + "policyId" + "}", localVarApiClient.escapeString(policyId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call detachPolicyFromUserValidateBeforeCall(String userId, String policyId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling detachPolicyFromUser(Async)");
        }

        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling detachPolicyFromUser(Async)");
        }

        return detachPolicyFromUserCall(userId, policyId, _callback);

    }


    private ApiResponse<Void> detachPolicyFromUserWithHttpInfo(String userId, String policyId) throws ApiException {
        okhttp3.Call localVarCall = detachPolicyFromUserValidateBeforeCall(userId, policyId, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call detachPolicyFromUserAsync(String userId, String policyId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = detachPolicyFromUserValidateBeforeCall(userId, policyId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIdetachPolicyFromUserRequest {
        private final String userId;
        private final String policyId;

        private APIdetachPolicyFromUserRequest(String userId, String policyId) {
            this.userId = userId;
            this.policyId = policyId;
        }

        /**
         * Build call for detachPolicyFromUser
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> policy detached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return detachPolicyFromUserCall(userId, policyId, _callback);
        }

        /**
         * Execute detachPolicyFromUser request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> policy detached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            detachPolicyFromUserWithHttpInfo(userId, policyId);
        }

        /**
         * Execute detachPolicyFromUser request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> policy detached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return detachPolicyFromUserWithHttpInfo(userId, policyId);
        }

        /**
         * Execute detachPolicyFromUser request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> policy detached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return detachPolicyFromUserAsync(userId, policyId, _callback);
        }
    }

    /**
     * detach policy from user
     * 
     * @param userId  (required)
     * @param policyId  (required)
     * @return APIdetachPolicyFromUserRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> policy detached successfully </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIdetachPolicyFromUserRequest detachPolicyFromUser(String userId, String policyId) {
        return new APIdetachPolicyFromUserRequest(userId, policyId);
    }
    private okhttp3.Call getCredentialsCall(String userId, String accessKeyId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/users/{userId}/credentials/{accessKeyId}"
            .replace("{" + "userId" + "}", localVarApiClient.escapeString(userId.toString()))
            .replace("{" + "accessKeyId" + "}", localVarApiClient.escapeString(accessKeyId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCredentialsValidateBeforeCall(String userId, String accessKeyId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getCredentials(Async)");
        }

        // verify the required parameter 'accessKeyId' is set
        if (accessKeyId == null) {
            throw new ApiException("Missing the required parameter 'accessKeyId' when calling getCredentials(Async)");
        }

        return getCredentialsCall(userId, accessKeyId, _callback);

    }


    private ApiResponse<Credentials> getCredentialsWithHttpInfo(String userId, String accessKeyId) throws ApiException {
        okhttp3.Call localVarCall = getCredentialsValidateBeforeCall(userId, accessKeyId, null);
        Type localVarReturnType = new TypeToken<Credentials>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call getCredentialsAsync(String userId, String accessKeyId, final ApiCallback<Credentials> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCredentialsValidateBeforeCall(userId, accessKeyId, _callback);
        Type localVarReturnType = new TypeToken<Credentials>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgetCredentialsRequest {
        private final String userId;
        private final String accessKeyId;

        private APIgetCredentialsRequest(String userId, String accessKeyId) {
            this.userId = userId;
            this.accessKeyId = accessKeyId;
        }

        /**
         * Build call for getCredentials
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> credentials </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return getCredentialsCall(userId, accessKeyId, _callback);
        }

        /**
         * Execute getCredentials request
         * @return Credentials
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> credentials </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public Credentials execute() throws ApiException {
            ApiResponse<Credentials> localVarResp = getCredentialsWithHttpInfo(userId, accessKeyId);
            return localVarResp.getData();
        }

        /**
         * Execute getCredentials request with HTTP info returned
         * @return ApiResponse&lt;Credentials&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> credentials </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Credentials> executeWithHttpInfo() throws ApiException {
            return getCredentialsWithHttpInfo(userId, accessKeyId);
        }

        /**
         * Execute getCredentials request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> credentials </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Credentials> _callback) throws ApiException {
            return getCredentialsAsync(userId, accessKeyId, _callback);
        }
    }

    /**
     * get credentials
     * 
     * @param userId  (required)
     * @param accessKeyId  (required)
     * @return APIgetCredentialsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> credentials </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIgetCredentialsRequest getCredentials(String userId, String accessKeyId) {
        return new APIgetCredentialsRequest(userId, accessKeyId);
    }
    private okhttp3.Call getCurrentUserCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/user";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCurrentUserValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return getCurrentUserCall(_callback);

    }


    private ApiResponse<CurrentUser> getCurrentUserWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getCurrentUserValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<CurrentUser>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call getCurrentUserAsync(final ApiCallback<CurrentUser> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCurrentUserValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<CurrentUser>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgetCurrentUserRequest {

        private APIgetCurrentUserRequest() {
        }

        /**
         * Build call for getCurrentUser
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> user </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return getCurrentUserCall(_callback);
        }

        /**
         * Execute getCurrentUser request
         * @return CurrentUser
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> user </td><td>  -  </td></tr>
         </table>
         */
        public CurrentUser execute() throws ApiException {
            ApiResponse<CurrentUser> localVarResp = getCurrentUserWithHttpInfo();
            return localVarResp.getData();
        }

        /**
         * Execute getCurrentUser request with HTTP info returned
         * @return ApiResponse&lt;CurrentUser&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> user </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<CurrentUser> executeWithHttpInfo() throws ApiException {
            return getCurrentUserWithHttpInfo();
        }

        /**
         * Execute getCurrentUser request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> user </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<CurrentUser> _callback) throws ApiException {
            return getCurrentUserAsync(_callback);
        }
    }

    /**
     * get current user
     * 
     * @return APIgetCurrentUserRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> user </td><td>  -  </td></tr>
     </table>
     */
    public APIgetCurrentUserRequest getCurrentUser() {
        return new APIgetCurrentUserRequest();
    }
    private okhttp3.Call getGroupCall(String groupId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/groups/{groupId}"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getGroupValidateBeforeCall(String groupId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling getGroup(Async)");
        }

        return getGroupCall(groupId, _callback);

    }


    private ApiResponse<Group> getGroupWithHttpInfo(String groupId) throws ApiException {
        okhttp3.Call localVarCall = getGroupValidateBeforeCall(groupId, null);
        Type localVarReturnType = new TypeToken<Group>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call getGroupAsync(String groupId, final ApiCallback<Group> _callback) throws ApiException {

        okhttp3.Call localVarCall = getGroupValidateBeforeCall(groupId, _callback);
        Type localVarReturnType = new TypeToken<Group>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgetGroupRequest {
        private final String groupId;

        private APIgetGroupRequest(String groupId) {
            this.groupId = groupId;
        }

        /**
         * Build call for getGroup
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> group </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return getGroupCall(groupId, _callback);
        }

        /**
         * Execute getGroup request
         * @return Group
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> group </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public Group execute() throws ApiException {
            ApiResponse<Group> localVarResp = getGroupWithHttpInfo(groupId);
            return localVarResp.getData();
        }

        /**
         * Execute getGroup request with HTTP info returned
         * @return ApiResponse&lt;Group&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> group </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Group> executeWithHttpInfo() throws ApiException {
            return getGroupWithHttpInfo(groupId);
        }

        /**
         * Execute getGroup request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> group </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Group> _callback) throws ApiException {
            return getGroupAsync(groupId, _callback);
        }
    }

    /**
     * get group
     * 
     * @param groupId  (required)
     * @return APIgetGroupRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> group </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIgetGroupRequest getGroup(String groupId) {
        return new APIgetGroupRequest(groupId);
    }
    private okhttp3.Call getGroupACLCall(String groupId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/groups/{groupId}/acl"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getGroupACLValidateBeforeCall(String groupId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling getGroupACL(Async)");
        }

        return getGroupACLCall(groupId, _callback);

    }


    private ApiResponse<ACL> getGroupACLWithHttpInfo(String groupId) throws ApiException {
        okhttp3.Call localVarCall = getGroupACLValidateBeforeCall(groupId, null);
        Type localVarReturnType = new TypeToken<ACL>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call getGroupACLAsync(String groupId, final ApiCallback<ACL> _callback) throws ApiException {

        okhttp3.Call localVarCall = getGroupACLValidateBeforeCall(groupId, _callback);
        Type localVarReturnType = new TypeToken<ACL>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgetGroupACLRequest {
        private final String groupId;

        private APIgetGroupACLRequest(String groupId) {
            this.groupId = groupId;
        }

        /**
         * Build call for getGroupACL
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> ACL of group </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Group not found, or group found but has no ACL </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return getGroupACLCall(groupId, _callback);
        }

        /**
         * Execute getGroupACL request
         * @return ACL
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> ACL of group </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Group not found, or group found but has no ACL </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ACL execute() throws ApiException {
            ApiResponse<ACL> localVarResp = getGroupACLWithHttpInfo(groupId);
            return localVarResp.getData();
        }

        /**
         * Execute getGroupACL request with HTTP info returned
         * @return ApiResponse&lt;ACL&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> ACL of group </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Group not found, or group found but has no ACL </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ACL> executeWithHttpInfo() throws ApiException {
            return getGroupACLWithHttpInfo(groupId);
        }

        /**
         * Execute getGroupACL request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> ACL of group </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Group not found, or group found but has no ACL </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ACL> _callback) throws ApiException {
            return getGroupACLAsync(groupId, _callback);
        }
    }

    /**
     * get ACL of group
     * 
     * @param groupId  (required)
     * @return APIgetGroupACLRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> ACL of group </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Group not found, or group found but has no ACL </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIgetGroupACLRequest getGroupACL(String groupId) {
        return new APIgetGroupACLRequest(groupId);
    }
    private okhttp3.Call getPolicyCall(String policyId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/policies/{policyId}"
            .replace("{" + "policyId" + "}", localVarApiClient.escapeString(policyId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getPolicyValidateBeforeCall(String policyId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling getPolicy(Async)");
        }

        return getPolicyCall(policyId, _callback);

    }


    private ApiResponse<Policy> getPolicyWithHttpInfo(String policyId) throws ApiException {
        okhttp3.Call localVarCall = getPolicyValidateBeforeCall(policyId, null);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call getPolicyAsync(String policyId, final ApiCallback<Policy> _callback) throws ApiException {

        okhttp3.Call localVarCall = getPolicyValidateBeforeCall(policyId, _callback);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgetPolicyRequest {
        private final String policyId;

        private APIgetPolicyRequest(String policyId) {
            this.policyId = policyId;
        }

        /**
         * Build call for getPolicy
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return getPolicyCall(policyId, _callback);
        }

        /**
         * Execute getPolicy request
         * @return Policy
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public Policy execute() throws ApiException {
            ApiResponse<Policy> localVarResp = getPolicyWithHttpInfo(policyId);
            return localVarResp.getData();
        }

        /**
         * Execute getPolicy request with HTTP info returned
         * @return ApiResponse&lt;Policy&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Policy> executeWithHttpInfo() throws ApiException {
            return getPolicyWithHttpInfo(policyId);
        }

        /**
         * Execute getPolicy request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Policy> _callback) throws ApiException {
            return getPolicyAsync(policyId, _callback);
        }
    }

    /**
     * get policy
     * 
     * @param policyId  (required)
     * @return APIgetPolicyRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> policy </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIgetPolicyRequest getPolicy(String policyId) {
        return new APIgetPolicyRequest(policyId);
    }
    private okhttp3.Call getUserCall(String userId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/users/{userId}"
            .replace("{" + "userId" + "}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUserValidateBeforeCall(String userId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getUser(Async)");
        }

        return getUserCall(userId, _callback);

    }


    private ApiResponse<User> getUserWithHttpInfo(String userId) throws ApiException {
        okhttp3.Call localVarCall = getUserValidateBeforeCall(userId, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call getUserAsync(String userId, final ApiCallback<User> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUserValidateBeforeCall(userId, _callback);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgetUserRequest {
        private final String userId;

        private APIgetUserRequest(String userId) {
            this.userId = userId;
        }

        /**
         * Build call for getUser
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> user </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return getUserCall(userId, _callback);
        }

        /**
         * Execute getUser request
         * @return User
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> user </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public User execute() throws ApiException {
            ApiResponse<User> localVarResp = getUserWithHttpInfo(userId);
            return localVarResp.getData();
        }

        /**
         * Execute getUser request with HTTP info returned
         * @return ApiResponse&lt;User&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> user </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<User> executeWithHttpInfo() throws ApiException {
            return getUserWithHttpInfo(userId);
        }

        /**
         * Execute getUser request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> user </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<User> _callback) throws ApiException {
            return getUserAsync(userId, _callback);
        }
    }

    /**
     * get user
     * 
     * @param userId  (required)
     * @return APIgetUserRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> user </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIgetUserRequest getUser(String userId) {
        return new APIgetUserRequest(userId);
    }
    private okhttp3.Call listGroupMembersCall(String groupId, String prefix, String after, Integer amount, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/groups/{groupId}/members"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (prefix != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("prefix", prefix));
        }

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (amount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("amount", amount));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listGroupMembersValidateBeforeCall(String groupId, String prefix, String after, Integer amount, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling listGroupMembers(Async)");
        }

        return listGroupMembersCall(groupId, prefix, after, amount, _callback);

    }


    private ApiResponse<UserList> listGroupMembersWithHttpInfo(String groupId, String prefix, String after, Integer amount) throws ApiException {
        okhttp3.Call localVarCall = listGroupMembersValidateBeforeCall(groupId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<UserList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listGroupMembersAsync(String groupId, String prefix, String after, Integer amount, final ApiCallback<UserList> _callback) throws ApiException {

        okhttp3.Call localVarCall = listGroupMembersValidateBeforeCall(groupId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<UserList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistGroupMembersRequest {
        private final String groupId;
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistGroupMembersRequest(String groupId) {
            this.groupId = groupId;
        }

        /**
         * Set prefix
         * @param prefix return items prefixed with this value (optional)
         * @return APIlistGroupMembersRequest
         */
        public APIlistGroupMembersRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Set after
         * @param after return items after this value (optional)
         * @return APIlistGroupMembersRequest
         */
        public APIlistGroupMembersRequest after(String after) {
            this.after = after;
            return this;
        }

        /**
         * Set amount
         * @param amount how many items to return (optional, default to 100)
         * @return APIlistGroupMembersRequest
         */
        public APIlistGroupMembersRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Build call for listGroupMembers
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> group member list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listGroupMembersCall(groupId, prefix, after, amount, _callback);
        }

        /**
         * Execute listGroupMembers request
         * @return UserList
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> group member list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public UserList execute() throws ApiException {
            ApiResponse<UserList> localVarResp = listGroupMembersWithHttpInfo(groupId, prefix, after, amount);
            return localVarResp.getData();
        }

        /**
         * Execute listGroupMembers request with HTTP info returned
         * @return ApiResponse&lt;UserList&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> group member list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<UserList> executeWithHttpInfo() throws ApiException {
            return listGroupMembersWithHttpInfo(groupId, prefix, after, amount);
        }

        /**
         * Execute listGroupMembers request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> group member list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<UserList> _callback) throws ApiException {
            return listGroupMembersAsync(groupId, prefix, after, amount, _callback);
        }
    }

    /**
     * list group members
     * 
     * @param groupId  (required)
     * @return APIlistGroupMembersRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> group member list </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIlistGroupMembersRequest listGroupMembers(String groupId) {
        return new APIlistGroupMembersRequest(groupId);
    }
    private okhttp3.Call listGroupPoliciesCall(String groupId, String prefix, String after, Integer amount, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/groups/{groupId}/policies"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (prefix != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("prefix", prefix));
        }

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (amount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("amount", amount));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listGroupPoliciesValidateBeforeCall(String groupId, String prefix, String after, Integer amount, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling listGroupPolicies(Async)");
        }

        return listGroupPoliciesCall(groupId, prefix, after, amount, _callback);

    }


    private ApiResponse<PolicyList> listGroupPoliciesWithHttpInfo(String groupId, String prefix, String after, Integer amount) throws ApiException {
        okhttp3.Call localVarCall = listGroupPoliciesValidateBeforeCall(groupId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listGroupPoliciesAsync(String groupId, String prefix, String after, Integer amount, final ApiCallback<PolicyList> _callback) throws ApiException {

        okhttp3.Call localVarCall = listGroupPoliciesValidateBeforeCall(groupId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistGroupPoliciesRequest {
        private final String groupId;
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistGroupPoliciesRequest(String groupId) {
            this.groupId = groupId;
        }

        /**
         * Set prefix
         * @param prefix return items prefixed with this value (optional)
         * @return APIlistGroupPoliciesRequest
         */
        public APIlistGroupPoliciesRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Set after
         * @param after return items after this value (optional)
         * @return APIlistGroupPoliciesRequest
         */
        public APIlistGroupPoliciesRequest after(String after) {
            this.after = after;
            return this;
        }

        /**
         * Set amount
         * @param amount how many items to return (optional, default to 100)
         * @return APIlistGroupPoliciesRequest
         */
        public APIlistGroupPoliciesRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Build call for listGroupPolicies
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listGroupPoliciesCall(groupId, prefix, after, amount, _callback);
        }

        /**
         * Execute listGroupPolicies request
         * @return PolicyList
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public PolicyList execute() throws ApiException {
            ApiResponse<PolicyList> localVarResp = listGroupPoliciesWithHttpInfo(groupId, prefix, after, amount);
            return localVarResp.getData();
        }

        /**
         * Execute listGroupPolicies request with HTTP info returned
         * @return ApiResponse&lt;PolicyList&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PolicyList> executeWithHttpInfo() throws ApiException {
            return listGroupPoliciesWithHttpInfo(groupId, prefix, after, amount);
        }

        /**
         * Execute listGroupPolicies request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PolicyList> _callback) throws ApiException {
            return listGroupPoliciesAsync(groupId, prefix, after, amount, _callback);
        }
    }

    /**
     * list group policies
     * 
     * @param groupId  (required)
     * @return APIlistGroupPoliciesRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> policy list </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIlistGroupPoliciesRequest listGroupPolicies(String groupId) {
        return new APIlistGroupPoliciesRequest(groupId);
    }
    private okhttp3.Call listGroupsCall(String prefix, String after, Integer amount, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/groups";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (prefix != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("prefix", prefix));
        }

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (amount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("amount", amount));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listGroupsValidateBeforeCall(String prefix, String after, Integer amount, final ApiCallback _callback) throws ApiException {
        return listGroupsCall(prefix, after, amount, _callback);

    }


    private ApiResponse<GroupList> listGroupsWithHttpInfo(String prefix, String after, Integer amount) throws ApiException {
        okhttp3.Call localVarCall = listGroupsValidateBeforeCall(prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<GroupList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listGroupsAsync(String prefix, String after, Integer amount, final ApiCallback<GroupList> _callback) throws ApiException {

        okhttp3.Call localVarCall = listGroupsValidateBeforeCall(prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<GroupList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistGroupsRequest {
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistGroupsRequest() {
        }

        /**
         * Set prefix
         * @param prefix return items prefixed with this value (optional)
         * @return APIlistGroupsRequest
         */
        public APIlistGroupsRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Set after
         * @param after return items after this value (optional)
         * @return APIlistGroupsRequest
         */
        public APIlistGroupsRequest after(String after) {
            this.after = after;
            return this;
        }

        /**
         * Set amount
         * @param amount how many items to return (optional, default to 100)
         * @return APIlistGroupsRequest
         */
        public APIlistGroupsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Build call for listGroups
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> group list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listGroupsCall(prefix, after, amount, _callback);
        }

        /**
         * Execute listGroups request
         * @return GroupList
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> group list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public GroupList execute() throws ApiException {
            ApiResponse<GroupList> localVarResp = listGroupsWithHttpInfo(prefix, after, amount);
            return localVarResp.getData();
        }

        /**
         * Execute listGroups request with HTTP info returned
         * @return ApiResponse&lt;GroupList&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> group list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<GroupList> executeWithHttpInfo() throws ApiException {
            return listGroupsWithHttpInfo(prefix, after, amount);
        }

        /**
         * Execute listGroups request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> group list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<GroupList> _callback) throws ApiException {
            return listGroupsAsync(prefix, after, amount, _callback);
        }
    }

    /**
     * list groups
     * 
     * @return APIlistGroupsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> group list </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIlistGroupsRequest listGroups() {
        return new APIlistGroupsRequest();
    }
    private okhttp3.Call listPoliciesCall(String prefix, String after, Integer amount, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/policies";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (prefix != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("prefix", prefix));
        }

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (amount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("amount", amount));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listPoliciesValidateBeforeCall(String prefix, String after, Integer amount, final ApiCallback _callback) throws ApiException {
        return listPoliciesCall(prefix, after, amount, _callback);

    }


    private ApiResponse<PolicyList> listPoliciesWithHttpInfo(String prefix, String after, Integer amount) throws ApiException {
        okhttp3.Call localVarCall = listPoliciesValidateBeforeCall(prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listPoliciesAsync(String prefix, String after, Integer amount, final ApiCallback<PolicyList> _callback) throws ApiException {

        okhttp3.Call localVarCall = listPoliciesValidateBeforeCall(prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistPoliciesRequest {
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistPoliciesRequest() {
        }

        /**
         * Set prefix
         * @param prefix return items prefixed with this value (optional)
         * @return APIlistPoliciesRequest
         */
        public APIlistPoliciesRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Set after
         * @param after return items after this value (optional)
         * @return APIlistPoliciesRequest
         */
        public APIlistPoliciesRequest after(String after) {
            this.after = after;
            return this;
        }

        /**
         * Set amount
         * @param amount how many items to return (optional, default to 100)
         * @return APIlistPoliciesRequest
         */
        public APIlistPoliciesRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Build call for listPolicies
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listPoliciesCall(prefix, after, amount, _callback);
        }

        /**
         * Execute listPolicies request
         * @return PolicyList
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public PolicyList execute() throws ApiException {
            ApiResponse<PolicyList> localVarResp = listPoliciesWithHttpInfo(prefix, after, amount);
            return localVarResp.getData();
        }

        /**
         * Execute listPolicies request with HTTP info returned
         * @return ApiResponse&lt;PolicyList&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PolicyList> executeWithHttpInfo() throws ApiException {
            return listPoliciesWithHttpInfo(prefix, after, amount);
        }

        /**
         * Execute listPolicies request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PolicyList> _callback) throws ApiException {
            return listPoliciesAsync(prefix, after, amount, _callback);
        }
    }

    /**
     * list policies
     * 
     * @return APIlistPoliciesRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> policy list </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIlistPoliciesRequest listPolicies() {
        return new APIlistPoliciesRequest();
    }
    private okhttp3.Call listUserCredentialsCall(String userId, String prefix, String after, Integer amount, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/users/{userId}/credentials"
            .replace("{" + "userId" + "}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (prefix != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("prefix", prefix));
        }

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (amount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("amount", amount));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUserCredentialsValidateBeforeCall(String userId, String prefix, String after, Integer amount, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listUserCredentials(Async)");
        }

        return listUserCredentialsCall(userId, prefix, after, amount, _callback);

    }


    private ApiResponse<CredentialsList> listUserCredentialsWithHttpInfo(String userId, String prefix, String after, Integer amount) throws ApiException {
        okhttp3.Call localVarCall = listUserCredentialsValidateBeforeCall(userId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<CredentialsList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listUserCredentialsAsync(String userId, String prefix, String after, Integer amount, final ApiCallback<CredentialsList> _callback) throws ApiException {

        okhttp3.Call localVarCall = listUserCredentialsValidateBeforeCall(userId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<CredentialsList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistUserCredentialsRequest {
        private final String userId;
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistUserCredentialsRequest(String userId) {
            this.userId = userId;
        }

        /**
         * Set prefix
         * @param prefix return items prefixed with this value (optional)
         * @return APIlistUserCredentialsRequest
         */
        public APIlistUserCredentialsRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Set after
         * @param after return items after this value (optional)
         * @return APIlistUserCredentialsRequest
         */
        public APIlistUserCredentialsRequest after(String after) {
            this.after = after;
            return this;
        }

        /**
         * Set amount
         * @param amount how many items to return (optional, default to 100)
         * @return APIlistUserCredentialsRequest
         */
        public APIlistUserCredentialsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Build call for listUserCredentials
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> credential list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listUserCredentialsCall(userId, prefix, after, amount, _callback);
        }

        /**
         * Execute listUserCredentials request
         * @return CredentialsList
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> credential list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public CredentialsList execute() throws ApiException {
            ApiResponse<CredentialsList> localVarResp = listUserCredentialsWithHttpInfo(userId, prefix, after, amount);
            return localVarResp.getData();
        }

        /**
         * Execute listUserCredentials request with HTTP info returned
         * @return ApiResponse&lt;CredentialsList&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> credential list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<CredentialsList> executeWithHttpInfo() throws ApiException {
            return listUserCredentialsWithHttpInfo(userId, prefix, after, amount);
        }

        /**
         * Execute listUserCredentials request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> credential list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<CredentialsList> _callback) throws ApiException {
            return listUserCredentialsAsync(userId, prefix, after, amount, _callback);
        }
    }

    /**
     * list user credentials
     * 
     * @param userId  (required)
     * @return APIlistUserCredentialsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> credential list </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIlistUserCredentialsRequest listUserCredentials(String userId) {
        return new APIlistUserCredentialsRequest(userId);
    }
    private okhttp3.Call listUserGroupsCall(String userId, String prefix, String after, Integer amount, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/users/{userId}/groups"
            .replace("{" + "userId" + "}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (prefix != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("prefix", prefix));
        }

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (amount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("amount", amount));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUserGroupsValidateBeforeCall(String userId, String prefix, String after, Integer amount, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listUserGroups(Async)");
        }

        return listUserGroupsCall(userId, prefix, after, amount, _callback);

    }


    private ApiResponse<GroupList> listUserGroupsWithHttpInfo(String userId, String prefix, String after, Integer amount) throws ApiException {
        okhttp3.Call localVarCall = listUserGroupsValidateBeforeCall(userId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<GroupList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listUserGroupsAsync(String userId, String prefix, String after, Integer amount, final ApiCallback<GroupList> _callback) throws ApiException {

        okhttp3.Call localVarCall = listUserGroupsValidateBeforeCall(userId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<GroupList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistUserGroupsRequest {
        private final String userId;
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistUserGroupsRequest(String userId) {
            this.userId = userId;
        }

        /**
         * Set prefix
         * @param prefix return items prefixed with this value (optional)
         * @return APIlistUserGroupsRequest
         */
        public APIlistUserGroupsRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Set after
         * @param after return items after this value (optional)
         * @return APIlistUserGroupsRequest
         */
        public APIlistUserGroupsRequest after(String after) {
            this.after = after;
            return this;
        }

        /**
         * Set amount
         * @param amount how many items to return (optional, default to 100)
         * @return APIlistUserGroupsRequest
         */
        public APIlistUserGroupsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Build call for listUserGroups
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> group list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listUserGroupsCall(userId, prefix, after, amount, _callback);
        }

        /**
         * Execute listUserGroups request
         * @return GroupList
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> group list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public GroupList execute() throws ApiException {
            ApiResponse<GroupList> localVarResp = listUserGroupsWithHttpInfo(userId, prefix, after, amount);
            return localVarResp.getData();
        }

        /**
         * Execute listUserGroups request with HTTP info returned
         * @return ApiResponse&lt;GroupList&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> group list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<GroupList> executeWithHttpInfo() throws ApiException {
            return listUserGroupsWithHttpInfo(userId, prefix, after, amount);
        }

        /**
         * Execute listUserGroups request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> group list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<GroupList> _callback) throws ApiException {
            return listUserGroupsAsync(userId, prefix, after, amount, _callback);
        }
    }

    /**
     * list user groups
     * 
     * @param userId  (required)
     * @return APIlistUserGroupsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> group list </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIlistUserGroupsRequest listUserGroups(String userId) {
        return new APIlistUserGroupsRequest(userId);
    }
    private okhttp3.Call listUserPoliciesCall(String userId, String prefix, String after, Integer amount, Boolean effective, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/users/{userId}/policies"
            .replace("{" + "userId" + "}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (prefix != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("prefix", prefix));
        }

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (amount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("amount", amount));
        }

        if (effective != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("effective", effective));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUserPoliciesValidateBeforeCall(String userId, String prefix, String after, Integer amount, Boolean effective, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listUserPolicies(Async)");
        }

        return listUserPoliciesCall(userId, prefix, after, amount, effective, _callback);

    }


    private ApiResponse<PolicyList> listUserPoliciesWithHttpInfo(String userId, String prefix, String after, Integer amount, Boolean effective) throws ApiException {
        okhttp3.Call localVarCall = listUserPoliciesValidateBeforeCall(userId, prefix, after, amount, effective, null);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listUserPoliciesAsync(String userId, String prefix, String after, Integer amount, Boolean effective, final ApiCallback<PolicyList> _callback) throws ApiException {

        okhttp3.Call localVarCall = listUserPoliciesValidateBeforeCall(userId, prefix, after, amount, effective, _callback);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistUserPoliciesRequest {
        private final String userId;
        private String prefix;
        private String after;
        private Integer amount;
        private Boolean effective;

        private APIlistUserPoliciesRequest(String userId) {
            this.userId = userId;
        }

        /**
         * Set prefix
         * @param prefix return items prefixed with this value (optional)
         * @return APIlistUserPoliciesRequest
         */
        public APIlistUserPoliciesRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Set after
         * @param after return items after this value (optional)
         * @return APIlistUserPoliciesRequest
         */
        public APIlistUserPoliciesRequest after(String after) {
            this.after = after;
            return this;
        }

        /**
         * Set amount
         * @param amount how many items to return (optional, default to 100)
         * @return APIlistUserPoliciesRequest
         */
        public APIlistUserPoliciesRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Set effective
         * @param effective will return all distinct policies attached to the user or any of its groups (optional, default to false)
         * @return APIlistUserPoliciesRequest
         */
        public APIlistUserPoliciesRequest effective(Boolean effective) {
            this.effective = effective;
            return this;
        }

        /**
         * Build call for listUserPolicies
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listUserPoliciesCall(userId, prefix, after, amount, effective, _callback);
        }

        /**
         * Execute listUserPolicies request
         * @return PolicyList
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public PolicyList execute() throws ApiException {
            ApiResponse<PolicyList> localVarResp = listUserPoliciesWithHttpInfo(userId, prefix, after, amount, effective);
            return localVarResp.getData();
        }

        /**
         * Execute listUserPolicies request with HTTP info returned
         * @return ApiResponse&lt;PolicyList&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PolicyList> executeWithHttpInfo() throws ApiException {
            return listUserPoliciesWithHttpInfo(userId, prefix, after, amount, effective);
        }

        /**
         * Execute listUserPolicies request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PolicyList> _callback) throws ApiException {
            return listUserPoliciesAsync(userId, prefix, after, amount, effective, _callback);
        }
    }

    /**
     * list user policies
     * 
     * @param userId  (required)
     * @return APIlistUserPoliciesRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> policy list </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIlistUserPoliciesRequest listUserPolicies(String userId) {
        return new APIlistUserPoliciesRequest(userId);
    }
    private okhttp3.Call listUsersCall(String prefix, String after, Integer amount, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/users";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (prefix != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("prefix", prefix));
        }

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (amount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("amount", amount));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUsersValidateBeforeCall(String prefix, String after, Integer amount, final ApiCallback _callback) throws ApiException {
        return listUsersCall(prefix, after, amount, _callback);

    }


    private ApiResponse<UserList> listUsersWithHttpInfo(String prefix, String after, Integer amount) throws ApiException {
        okhttp3.Call localVarCall = listUsersValidateBeforeCall(prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<UserList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listUsersAsync(String prefix, String after, Integer amount, final ApiCallback<UserList> _callback) throws ApiException {

        okhttp3.Call localVarCall = listUsersValidateBeforeCall(prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<UserList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistUsersRequest {
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistUsersRequest() {
        }

        /**
         * Set prefix
         * @param prefix return items prefixed with this value (optional)
         * @return APIlistUsersRequest
         */
        public APIlistUsersRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Set after
         * @param after return items after this value (optional)
         * @return APIlistUsersRequest
         */
        public APIlistUsersRequest after(String after) {
            this.after = after;
            return this;
        }

        /**
         * Set amount
         * @param amount how many items to return (optional, default to 100)
         * @return APIlistUsersRequest
         */
        public APIlistUsersRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Build call for listUsers
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> user list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listUsersCall(prefix, after, amount, _callback);
        }

        /**
         * Execute listUsers request
         * @return UserList
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> user list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public UserList execute() throws ApiException {
            ApiResponse<UserList> localVarResp = listUsersWithHttpInfo(prefix, after, amount);
            return localVarResp.getData();
        }

        /**
         * Execute listUsers request with HTTP info returned
         * @return ApiResponse&lt;UserList&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> user list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<UserList> executeWithHttpInfo() throws ApiException {
            return listUsersWithHttpInfo(prefix, after, amount);
        }

        /**
         * Execute listUsers request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> user list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<UserList> _callback) throws ApiException {
            return listUsersAsync(prefix, after, amount, _callback);
        }
    }

    /**
     * list users
     * 
     * @return APIlistUsersRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> user list </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIlistUsersRequest listUsers() {
        return new APIlistUsersRequest();
    }
    private okhttp3.Call loginCall(LoginInformation loginInformation, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = loginInformation;

        // create path and map variables
        String localVarPath = "/auth/login";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call loginValidateBeforeCall(LoginInformation loginInformation, final ApiCallback _callback) throws ApiException {
        return loginCall(loginInformation, _callback);

    }


    private ApiResponse<AuthenticationToken> loginWithHttpInfo(LoginInformation loginInformation) throws ApiException {
        okhttp3.Call localVarCall = loginValidateBeforeCall(loginInformation, null);
        Type localVarReturnType = new TypeToken<AuthenticationToken>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call loginAsync(LoginInformation loginInformation, final ApiCallback<AuthenticationToken> _callback) throws ApiException {

        okhttp3.Call localVarCall = loginValidateBeforeCall(loginInformation, _callback);
        Type localVarReturnType = new TypeToken<AuthenticationToken>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIloginRequest {
        private LoginInformation loginInformation;

        private APIloginRequest() {
        }

        /**
         * Set loginInformation
         * @param loginInformation  (optional)
         * @return APIloginRequest
         */
        public APIloginRequest loginInformation(LoginInformation loginInformation) {
            this.loginInformation = loginInformation;
            return this;
        }

        /**
         * Build call for login
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> successful login </td><td>  * Set-Cookie -  <br>  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return loginCall(loginInformation, _callback);
        }

        /**
         * Execute login request
         * @return AuthenticationToken
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> successful login </td><td>  * Set-Cookie -  <br>  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public AuthenticationToken execute() throws ApiException {
            ApiResponse<AuthenticationToken> localVarResp = loginWithHttpInfo(loginInformation);
            return localVarResp.getData();
        }

        /**
         * Execute login request with HTTP info returned
         * @return ApiResponse&lt;AuthenticationToken&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> successful login </td><td>  * Set-Cookie -  <br>  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<AuthenticationToken> executeWithHttpInfo() throws ApiException {
            return loginWithHttpInfo(loginInformation);
        }

        /**
         * Execute login request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> successful login </td><td>  * Set-Cookie -  <br>  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<AuthenticationToken> _callback) throws ApiException {
            return loginAsync(loginInformation, _callback);
        }
    }

    /**
     * perform a login
     * 
     * @return APIloginRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> successful login </td><td>  * Set-Cookie -  <br>  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIloginRequest login() {
        return new APIloginRequest();
    }
    private okhttp3.Call setGroupACLCall(String groupId, ACL ACL, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = ACL;

        // create path and map variables
        String localVarPath = "/auth/groups/{groupId}/acl"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setGroupACLValidateBeforeCall(String groupId, ACL ACL, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling setGroupACL(Async)");
        }

        // verify the required parameter 'ACL' is set
        if (ACL == null) {
            throw new ApiException("Missing the required parameter 'ACL' when calling setGroupACL(Async)");
        }

        return setGroupACLCall(groupId, ACL, _callback);

    }


    private ApiResponse<Void> setGroupACLWithHttpInfo(String groupId, ACL ACL) throws ApiException {
        okhttp3.Call localVarCall = setGroupACLValidateBeforeCall(groupId, ACL, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call setGroupACLAsync(String groupId, ACL ACL, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = setGroupACLValidateBeforeCall(groupId, ACL, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIsetGroupACLRequest {
        private final String groupId;
        private final ACL ACL;

        private APIsetGroupACLRequest(String groupId, ACL ACL) {
            this.groupId = groupId;
            this.ACL = ACL;
        }

        /**
         * Build call for setGroupACL
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> ACL successfully changed </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return setGroupACLCall(groupId, ACL, _callback);
        }

        /**
         * Execute setGroupACL request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> ACL successfully changed </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            setGroupACLWithHttpInfo(groupId, ACL);
        }

        /**
         * Execute setGroupACL request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> ACL successfully changed </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return setGroupACLWithHttpInfo(groupId, ACL);
        }

        /**
         * Execute setGroupACL request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> ACL successfully changed </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return setGroupACLAsync(groupId, ACL, _callback);
        }
    }

    /**
     * set ACL of group
     * 
     * @param groupId  (required)
     * @param ACL  (required)
     * @return APIsetGroupACLRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> ACL successfully changed </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIsetGroupACLRequest setGroupACL(String groupId, ACL ACL) {
        return new APIsetGroupACLRequest(groupId, ACL);
    }
    private okhttp3.Call updatePolicyCall(String policyId, Policy policy, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = policy;

        // create path and map variables
        String localVarPath = "/auth/policies/{policyId}"
            .replace("{" + "policyId" + "}", localVarApiClient.escapeString(policyId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updatePolicyValidateBeforeCall(String policyId, Policy policy, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'policyId' is set
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling updatePolicy(Async)");
        }

        // verify the required parameter 'policy' is set
        if (policy == null) {
            throw new ApiException("Missing the required parameter 'policy' when calling updatePolicy(Async)");
        }

        return updatePolicyCall(policyId, policy, _callback);

    }


    private ApiResponse<Policy> updatePolicyWithHttpInfo(String policyId, Policy policy) throws ApiException {
        okhttp3.Call localVarCall = updatePolicyValidateBeforeCall(policyId, policy, null);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call updatePolicyAsync(String policyId, Policy policy, final ApiCallback<Policy> _callback) throws ApiException {

        okhttp3.Call localVarCall = updatePolicyValidateBeforeCall(policyId, policy, _callback);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIupdatePolicyRequest {
        private final String policyId;
        private final Policy policy;

        private APIupdatePolicyRequest(String policyId, Policy policy) {
            this.policyId = policyId;
            this.policy = policy;
        }

        /**
         * Build call for updatePolicy
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return updatePolicyCall(policyId, policy, _callback);
        }

        /**
         * Execute updatePolicy request
         * @return Policy
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public Policy execute() throws ApiException {
            ApiResponse<Policy> localVarResp = updatePolicyWithHttpInfo(policyId, policy);
            return localVarResp.getData();
        }

        /**
         * Execute updatePolicy request with HTTP info returned
         * @return ApiResponse&lt;Policy&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Policy> executeWithHttpInfo() throws ApiException {
            return updatePolicyWithHttpInfo(policyId, policy);
        }

        /**
         * Execute updatePolicy request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> policy </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Policy> _callback) throws ApiException {
            return updatePolicyAsync(policyId, policy, _callback);
        }
    }

    /**
     * update policy
     * 
     * @param policyId  (required)
     * @param policy  (required)
     * @return APIupdatePolicyRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> policy </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIupdatePolicyRequest updatePolicy(String policyId, Policy policy) {
        return new APIupdatePolicyRequest(policyId, policy);
    }
}
