/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.model.AbortPresignMultipartUpload;
import io.lakefs.clients.sdk.model.CompletePresignMultipartUpload;
import io.lakefs.clients.sdk.model.ObjectStats;
import io.lakefs.clients.sdk.model.PresignMultipartUpload;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ExperimentalApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ExperimentalApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExperimentalApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call abortPresignMultipartUploadCall(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AbortPresignMultipartUpload localVarPostBody = abortPresignMultipartUpload;
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/pmpu/{uploadId}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString())).replace("{uploadId}", this.localVarApiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call abortPresignMultipartUploadValidateBeforeCall(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling abortPresignMultipartUpload(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling abortPresignMultipartUpload(Async)");
        }
        if (uploadId == null) {
            throw new ApiException("Missing the required parameter 'uploadId' when calling abortPresignMultipartUpload(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling abortPresignMultipartUpload(Async)");
        }
        return this.abortPresignMultipartUploadCall(repository, branch, uploadId, path, abortPresignMultipartUpload, _callback);
    }

    private ApiResponse<Void> abortPresignMultipartUploadWithHttpInfo(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload) throws ApiException {
        Call localVarCall = this.abortPresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, abortPresignMultipartUpload, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call abortPresignMultipartUploadAsync(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.abortPresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, abortPresignMultipartUpload, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIabortPresignMultipartUploadRequest abortPresignMultipartUpload(String repository, String branch, String uploadId, String path) {
        return new APIabortPresignMultipartUploadRequest(repository, branch, uploadId, path);
    }

    private Call completePresignMultipartUploadCall(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CompletePresignMultipartUpload localVarPostBody = completePresignMultipartUpload;
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/pmpu/{uploadId}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString())).replace("{uploadId}", this.localVarApiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call completePresignMultipartUploadValidateBeforeCall(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling completePresignMultipartUpload(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling completePresignMultipartUpload(Async)");
        }
        if (uploadId == null) {
            throw new ApiException("Missing the required parameter 'uploadId' when calling completePresignMultipartUpload(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling completePresignMultipartUpload(Async)");
        }
        return this.completePresignMultipartUploadCall(repository, branch, uploadId, path, completePresignMultipartUpload, _callback);
    }

    private ApiResponse<ObjectStats> completePresignMultipartUploadWithHttpInfo(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload) throws ApiException {
        Call localVarCall = this.completePresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, completePresignMultipartUpload, null);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call completePresignMultipartUploadAsync(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload, ApiCallback<ObjectStats> _callback) throws ApiException {
        Call localVarCall = this.completePresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, completePresignMultipartUpload, _callback);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcompletePresignMultipartUploadRequest completePresignMultipartUpload(String repository, String branch, String uploadId, String path) {
        return new APIcompletePresignMultipartUploadRequest(repository, branch, uploadId, path);
    }

    private Call createPresignMultipartUploadCall(String repository, String branch, String path, Integer parts, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/pmpu".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if (parts != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("parts", parts));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPresignMultipartUploadValidateBeforeCall(String repository, String branch, String path, Integer parts, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createPresignMultipartUpload(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling createPresignMultipartUpload(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling createPresignMultipartUpload(Async)");
        }
        return this.createPresignMultipartUploadCall(repository, branch, path, parts, _callback);
    }

    private ApiResponse<PresignMultipartUpload> createPresignMultipartUploadWithHttpInfo(String repository, String branch, String path, Integer parts) throws ApiException {
        Call localVarCall = this.createPresignMultipartUploadValidateBeforeCall(repository, branch, path, parts, null);
        Type localVarReturnType = new TypeToken<PresignMultipartUpload>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createPresignMultipartUploadAsync(String repository, String branch, String path, Integer parts, ApiCallback<PresignMultipartUpload> _callback) throws ApiException {
        Call localVarCall = this.createPresignMultipartUploadValidateBeforeCall(repository, branch, path, parts, _callback);
        Type localVarReturnType = new TypeToken<PresignMultipartUpload>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreatePresignMultipartUploadRequest createPresignMultipartUpload(String repository, String branch, String path) {
        return new APIcreatePresignMultipartUploadRequest(repository, branch, path);
    }

    private Call hardResetBranchCall(String repository, String branch, String ref, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/hard_reset".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ref != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ref", ref));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call hardResetBranchValidateBeforeCall(String repository, String branch, String ref, Boolean force, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling hardResetBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling hardResetBranch(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling hardResetBranch(Async)");
        }
        return this.hardResetBranchCall(repository, branch, ref, force, _callback);
    }

    private ApiResponse<Void> hardResetBranchWithHttpInfo(String repository, String branch, String ref, Boolean force) throws ApiException {
        Call localVarCall = this.hardResetBranchValidateBeforeCall(repository, branch, ref, force, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call hardResetBranchAsync(String repository, String branch, String ref, Boolean force, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.hardResetBranchValidateBeforeCall(repository, branch, ref, force, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIhardResetBranchRequest hardResetBranch(String repository, String branch, String ref) {
        return new APIhardResetBranchRequest(repository, branch, ref);
    }

    public class APIhardResetBranchRequest {
        private final String repository;
        private final String branch;
        private final String ref;
        private Boolean force;

        private APIhardResetBranchRequest(String repository, String branch, String ref) {
            this.repository = repository;
            this.branch = branch;
            this.ref = ref;
        }

        public APIhardResetBranchRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExperimentalApi.this.hardResetBranchCall(this.repository, this.branch, this.ref, this.force, _callback);
        }

        public void execute() throws ApiException {
            ExperimentalApi.this.hardResetBranchWithHttpInfo(this.repository, this.branch, this.ref, this.force);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ExperimentalApi.this.hardResetBranchWithHttpInfo(this.repository, this.branch, this.ref, this.force);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ExperimentalApi.this.hardResetBranchAsync(this.repository, this.branch, this.ref, this.force, _callback);
        }
    }

    public class APIcreatePresignMultipartUploadRequest {
        private final String repository;
        private final String branch;
        private final String path;
        private Integer parts;

        private APIcreatePresignMultipartUploadRequest(String repository, String branch, String path) {
            this.repository = repository;
            this.branch = branch;
            this.path = path;
        }

        public APIcreatePresignMultipartUploadRequest parts(Integer parts) {
            this.parts = parts;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExperimentalApi.this.createPresignMultipartUploadCall(this.repository, this.branch, this.path, this.parts, _callback);
        }

        public PresignMultipartUpload execute() throws ApiException {
            ApiResponse localVarResp = ExperimentalApi.this.createPresignMultipartUploadWithHttpInfo(this.repository, this.branch, this.path, this.parts);
            return (PresignMultipartUpload)localVarResp.getData();
        }

        public ApiResponse<PresignMultipartUpload> executeWithHttpInfo() throws ApiException {
            return ExperimentalApi.this.createPresignMultipartUploadWithHttpInfo(this.repository, this.branch, this.path, this.parts);
        }

        public Call executeAsync(ApiCallback<PresignMultipartUpload> _callback) throws ApiException {
            return ExperimentalApi.this.createPresignMultipartUploadAsync(this.repository, this.branch, this.path, this.parts, _callback);
        }
    }

    public class APIcompletePresignMultipartUploadRequest {
        private final String repository;
        private final String branch;
        private final String uploadId;
        private final String path;
        private CompletePresignMultipartUpload completePresignMultipartUpload;

        private APIcompletePresignMultipartUploadRequest(String repository, String branch, String uploadId, String path) {
            this.repository = repository;
            this.branch = branch;
            this.uploadId = uploadId;
            this.path = path;
        }

        public APIcompletePresignMultipartUploadRequest completePresignMultipartUpload(CompletePresignMultipartUpload completePresignMultipartUpload) {
            this.completePresignMultipartUpload = completePresignMultipartUpload;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExperimentalApi.this.completePresignMultipartUploadCall(this.repository, this.branch, this.uploadId, this.path, this.completePresignMultipartUpload, _callback);
        }

        public ObjectStats execute() throws ApiException {
            ApiResponse localVarResp = ExperimentalApi.this.completePresignMultipartUploadWithHttpInfo(this.repository, this.branch, this.uploadId, this.path, this.completePresignMultipartUpload);
            return (ObjectStats)localVarResp.getData();
        }

        public ApiResponse<ObjectStats> executeWithHttpInfo() throws ApiException {
            return ExperimentalApi.this.completePresignMultipartUploadWithHttpInfo(this.repository, this.branch, this.uploadId, this.path, this.completePresignMultipartUpload);
        }

        public Call executeAsync(ApiCallback<ObjectStats> _callback) throws ApiException {
            return ExperimentalApi.this.completePresignMultipartUploadAsync(this.repository, this.branch, this.uploadId, this.path, this.completePresignMultipartUpload, _callback);
        }
    }

    public class APIabortPresignMultipartUploadRequest {
        private final String repository;
        private final String branch;
        private final String uploadId;
        private final String path;
        private AbortPresignMultipartUpload abortPresignMultipartUpload;

        private APIabortPresignMultipartUploadRequest(String repository, String branch, String uploadId, String path) {
            this.repository = repository;
            this.branch = branch;
            this.uploadId = uploadId;
            this.path = path;
        }

        public APIabortPresignMultipartUploadRequest abortPresignMultipartUpload(AbortPresignMultipartUpload abortPresignMultipartUpload) {
            this.abortPresignMultipartUpload = abortPresignMultipartUpload;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExperimentalApi.this.abortPresignMultipartUploadCall(this.repository, this.branch, this.uploadId, this.path, this.abortPresignMultipartUpload, _callback);
        }

        public void execute() throws ApiException {
            ExperimentalApi.this.abortPresignMultipartUploadWithHttpInfo(this.repository, this.branch, this.uploadId, this.path, this.abortPresignMultipartUpload);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ExperimentalApi.this.abortPresignMultipartUploadWithHttpInfo(this.repository, this.branch, this.uploadId, this.path, this.abortPresignMultipartUpload);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ExperimentalApi.this.abortPresignMultipartUploadAsync(this.repository, this.branch, this.uploadId, this.path, this.abortPresignMultipartUpload, _callback);
        }
    }
}

