/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.model.AuthCapabilities;
import io.lakefs.clients.sdk.model.BranchProtectionRule;
import io.lakefs.clients.sdk.model.CommPrefsInput;
import io.lakefs.clients.sdk.model.CommitRecordCreation;
import io.lakefs.clients.sdk.model.CredentialsWithSecret;
import io.lakefs.clients.sdk.model.GarbageCollectionConfig;
import io.lakefs.clients.sdk.model.GarbageCollectionPrepareResponse;
import io.lakefs.clients.sdk.model.GarbageCollectionRules;
import io.lakefs.clients.sdk.model.InstallationUsageReport;
import io.lakefs.clients.sdk.model.InternalDeleteBranchProtectionRuleRequest;
import io.lakefs.clients.sdk.model.ObjectStageCreation;
import io.lakefs.clients.sdk.model.ObjectStats;
import io.lakefs.clients.sdk.model.PrepareGCUncommittedRequest;
import io.lakefs.clients.sdk.model.PrepareGCUncommittedResponse;
import io.lakefs.clients.sdk.model.RefsDump;
import io.lakefs.clients.sdk.model.RefsRestore;
import io.lakefs.clients.sdk.model.RepositoryMetadataKeys;
import io.lakefs.clients.sdk.model.RepositoryMetadataSet;
import io.lakefs.clients.sdk.model.Setup;
import io.lakefs.clients.sdk.model.SetupState;
import io.lakefs.clients.sdk.model.StatsEventsList;
import io.lakefs.clients.sdk.model.StorageConfig;
import io.lakefs.clients.sdk.model.StorageURI;
import io.lakefs.clients.sdk.model.VersionConfig;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class InternalApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InternalApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InternalApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createBranchProtectionRulePreflightCall(String repository, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branch_protection/set_allowed".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBranchProtectionRulePreflightValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createBranchProtectionRulePreflight(Async)");
        }
        return this.createBranchProtectionRulePreflightCall(repository, _callback);
    }

    private ApiResponse<Void> createBranchProtectionRulePreflightWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.createBranchProtectionRulePreflightValidateBeforeCall(repository, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call createBranchProtectionRulePreflightAsync(String repository, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createBranchProtectionRulePreflightValidateBeforeCall(repository, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcreateBranchProtectionRulePreflightRequest createBranchProtectionRulePreflight(String repository) {
        return new APIcreateBranchProtectionRulePreflightRequest(repository);
    }

    private Call createCommitRecordCall(String repository, CommitRecordCreation commitRecordCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CommitRecordCreation localVarPostBody = commitRecordCreation;
        String localVarPath = "/repositories/{repository}/commits".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCommitRecordValidateBeforeCall(String repository, CommitRecordCreation commitRecordCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createCommitRecord(Async)");
        }
        if (commitRecordCreation == null) {
            throw new ApiException("Missing the required parameter 'commitRecordCreation' when calling createCommitRecord(Async)");
        }
        return this.createCommitRecordCall(repository, commitRecordCreation, _callback);
    }

    private ApiResponse<Void> createCommitRecordWithHttpInfo(String repository, CommitRecordCreation commitRecordCreation) throws ApiException {
        Call localVarCall = this.createCommitRecordValidateBeforeCall(repository, commitRecordCreation, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call createCommitRecordAsync(String repository, CommitRecordCreation commitRecordCreation, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createCommitRecordValidateBeforeCall(repository, commitRecordCreation, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcreateCommitRecordRequest createCommitRecord(String repository, CommitRecordCreation commitRecordCreation) {
        return new APIcreateCommitRecordRequest(repository, commitRecordCreation);
    }

    private Call createSymlinkFileCall(String repository, String branch, String location, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{branch}/symlink".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (location != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("location", location));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSymlinkFileValidateBeforeCall(String repository, String branch, String location, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createSymlinkFile(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling createSymlinkFile(Async)");
        }
        return this.createSymlinkFileCall(repository, branch, location, _callback);
    }

    private ApiResponse<StorageURI> createSymlinkFileWithHttpInfo(String repository, String branch, String location) throws ApiException {
        Call localVarCall = this.createSymlinkFileValidateBeforeCall(repository, branch, location, null);
        Type localVarReturnType = new TypeToken<StorageURI>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createSymlinkFileAsync(String repository, String branch, String location, ApiCallback<StorageURI> _callback) throws ApiException {
        Call localVarCall = this.createSymlinkFileValidateBeforeCall(repository, branch, location, _callback);
        Type localVarReturnType = new TypeToken<StorageURI>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateSymlinkFileRequest createSymlinkFile(String repository, String branch) {
        return new APIcreateSymlinkFileRequest(repository, branch);
    }

    private Call deleteRepositoryMetadataCall(String repository, RepositoryMetadataKeys repositoryMetadataKeys, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RepositoryMetadataKeys localVarPostBody = repositoryMetadataKeys;
        String localVarPath = "/repositories/{repository}/metadata".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteRepositoryMetadataValidateBeforeCall(String repository, RepositoryMetadataKeys repositoryMetadataKeys, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling deleteRepositoryMetadata(Async)");
        }
        if (repositoryMetadataKeys == null) {
            throw new ApiException("Missing the required parameter 'repositoryMetadataKeys' when calling deleteRepositoryMetadata(Async)");
        }
        return this.deleteRepositoryMetadataCall(repository, repositoryMetadataKeys, _callback);
    }

    private ApiResponse<Void> deleteRepositoryMetadataWithHttpInfo(String repository, RepositoryMetadataKeys repositoryMetadataKeys) throws ApiException {
        Call localVarCall = this.deleteRepositoryMetadataValidateBeforeCall(repository, repositoryMetadataKeys, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteRepositoryMetadataAsync(String repository, RepositoryMetadataKeys repositoryMetadataKeys, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteRepositoryMetadataValidateBeforeCall(repository, repositoryMetadataKeys, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIdeleteRepositoryMetadataRequest deleteRepositoryMetadata(String repository, RepositoryMetadataKeys repositoryMetadataKeys) {
        return new APIdeleteRepositoryMetadataRequest(repository, repositoryMetadataKeys);
    }

    private Call dumpRefsCall(String repository, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/dump".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call dumpRefsValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling dumpRefs(Async)");
        }
        return this.dumpRefsCall(repository, _callback);
    }

    private ApiResponse<RefsDump> dumpRefsWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.dumpRefsValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<RefsDump>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call dumpRefsAsync(String repository, ApiCallback<RefsDump> _callback) throws ApiException {
        Call localVarCall = this.dumpRefsValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<RefsDump>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdumpRefsRequest dumpRefs(String repository) {
        return new APIdumpRefsRequest(repository);
    }

    private Call getAuthCapabilitiesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/capabilities";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAuthCapabilitiesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getAuthCapabilitiesCall(_callback);
    }

    private ApiResponse<AuthCapabilities> getAuthCapabilitiesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAuthCapabilitiesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<AuthCapabilities>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAuthCapabilitiesAsync(ApiCallback<AuthCapabilities> _callback) throws ApiException {
        Call localVarCall = this.getAuthCapabilitiesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<AuthCapabilities>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetAuthCapabilitiesRequest getAuthCapabilities() {
        return new APIgetAuthCapabilitiesRequest();
    }

    private Call getGarbageCollectionConfigCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/config/garbage-collection";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGarbageCollectionConfigValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getGarbageCollectionConfigCall(_callback);
    }

    private ApiResponse<GarbageCollectionConfig> getGarbageCollectionConfigWithHttpInfo() throws ApiException {
        Call localVarCall = this.getGarbageCollectionConfigValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<GarbageCollectionConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getGarbageCollectionConfigAsync(ApiCallback<GarbageCollectionConfig> _callback) throws ApiException {
        Call localVarCall = this.getGarbageCollectionConfigValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<GarbageCollectionConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetGarbageCollectionConfigRequest getGarbageCollectionConfig() {
        return new APIgetGarbageCollectionConfigRequest();
    }

    private Call getLakeFSVersionCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/config/version";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call getLakeFSVersionValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getLakeFSVersionCall(_callback);
    }

    private ApiResponse<VersionConfig> getLakeFSVersionWithHttpInfo() throws ApiException {
        Call localVarCall = this.getLakeFSVersionValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<VersionConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getLakeFSVersionAsync(ApiCallback<VersionConfig> _callback) throws ApiException {
        Call localVarCall = this.getLakeFSVersionValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<VersionConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public APIgetLakeFSVersionRequest getLakeFSVersion() {
        return new APIgetLakeFSVersionRequest();
    }

    private Call getSetupStateCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/setup_lakefs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSetupStateValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getSetupStateCall(_callback);
    }

    private ApiResponse<SetupState> getSetupStateWithHttpInfo() throws ApiException {
        Call localVarCall = this.getSetupStateValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<SetupState>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getSetupStateAsync(ApiCallback<SetupState> _callback) throws ApiException {
        Call localVarCall = this.getSetupStateValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<SetupState>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetSetupStateRequest getSetupState() {
        return new APIgetSetupStateRequest();
    }

    private Call getStorageConfigCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/config/storage";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call getStorageConfigValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getStorageConfigCall(_callback);
    }

    private ApiResponse<StorageConfig> getStorageConfigWithHttpInfo() throws ApiException {
        Call localVarCall = this.getStorageConfigValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<StorageConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getStorageConfigAsync(ApiCallback<StorageConfig> _callback) throws ApiException {
        Call localVarCall = this.getStorageConfigValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<StorageConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public APIgetStorageConfigRequest getStorageConfig() {
        return new APIgetStorageConfigRequest();
    }

    private Call getUsageReportSummaryCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/usage-report/summary";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/text"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUsageReportSummaryValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getUsageReportSummaryCall(_callback);
    }

    private ApiResponse<InstallationUsageReport> getUsageReportSummaryWithHttpInfo() throws ApiException {
        Call localVarCall = this.getUsageReportSummaryValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<InstallationUsageReport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getUsageReportSummaryAsync(ApiCallback<InstallationUsageReport> _callback) throws ApiException {
        Call localVarCall = this.getUsageReportSummaryValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<InstallationUsageReport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetUsageReportSummaryRequest getUsageReportSummary() {
        return new APIgetUsageReportSummaryRequest();
    }

    private Call internalCreateBranchProtectionRuleCall(String repository, BranchProtectionRule branchProtectionRule, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BranchProtectionRule localVarPostBody = branchProtectionRule;
        String localVarPath = "/repositories/{repository}/branch_protection".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call internalCreateBranchProtectionRuleValidateBeforeCall(String repository, BranchProtectionRule branchProtectionRule, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling internalCreateBranchProtectionRule(Async)");
        }
        if (branchProtectionRule == null) {
            throw new ApiException("Missing the required parameter 'branchProtectionRule' when calling internalCreateBranchProtectionRule(Async)");
        }
        return this.internalCreateBranchProtectionRuleCall(repository, branchProtectionRule, _callback);
    }

    private ApiResponse<Void> internalCreateBranchProtectionRuleWithHttpInfo(String repository, BranchProtectionRule branchProtectionRule) throws ApiException {
        Call localVarCall = this.internalCreateBranchProtectionRuleValidateBeforeCall(repository, branchProtectionRule, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call internalCreateBranchProtectionRuleAsync(String repository, BranchProtectionRule branchProtectionRule, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.internalCreateBranchProtectionRuleValidateBeforeCall(repository, branchProtectionRule, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    @Deprecated
    public APIinternalCreateBranchProtectionRuleRequest internalCreateBranchProtectionRule(String repository, BranchProtectionRule branchProtectionRule) {
        return new APIinternalCreateBranchProtectionRuleRequest(repository, branchProtectionRule);
    }

    private Call internalDeleteBranchProtectionRuleCall(String repository, InternalDeleteBranchProtectionRuleRequest internalDeleteBranchProtectionRuleRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        InternalDeleteBranchProtectionRuleRequest localVarPostBody = internalDeleteBranchProtectionRuleRequest;
        String localVarPath = "/repositories/{repository}/branch_protection".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call internalDeleteBranchProtectionRuleValidateBeforeCall(String repository, InternalDeleteBranchProtectionRuleRequest internalDeleteBranchProtectionRuleRequest, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling internalDeleteBranchProtectionRule(Async)");
        }
        if (internalDeleteBranchProtectionRuleRequest == null) {
            throw new ApiException("Missing the required parameter 'internalDeleteBranchProtectionRuleRequest' when calling internalDeleteBranchProtectionRule(Async)");
        }
        return this.internalDeleteBranchProtectionRuleCall(repository, internalDeleteBranchProtectionRuleRequest, _callback);
    }

    private ApiResponse<Void> internalDeleteBranchProtectionRuleWithHttpInfo(String repository, InternalDeleteBranchProtectionRuleRequest internalDeleteBranchProtectionRuleRequest) throws ApiException {
        Call localVarCall = this.internalDeleteBranchProtectionRuleValidateBeforeCall(repository, internalDeleteBranchProtectionRuleRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call internalDeleteBranchProtectionRuleAsync(String repository, InternalDeleteBranchProtectionRuleRequest internalDeleteBranchProtectionRuleRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.internalDeleteBranchProtectionRuleValidateBeforeCall(repository, internalDeleteBranchProtectionRuleRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    @Deprecated
    public APIinternalDeleteBranchProtectionRuleRequest internalDeleteBranchProtectionRule(String repository, InternalDeleteBranchProtectionRuleRequest internalDeleteBranchProtectionRuleRequest) {
        return new APIinternalDeleteBranchProtectionRuleRequest(repository, internalDeleteBranchProtectionRuleRequest);
    }

    private Call internalDeleteGarbageCollectionRulesCall(String repository, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/gc/rules".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call internalDeleteGarbageCollectionRulesValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling internalDeleteGarbageCollectionRules(Async)");
        }
        return this.internalDeleteGarbageCollectionRulesCall(repository, _callback);
    }

    private ApiResponse<Void> internalDeleteGarbageCollectionRulesWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.internalDeleteGarbageCollectionRulesValidateBeforeCall(repository, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call internalDeleteGarbageCollectionRulesAsync(String repository, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.internalDeleteGarbageCollectionRulesValidateBeforeCall(repository, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    @Deprecated
    public APIinternalDeleteGarbageCollectionRulesRequest internalDeleteGarbageCollectionRules(String repository) {
        return new APIinternalDeleteGarbageCollectionRulesRequest(repository);
    }

    private Call internalGetBranchProtectionRulesCall(String repository, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branch_protection".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call internalGetBranchProtectionRulesValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling internalGetBranchProtectionRules(Async)");
        }
        return this.internalGetBranchProtectionRulesCall(repository, _callback);
    }

    private ApiResponse<List<BranchProtectionRule>> internalGetBranchProtectionRulesWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.internalGetBranchProtectionRulesValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<List<BranchProtectionRule>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call internalGetBranchProtectionRulesAsync(String repository, ApiCallback<List<BranchProtectionRule>> _callback) throws ApiException {
        Call localVarCall = this.internalGetBranchProtectionRulesValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<List<BranchProtectionRule>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public APIinternalGetBranchProtectionRulesRequest internalGetBranchProtectionRules(String repository) {
        return new APIinternalGetBranchProtectionRulesRequest(repository);
    }

    private Call internalGetGarbageCollectionRulesCall(String repository, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/gc/rules".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call internalGetGarbageCollectionRulesValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling internalGetGarbageCollectionRules(Async)");
        }
        return this.internalGetGarbageCollectionRulesCall(repository, _callback);
    }

    private ApiResponse<GarbageCollectionRules> internalGetGarbageCollectionRulesWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.internalGetGarbageCollectionRulesValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<GarbageCollectionRules>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call internalGetGarbageCollectionRulesAsync(String repository, ApiCallback<GarbageCollectionRules> _callback) throws ApiException {
        Call localVarCall = this.internalGetGarbageCollectionRulesValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<GarbageCollectionRules>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public APIinternalGetGarbageCollectionRulesRequest internalGetGarbageCollectionRules(String repository) {
        return new APIinternalGetGarbageCollectionRulesRequest(repository);
    }

    private Call internalSetGarbageCollectionRulesCall(String repository, GarbageCollectionRules garbageCollectionRules, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GarbageCollectionRules localVarPostBody = garbageCollectionRules;
        String localVarPath = "/repositories/{repository}/gc/rules".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call internalSetGarbageCollectionRulesValidateBeforeCall(String repository, GarbageCollectionRules garbageCollectionRules, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling internalSetGarbageCollectionRules(Async)");
        }
        if (garbageCollectionRules == null) {
            throw new ApiException("Missing the required parameter 'garbageCollectionRules' when calling internalSetGarbageCollectionRules(Async)");
        }
        return this.internalSetGarbageCollectionRulesCall(repository, garbageCollectionRules, _callback);
    }

    private ApiResponse<Void> internalSetGarbageCollectionRulesWithHttpInfo(String repository, GarbageCollectionRules garbageCollectionRules) throws ApiException {
        Call localVarCall = this.internalSetGarbageCollectionRulesValidateBeforeCall(repository, garbageCollectionRules, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call internalSetGarbageCollectionRulesAsync(String repository, GarbageCollectionRules garbageCollectionRules, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.internalSetGarbageCollectionRulesValidateBeforeCall(repository, garbageCollectionRules, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    @Deprecated
    public APIinternalSetGarbageCollectionRulesRequest internalSetGarbageCollectionRules(String repository, GarbageCollectionRules garbageCollectionRules) {
        return new APIinternalSetGarbageCollectionRulesRequest(repository, garbageCollectionRules);
    }

    private Call postStatsEventsCall(StatsEventsList statsEventsList, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        StatsEventsList localVarPostBody = statsEventsList;
        String localVarPath = "/statistics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postStatsEventsValidateBeforeCall(StatsEventsList statsEventsList, ApiCallback _callback) throws ApiException {
        if (statsEventsList == null) {
            throw new ApiException("Missing the required parameter 'statsEventsList' when calling postStatsEvents(Async)");
        }
        return this.postStatsEventsCall(statsEventsList, _callback);
    }

    private ApiResponse<Void> postStatsEventsWithHttpInfo(StatsEventsList statsEventsList) throws ApiException {
        Call localVarCall = this.postStatsEventsValidateBeforeCall(statsEventsList, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call postStatsEventsAsync(StatsEventsList statsEventsList, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.postStatsEventsValidateBeforeCall(statsEventsList, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIpostStatsEventsRequest postStatsEvents(StatsEventsList statsEventsList) {
        return new APIpostStatsEventsRequest(statsEventsList);
    }

    private Call prepareGarbageCollectionCommitsCall(String repository, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/gc/prepare_commits".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call prepareGarbageCollectionCommitsValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling prepareGarbageCollectionCommits(Async)");
        }
        return this.prepareGarbageCollectionCommitsCall(repository, _callback);
    }

    private ApiResponse<GarbageCollectionPrepareResponse> prepareGarbageCollectionCommitsWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.prepareGarbageCollectionCommitsValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<GarbageCollectionPrepareResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call prepareGarbageCollectionCommitsAsync(String repository, ApiCallback<GarbageCollectionPrepareResponse> _callback) throws ApiException {
        Call localVarCall = this.prepareGarbageCollectionCommitsValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<GarbageCollectionPrepareResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIprepareGarbageCollectionCommitsRequest prepareGarbageCollectionCommits(String repository) {
        return new APIprepareGarbageCollectionCommitsRequest(repository);
    }

    private Call prepareGarbageCollectionUncommittedCall(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PrepareGCUncommittedRequest localVarPostBody = prepareGCUncommittedRequest;
        String localVarPath = "/repositories/{repository}/gc/prepare_uncommited".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call prepareGarbageCollectionUncommittedValidateBeforeCall(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling prepareGarbageCollectionUncommitted(Async)");
        }
        return this.prepareGarbageCollectionUncommittedCall(repository, prepareGCUncommittedRequest, _callback);
    }

    private ApiResponse<PrepareGCUncommittedResponse> prepareGarbageCollectionUncommittedWithHttpInfo(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest) throws ApiException {
        Call localVarCall = this.prepareGarbageCollectionUncommittedValidateBeforeCall(repository, prepareGCUncommittedRequest, null);
        Type localVarReturnType = new TypeToken<PrepareGCUncommittedResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call prepareGarbageCollectionUncommittedAsync(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest, ApiCallback<PrepareGCUncommittedResponse> _callback) throws ApiException {
        Call localVarCall = this.prepareGarbageCollectionUncommittedValidateBeforeCall(repository, prepareGCUncommittedRequest, _callback);
        Type localVarReturnType = new TypeToken<PrepareGCUncommittedResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIprepareGarbageCollectionUncommittedRequest prepareGarbageCollectionUncommitted(String repository) {
        return new APIprepareGarbageCollectionUncommittedRequest(repository);
    }

    private Call restoreRefsCall(String repository, RefsRestore refsRestore, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RefsRestore localVarPostBody = refsRestore;
        String localVarPath = "/repositories/{repository}/refs/restore".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call restoreRefsValidateBeforeCall(String repository, RefsRestore refsRestore, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling restoreRefs(Async)");
        }
        if (refsRestore == null) {
            throw new ApiException("Missing the required parameter 'refsRestore' when calling restoreRefs(Async)");
        }
        return this.restoreRefsCall(repository, refsRestore, _callback);
    }

    private ApiResponse<Void> restoreRefsWithHttpInfo(String repository, RefsRestore refsRestore) throws ApiException {
        Call localVarCall = this.restoreRefsValidateBeforeCall(repository, refsRestore, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call restoreRefsAsync(String repository, RefsRestore refsRestore, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.restoreRefsValidateBeforeCall(repository, refsRestore, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIrestoreRefsRequest restoreRefs(String repository, RefsRestore refsRestore) {
        return new APIrestoreRefsRequest(repository, refsRestore);
    }

    private Call setGarbageCollectionRulesPreflightCall(String repository, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/gc/rules/set_allowed".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setGarbageCollectionRulesPreflightValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling setGarbageCollectionRulesPreflight(Async)");
        }
        return this.setGarbageCollectionRulesPreflightCall(repository, _callback);
    }

    private ApiResponse<Void> setGarbageCollectionRulesPreflightWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.setGarbageCollectionRulesPreflightValidateBeforeCall(repository, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call setGarbageCollectionRulesPreflightAsync(String repository, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setGarbageCollectionRulesPreflightValidateBeforeCall(repository, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIsetGarbageCollectionRulesPreflightRequest setGarbageCollectionRulesPreflight(String repository) {
        return new APIsetGarbageCollectionRulesPreflightRequest(repository);
    }

    private Call setRepositoryMetadataCall(String repository, RepositoryMetadataSet repositoryMetadataSet, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RepositoryMetadataSet localVarPostBody = repositoryMetadataSet;
        String localVarPath = "/repositories/{repository}/metadata".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setRepositoryMetadataValidateBeforeCall(String repository, RepositoryMetadataSet repositoryMetadataSet, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling setRepositoryMetadata(Async)");
        }
        if (repositoryMetadataSet == null) {
            throw new ApiException("Missing the required parameter 'repositoryMetadataSet' when calling setRepositoryMetadata(Async)");
        }
        return this.setRepositoryMetadataCall(repository, repositoryMetadataSet, _callback);
    }

    private ApiResponse<Void> setRepositoryMetadataWithHttpInfo(String repository, RepositoryMetadataSet repositoryMetadataSet) throws ApiException {
        Call localVarCall = this.setRepositoryMetadataValidateBeforeCall(repository, repositoryMetadataSet, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call setRepositoryMetadataAsync(String repository, RepositoryMetadataSet repositoryMetadataSet, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setRepositoryMetadataValidateBeforeCall(repository, repositoryMetadataSet, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIsetRepositoryMetadataRequest setRepositoryMetadata(String repository, RepositoryMetadataSet repositoryMetadataSet) {
        return new APIsetRepositoryMetadataRequest(repository, repositoryMetadataSet);
    }

    private Call setupCall(Setup setup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Setup localVarPostBody = setup;
        String localVarPath = "/setup_lakefs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setupValidateBeforeCall(Setup setup, ApiCallback _callback) throws ApiException {
        if (setup == null) {
            throw new ApiException("Missing the required parameter 'setup' when calling setup(Async)");
        }
        return this.setupCall(setup, _callback);
    }

    private ApiResponse<CredentialsWithSecret> setupWithHttpInfo(Setup setup) throws ApiException {
        Call localVarCall = this.setupValidateBeforeCall(setup, null);
        Type localVarReturnType = new TypeToken<CredentialsWithSecret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call setupAsync(Setup setup, ApiCallback<CredentialsWithSecret> _callback) throws ApiException {
        Call localVarCall = this.setupValidateBeforeCall(setup, _callback);
        Type localVarReturnType = new TypeToken<CredentialsWithSecret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsetupRequest setup(Setup setup) {
        return new APIsetupRequest(setup);
    }

    private Call setupCommPrefsCall(CommPrefsInput commPrefsInput, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CommPrefsInput localVarPostBody = commPrefsInput;
        String localVarPath = "/setup_comm_prefs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setupCommPrefsValidateBeforeCall(CommPrefsInput commPrefsInput, ApiCallback _callback) throws ApiException {
        if (commPrefsInput == null) {
            throw new ApiException("Missing the required parameter 'commPrefsInput' when calling setupCommPrefs(Async)");
        }
        return this.setupCommPrefsCall(commPrefsInput, _callback);
    }

    private ApiResponse<Void> setupCommPrefsWithHttpInfo(CommPrefsInput commPrefsInput) throws ApiException {
        Call localVarCall = this.setupCommPrefsValidateBeforeCall(commPrefsInput, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call setupCommPrefsAsync(CommPrefsInput commPrefsInput, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setupCommPrefsValidateBeforeCall(commPrefsInput, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIsetupCommPrefsRequest setupCommPrefs(CommPrefsInput commPrefsInput) {
        return new APIsetupCommPrefsRequest(commPrefsInput);
    }

    private Call stageObjectCall(String repository, String branch, String path, ObjectStageCreation objectStageCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ObjectStageCreation localVarPostBody = objectStageCreation;
        String localVarPath = "/repositories/{repository}/branches/{branch}/objects".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call stageObjectValidateBeforeCall(String repository, String branch, String path, ObjectStageCreation objectStageCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling stageObject(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling stageObject(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling stageObject(Async)");
        }
        if (objectStageCreation == null) {
            throw new ApiException("Missing the required parameter 'objectStageCreation' when calling stageObject(Async)");
        }
        return this.stageObjectCall(repository, branch, path, objectStageCreation, _callback);
    }

    private ApiResponse<ObjectStats> stageObjectWithHttpInfo(String repository, String branch, String path, ObjectStageCreation objectStageCreation) throws ApiException {
        Call localVarCall = this.stageObjectValidateBeforeCall(repository, branch, path, objectStageCreation, null);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call stageObjectAsync(String repository, String branch, String path, ObjectStageCreation objectStageCreation, ApiCallback<ObjectStats> _callback) throws ApiException {
        Call localVarCall = this.stageObjectValidateBeforeCall(repository, branch, path, objectStageCreation, _callback);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public APIstageObjectRequest stageObject(String repository, String branch, String path, ObjectStageCreation objectStageCreation) {
        return new APIstageObjectRequest(repository, branch, path, objectStageCreation);
    }

    private Call uploadObjectPreflightCall(String repository, String branch, String path, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/objects/stage_allowed".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadObjectPreflightValidateBeforeCall(String repository, String branch, String path, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling uploadObjectPreflight(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling uploadObjectPreflight(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling uploadObjectPreflight(Async)");
        }
        return this.uploadObjectPreflightCall(repository, branch, path, _callback);
    }

    private ApiResponse<Void> uploadObjectPreflightWithHttpInfo(String repository, String branch, String path) throws ApiException {
        Call localVarCall = this.uploadObjectPreflightValidateBeforeCall(repository, branch, path, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call uploadObjectPreflightAsync(String repository, String branch, String path, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.uploadObjectPreflightValidateBeforeCall(repository, branch, path, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIuploadObjectPreflightRequest uploadObjectPreflight(String repository, String branch, String path) {
        return new APIuploadObjectPreflightRequest(repository, branch, path);
    }

    public class APIuploadObjectPreflightRequest {
        private final String repository;
        private final String branch;
        private final String path;

        private APIuploadObjectPreflightRequest(String repository, String branch, String path) {
            this.repository = repository;
            this.branch = branch;
            this.path = path;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.uploadObjectPreflightCall(this.repository, this.branch, this.path, _callback);
        }

        public void execute() throws ApiException {
            InternalApi.this.uploadObjectPreflightWithHttpInfo(this.repository, this.branch, this.path);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.uploadObjectPreflightWithHttpInfo(this.repository, this.branch, this.path);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return InternalApi.this.uploadObjectPreflightAsync(this.repository, this.branch, this.path, _callback);
        }
    }

    public class APIstageObjectRequest {
        private final String repository;
        private final String branch;
        private final String path;
        private final ObjectStageCreation objectStageCreation;

        private APIstageObjectRequest(String repository, String branch, String path, ObjectStageCreation objectStageCreation) {
            this.repository = repository;
            this.branch = branch;
            this.path = path;
            this.objectStageCreation = objectStageCreation;
        }

        @Deprecated
        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.stageObjectCall(this.repository, this.branch, this.path, this.objectStageCreation, _callback);
        }

        @Deprecated
        public ObjectStats execute() throws ApiException {
            ApiResponse localVarResp = InternalApi.this.stageObjectWithHttpInfo(this.repository, this.branch, this.path, this.objectStageCreation);
            return (ObjectStats)localVarResp.getData();
        }

        @Deprecated
        public ApiResponse<ObjectStats> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.stageObjectWithHttpInfo(this.repository, this.branch, this.path, this.objectStageCreation);
        }

        @Deprecated
        public Call executeAsync(ApiCallback<ObjectStats> _callback) throws ApiException {
            return InternalApi.this.stageObjectAsync(this.repository, this.branch, this.path, this.objectStageCreation, _callback);
        }
    }

    public class APIsetupCommPrefsRequest {
        private final CommPrefsInput commPrefsInput;

        private APIsetupCommPrefsRequest(CommPrefsInput commPrefsInput) {
            this.commPrefsInput = commPrefsInput;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.setupCommPrefsCall(this.commPrefsInput, _callback);
        }

        public void execute() throws ApiException {
            InternalApi.this.setupCommPrefsWithHttpInfo(this.commPrefsInput);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.setupCommPrefsWithHttpInfo(this.commPrefsInput);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return InternalApi.this.setupCommPrefsAsync(this.commPrefsInput, _callback);
        }
    }

    public class APIsetupRequest {
        private final Setup setup;

        private APIsetupRequest(Setup setup) {
            this.setup = setup;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.setupCall(this.setup, _callback);
        }

        public CredentialsWithSecret execute() throws ApiException {
            ApiResponse localVarResp = InternalApi.this.setupWithHttpInfo(this.setup);
            return (CredentialsWithSecret)localVarResp.getData();
        }

        public ApiResponse<CredentialsWithSecret> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.setupWithHttpInfo(this.setup);
        }

        public Call executeAsync(ApiCallback<CredentialsWithSecret> _callback) throws ApiException {
            return InternalApi.this.setupAsync(this.setup, _callback);
        }
    }

    public class APIsetRepositoryMetadataRequest {
        private final String repository;
        private final RepositoryMetadataSet repositoryMetadataSet;

        private APIsetRepositoryMetadataRequest(String repository, RepositoryMetadataSet repositoryMetadataSet) {
            this.repository = repository;
            this.repositoryMetadataSet = repositoryMetadataSet;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.setRepositoryMetadataCall(this.repository, this.repositoryMetadataSet, _callback);
        }

        public void execute() throws ApiException {
            InternalApi.this.setRepositoryMetadataWithHttpInfo(this.repository, this.repositoryMetadataSet);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.setRepositoryMetadataWithHttpInfo(this.repository, this.repositoryMetadataSet);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return InternalApi.this.setRepositoryMetadataAsync(this.repository, this.repositoryMetadataSet, _callback);
        }
    }

    public class APIsetGarbageCollectionRulesPreflightRequest {
        private final String repository;

        private APIsetGarbageCollectionRulesPreflightRequest(String repository) {
            this.repository = repository;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.setGarbageCollectionRulesPreflightCall(this.repository, _callback);
        }

        public void execute() throws ApiException {
            InternalApi.this.setGarbageCollectionRulesPreflightWithHttpInfo(this.repository);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.setGarbageCollectionRulesPreflightWithHttpInfo(this.repository);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return InternalApi.this.setGarbageCollectionRulesPreflightAsync(this.repository, _callback);
        }
    }

    public class APIrestoreRefsRequest {
        private final String repository;
        private final RefsRestore refsRestore;

        private APIrestoreRefsRequest(String repository, RefsRestore refsRestore) {
            this.repository = repository;
            this.refsRestore = refsRestore;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.restoreRefsCall(this.repository, this.refsRestore, _callback);
        }

        public void execute() throws ApiException {
            InternalApi.this.restoreRefsWithHttpInfo(this.repository, this.refsRestore);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.restoreRefsWithHttpInfo(this.repository, this.refsRestore);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return InternalApi.this.restoreRefsAsync(this.repository, this.refsRestore, _callback);
        }
    }

    public class APIprepareGarbageCollectionUncommittedRequest {
        private final String repository;
        private PrepareGCUncommittedRequest prepareGCUncommittedRequest;

        private APIprepareGarbageCollectionUncommittedRequest(String repository) {
            this.repository = repository;
        }

        public APIprepareGarbageCollectionUncommittedRequest prepareGCUncommittedRequest(PrepareGCUncommittedRequest prepareGCUncommittedRequest) {
            this.prepareGCUncommittedRequest = prepareGCUncommittedRequest;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.prepareGarbageCollectionUncommittedCall(this.repository, this.prepareGCUncommittedRequest, _callback);
        }

        public PrepareGCUncommittedResponse execute() throws ApiException {
            ApiResponse localVarResp = InternalApi.this.prepareGarbageCollectionUncommittedWithHttpInfo(this.repository, this.prepareGCUncommittedRequest);
            return (PrepareGCUncommittedResponse)localVarResp.getData();
        }

        public ApiResponse<PrepareGCUncommittedResponse> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.prepareGarbageCollectionUncommittedWithHttpInfo(this.repository, this.prepareGCUncommittedRequest);
        }

        public Call executeAsync(ApiCallback<PrepareGCUncommittedResponse> _callback) throws ApiException {
            return InternalApi.this.prepareGarbageCollectionUncommittedAsync(this.repository, this.prepareGCUncommittedRequest, _callback);
        }
    }

    public class APIprepareGarbageCollectionCommitsRequest {
        private final String repository;

        private APIprepareGarbageCollectionCommitsRequest(String repository) {
            this.repository = repository;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.prepareGarbageCollectionCommitsCall(this.repository, _callback);
        }

        public GarbageCollectionPrepareResponse execute() throws ApiException {
            ApiResponse localVarResp = InternalApi.this.prepareGarbageCollectionCommitsWithHttpInfo(this.repository);
            return (GarbageCollectionPrepareResponse)localVarResp.getData();
        }

        public ApiResponse<GarbageCollectionPrepareResponse> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.prepareGarbageCollectionCommitsWithHttpInfo(this.repository);
        }

        public Call executeAsync(ApiCallback<GarbageCollectionPrepareResponse> _callback) throws ApiException {
            return InternalApi.this.prepareGarbageCollectionCommitsAsync(this.repository, _callback);
        }
    }

    public class APIpostStatsEventsRequest {
        private final StatsEventsList statsEventsList;

        private APIpostStatsEventsRequest(StatsEventsList statsEventsList) {
            this.statsEventsList = statsEventsList;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.postStatsEventsCall(this.statsEventsList, _callback);
        }

        public void execute() throws ApiException {
            InternalApi.this.postStatsEventsWithHttpInfo(this.statsEventsList);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.postStatsEventsWithHttpInfo(this.statsEventsList);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return InternalApi.this.postStatsEventsAsync(this.statsEventsList, _callback);
        }
    }

    public class APIinternalSetGarbageCollectionRulesRequest {
        private final String repository;
        private final GarbageCollectionRules garbageCollectionRules;

        private APIinternalSetGarbageCollectionRulesRequest(String repository, GarbageCollectionRules garbageCollectionRules) {
            this.repository = repository;
            this.garbageCollectionRules = garbageCollectionRules;
        }

        @Deprecated
        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.internalSetGarbageCollectionRulesCall(this.repository, this.garbageCollectionRules, _callback);
        }

        @Deprecated
        public void execute() throws ApiException {
            InternalApi.this.internalSetGarbageCollectionRulesWithHttpInfo(this.repository, this.garbageCollectionRules);
        }

        @Deprecated
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.internalSetGarbageCollectionRulesWithHttpInfo(this.repository, this.garbageCollectionRules);
        }

        @Deprecated
        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return InternalApi.this.internalSetGarbageCollectionRulesAsync(this.repository, this.garbageCollectionRules, _callback);
        }
    }

    public class APIinternalGetGarbageCollectionRulesRequest {
        private final String repository;

        private APIinternalGetGarbageCollectionRulesRequest(String repository) {
            this.repository = repository;
        }

        @Deprecated
        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.internalGetGarbageCollectionRulesCall(this.repository, _callback);
        }

        @Deprecated
        public GarbageCollectionRules execute() throws ApiException {
            ApiResponse localVarResp = InternalApi.this.internalGetGarbageCollectionRulesWithHttpInfo(this.repository);
            return (GarbageCollectionRules)localVarResp.getData();
        }

        @Deprecated
        public ApiResponse<GarbageCollectionRules> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.internalGetGarbageCollectionRulesWithHttpInfo(this.repository);
        }

        @Deprecated
        public Call executeAsync(ApiCallback<GarbageCollectionRules> _callback) throws ApiException {
            return InternalApi.this.internalGetGarbageCollectionRulesAsync(this.repository, _callback);
        }
    }

    public class APIinternalGetBranchProtectionRulesRequest {
        private final String repository;

        private APIinternalGetBranchProtectionRulesRequest(String repository) {
            this.repository = repository;
        }

        @Deprecated
        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.internalGetBranchProtectionRulesCall(this.repository, _callback);
        }

        @Deprecated
        public List<BranchProtectionRule> execute() throws ApiException {
            ApiResponse localVarResp = InternalApi.this.internalGetBranchProtectionRulesWithHttpInfo(this.repository);
            return (List)localVarResp.getData();
        }

        @Deprecated
        public ApiResponse<List<BranchProtectionRule>> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.internalGetBranchProtectionRulesWithHttpInfo(this.repository);
        }

        @Deprecated
        public Call executeAsync(ApiCallback<List<BranchProtectionRule>> _callback) throws ApiException {
            return InternalApi.this.internalGetBranchProtectionRulesAsync(this.repository, _callback);
        }
    }

    public class APIinternalDeleteGarbageCollectionRulesRequest {
        private final String repository;

        private APIinternalDeleteGarbageCollectionRulesRequest(String repository) {
            this.repository = repository;
        }

        @Deprecated
        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.internalDeleteGarbageCollectionRulesCall(this.repository, _callback);
        }

        @Deprecated
        public void execute() throws ApiException {
            InternalApi.this.internalDeleteGarbageCollectionRulesWithHttpInfo(this.repository);
        }

        @Deprecated
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.internalDeleteGarbageCollectionRulesWithHttpInfo(this.repository);
        }

        @Deprecated
        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return InternalApi.this.internalDeleteGarbageCollectionRulesAsync(this.repository, _callback);
        }
    }

    public class APIinternalDeleteBranchProtectionRuleRequest {
        private final String repository;
        private final InternalDeleteBranchProtectionRuleRequest internalDeleteBranchProtectionRuleRequest;

        private APIinternalDeleteBranchProtectionRuleRequest(String repository, InternalDeleteBranchProtectionRuleRequest internalDeleteBranchProtectionRuleRequest) {
            this.repository = repository;
            this.internalDeleteBranchProtectionRuleRequest = internalDeleteBranchProtectionRuleRequest;
        }

        @Deprecated
        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.internalDeleteBranchProtectionRuleCall(this.repository, this.internalDeleteBranchProtectionRuleRequest, _callback);
        }

        @Deprecated
        public void execute() throws ApiException {
            InternalApi.this.internalDeleteBranchProtectionRuleWithHttpInfo(this.repository, this.internalDeleteBranchProtectionRuleRequest);
        }

        @Deprecated
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.internalDeleteBranchProtectionRuleWithHttpInfo(this.repository, this.internalDeleteBranchProtectionRuleRequest);
        }

        @Deprecated
        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return InternalApi.this.internalDeleteBranchProtectionRuleAsync(this.repository, this.internalDeleteBranchProtectionRuleRequest, _callback);
        }
    }

    public class APIinternalCreateBranchProtectionRuleRequest {
        private final String repository;
        private final BranchProtectionRule branchProtectionRule;

        private APIinternalCreateBranchProtectionRuleRequest(String repository, BranchProtectionRule branchProtectionRule) {
            this.repository = repository;
            this.branchProtectionRule = branchProtectionRule;
        }

        @Deprecated
        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.internalCreateBranchProtectionRuleCall(this.repository, this.branchProtectionRule, _callback);
        }

        @Deprecated
        public void execute() throws ApiException {
            InternalApi.this.internalCreateBranchProtectionRuleWithHttpInfo(this.repository, this.branchProtectionRule);
        }

        @Deprecated
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.internalCreateBranchProtectionRuleWithHttpInfo(this.repository, this.branchProtectionRule);
        }

        @Deprecated
        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return InternalApi.this.internalCreateBranchProtectionRuleAsync(this.repository, this.branchProtectionRule, _callback);
        }
    }

    public class APIgetUsageReportSummaryRequest {
        private APIgetUsageReportSummaryRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.getUsageReportSummaryCall(_callback);
        }

        public InstallationUsageReport execute() throws ApiException {
            ApiResponse localVarResp = InternalApi.this.getUsageReportSummaryWithHttpInfo();
            return (InstallationUsageReport)localVarResp.getData();
        }

        public ApiResponse<InstallationUsageReport> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.getUsageReportSummaryWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<InstallationUsageReport> _callback) throws ApiException {
            return InternalApi.this.getUsageReportSummaryAsync(_callback);
        }
    }

    public class APIgetStorageConfigRequest {
        private APIgetStorageConfigRequest() {
        }

        @Deprecated
        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.getStorageConfigCall(_callback);
        }

        @Deprecated
        public StorageConfig execute() throws ApiException {
            ApiResponse localVarResp = InternalApi.this.getStorageConfigWithHttpInfo();
            return (StorageConfig)localVarResp.getData();
        }

        @Deprecated
        public ApiResponse<StorageConfig> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.getStorageConfigWithHttpInfo();
        }

        @Deprecated
        public Call executeAsync(ApiCallback<StorageConfig> _callback) throws ApiException {
            return InternalApi.this.getStorageConfigAsync(_callback);
        }
    }

    public class APIgetSetupStateRequest {
        private APIgetSetupStateRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.getSetupStateCall(_callback);
        }

        public SetupState execute() throws ApiException {
            ApiResponse localVarResp = InternalApi.this.getSetupStateWithHttpInfo();
            return (SetupState)localVarResp.getData();
        }

        public ApiResponse<SetupState> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.getSetupStateWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<SetupState> _callback) throws ApiException {
            return InternalApi.this.getSetupStateAsync(_callback);
        }
    }

    public class APIgetLakeFSVersionRequest {
        private APIgetLakeFSVersionRequest() {
        }

        @Deprecated
        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.getLakeFSVersionCall(_callback);
        }

        @Deprecated
        public VersionConfig execute() throws ApiException {
            ApiResponse localVarResp = InternalApi.this.getLakeFSVersionWithHttpInfo();
            return (VersionConfig)localVarResp.getData();
        }

        @Deprecated
        public ApiResponse<VersionConfig> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.getLakeFSVersionWithHttpInfo();
        }

        @Deprecated
        public Call executeAsync(ApiCallback<VersionConfig> _callback) throws ApiException {
            return InternalApi.this.getLakeFSVersionAsync(_callback);
        }
    }

    public class APIgetGarbageCollectionConfigRequest {
        private APIgetGarbageCollectionConfigRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.getGarbageCollectionConfigCall(_callback);
        }

        public GarbageCollectionConfig execute() throws ApiException {
            ApiResponse localVarResp = InternalApi.this.getGarbageCollectionConfigWithHttpInfo();
            return (GarbageCollectionConfig)localVarResp.getData();
        }

        public ApiResponse<GarbageCollectionConfig> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.getGarbageCollectionConfigWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<GarbageCollectionConfig> _callback) throws ApiException {
            return InternalApi.this.getGarbageCollectionConfigAsync(_callback);
        }
    }

    public class APIgetAuthCapabilitiesRequest {
        private APIgetAuthCapabilitiesRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.getAuthCapabilitiesCall(_callback);
        }

        public AuthCapabilities execute() throws ApiException {
            ApiResponse localVarResp = InternalApi.this.getAuthCapabilitiesWithHttpInfo();
            return (AuthCapabilities)localVarResp.getData();
        }

        public ApiResponse<AuthCapabilities> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.getAuthCapabilitiesWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<AuthCapabilities> _callback) throws ApiException {
            return InternalApi.this.getAuthCapabilitiesAsync(_callback);
        }
    }

    public class APIdumpRefsRequest {
        private final String repository;

        private APIdumpRefsRequest(String repository) {
            this.repository = repository;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.dumpRefsCall(this.repository, _callback);
        }

        public RefsDump execute() throws ApiException {
            ApiResponse localVarResp = InternalApi.this.dumpRefsWithHttpInfo(this.repository);
            return (RefsDump)localVarResp.getData();
        }

        public ApiResponse<RefsDump> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.dumpRefsWithHttpInfo(this.repository);
        }

        public Call executeAsync(ApiCallback<RefsDump> _callback) throws ApiException {
            return InternalApi.this.dumpRefsAsync(this.repository, _callback);
        }
    }

    public class APIdeleteRepositoryMetadataRequest {
        private final String repository;
        private final RepositoryMetadataKeys repositoryMetadataKeys;

        private APIdeleteRepositoryMetadataRequest(String repository, RepositoryMetadataKeys repositoryMetadataKeys) {
            this.repository = repository;
            this.repositoryMetadataKeys = repositoryMetadataKeys;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.deleteRepositoryMetadataCall(this.repository, this.repositoryMetadataKeys, _callback);
        }

        public void execute() throws ApiException {
            InternalApi.this.deleteRepositoryMetadataWithHttpInfo(this.repository, this.repositoryMetadataKeys);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.deleteRepositoryMetadataWithHttpInfo(this.repository, this.repositoryMetadataKeys);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return InternalApi.this.deleteRepositoryMetadataAsync(this.repository, this.repositoryMetadataKeys, _callback);
        }
    }

    public class APIcreateSymlinkFileRequest {
        private final String repository;
        private final String branch;
        private String location;

        private APIcreateSymlinkFileRequest(String repository, String branch) {
            this.repository = repository;
            this.branch = branch;
        }

        public APIcreateSymlinkFileRequest location(String location) {
            this.location = location;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.createSymlinkFileCall(this.repository, this.branch, this.location, _callback);
        }

        public StorageURI execute() throws ApiException {
            ApiResponse localVarResp = InternalApi.this.createSymlinkFileWithHttpInfo(this.repository, this.branch, this.location);
            return (StorageURI)localVarResp.getData();
        }

        public ApiResponse<StorageURI> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.createSymlinkFileWithHttpInfo(this.repository, this.branch, this.location);
        }

        public Call executeAsync(ApiCallback<StorageURI> _callback) throws ApiException {
            return InternalApi.this.createSymlinkFileAsync(this.repository, this.branch, this.location, _callback);
        }
    }

    public class APIcreateCommitRecordRequest {
        private final String repository;
        private final CommitRecordCreation commitRecordCreation;

        private APIcreateCommitRecordRequest(String repository, CommitRecordCreation commitRecordCreation) {
            this.repository = repository;
            this.commitRecordCreation = commitRecordCreation;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.createCommitRecordCall(this.repository, this.commitRecordCreation, _callback);
        }

        public void execute() throws ApiException {
            InternalApi.this.createCommitRecordWithHttpInfo(this.repository, this.commitRecordCreation);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.createCommitRecordWithHttpInfo(this.repository, this.commitRecordCreation);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return InternalApi.this.createCommitRecordAsync(this.repository, this.commitRecordCreation, _callback);
        }
    }

    public class APIcreateBranchProtectionRulePreflightRequest {
        private final String repository;

        private APIcreateBranchProtectionRulePreflightRequest(String repository) {
            this.repository = repository;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InternalApi.this.createBranchProtectionRulePreflightCall(this.repository, _callback);
        }

        public void execute() throws ApiException {
            InternalApi.this.createBranchProtectionRulePreflightWithHttpInfo(this.repository);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return InternalApi.this.createBranchProtectionRulePreflightWithHttpInfo(this.repository);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return InternalApi.this.createBranchProtectionRulePreflightAsync(this.repository, _callback);
        }
    }
}

