/*
 * lakeFS API
 * lakeFS HTTP API
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.lakefs.clients.sdk;

import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.ProgressRequestBody;
import io.lakefs.clients.sdk.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.lakefs.clients.sdk.model.AbortPresignMultipartUpload;
import io.lakefs.clients.sdk.model.CompletePresignMultipartUpload;
import io.lakefs.clients.sdk.model.Error;
import io.lakefs.clients.sdk.model.ObjectStats;
import io.lakefs.clients.sdk.model.PresignMultipartUpload;
import io.lakefs.clients.sdk.model.StagingLocation;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExperimentalApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ExperimentalApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExperimentalApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call abortPresignMultipartUploadCall(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = abortPresignMultipartUpload;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/pmpu/{uploadId}"
            .replace("{" + "repository" + "}", localVarApiClient.escapeString(repository.toString()))
            .replace("{" + "branch" + "}", localVarApiClient.escapeString(branch.toString()))
            .replace("{" + "uploadId" + "}", localVarApiClient.escapeString(uploadId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (path != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("path", path));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call abortPresignMultipartUploadValidateBeforeCall(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling abortPresignMultipartUpload(Async)");
        }

        // verify the required parameter 'branch' is set
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling abortPresignMultipartUpload(Async)");
        }

        // verify the required parameter 'uploadId' is set
        if (uploadId == null) {
            throw new ApiException("Missing the required parameter 'uploadId' when calling abortPresignMultipartUpload(Async)");
        }

        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling abortPresignMultipartUpload(Async)");
        }

        return abortPresignMultipartUploadCall(repository, branch, uploadId, path, abortPresignMultipartUpload, _callback);

    }


    private ApiResponse<Void> abortPresignMultipartUploadWithHttpInfo(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload) throws ApiException {
        okhttp3.Call localVarCall = abortPresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, abortPresignMultipartUpload, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call abortPresignMultipartUploadAsync(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = abortPresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, abortPresignMultipartUpload, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIabortPresignMultipartUploadRequest {
        private final String repository;
        private final String branch;
        private final String uploadId;
        private final String path;
        private AbortPresignMultipartUpload abortPresignMultipartUpload;

        private APIabortPresignMultipartUploadRequest(String repository, String branch, String uploadId, String path) {
            this.repository = repository;
            this.branch = branch;
            this.uploadId = uploadId;
            this.path = path;
        }

        /**
         * Set abortPresignMultipartUpload
         * @param abortPresignMultipartUpload  (optional)
         * @return APIabortPresignMultipartUploadRequest
         */
        public APIabortPresignMultipartUploadRequest abortPresignMultipartUpload(AbortPresignMultipartUpload abortPresignMultipartUpload) {
            this.abortPresignMultipartUpload = abortPresignMultipartUpload;
            return this;
        }

        /**
         * Build call for abortPresignMultipartUpload
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> Presign multipart upload aborted </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return abortPresignMultipartUploadCall(repository, branch, uploadId, path, abortPresignMultipartUpload, _callback);
        }

        /**
         * Execute abortPresignMultipartUpload request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> Presign multipart upload aborted </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            abortPresignMultipartUploadWithHttpInfo(repository, branch, uploadId, path, abortPresignMultipartUpload);
        }

        /**
         * Execute abortPresignMultipartUpload request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> Presign multipart upload aborted </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return abortPresignMultipartUploadWithHttpInfo(repository, branch, uploadId, path, abortPresignMultipartUpload);
        }

        /**
         * Execute abortPresignMultipartUpload request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> Presign multipart upload aborted </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return abortPresignMultipartUploadAsync(repository, branch, uploadId, path, abortPresignMultipartUpload, _callback);
        }
    }

    /**
     * Abort a presign multipart upload
     * Aborts a presign multipart upload.
     * @param repository  (required)
     * @param branch  (required)
     * @param uploadId  (required)
     * @param path relative to the branch (required)
     * @return APIabortPresignMultipartUploadRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Presign multipart upload aborted </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIabortPresignMultipartUploadRequest abortPresignMultipartUpload(String repository, String branch, String uploadId, String path) {
        return new APIabortPresignMultipartUploadRequest(repository, branch, uploadId, path);
    }
    private okhttp3.Call completePresignMultipartUploadCall(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = completePresignMultipartUpload;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/pmpu/{uploadId}"
            .replace("{" + "repository" + "}", localVarApiClient.escapeString(repository.toString()))
            .replace("{" + "branch" + "}", localVarApiClient.escapeString(branch.toString()))
            .replace("{" + "uploadId" + "}", localVarApiClient.escapeString(uploadId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (path != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("path", path));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call completePresignMultipartUploadValidateBeforeCall(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling completePresignMultipartUpload(Async)");
        }

        // verify the required parameter 'branch' is set
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling completePresignMultipartUpload(Async)");
        }

        // verify the required parameter 'uploadId' is set
        if (uploadId == null) {
            throw new ApiException("Missing the required parameter 'uploadId' when calling completePresignMultipartUpload(Async)");
        }

        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling completePresignMultipartUpload(Async)");
        }

        return completePresignMultipartUploadCall(repository, branch, uploadId, path, completePresignMultipartUpload, _callback);

    }


    private ApiResponse<ObjectStats> completePresignMultipartUploadWithHttpInfo(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload) throws ApiException {
        okhttp3.Call localVarCall = completePresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, completePresignMultipartUpload, null);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call completePresignMultipartUploadAsync(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload, final ApiCallback<ObjectStats> _callback) throws ApiException {

        okhttp3.Call localVarCall = completePresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, completePresignMultipartUpload, _callback);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcompletePresignMultipartUploadRequest {
        private final String repository;
        private final String branch;
        private final String uploadId;
        private final String path;
        private CompletePresignMultipartUpload completePresignMultipartUpload;

        private APIcompletePresignMultipartUploadRequest(String repository, String branch, String uploadId, String path) {
            this.repository = repository;
            this.branch = branch;
            this.uploadId = uploadId;
            this.path = path;
        }

        /**
         * Set completePresignMultipartUpload
         * @param completePresignMultipartUpload  (optional)
         * @return APIcompletePresignMultipartUploadRequest
         */
        public APIcompletePresignMultipartUploadRequest completePresignMultipartUpload(CompletePresignMultipartUpload completePresignMultipartUpload) {
            this.completePresignMultipartUpload = completePresignMultipartUpload;
            return this;
        }

        /**
         * Build call for completePresignMultipartUpload
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Presign multipart upload completed </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> conflict with a commit, try here </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return completePresignMultipartUploadCall(repository, branch, uploadId, path, completePresignMultipartUpload, _callback);
        }

        /**
         * Execute completePresignMultipartUpload request
         * @return ObjectStats
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Presign multipart upload completed </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> conflict with a commit, try here </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ObjectStats execute() throws ApiException {
            ApiResponse<ObjectStats> localVarResp = completePresignMultipartUploadWithHttpInfo(repository, branch, uploadId, path, completePresignMultipartUpload);
            return localVarResp.getData();
        }

        /**
         * Execute completePresignMultipartUpload request with HTTP info returned
         * @return ApiResponse&lt;ObjectStats&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Presign multipart upload completed </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> conflict with a commit, try here </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ObjectStats> executeWithHttpInfo() throws ApiException {
            return completePresignMultipartUploadWithHttpInfo(repository, branch, uploadId, path, completePresignMultipartUpload);
        }

        /**
         * Execute completePresignMultipartUpload request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Presign multipart upload completed </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> conflict with a commit, try here </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ObjectStats> _callback) throws ApiException {
            return completePresignMultipartUploadAsync(repository, branch, uploadId, path, completePresignMultipartUpload, _callback);
        }
    }

    /**
     * Complete a presign multipart upload request
     * Completes a presign multipart upload by assembling the uploaded parts.
     * @param repository  (required)
     * @param branch  (required)
     * @param uploadId  (required)
     * @param path relative to the branch (required)
     * @return APIcompletePresignMultipartUploadRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Presign multipart upload completed </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> conflict with a commit, try here </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIcompletePresignMultipartUploadRequest completePresignMultipartUpload(String repository, String branch, String uploadId, String path) {
        return new APIcompletePresignMultipartUploadRequest(repository, branch, uploadId, path);
    }
    private okhttp3.Call createPresignMultipartUploadCall(String repository, String branch, String path, Integer parts, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/pmpu"
            .replace("{" + "repository" + "}", localVarApiClient.escapeString(repository.toString()))
            .replace("{" + "branch" + "}", localVarApiClient.escapeString(branch.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (path != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("path", path));
        }

        if (parts != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("parts", parts));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createPresignMultipartUploadValidateBeforeCall(String repository, String branch, String path, Integer parts, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createPresignMultipartUpload(Async)");
        }

        // verify the required parameter 'branch' is set
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling createPresignMultipartUpload(Async)");
        }

        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling createPresignMultipartUpload(Async)");
        }

        return createPresignMultipartUploadCall(repository, branch, path, parts, _callback);

    }


    private ApiResponse<PresignMultipartUpload> createPresignMultipartUploadWithHttpInfo(String repository, String branch, String path, Integer parts) throws ApiException {
        okhttp3.Call localVarCall = createPresignMultipartUploadValidateBeforeCall(repository, branch, path, parts, null);
        Type localVarReturnType = new TypeToken<PresignMultipartUpload>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call createPresignMultipartUploadAsync(String repository, String branch, String path, Integer parts, final ApiCallback<PresignMultipartUpload> _callback) throws ApiException {

        okhttp3.Call localVarCall = createPresignMultipartUploadValidateBeforeCall(repository, branch, path, parts, _callback);
        Type localVarReturnType = new TypeToken<PresignMultipartUpload>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcreatePresignMultipartUploadRequest {
        private final String repository;
        private final String branch;
        private final String path;
        private Integer parts;

        private APIcreatePresignMultipartUploadRequest(String repository, String branch, String path) {
            this.repository = repository;
            this.branch = branch;
            this.path = path;
        }

        /**
         * Set parts
         * @param parts number of presigned URL parts required to upload (optional)
         * @return APIcreatePresignMultipartUploadRequest
         */
        public APIcreatePresignMultipartUploadRequest parts(Integer parts) {
            this.parts = parts;
            return this;
        }

        /**
         * Build call for createPresignMultipartUpload
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Presign multipart upload initiated </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return createPresignMultipartUploadCall(repository, branch, path, parts, _callback);
        }

        /**
         * Execute createPresignMultipartUpload request
         * @return PresignMultipartUpload
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Presign multipart upload initiated </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public PresignMultipartUpload execute() throws ApiException {
            ApiResponse<PresignMultipartUpload> localVarResp = createPresignMultipartUploadWithHttpInfo(repository, branch, path, parts);
            return localVarResp.getData();
        }

        /**
         * Execute createPresignMultipartUpload request with HTTP info returned
         * @return ApiResponse&lt;PresignMultipartUpload&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Presign multipart upload initiated </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PresignMultipartUpload> executeWithHttpInfo() throws ApiException {
            return createPresignMultipartUploadWithHttpInfo(repository, branch, path, parts);
        }

        /**
         * Execute createPresignMultipartUpload request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Presign multipart upload initiated </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PresignMultipartUpload> _callback) throws ApiException {
            return createPresignMultipartUploadAsync(repository, branch, path, parts, _callback);
        }
    }

    /**
     * Initiate a multipart upload
     * Initiates a multipart upload and returns an upload ID with presigned URLs for each part (optional). Part numbers starts with 1. Each part except the last one has minimum size depends on the underlying blockstore implementation. For example working with S3 blockstore, minimum size is 5MB (excluding the last part). 
     * @param repository  (required)
     * @param branch  (required)
     * @param path relative to the branch (required)
     * @return APIcreatePresignMultipartUploadRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Presign multipart upload initiated </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIcreatePresignMultipartUploadRequest createPresignMultipartUpload(String repository, String branch, String path) {
        return new APIcreatePresignMultipartUploadRequest(repository, branch, path);
    }
    private okhttp3.Call hardResetBranchCall(String repository, String branch, String ref, Boolean force, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/branches/{branch}/hard_reset"
            .replace("{" + "repository" + "}", localVarApiClient.escapeString(repository.toString()))
            .replace("{" + "branch" + "}", localVarApiClient.escapeString(branch.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (ref != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ref", ref));
        }

        if (force != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("force", force));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call hardResetBranchValidateBeforeCall(String repository, String branch, String ref, Boolean force, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling hardResetBranch(Async)");
        }

        // verify the required parameter 'branch' is set
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling hardResetBranch(Async)");
        }

        // verify the required parameter 'ref' is set
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling hardResetBranch(Async)");
        }

        return hardResetBranchCall(repository, branch, ref, force, _callback);

    }


    private ApiResponse<Void> hardResetBranchWithHttpInfo(String repository, String branch, String ref, Boolean force) throws ApiException {
        okhttp3.Call localVarCall = hardResetBranchValidateBeforeCall(repository, branch, ref, force, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call hardResetBranchAsync(String repository, String branch, String ref, Boolean force, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = hardResetBranchValidateBeforeCall(repository, branch, ref, force, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIhardResetBranchRequest {
        private final String repository;
        private final String branch;
        private final String ref;
        private Boolean force;

        private APIhardResetBranchRequest(String repository, String branch, String ref) {
            this.repository = repository;
            this.branch = branch;
            this.ref = ref;
        }

        /**
         * Set force
         * @param force  (optional, default to false)
         * @return APIhardResetBranchRequest
         */
        public APIhardResetBranchRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        /**
         * Build call for hardResetBranch
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> reset successful </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return hardResetBranchCall(repository, branch, ref, force, _callback);
        }

        /**
         * Execute hardResetBranch request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> reset successful </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            hardResetBranchWithHttpInfo(repository, branch, ref, force);
        }

        /**
         * Execute hardResetBranch request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> reset successful </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return hardResetBranchWithHttpInfo(repository, branch, ref, force);
        }

        /**
         * Execute hardResetBranch request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> reset successful </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return hardResetBranchAsync(repository, branch, ref, force, _callback);
        }
    }

    /**
     * hard reset branch
     * Relocate branch to refer to ref.  Branch must not contain uncommitted data.
     * @param repository  (required)
     * @param branch  (required)
     * @param ref After reset, branch will point at this reference. (required)
     * @return APIhardResetBranchRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> reset successful </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIhardResetBranchRequest hardResetBranch(String repository, String branch, String ref) {
        return new APIhardResetBranchRequest(repository, branch, ref);
    }
}
