/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.lakefs.clients.sdk.JSON;
import io.lakefs.clients.sdk.model.Commit;
import io.lakefs.clients.sdk.model.Error;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImportStatus {
    public static final String SERIALIZED_NAME_COMPLETED = "completed";
    @SerializedName(value="completed")
    private Boolean completed;
    public static final String SERIALIZED_NAME_UPDATE_TIME = "update_time";
    @SerializedName(value="update_time")
    private OffsetDateTime updateTime;
    public static final String SERIALIZED_NAME_INGESTED_OBJECTS = "ingested_objects";
    @SerializedName(value="ingested_objects")
    private Long ingestedObjects;
    public static final String SERIALIZED_NAME_METARANGE_ID = "metarange_id";
    @SerializedName(value="metarange_id")
    private String metarangeId;
    public static final String SERIALIZED_NAME_COMMIT = "commit";
    @SerializedName(value="commit")
    private Commit commit;
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private Error error;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ImportStatus completed(Boolean completed) {
        this.completed = completed;
        return this;
    }

    @Nonnull
    public Boolean getCompleted() {
        return this.completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public ImportStatus updateTime(OffsetDateTime updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    @Nonnull
    public OffsetDateTime getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(OffsetDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public ImportStatus ingestedObjects(Long ingestedObjects) {
        this.ingestedObjects = ingestedObjects;
        return this;
    }

    @Nullable
    public Long getIngestedObjects() {
        return this.ingestedObjects;
    }

    public void setIngestedObjects(Long ingestedObjects) {
        this.ingestedObjects = ingestedObjects;
    }

    public ImportStatus metarangeId(String metarangeId) {
        this.metarangeId = metarangeId;
        return this;
    }

    @Nullable
    public String getMetarangeId() {
        return this.metarangeId;
    }

    public void setMetarangeId(String metarangeId) {
        this.metarangeId = metarangeId;
    }

    public ImportStatus commit(Commit commit) {
        this.commit = commit;
        return this;
    }

    @Nullable
    public Commit getCommit() {
        return this.commit;
    }

    public void setCommit(Commit commit) {
        this.commit = commit;
    }

    public ImportStatus error(Error error) {
        this.error = error;
        return this;
    }

    @Nullable
    public Error getError() {
        return this.error;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public ImportStatus putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportStatus importStatus = (ImportStatus)o;
        return Objects.equals(this.completed, importStatus.completed) && Objects.equals(this.updateTime, importStatus.updateTime) && Objects.equals(this.ingestedObjects, importStatus.ingestedObjects) && Objects.equals(this.metarangeId, importStatus.metarangeId) && Objects.equals(this.commit, importStatus.commit) && Objects.equals(this.error, importStatus.error) && Objects.equals(this.additionalProperties, importStatus.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.completed, this.updateTime, this.ingestedObjects, this.metarangeId, this.commit, this.error, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportStatus {\n");
        sb.append("    completed: ").append(this.toIndentedString(this.completed)).append("\n");
        sb.append("    updateTime: ").append(this.toIndentedString(this.updateTime)).append("\n");
        sb.append("    ingestedObjects: ").append(this.toIndentedString(this.ingestedObjects)).append("\n");
        sb.append("    metarangeId: ").append(this.toIndentedString(this.metarangeId)).append("\n");
        sb.append("    commit: ").append(this.toIndentedString(this.commit)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ImportStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_METARANGE_ID) != null && !jsonObj.get(SERIALIZED_NAME_METARANGE_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_METARANGE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `metarange_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_METARANGE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMIT) != null && !jsonObj.get(SERIALIZED_NAME_COMMIT).isJsonNull()) {
            Commit.validateJsonElement(jsonObj.get(SERIALIZED_NAME_COMMIT));
        }
        if (jsonObj.get(SERIALIZED_NAME_ERROR) != null && !jsonObj.get(SERIALIZED_NAME_ERROR).isJsonNull()) {
            Error.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ERROR));
        }
    }

    public static ImportStatus fromJson(String jsonString) throws IOException {
        return (ImportStatus)JSON.getGson().fromJson(jsonString, ImportStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COMPLETED);
        openapiFields.add(SERIALIZED_NAME_UPDATE_TIME);
        openapiFields.add(SERIALIZED_NAME_INGESTED_OBJECTS);
        openapiFields.add(SERIALIZED_NAME_METARANGE_ID);
        openapiFields.add(SERIALIZED_NAME_COMMIT);
        openapiFields.add(SERIALIZED_NAME_ERROR);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_COMPLETED);
        openapiRequiredFields.add(SERIALIZED_NAME_UPDATE_TIME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ImportStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ImportStatus.class));
            return new TypeAdapter<ImportStatus>(){

                public void write(JsonWriter out, ImportStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ImportStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ImportStatus.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    ImportStatus instance = (ImportStatus)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

