/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.model.OTFDiffs;
import io.lakefs.clients.sdk.model.OtfDiffList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ExperimentalApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ExperimentalApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExperimentalApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getOtfDiffsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/otf/diffs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOtfDiffsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getOtfDiffsCall(_callback);
    }

    private ApiResponse<OTFDiffs> getOtfDiffsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getOtfDiffsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<OTFDiffs>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getOtfDiffsAsync(ApiCallback<OTFDiffs> _callback) throws ApiException {
        Call localVarCall = this.getOtfDiffsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<OTFDiffs>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetOtfDiffsRequest getOtfDiffs() {
        return new APIgetOtfDiffsRequest();
    }

    private Call otfDiffCall(String repository, String leftRef, String rightRef, String tablePath, String type, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/otf/refs/{left_ref}/diff/{right_ref}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{left_ref}", this.localVarApiClient.escapeString(leftRef.toString())).replace("{right_ref}", this.localVarApiClient.escapeString(rightRef.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (tablePath != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("table_path", tablePath));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call otfDiffValidateBeforeCall(String repository, String leftRef, String rightRef, String tablePath, String type, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling otfDiff(Async)");
        }
        if (leftRef == null) {
            throw new ApiException("Missing the required parameter 'leftRef' when calling otfDiff(Async)");
        }
        if (rightRef == null) {
            throw new ApiException("Missing the required parameter 'rightRef' when calling otfDiff(Async)");
        }
        if (tablePath == null) {
            throw new ApiException("Missing the required parameter 'tablePath' when calling otfDiff(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling otfDiff(Async)");
        }
        return this.otfDiffCall(repository, leftRef, rightRef, tablePath, type, _callback);
    }

    private ApiResponse<OtfDiffList> otfDiffWithHttpInfo(String repository, String leftRef, String rightRef, String tablePath, String type) throws ApiException {
        Call localVarCall = this.otfDiffValidateBeforeCall(repository, leftRef, rightRef, tablePath, type, null);
        Type localVarReturnType = new TypeToken<OtfDiffList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call otfDiffAsync(String repository, String leftRef, String rightRef, String tablePath, String type, ApiCallback<OtfDiffList> _callback) throws ApiException {
        Call localVarCall = this.otfDiffValidateBeforeCall(repository, leftRef, rightRef, tablePath, type, _callback);
        Type localVarReturnType = new TypeToken<OtfDiffList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIotfDiffRequest otfDiff(String repository, String leftRef, String rightRef, String tablePath, String type) {
        return new APIotfDiffRequest(repository, leftRef, rightRef, tablePath, type);
    }

    public class APIotfDiffRequest {
        private final String repository;
        private final String leftRef;
        private final String rightRef;
        private final String tablePath;
        private final String type;

        private APIotfDiffRequest(String repository, String leftRef, String rightRef, String tablePath, String type) {
            this.repository = repository;
            this.leftRef = leftRef;
            this.rightRef = rightRef;
            this.tablePath = tablePath;
            this.type = type;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExperimentalApi.this.otfDiffCall(this.repository, this.leftRef, this.rightRef, this.tablePath, this.type, _callback);
        }

        public OtfDiffList execute() throws ApiException {
            ApiResponse localVarResp = ExperimentalApi.this.otfDiffWithHttpInfo(this.repository, this.leftRef, this.rightRef, this.tablePath, this.type);
            return (OtfDiffList)localVarResp.getData();
        }

        public ApiResponse<OtfDiffList> executeWithHttpInfo() throws ApiException {
            return ExperimentalApi.this.otfDiffWithHttpInfo(this.repository, this.leftRef, this.rightRef, this.tablePath, this.type);
        }

        public Call executeAsync(ApiCallback<OtfDiffList> _callback) throws ApiException {
            return ExperimentalApi.this.otfDiffAsync(this.repository, this.leftRef, this.rightRef, this.tablePath, this.type, _callback);
        }
    }

    public class APIgetOtfDiffsRequest {
        private APIgetOtfDiffsRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExperimentalApi.this.getOtfDiffsCall(_callback);
        }

        public OTFDiffs execute() throws ApiException {
            ApiResponse localVarResp = ExperimentalApi.this.getOtfDiffsWithHttpInfo();
            return (OTFDiffs)localVarResp.getData();
        }

        public ApiResponse<OTFDiffs> executeWithHttpInfo() throws ApiException {
            return ExperimentalApi.this.getOtfDiffsWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<OTFDiffs> _callback) throws ApiException {
            return ExperimentalApi.this.getOtfDiffsAsync(_callback);
        }
    }
}

