/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.model.CommitList;
import io.lakefs.clients.sdk.model.DiffList;
import io.lakefs.clients.sdk.model.FindMergeBaseResult;
import io.lakefs.clients.sdk.model.Merge;
import io.lakefs.clients.sdk.model.MergeResult;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class RefsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public RefsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RefsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call diffRefsCall(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{leftRef}/diff/{rightRef}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{leftRef}", this.localVarApiClient.escapeString(leftRef.toString())).replace("{rightRef}", this.localVarApiClient.escapeString(rightRef.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (delimiter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("delimiter", delimiter));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call diffRefsValidateBeforeCall(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling diffRefs(Async)");
        }
        if (leftRef == null) {
            throw new ApiException("Missing the required parameter 'leftRef' when calling diffRefs(Async)");
        }
        if (rightRef == null) {
            throw new ApiException("Missing the required parameter 'rightRef' when calling diffRefs(Async)");
        }
        return this.diffRefsCall(repository, leftRef, rightRef, after, amount, prefix, delimiter, type, _callback);
    }

    private ApiResponse<DiffList> diffRefsWithHttpInfo(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type) throws ApiException {
        Call localVarCall = this.diffRefsValidateBeforeCall(repository, leftRef, rightRef, after, amount, prefix, delimiter, type, null);
        Type localVarReturnType = new TypeToken<DiffList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call diffRefsAsync(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type, ApiCallback<DiffList> _callback) throws ApiException {
        Call localVarCall = this.diffRefsValidateBeforeCall(repository, leftRef, rightRef, after, amount, prefix, delimiter, type, _callback);
        Type localVarReturnType = new TypeToken<DiffList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdiffRefsRequest diffRefs(String repository, String leftRef, String rightRef) {
        return new APIdiffRefsRequest(repository, leftRef, rightRef);
    }

    private Call findMergeBaseCall(String repository, String sourceRef, String destinationBranch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{sourceRef}/merge/{destinationBranch}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{sourceRef}", this.localVarApiClient.escapeString(sourceRef.toString())).replace("{destinationBranch}", this.localVarApiClient.escapeString(destinationBranch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call findMergeBaseValidateBeforeCall(String repository, String sourceRef, String destinationBranch, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling findMergeBase(Async)");
        }
        if (sourceRef == null) {
            throw new ApiException("Missing the required parameter 'sourceRef' when calling findMergeBase(Async)");
        }
        if (destinationBranch == null) {
            throw new ApiException("Missing the required parameter 'destinationBranch' when calling findMergeBase(Async)");
        }
        return this.findMergeBaseCall(repository, sourceRef, destinationBranch, _callback);
    }

    private ApiResponse<FindMergeBaseResult> findMergeBaseWithHttpInfo(String repository, String sourceRef, String destinationBranch) throws ApiException {
        Call localVarCall = this.findMergeBaseValidateBeforeCall(repository, sourceRef, destinationBranch, null);
        Type localVarReturnType = new TypeToken<FindMergeBaseResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call findMergeBaseAsync(String repository, String sourceRef, String destinationBranch, ApiCallback<FindMergeBaseResult> _callback) throws ApiException {
        Call localVarCall = this.findMergeBaseValidateBeforeCall(repository, sourceRef, destinationBranch, _callback);
        Type localVarReturnType = new TypeToken<FindMergeBaseResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIfindMergeBaseRequest findMergeBase(String repository, String sourceRef, String destinationBranch) {
        return new APIfindMergeBaseRequest(repository, sourceRef, destinationBranch);
    }

    private Call logCommitsCall(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{ref}/commits".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{ref}", this.localVarApiClient.escapeString(ref.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if (objects != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "objects", objects));
        }
        if (prefixes != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prefixes", prefixes));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (firstParent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("first_parent", firstParent));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call logCommitsValidateBeforeCall(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling logCommits(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling logCommits(Async)");
        }
        return this.logCommitsCall(repository, ref, after, amount, objects, prefixes, limit, firstParent, _callback);
    }

    private ApiResponse<CommitList> logCommitsWithHttpInfo(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent) throws ApiException {
        Call localVarCall = this.logCommitsValidateBeforeCall(repository, ref, after, amount, objects, prefixes, limit, firstParent, null);
        Type localVarReturnType = new TypeToken<CommitList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call logCommitsAsync(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent, ApiCallback<CommitList> _callback) throws ApiException {
        Call localVarCall = this.logCommitsValidateBeforeCall(repository, ref, after, amount, objects, prefixes, limit, firstParent, _callback);
        Type localVarReturnType = new TypeToken<CommitList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlogCommitsRequest logCommits(String repository, String ref) {
        return new APIlogCommitsRequest(repository, ref);
    }

    private Call mergeIntoBranchCall(String repository, String sourceRef, String destinationBranch, Merge merge, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Merge localVarPostBody = merge;
        String localVarPath = "/repositories/{repository}/refs/{sourceRef}/merge/{destinationBranch}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{sourceRef}", this.localVarApiClient.escapeString(sourceRef.toString())).replace("{destinationBranch}", this.localVarApiClient.escapeString(destinationBranch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call mergeIntoBranchValidateBeforeCall(String repository, String sourceRef, String destinationBranch, Merge merge, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling mergeIntoBranch(Async)");
        }
        if (sourceRef == null) {
            throw new ApiException("Missing the required parameter 'sourceRef' when calling mergeIntoBranch(Async)");
        }
        if (destinationBranch == null) {
            throw new ApiException("Missing the required parameter 'destinationBranch' when calling mergeIntoBranch(Async)");
        }
        return this.mergeIntoBranchCall(repository, sourceRef, destinationBranch, merge, _callback);
    }

    private ApiResponse<MergeResult> mergeIntoBranchWithHttpInfo(String repository, String sourceRef, String destinationBranch, Merge merge) throws ApiException {
        Call localVarCall = this.mergeIntoBranchValidateBeforeCall(repository, sourceRef, destinationBranch, merge, null);
        Type localVarReturnType = new TypeToken<MergeResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call mergeIntoBranchAsync(String repository, String sourceRef, String destinationBranch, Merge merge, ApiCallback<MergeResult> _callback) throws ApiException {
        Call localVarCall = this.mergeIntoBranchValidateBeforeCall(repository, sourceRef, destinationBranch, merge, _callback);
        Type localVarReturnType = new TypeToken<MergeResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APImergeIntoBranchRequest mergeIntoBranch(String repository, String sourceRef, String destinationBranch) {
        return new APImergeIntoBranchRequest(repository, sourceRef, destinationBranch);
    }

    public class APImergeIntoBranchRequest {
        private final String repository;
        private final String sourceRef;
        private final String destinationBranch;
        private Merge merge;

        private APImergeIntoBranchRequest(String repository, String sourceRef, String destinationBranch) {
            this.repository = repository;
            this.sourceRef = sourceRef;
            this.destinationBranch = destinationBranch;
        }

        public APImergeIntoBranchRequest merge(Merge merge) {
            this.merge = merge;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RefsApi.this.mergeIntoBranchCall(this.repository, this.sourceRef, this.destinationBranch, this.merge, _callback);
        }

        public MergeResult execute() throws ApiException {
            ApiResponse localVarResp = RefsApi.this.mergeIntoBranchWithHttpInfo(this.repository, this.sourceRef, this.destinationBranch, this.merge);
            return (MergeResult)localVarResp.getData();
        }

        public ApiResponse<MergeResult> executeWithHttpInfo() throws ApiException {
            return RefsApi.this.mergeIntoBranchWithHttpInfo(this.repository, this.sourceRef, this.destinationBranch, this.merge);
        }

        public Call executeAsync(ApiCallback<MergeResult> _callback) throws ApiException {
            return RefsApi.this.mergeIntoBranchAsync(this.repository, this.sourceRef, this.destinationBranch, this.merge, _callback);
        }
    }

    public class APIlogCommitsRequest {
        private final String repository;
        private final String ref;
        private String after;
        private Integer amount;
        private List<String> objects;
        private List<String> prefixes;
        private Boolean limit;
        private Boolean firstParent;

        private APIlogCommitsRequest(String repository, String ref) {
            this.repository = repository;
            this.ref = ref;
        }

        public APIlogCommitsRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlogCommitsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public APIlogCommitsRequest objects(List<String> objects) {
            this.objects = objects;
            return this;
        }

        public APIlogCommitsRequest prefixes(List<String> prefixes) {
            this.prefixes = prefixes;
            return this;
        }

        public APIlogCommitsRequest limit(Boolean limit) {
            this.limit = limit;
            return this;
        }

        public APIlogCommitsRequest firstParent(Boolean firstParent) {
            this.firstParent = firstParent;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RefsApi.this.logCommitsCall(this.repository, this.ref, this.after, this.amount, this.objects, this.prefixes, this.limit, this.firstParent, _callback);
        }

        public CommitList execute() throws ApiException {
            ApiResponse localVarResp = RefsApi.this.logCommitsWithHttpInfo(this.repository, this.ref, this.after, this.amount, this.objects, this.prefixes, this.limit, this.firstParent);
            return (CommitList)localVarResp.getData();
        }

        public ApiResponse<CommitList> executeWithHttpInfo() throws ApiException {
            return RefsApi.this.logCommitsWithHttpInfo(this.repository, this.ref, this.after, this.amount, this.objects, this.prefixes, this.limit, this.firstParent);
        }

        public Call executeAsync(ApiCallback<CommitList> _callback) throws ApiException {
            return RefsApi.this.logCommitsAsync(this.repository, this.ref, this.after, this.amount, this.objects, this.prefixes, this.limit, this.firstParent, _callback);
        }
    }

    public class APIfindMergeBaseRequest {
        private final String repository;
        private final String sourceRef;
        private final String destinationBranch;

        private APIfindMergeBaseRequest(String repository, String sourceRef, String destinationBranch) {
            this.repository = repository;
            this.sourceRef = sourceRef;
            this.destinationBranch = destinationBranch;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RefsApi.this.findMergeBaseCall(this.repository, this.sourceRef, this.destinationBranch, _callback);
        }

        public FindMergeBaseResult execute() throws ApiException {
            ApiResponse localVarResp = RefsApi.this.findMergeBaseWithHttpInfo(this.repository, this.sourceRef, this.destinationBranch);
            return (FindMergeBaseResult)localVarResp.getData();
        }

        public ApiResponse<FindMergeBaseResult> executeWithHttpInfo() throws ApiException {
            return RefsApi.this.findMergeBaseWithHttpInfo(this.repository, this.sourceRef, this.destinationBranch);
        }

        public Call executeAsync(ApiCallback<FindMergeBaseResult> _callback) throws ApiException {
            return RefsApi.this.findMergeBaseAsync(this.repository, this.sourceRef, this.destinationBranch, _callback);
        }
    }

    public class APIdiffRefsRequest {
        private final String repository;
        private final String leftRef;
        private final String rightRef;
        private String after;
        private Integer amount;
        private String prefix;
        private String delimiter;
        private String type;

        private APIdiffRefsRequest(String repository, String leftRef, String rightRef) {
            this.repository = repository;
            this.leftRef = leftRef;
            this.rightRef = rightRef;
        }

        public APIdiffRefsRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIdiffRefsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public APIdiffRefsRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public APIdiffRefsRequest delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public APIdiffRefsRequest type(String type) {
            this.type = type;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RefsApi.this.diffRefsCall(this.repository, this.leftRef, this.rightRef, this.after, this.amount, this.prefix, this.delimiter, this.type, _callback);
        }

        public DiffList execute() throws ApiException {
            ApiResponse localVarResp = RefsApi.this.diffRefsWithHttpInfo(this.repository, this.leftRef, this.rightRef, this.after, this.amount, this.prefix, this.delimiter, this.type);
            return (DiffList)localVarResp.getData();
        }

        public ApiResponse<DiffList> executeWithHttpInfo() throws ApiException {
            return RefsApi.this.diffRefsWithHttpInfo(this.repository, this.leftRef, this.rightRef, this.after, this.amount, this.prefix, this.delimiter, this.type);
        }

        public Call executeAsync(ApiCallback<DiffList> _callback) throws ApiException {
            return RefsApi.this.diffRefsAsync(this.repository, this.leftRef, this.rightRef, this.after, this.amount, this.prefix, this.delimiter, this.type, _callback);
        }
    }
}

