/*
 * lakeFS API
 * lakeFS HTTP API
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.lakefs.clients.sdk;

import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.ProgressRequestBody;
import io.lakefs.clients.sdk.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.lakefs.clients.sdk.model.CommitList;
import io.lakefs.clients.sdk.model.DiffList;
import io.lakefs.clients.sdk.model.Error;
import io.lakefs.clients.sdk.model.FindMergeBaseResult;
import io.lakefs.clients.sdk.model.Merge;
import io.lakefs.clients.sdk.model.MergeResult;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RefsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public RefsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RefsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call diffRefsCall(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/refs/{leftRef}/diff/{rightRef}"
            .replace("{" + "repository" + "}", localVarApiClient.escapeString(repository.toString()))
            .replace("{" + "leftRef" + "}", localVarApiClient.escapeString(leftRef.toString()))
            .replace("{" + "rightRef" + "}", localVarApiClient.escapeString(rightRef.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (amount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("amount", amount));
        }

        if (prefix != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("prefix", prefix));
        }

        if (delimiter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("delimiter", delimiter));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call diffRefsValidateBeforeCall(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling diffRefs(Async)");
        }

        // verify the required parameter 'leftRef' is set
        if (leftRef == null) {
            throw new ApiException("Missing the required parameter 'leftRef' when calling diffRefs(Async)");
        }

        // verify the required parameter 'rightRef' is set
        if (rightRef == null) {
            throw new ApiException("Missing the required parameter 'rightRef' when calling diffRefs(Async)");
        }

        return diffRefsCall(repository, leftRef, rightRef, after, amount, prefix, delimiter, type, _callback);

    }


    private ApiResponse<DiffList> diffRefsWithHttpInfo(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type) throws ApiException {
        okhttp3.Call localVarCall = diffRefsValidateBeforeCall(repository, leftRef, rightRef, after, amount, prefix, delimiter, type, null);
        Type localVarReturnType = new TypeToken<DiffList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call diffRefsAsync(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type, final ApiCallback<DiffList> _callback) throws ApiException {

        okhttp3.Call localVarCall = diffRefsValidateBeforeCall(repository, leftRef, rightRef, after, amount, prefix, delimiter, type, _callback);
        Type localVarReturnType = new TypeToken<DiffList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIdiffRefsRequest {
        private final String repository;
        private final String leftRef;
        private final String rightRef;
        private String after;
        private Integer amount;
        private String prefix;
        private String delimiter;
        private String type;

        private APIdiffRefsRequest(String repository, String leftRef, String rightRef) {
            this.repository = repository;
            this.leftRef = leftRef;
            this.rightRef = rightRef;
        }

        /**
         * Set after
         * @param after return items after this value (optional)
         * @return APIdiffRefsRequest
         */
        public APIdiffRefsRequest after(String after) {
            this.after = after;
            return this;
        }

        /**
         * Set amount
         * @param amount how many items to return (optional, default to 100)
         * @return APIdiffRefsRequest
         */
        public APIdiffRefsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Set prefix
         * @param prefix return items prefixed with this value (optional)
         * @return APIdiffRefsRequest
         */
        public APIdiffRefsRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Set delimiter
         * @param delimiter delimiter used to group common prefixes by (optional)
         * @return APIdiffRefsRequest
         */
        public APIdiffRefsRequest delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        /**
         * Set type
         * @param type  (optional, default to three_dot)
         * @return APIdiffRefsRequest
         */
        public APIdiffRefsRequest type(String type) {
            this.type = type;
            return this;
        }

        /**
         * Build call for diffRefs
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> diff between refs </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return diffRefsCall(repository, leftRef, rightRef, after, amount, prefix, delimiter, type, _callback);
        }

        /**
         * Execute diffRefs request
         * @return DiffList
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> diff between refs </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public DiffList execute() throws ApiException {
            ApiResponse<DiffList> localVarResp = diffRefsWithHttpInfo(repository, leftRef, rightRef, after, amount, prefix, delimiter, type);
            return localVarResp.getData();
        }

        /**
         * Execute diffRefs request with HTTP info returned
         * @return ApiResponse&lt;DiffList&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> diff between refs </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<DiffList> executeWithHttpInfo() throws ApiException {
            return diffRefsWithHttpInfo(repository, leftRef, rightRef, after, amount, prefix, delimiter, type);
        }

        /**
         * Execute diffRefs request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> diff between refs </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<DiffList> _callback) throws ApiException {
            return diffRefsAsync(repository, leftRef, rightRef, after, amount, prefix, delimiter, type, _callback);
        }
    }

    /**
     * diff references
     * 
     * @param repository  (required)
     * @param leftRef a reference (could be either a branch or a commit ID) (required)
     * @param rightRef a reference (could be either a branch or a commit ID) to compare against (required)
     * @return APIdiffRefsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> diff between refs </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIdiffRefsRequest diffRefs(String repository, String leftRef, String rightRef) {
        return new APIdiffRefsRequest(repository, leftRef, rightRef);
    }
    private okhttp3.Call findMergeBaseCall(String repository, String sourceRef, String destinationBranch, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/refs/{sourceRef}/merge/{destinationBranch}"
            .replace("{" + "repository" + "}", localVarApiClient.escapeString(repository.toString()))
            .replace("{" + "sourceRef" + "}", localVarApiClient.escapeString(sourceRef.toString()))
            .replace("{" + "destinationBranch" + "}", localVarApiClient.escapeString(destinationBranch.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call findMergeBaseValidateBeforeCall(String repository, String sourceRef, String destinationBranch, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling findMergeBase(Async)");
        }

        // verify the required parameter 'sourceRef' is set
        if (sourceRef == null) {
            throw new ApiException("Missing the required parameter 'sourceRef' when calling findMergeBase(Async)");
        }

        // verify the required parameter 'destinationBranch' is set
        if (destinationBranch == null) {
            throw new ApiException("Missing the required parameter 'destinationBranch' when calling findMergeBase(Async)");
        }

        return findMergeBaseCall(repository, sourceRef, destinationBranch, _callback);

    }


    private ApiResponse<FindMergeBaseResult> findMergeBaseWithHttpInfo(String repository, String sourceRef, String destinationBranch) throws ApiException {
        okhttp3.Call localVarCall = findMergeBaseValidateBeforeCall(repository, sourceRef, destinationBranch, null);
        Type localVarReturnType = new TypeToken<FindMergeBaseResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call findMergeBaseAsync(String repository, String sourceRef, String destinationBranch, final ApiCallback<FindMergeBaseResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = findMergeBaseValidateBeforeCall(repository, sourceRef, destinationBranch, _callback);
        Type localVarReturnType = new TypeToken<FindMergeBaseResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIfindMergeBaseRequest {
        private final String repository;
        private final String sourceRef;
        private final String destinationBranch;

        private APIfindMergeBaseRequest(String repository, String sourceRef, String destinationBranch) {
            this.repository = repository;
            this.sourceRef = sourceRef;
            this.destinationBranch = destinationBranch;
        }

        /**
         * Build call for findMergeBase
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Found the merge base </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return findMergeBaseCall(repository, sourceRef, destinationBranch, _callback);
        }

        /**
         * Execute findMergeBase request
         * @return FindMergeBaseResult
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Found the merge base </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public FindMergeBaseResult execute() throws ApiException {
            ApiResponse<FindMergeBaseResult> localVarResp = findMergeBaseWithHttpInfo(repository, sourceRef, destinationBranch);
            return localVarResp.getData();
        }

        /**
         * Execute findMergeBase request with HTTP info returned
         * @return ApiResponse&lt;FindMergeBaseResult&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Found the merge base </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<FindMergeBaseResult> executeWithHttpInfo() throws ApiException {
            return findMergeBaseWithHttpInfo(repository, sourceRef, destinationBranch);
        }

        /**
         * Execute findMergeBase request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Found the merge base </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<FindMergeBaseResult> _callback) throws ApiException {
            return findMergeBaseAsync(repository, sourceRef, destinationBranch, _callback);
        }
    }

    /**
     * find the merge base for 2 references
     * 
     * @param repository  (required)
     * @param sourceRef source ref (required)
     * @param destinationBranch destination branch name (required)
     * @return APIfindMergeBaseRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Found the merge base </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIfindMergeBaseRequest findMergeBase(String repository, String sourceRef, String destinationBranch) {
        return new APIfindMergeBaseRequest(repository, sourceRef, destinationBranch);
    }
    private okhttp3.Call logCommitsCall(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/refs/{ref}/commits"
            .replace("{" + "repository" + "}", localVarApiClient.escapeString(repository.toString()))
            .replace("{" + "ref" + "}", localVarApiClient.escapeString(ref.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (amount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("amount", amount));
        }

        if (objects != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "objects", objects));
        }

        if (prefixes != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "prefixes", prefixes));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (firstParent != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("first_parent", firstParent));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call logCommitsValidateBeforeCall(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling logCommits(Async)");
        }

        // verify the required parameter 'ref' is set
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling logCommits(Async)");
        }

        return logCommitsCall(repository, ref, after, amount, objects, prefixes, limit, firstParent, _callback);

    }


    private ApiResponse<CommitList> logCommitsWithHttpInfo(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent) throws ApiException {
        okhttp3.Call localVarCall = logCommitsValidateBeforeCall(repository, ref, after, amount, objects, prefixes, limit, firstParent, null);
        Type localVarReturnType = new TypeToken<CommitList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call logCommitsAsync(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent, final ApiCallback<CommitList> _callback) throws ApiException {

        okhttp3.Call localVarCall = logCommitsValidateBeforeCall(repository, ref, after, amount, objects, prefixes, limit, firstParent, _callback);
        Type localVarReturnType = new TypeToken<CommitList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlogCommitsRequest {
        private final String repository;
        private final String ref;
        private String after;
        private Integer amount;
        private List<String> objects;
        private List<String> prefixes;
        private Boolean limit;
        private Boolean firstParent;

        private APIlogCommitsRequest(String repository, String ref) {
            this.repository = repository;
            this.ref = ref;
        }

        /**
         * Set after
         * @param after return items after this value (optional)
         * @return APIlogCommitsRequest
         */
        public APIlogCommitsRequest after(String after) {
            this.after = after;
            return this;
        }

        /**
         * Set amount
         * @param amount how many items to return (optional, default to 100)
         * @return APIlogCommitsRequest
         */
        public APIlogCommitsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Set objects
         * @param objects list of paths, each element is a path of a specific object (optional)
         * @return APIlogCommitsRequest
         */
        public APIlogCommitsRequest objects(List<String> objects) {
            this.objects = objects;
            return this;
        }

        /**
         * Set prefixes
         * @param prefixes list of paths, each element is a path of a prefix (optional)
         * @return APIlogCommitsRequest
         */
        public APIlogCommitsRequest prefixes(List<String> prefixes) {
            this.prefixes = prefixes;
            return this;
        }

        /**
         * Set limit
         * @param limit limit the number of items in return to &#39;amount&#39;. Without further indication on actual number of items. (optional)
         * @return APIlogCommitsRequest
         */
        public APIlogCommitsRequest limit(Boolean limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set firstParent
         * @param firstParent if set to true, follow only the first parent upon reaching a merge commit (optional)
         * @return APIlogCommitsRequest
         */
        public APIlogCommitsRequest firstParent(Boolean firstParent) {
            this.firstParent = firstParent;
            return this;
        }

        /**
         * Build call for logCommits
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> commit log </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return logCommitsCall(repository, ref, after, amount, objects, prefixes, limit, firstParent, _callback);
        }

        /**
         * Execute logCommits request
         * @return CommitList
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> commit log </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public CommitList execute() throws ApiException {
            ApiResponse<CommitList> localVarResp = logCommitsWithHttpInfo(repository, ref, after, amount, objects, prefixes, limit, firstParent);
            return localVarResp.getData();
        }

        /**
         * Execute logCommits request with HTTP info returned
         * @return ApiResponse&lt;CommitList&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> commit log </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<CommitList> executeWithHttpInfo() throws ApiException {
            return logCommitsWithHttpInfo(repository, ref, after, amount, objects, prefixes, limit, firstParent);
        }

        /**
         * Execute logCommits request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> commit log </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<CommitList> _callback) throws ApiException {
            return logCommitsAsync(repository, ref, after, amount, objects, prefixes, limit, firstParent, _callback);
        }
    }

    /**
     * get commit log from ref. If both objects and prefixes are empty, return all commits.
     * 
     * @param repository  (required)
     * @param ref  (required)
     * @return APIlogCommitsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> commit log </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIlogCommitsRequest logCommits(String repository, String ref) {
        return new APIlogCommitsRequest(repository, ref);
    }
    private okhttp3.Call mergeIntoBranchCall(String repository, String sourceRef, String destinationBranch, Merge merge, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = merge;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/refs/{sourceRef}/merge/{destinationBranch}"
            .replace("{" + "repository" + "}", localVarApiClient.escapeString(repository.toString()))
            .replace("{" + "sourceRef" + "}", localVarApiClient.escapeString(sourceRef.toString()))
            .replace("{" + "destinationBranch" + "}", localVarApiClient.escapeString(destinationBranch.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call mergeIntoBranchValidateBeforeCall(String repository, String sourceRef, String destinationBranch, Merge merge, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling mergeIntoBranch(Async)");
        }

        // verify the required parameter 'sourceRef' is set
        if (sourceRef == null) {
            throw new ApiException("Missing the required parameter 'sourceRef' when calling mergeIntoBranch(Async)");
        }

        // verify the required parameter 'destinationBranch' is set
        if (destinationBranch == null) {
            throw new ApiException("Missing the required parameter 'destinationBranch' when calling mergeIntoBranch(Async)");
        }

        return mergeIntoBranchCall(repository, sourceRef, destinationBranch, merge, _callback);

    }


    private ApiResponse<MergeResult> mergeIntoBranchWithHttpInfo(String repository, String sourceRef, String destinationBranch, Merge merge) throws ApiException {
        okhttp3.Call localVarCall = mergeIntoBranchValidateBeforeCall(repository, sourceRef, destinationBranch, merge, null);
        Type localVarReturnType = new TypeToken<MergeResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call mergeIntoBranchAsync(String repository, String sourceRef, String destinationBranch, Merge merge, final ApiCallback<MergeResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = mergeIntoBranchValidateBeforeCall(repository, sourceRef, destinationBranch, merge, _callback);
        Type localVarReturnType = new TypeToken<MergeResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APImergeIntoBranchRequest {
        private final String repository;
        private final String sourceRef;
        private final String destinationBranch;
        private Merge merge;

        private APImergeIntoBranchRequest(String repository, String sourceRef, String destinationBranch) {
            this.repository = repository;
            this.sourceRef = sourceRef;
            this.destinationBranch = destinationBranch;
        }

        /**
         * Set merge
         * @param merge  (optional)
         * @return APImergeIntoBranchRequest
         */
        public APImergeIntoBranchRequest merge(Merge merge) {
            this.merge = merge;
            return this;
        }

        /**
         * Build call for mergeIntoBranch
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> merge completed </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict Deprecated: content schema will return Error format and not an empty MergeResult  </td><td>  -  </td></tr>
            <tr><td> 412 </td><td> precondition failed (e.g. a pre-merge hook returned a failure) </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return mergeIntoBranchCall(repository, sourceRef, destinationBranch, merge, _callback);
        }

        /**
         * Execute mergeIntoBranch request
         * @return MergeResult
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> merge completed </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict Deprecated: content schema will return Error format and not an empty MergeResult  </td><td>  -  </td></tr>
            <tr><td> 412 </td><td> precondition failed (e.g. a pre-merge hook returned a failure) </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public MergeResult execute() throws ApiException {
            ApiResponse<MergeResult> localVarResp = mergeIntoBranchWithHttpInfo(repository, sourceRef, destinationBranch, merge);
            return localVarResp.getData();
        }

        /**
         * Execute mergeIntoBranch request with HTTP info returned
         * @return ApiResponse&lt;MergeResult&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> merge completed </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict Deprecated: content schema will return Error format and not an empty MergeResult  </td><td>  -  </td></tr>
            <tr><td> 412 </td><td> precondition failed (e.g. a pre-merge hook returned a failure) </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<MergeResult> executeWithHttpInfo() throws ApiException {
            return mergeIntoBranchWithHttpInfo(repository, sourceRef, destinationBranch, merge);
        }

        /**
         * Execute mergeIntoBranch request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> merge completed </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict Deprecated: content schema will return Error format and not an empty MergeResult  </td><td>  -  </td></tr>
            <tr><td> 412 </td><td> precondition failed (e.g. a pre-merge hook returned a failure) </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<MergeResult> _callback) throws ApiException {
            return mergeIntoBranchAsync(repository, sourceRef, destinationBranch, merge, _callback);
        }
    }

    /**
     * merge references
     * 
     * @param repository  (required)
     * @param sourceRef source ref (required)
     * @param destinationBranch destination branch name (required)
     * @return APImergeIntoBranchRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> merge completed </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict Deprecated: content schema will return Error format and not an empty MergeResult  </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> precondition failed (e.g. a pre-merge hook returned a failure) </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APImergeIntoBranchRequest mergeIntoBranch(String repository, String sourceRef, String destinationBranch) {
        return new APImergeIntoBranchRequest(repository, sourceRef, destinationBranch);
    }
}
