/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.iceberg.extension;

import java.io.Serializable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.StringLiteral$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class TableDataDiff$ {
    public static TableDataDiff$ MODULE$;
    private final Tuple3<FunctionIdentifier, ExpressionInfo, Function1<Seq<Expression>, LogicalPlan>> function;

    static {
        new TableDataDiff$();
    }

    private String computeString(Expression e) {
        Option literalValue = StringLiteral$.MODULE$.unapply((Object)e);
        Option option = literalValue;
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException(new StringBuilder(21).append(e).append(" not a literal string").toString());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            return s;
        }
        throw new MatchError((Object)option);
    }

    private String tableAt(String prefix, String schema, String suffix) {
        Option option = SparkSession$.MODULE$.getActiveSession();
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException("Whoops!  No Spark session...");
        }
        if (!(option instanceof Some)) {
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        SparkSession spark = (SparkSession)some.value();
        SparkSession spark2 = spark;
        Function1 & Serializable & scala.Serializable parseId = (Function1 & Serializable & scala.Serializable)x$1 -> spark2.sessionState().sqlParser().parseMultipartIdentifier(x$1);
        Seq parts = (Seq)((TraversableLike)((TraversableLike)parseId.apply((Object)prefix)).$plus$plus((GenTraversableOnce)new .colon.colon((Object)schema, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)parseId.apply((Object)suffix), Seq$.MODULE$.canBuildFrom());
        return ((TraversableOnce)parts.map((Function1 & Serializable & scala.Serializable)str -> new StringBuilder(2).append("`").append((String)str).append("`").toString(), Seq$.MODULE$.canBuildFrom())).mkString(".");
    }

    private String sql(String prefix, String fromSchema, String toSchema, String suffix) {
        String fromTableName = this.tableAt(prefix, fromSchema, suffix);
        String toTableName = this.tableAt(prefix, toSchema, suffix);
        return new StringBuilder(181).append("\n      (SELECT '+' lakefs_change, * FROM (SELECT * FROM ").append(toTableName).append(" EXCEPT SELECT * FROM ").append(fromTableName).append("))\n      UNION ALL\n      (SELECT '-' lakefs_change, * FROM (SELECT * FROM ").append(fromTableName).append(" EXCEPT SELECT * FROM ").append(toTableName).append("))\n    ").toString();
    }

    private LogicalPlan tdfBuilder(Seq<Expression> e2) {
        Option option = SparkSession$.MODULE$.getActiveSession();
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException("Whoops: No spark session!");
        }
        if (!(option instanceof Some)) {
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        SparkSession spark = (SparkSession)some.value();
        SparkSession spark2 = spark;
        if (e2.size() != 4) {
            throw new RuntimeException(new StringBuilder(79).append("Need exactly 4 arguments <tablePrefix, fromSchema, toSchema, tableSuffix>, got ").append(e2).toString());
        }
        Seq seq = (Seq)e2.map((Function1 & Serializable & scala.Serializable)e -> MODULE$.computeString((Expression)e), Seq$.MODULE$.canBuildFrom());
        Some some2 = Seq$.MODULE$.unapplySeq(seq);
        if (some2.isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(4) != 0) {
            throw new MatchError((Object)seq);
        }
        String tablePrefix = (String)((SeqLike)some2.get()).apply(0);
        String fromSchema = (String)((SeqLike)some2.get()).apply(1);
        String toSchema = (String)((SeqLike)some2.get()).apply(2);
        String tableSuffix = (String)((SeqLike)some2.get()).apply(3);
        Tuple4 tuple4 = new Tuple4((Object)tablePrefix, (Object)fromSchema, (Object)toSchema, (Object)tableSuffix);
        String tablePrefix2 = (String)tuple4._1();
        String fromSchema2 = (String)tuple4._2();
        String toSchema2 = (String)tuple4._3();
        String tableSuffix2 = (String)tuple4._4();
        String sqlString = this.sql(tablePrefix2, fromSchema2, toSchema2, tableSuffix2);
        return spark2.sql(sqlString).queryExecution().logical();
    }

    public Tuple3<FunctionIdentifier, ExpressionInfo, Function1<Seq<Expression>, LogicalPlan>> function() {
        return this.function;
    }

    private TableDataDiff$() {
        MODULE$ = this;
        this.function = new Tuple3((Object)FunctionIdentifier$.MODULE$.apply("refs_data_diff"), (Object)new ExpressionInfo("io.lakefs.iceberg.extension.TableDataDiff$", "", "refs_data_diff", "refs_data_diff('TABLE_PREFIX', 'FROM_SCHEMA', 'TO_SCHEMA', 'TABLE_SUFFIX')", "refs_data_diff('TABLE_PREFIX', 'FROM_SCHEMA', 'TO_SCHEMA', 'TABLE_SUFFIX')"), (Function1 & Serializable & scala.Serializable)e -> MODULE$.tdfBuilder((Seq<Expression>)e));
    }
}

