/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.gc;

import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.model.GarbageCollectionPrepareResponse;
import io.treeverse.clients.ApiClient;
import io.treeverse.clients.ApiClient$;
import io.treeverse.clients.LakeFSContext$;
import io.treeverse.clients.LakeFSJobParams$;
import io.treeverse.gc.CommittedAddressLister;
import io.treeverse.gc.NaiveCommittedAddressLister;
import java.io.Serializable;
import java.net.URI;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0003\u0006\u0001#!AA\u0004\u0001BC\u0002\u0013\u0005Q\u0004\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u001f\u0011!)\u0003A!b\u0001\n\u00031\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u0011M\u0002!Q1A\u0005\u0002\u0019B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\u0006k\u0001!\tA\u000e\u0005\u0006w\u0001!\t\u0005\u0010\u0002\u001b\u0003\u000e$\u0018N^3D_6l\u0017\u000e^:BI\u0012\u0014Xm]:MSN$XM\u001d\u0006\u0003\u00171\t!aZ2\u000b\u00055q\u0011!\u0003;sK\u00164XM]:f\u0015\u0005y\u0011AA5p\u0007\u0001\u00192\u0001\u0001\n\u0019!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u0011\u0011DG\u0007\u0002\u0015%\u00111D\u0003\u0002\u0017\u0007>lW.\u001b;uK\u0012\fE\r\u001a:fgNd\u0015n\u001d;fe\u0006I\u0011\r]5DY&,g\u000e^\u000b\u0002=A\u0011qDI\u0007\u0002A)\u0011\u0011\u0005D\u0001\bG2LWM\u001c;t\u0013\t\u0019\u0003EA\u0005Ba&\u001cE.[3oi\u0006Q\u0011\r]5DY&,g\u000e\u001e\u0011\u0002\u0011I,\u0007o\u001c(b[\u0016,\u0012a\n\t\u0003Q=r!!K\u0017\u0011\u0005)\"R\"A\u0016\u000b\u00051\u0002\u0012A\u0002\u001fs_>$h(\u0003\u0002/)\u00051\u0001K]3eK\u001aL!\u0001M\u0019\u0003\rM#(/\u001b8h\u0015\tqC#A\u0005sKB|g*Y7fA\u0005Y1\u000f^8sC\u001e,G+\u001f9f\u00031\u0019Ho\u001c:bO\u0016$\u0016\u0010]3!\u0003\u0019a\u0014N\\5u}Q!q\u0007O\u001d;!\tI\u0002\u0001C\u0003\u001d\u000f\u0001\u0007a\u0004C\u0003&\u000f\u0001\u0007q\u0005C\u00034\u000f\u0001\u0007q%\u0001\fmSN$8i\\7nSR$X\rZ!eIJ,7o]3t)\u0011iD+W.\u0011\u0005y\nfBA O\u001d\t\u00015J\u0004\u0002B\u0011:\u0011!)\u0012\b\u0003U\rK\u0011\u0001R\u0001\u0004_J<\u0017B\u0001$H\u0003\u0019\t\u0007/Y2iK*\tA)\u0003\u0002J\u0015\u0006)1\u000f]1sW*\u0011aiR\u0005\u0003\u00196\u000b1a]9m\u0015\tI%*\u0003\u0002P!\u00069\u0001/Y2lC\u001e,'B\u0001'N\u0013\t\u00116KA\u0005ECR\fgI]1nK*\u0011q\n\u0015\u0005\u0006\u0013\"\u0001\r!\u0016\t\u0003-^k\u0011\u0001U\u0005\u00031B\u0013Ab\u00159be.\u001cVm]:j_:DQA\u0017\u0005A\u0002\u001d\n\u0001c\u001d;pe\u0006<WMT1nKN\u0004\u0018mY3\t\u000bqC\u0001\u0019A\u0014\u0002-\rd\u0017.\u001a8u'R|'/Y4f\u001d\u0006lWm\u001d9bG\u0016\u0004")
public class ActiveCommitsAddressLister
implements CommittedAddressLister {
    private final ApiClient apiClient;
    private final String repoName;
    private final String storageType;

    @Override
    public Dataset<Row> filterAddresses(SparkSession spark, Dataset<Row> df, String normalizedClientStorageNamespace) {
        return CommittedAddressLister.filterAddresses$(this, spark, df, normalizedClientStorageNamespace);
    }

    public ApiClient apiClient() {
        return this.apiClient;
    }

    public String repoName() {
        return this.repoName;
    }

    public String storageType() {
        return this.storageType;
    }

    @Override
    public Dataset<Row> listCommittedAddresses(SparkSession spark, String storageNamespace, String clientStorageNamespace) {
        GarbageCollectionPrepareResponse garbageCollectionPrepareResponse;
        try {
            garbageCollectionPrepareResponse = this.apiClient().prepareGarbageCollectionCommits(this.repoName(), "");
        }
        catch (ApiException e) {
            if (e.getCode() == 404) {
                return new NaiveCommittedAddressLister().listCommittedAddresses(spark, storageNamespace, clientStorageNamespace);
            }
            throw e;
        }
        GarbageCollectionPrepareResponse prepareResult = garbageCollectionPrepareResponse;
        URI gcCommitsLocation = ApiClient$.MODULE$.translateURI(new URI(prepareResult.getGcCommitsLocation()), this.storageType());
        Dataset commitsDF = spark.read().option("header", true).option("inferSchema", true).csv(gcCommitsLocation.toString());
        commitsDF = commitsDF.filter(commitsDF.apply("expired").$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false))).select("commit_id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Dataset<Row> df = LakeFSContext$.MODULE$.newDF(spark, LakeFSJobParams$.MODULE$.forCommits(this.repoName(), (Iterable<String>)((Iterable)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commitsDF.collect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getString(0), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), "experimental-unified-gc"));
        String normalizedClientStorageNamespace = clientStorageNamespace.endsWith("/") ? clientStorageNamespace : new StringBuilder(1).append(clientStorageNamespace).append("/").toString();
        return this.filterAddresses(spark, df, normalizedClientStorageNamespace);
    }

    public ActiveCommitsAddressLister(ApiClient apiClient, String repoName, String storageType) {
        this.apiClient = apiClient;
        this.repoName = repoName;
        this.storageType = storageType;
        CommittedAddressLister.$init$(this);
    }
}

