/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients.conditional;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.retry.PredefinedBackoffStrategies;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import io.treeverse.clients.LakeFSContext$;
import io.treeverse.clients.S3ClientBuilder;
import io.treeverse.clients.S3RetryDeleteObjectsCondition;
import io.treeverse.clients.StorageUtils$S3$;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;

public final class S3ClientBuilder$
implements S3ClientBuilder {
    public static S3ClientBuilder$ MODULE$;
    private final Logger logger;
    private final String S3A_PATH_STYLE_ACCESS;

    static {
        new S3ClientBuilder$();
    }

    @Override
    public String S3A_PATH_STYLE_ACCESS() {
        return this.S3A_PATH_STYLE_ACCESS;
    }

    @Override
    public void io$treeverse$clients$S3ClientBuilder$_setter_$S3A_PATH_STYLE_ACCESS_$eq(String x$1) {
        this.S3A_PATH_STYLE_ACCESS = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public AmazonS3 build(Configuration hc, String bucket, String region, int numRetries) {
        None$ none$;
        int minBackoffMsecs = hc.getInt(LakeFSContext$.MODULE$.LAKEFS_CONF_GC_S3_MIN_BACKOFF_SECONDS(), LakeFSContext$.MODULE$.DEFAULT_LAKEFS_CONF_GC_S3_MIN_BACKOFF_SECONDS()) * 1000;
        int maxBackoffMsecs = hc.getInt(LakeFSContext$.MODULE$.LAKEFS_CONF_GC_S3_MAX_BACKOFF_SECONDS(), LakeFSContext$.MODULE$.DEFAULT_LAKEFS_CONF_GC_S3_MAX_BACKOFF_SECONDS()) * 1000;
        PredefinedBackoffStrategies.FullJitterBackoffStrategy backoffStrategy = new PredefinedBackoffStrategies.FullJitterBackoffStrategy(minBackoffMsecs, maxBackoffMsecs);
        RetryPolicy retryPolicy = new RetryPolicy((RetryPolicy.RetryCondition)new S3RetryDeleteObjectsCondition(), (RetryPolicy.BackoffStrategy)backoffStrategy, numRetries, true);
        ClientConfiguration configuration = new ClientConfiguration().withRetryPolicy(retryPolicy).withThrottledRetries(true);
        String s3Endpoint = hc.get("fs.s3a.endpoint", null);
        if (hc.get("fs.s3a.access.key") != null) {
            this.logger().info("Use access key ID {} {}", (Object)hc.get("fs.s3a.access.key"), (Object)(hc.get("fs.s3a.secret.key") == null ? "(missing secret key)" : "secret key ******"));
            none$ = new Some((Object)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(hc.get("fs.s3a.access.key"), hc.get("fs.s3a.secret.key"))));
        } else {
            none$ = None$.MODULE$;
        }
        None$ credentialsProvider = none$;
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withPathStyleAccessEnabled(Predef$.MODULE$.boolean2Boolean(hc.getBoolean(this.S3A_PATH_STYLE_ACCESS(), true)));
        return StorageUtils$S3$.MODULE$.createAndValidateS3Client(configuration, (Option<AWSCredentialsProvider>)credentialsProvider, builder, s3Endpoint, region, bucket);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private S3ClientBuilder$() {
        MODULE$ = this;
        S3ClientBuilder.$init$(this);
        this.logger = LoggerFactory.getLogger((String)new StringBuilder(9).append(this.getClass().toString()).append("[hadoop2]").toString());
    }
}

