/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import com.amazonaws.services.s3.AmazonS3;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.batch.BlobBatchClient;
import com.azure.storage.blob.batch.BlobBatchClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.policy.RequestRetryOptions;
import io.treeverse.clients.ConfigMapper;
import io.treeverse.clients.StorageClient;
import io.treeverse.clients.StorageClients$;
import io.treeverse.clients.StorageUtils$AzureBlob$;
import io.treeverse.clients.conditional.S3ClientBuilder$;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\rs!\u0002\u000f\u001e\u0011\u0003!c!\u0002\u0014\u001e\u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003yc\u0001\u0002\u0019\u0002\u0001EB\u0001\u0002O\u0002\u0003\u0002\u0003\u0006I!\u000f\u0005\t\t\u000e\u0011\t\u0011)A\u0005s!AQi\u0001B\u0001B\u0003%a\t\u0003\u0005J\u0007\t\u0005\t\u0015!\u0003K\u0011\u0015q3\u0001\"\u0001N\u0011\u001d!6A1A\u0005\nUCaAX\u0002!\u0002\u00131\u0006bB0\u0004\u0005\u0004%I\u0001\u0019\u0005\u0007C\u000e\u0001\u000b\u0011B\u001d\t\u0011\t\u001c\u0001R1A\u0005\u0002\r4A\u0001^\u0001\u0001k\"A\u0011J\u0004B\u0001B\u0003%!\n\u0003\u00059\u001d\t\u0005\t\u0015!\u0003:\u0011\u0015qc\u0002\"\u0001w\u0011\u001d!fB1A\u0005\nUCaA\u0018\b!\u0002\u00131\u0006b\u0002>\u000f\u0005\u0004%I\u0001\u0019\u0005\u0007w:\u0001\u000b\u0011B\u001d\t\u000fqt!\u0019!C\u0005A\"1QP\u0004Q\u0001\neB\u0001B \b\t\u0006\u0004%Ia \u0005\u000b\u0003/q\u0001R1A\u0005\u0002\u0005e\u0001bBA\u0015\u001d\u0011%\u00111\u0006\u0005\b\u0003k\tA\u0011AA\u001c\u00039\u0019Fo\u001c:bO\u0016\u001cE.[3oiNT!AH\u0010\u0002\u000f\rd\u0017.\u001a8ug*\u0011\u0001%I\u0001\niJ,WM^3sg\u0016T\u0011AI\u0001\u0003S>\u001c\u0001\u0001\u0005\u0002&\u00035\tQD\u0001\bTi>\u0014\u0018mZ3DY&,g\u000e^:\u0014\u0005\u0005A\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002I\t\u00111kM\n\u0005\u0007!\u0012T\u0007\u0005\u0002&g%\u0011A'\b\u0002\u000e'R|'/Y4f\u00072LWM\u001c;\u0011\u0005%2\u0014BA\u001c+\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003A\u0019Ho\u001c:bO\u0016t\u0015-\\3ta\u0006\u001cW\r\u0005\u0002;\u0003:\u00111h\u0010\t\u0003y)j\u0011!\u0010\u0006\u0003}\r\na\u0001\u0010:p_Rt\u0014B\u0001!+\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001S\u0013A\u0002:fO&|g.A\u0004sKR\u0014\u0018.Z:\u0011\u0005%:\u0015B\u0001%+\u0005\rIe\u000e^\u0001\u0007G>tg-[4\u0011\u0005\u0015Z\u0015B\u0001'\u001e\u00051\u0019uN\u001c4jO6\u000b\u0007\u000f]3s)\u0015q\u0005+\u0015*T!\ty5!D\u0001\u0002\u0011\u0015A\u0004\u00021\u0001:\u0011\u0015!\u0005\u00021\u0001:\u0011\u0015)\u0005\u00021\u0001G\u0011\u0015I\u0005\u00021\u0001K\u00031\u0019Ho\u001c:bO\u0016t5+\u0016*J+\u00051\u0006CA,]\u001b\u0005A&BA-[\u0003\rqW\r\u001e\u0006\u00027\u0006!!.\u0019<b\u0013\ti\u0006LA\u0002V%&\u000bQb\u001d;pe\u0006<WMT*V%&\u0003\u0013A\u00022vG.,G/F\u0001:\u0003\u001d\u0011WoY6fi\u0002\n\u0001b]\u001aDY&,g\u000e^\u000b\u0002IB\u0011QM\\\u0007\u0002M*\u0011q\r[\u0001\u0003gNR!!\u001b6\u0002\u0011M,'O^5dKNT!a\u001b7\u0002\u0013\u0005l\u0017M_8oC^\u001c(\"A7\u0002\u0007\r|W.\u0003\u0002pM\nA\u0011)\\1{_:\u001c6\u0007\u000b\u0002\u000ecB\u0011\u0011F]\u0005\u0003g*\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0003\u000b\u0005SXO]3\u0014\t9A#'\u000e\u000b\u0004obL\bCA(\u000f\u0011\u0015I\u0015\u00031\u0001K\u0011\u0015A\u0014\u00031\u0001:\u0003E\u0019Ho\u001c:bO\u0016\f5mY8v]R,&\u000f\\\u0001\u0013gR|'/Y4f\u0003\u000e\u001cw.\u001e8u+Jd\u0007%\u0001\nti>\u0014\u0018mZ3BG\u000e|WO\u001c;OC6,\u0017aE:u_J\fw-Z!dG>,h\u000e\u001e(b[\u0016\u0004\u0013!\u00052m_\n\u001cVM\u001d<jG\u0016\u001cE.[3oiV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\t\t\"\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003\u0011\u0011Gn\u001c2\u000b\t\u0005-\u0011QB\u0001\bgR|'/Y4f\u0015\r\ty\u0001\\\u0001\u0006Cj,(/Z\u0005\u0005\u0003'\t)AA\tCY>\u00147+\u001a:wS\u000e,7\t\\5f]RD#\u0001G9\u0002\u001f\tdwN\u0019\"bi\u000eD7\t\\5f]R,\"!a\u0007\u0011\t\u0005u\u00111E\u0007\u0003\u0003?QA!!\t\u0002\u0006\u0005)!-\u0019;dQ&!\u0011QEA\u0010\u0005=\u0011En\u001c2CCR\u001c\u0007n\u00117jK:$\bFA\rr\u0003Q9W\r\u001e\"m_\n\u001cVM\u001d<jG\u0016\u001cE.[3oiRA\u0011\u0011AA\u0017\u0003_\t\t\u0004C\u0003{5\u0001\u0007\u0011\bC\u0003}5\u0001\u0007\u0011\b\u0003\u0004\u00024i\u0001\rAS\u0001\rG>tg-[4NCB\u0004XM]\u0001\u0006CB\u0004H.\u001f\u000b\ne\u0005e\u0012QHA \u0003\u0003Ba!a\u000f\u001c\u0001\u0004I\u0014aC:u_J\fw-\u001a+za\u0016Da!a\r\u001c\u0001\u0004Q\u0005\"\u0002\u001d\u001c\u0001\u0004I\u0004\"\u0002#\u001c\u0001\u0004I\u0004")
public final class StorageClients {
    public static StorageClient apply(String string, ConfigMapper configMapper, String string2, String string3) {
        return StorageClients$.MODULE$.apply(string, configMapper, string2, string3);
    }

    public static class Azure
    implements StorageClient,
    Serializable {
        private transient BlobServiceClient blobServiceClient;
        private transient BlobBatchClient blobBatchClient;
        private final ConfigMapper config;
        private final URI storageNSURI;
        private final String storageAccountUrl;
        private final String storageAccountName;
        private volatile transient byte bitmap$trans$0;

        private URI storageNSURI() {
            return this.storageNSURI;
        }

        private String storageAccountUrl() {
            return this.storageAccountUrl;
        }

        private String storageAccountName() {
            return this.storageAccountName;
        }

        private BlobServiceClient blobServiceClient$lzycompute() {
            Azure azure = this;
            synchronized (azure) {
                if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                    this.blobServiceClient = this.getBlobServiceClient(this.storageAccountUrl(), this.storageAccountName(), this.config);
                    this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
                }
            }
            return this.blobServiceClient;
        }

        private BlobServiceClient blobServiceClient() {
            return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.blobServiceClient$lzycompute() : this.blobServiceClient;
        }

        private BlobBatchClient blobBatchClient$lzycompute() {
            Azure azure = this;
            synchronized (azure) {
                if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                    this.blobBatchClient = new BlobBatchClientBuilder(this.blobServiceClient()).buildClient();
                    this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
                }
            }
            return this.blobBatchClient;
        }

        public BlobBatchClient blobBatchClient() {
            return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.blobBatchClient$lzycompute() : this.blobBatchClient;
        }

        private BlobServiceClient getBlobServiceClient(String storageAccountUrl, String storageAccountName, ConfigMapper configMapper) {
            BlobServiceClientBuilder blobServiceClientBuilder;
            Configuration hc = configMapper.configuration();
            String storageAccountKey = hc.get(String.format(StorageUtils$AzureBlob$.MODULE$.StorageAccountKeyProperty(), storageAccountName));
            BlobServiceClientBuilder blobServiceClientBuilder2 = new BlobServiceClientBuilder().endpoint(storageAccountUrl).retryOptions(new RequestRetryOptions()).httpClient(HttpClient.createDefault());
            if (storageAccountKey != null) {
                blobServiceClientBuilder = blobServiceClientBuilder2.credential(new StorageSharedKeyCredential(storageAccountName, storageAccountKey));
            } else {
                String string = hc.get(String.format(StorageUtils$AzureBlob$.MODULE$.AccountAuthType(), storageAccountName));
                String string2 = "OAuth";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    String tenantId = StorageUtils$AzureBlob$.MODULE$.getTenantId(new URI(hc.get(String.format(StorageUtils$AzureBlob$.MODULE$.AccountOAuthClientEndpoint(), storageAccountName))));
                    ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(hc.get(String.format(StorageUtils$AzureBlob$.MODULE$.AccountOAuthClientId(), storageAccountName)))).clientSecret(hc.get(String.format(StorageUtils$AzureBlob$.MODULE$.AccountOAuthClientSecret(), storageAccountName))).tenantId(tenantId)).build();
                    blobServiceClientBuilder = blobServiceClientBuilder2.credential((TokenCredential)clientSecretCredential);
                } else {
                    blobServiceClientBuilder = BoxedUnit.UNIT;
                }
            }
            return blobServiceClientBuilder2.buildClient();
        }

        public Azure(ConfigMapper config, String storageNamespace) {
            this.config = config;
            this.storageNSURI = new URI(storageNamespace);
            this.storageAccountUrl = StorageUtils$AzureBlob$.MODULE$.uriToStorageAccountUrl(this.storageNSURI());
            this.storageAccountName = StorageUtils$AzureBlob$.MODULE$.uriToStorageAccountName(this.storageNSURI());
        }
    }

    public static class S3
    implements StorageClient,
    Serializable {
        private transient AmazonS3 s3Client;
        private final String region;
        private final int retries;
        private final ConfigMapper config;
        private final URI storageNSURI;
        private final String bucket;
        private volatile transient boolean bitmap$trans$0;

        private URI storageNSURI() {
            return this.storageNSURI;
        }

        private String bucket() {
            return this.bucket;
        }

        private AmazonS3 s3Client$lzycompute() {
            S3 s3 = this;
            synchronized (s3) {
                if (!this.bitmap$trans$0) {
                    this.s3Client = S3ClientBuilder$.MODULE$.build(this.config.configuration(), this.bucket(), this.region, this.retries);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.s3Client;
        }

        public AmazonS3 s3Client() {
            return !this.bitmap$trans$0 ? this.s3Client$lzycompute() : this.s3Client;
        }

        public S3(String storageNamespace, String region, int retries, ConfigMapper config) {
            this.region = region;
            this.retries = retries;
            this.config = config;
            this.storageNSURI = new URI(storageNamespace);
            this.bucket = this.storageNSURI().getHost();
        }
    }
}

