/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import io.treeverse.clients.APIConfigurations;
import io.treeverse.clients.ApiClient;
import io.treeverse.clients.GravelerSplit;
import io.treeverse.clients.LakeFSBaseInputFormat;
import io.treeverse.clients.LakeFSContext$;
import io.treeverse.clients.LakeFSInputFormat$;
import io.treeverse.clients.StorageClientType$;
import java.net.URI;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import scala.collection.JavaConverters$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000192Aa\u0001\u0003\u0001\u0017!)\u0001\u0003\u0001C\u0001#!)1\u0003\u0001C!)\tQB*Y6f\rN\u000bE\u000e\u001c*b]\u001e,7/\u00138qkR4uN]7bi*\u0011QAB\u0001\bG2LWM\u001c;t\u0015\t9\u0001\"A\u0005ue\u0016,g/\u001a:tK*\t\u0011\"\u0001\u0002j_\u000e\u00011C\u0001\u0001\r!\tia\"D\u0001\u0005\u0013\tyAAA\u000bMC.,gi\u0015\"bg\u0016Le\u000e];u\r>\u0014X.\u0019;\u0002\rqJg.\u001b;?)\u0005\u0011\u0002CA\u0007\u0001\u0003%9W\r^*qY&$8\u000f\u0006\u0002\u0016SA\u0019acG\u000f\u000e\u0003]Q!\u0001G\r\u0002\tU$\u0018\u000e\u001c\u0006\u00025\u0005!!.\u0019<b\u0013\tarC\u0001\u0003MSN$\bC\u0001\u0010(\u001b\u0005y\"B\u0001\u0011\"\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002#G\u00051\u0001.\u00193p_BT!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO&\u0011\u0001f\b\u0002\u000b\u0013:\u0004X\u000f^*qY&$\b\"\u0002\u0016\u0003\u0001\u0004Y\u0013a\u00016pEB\u0011a\u0004L\u0005\u0003[}\u0011!BS8c\u0007>tG/\u001a=u\u0001")
public class LakeFSAllRangesInputFormat
extends LakeFSBaseInputFormat {
    public List<InputSplit> getSplits(JobContext job) {
        Configuration conf = job.getConfiguration();
        String repoName = conf.get(LakeFSContext$.MODULE$.LAKEFS_CONF_JOB_REPO_NAME_KEY());
        String storageNamespace = conf.get(LakeFSContext$.MODULE$.LAKEFS_CONF_JOB_STORAGE_NAMESPACE_KEY());
        if (StringUtils.isBlank((CharSequence)repoName) && StringUtils.isBlank((CharSequence)storageNamespace) || StringUtils.isNotBlank((CharSequence)repoName) && StringUtils.isNotBlank((CharSequence)storageNamespace)) {
            throw new IllegalArgumentException("Must specify exactly one of LAKEFS_CONF_JOB_REPO_NAME_KEY or LAKEFS_CONF_JOB_STORAGE_NAMESPACE_KEY");
        }
        ApiClient apiClient = (ApiClient)this.apiClientGetter().apply((Object)new APIConfigurations(conf.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_URL_KEY()), conf.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_ACCESS_KEY_KEY()), conf.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_SECRET_KEY_KEY()), conf.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_CONNECTION_TIMEOUT_SEC_KEY()), conf.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_READ_TIMEOUT_SEC_KEY()), conf.get(LakeFSContext$.MODULE$.LAKEFS_CONF_JOB_SOURCE_NAME_KEY(), "input_format")));
        if (StringUtils.isBlank((CharSequence)storageNamespace)) {
            storageNamespace = apiClient.getStorageNamespace(repoName, StorageClientType$.MODULE$.HadoopFS());
        }
        URI namespaceURI = URI.create(storageNamespace);
        FileSystem fs = FileSystem.get((URI)namespaceURI, (Configuration)conf);
        fs.getStatus(new Path(namespaceURI));
        URI metadataURI = namespaceURI.resolve(storageNamespace.endsWith("/") ? "_lakefs" : "/_lakefs");
        Path metadataPath = new Path(metadataURI);
        if (!fs.exists(metadataPath)) {
            return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)ListBuffer$.MODULE$.empty()).asJava();
        }
        ListBuffer splits = new ListBuffer();
        RemoteIterator it = fs.listFiles(metadataPath, false);
        while (it.hasNext()) {
            LocatedFileStatus file = (LocatedFileStatus)it.next();
            splits.$plus$eq((Object)new GravelerSplit(file.getPath(), file.getPath().getName(), file.getLen(), false));
        }
        LakeFSInputFormat$.MODULE$.logger().debug(new StringBuilder(17).append("Returning ").append(splits.size()).append(" splits").toString());
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)splits).asJava();
    }
}

