/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.storage.blob.batch.BlobBatchClient;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import io.treeverse.clients.BulkRemover;
import io.treeverse.clients.BulkRemoverFactory$;
import io.treeverse.clients.StorageClient;
import io.treeverse.clients.StorageClients;
import io.treeverse.clients.StorageUtils$AzureBlob$;
import io.treeverse.clients.StorageUtils$S3$;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001y<Qa\u0005\u000b\t\u0002m1Q!\b\u000b\t\u0002yAQ!J\u0001\u0005\u0002\u00192AaJ\u0001\u0005Q!AAf\u0001B\u0001B\u0003%Q\u0006\u0003\u00059\u0007\t\u0005\t\u0015!\u0003:\u0011\u0015)3\u0001\"\u0001A\u0011\u001d)5A1A\u0005\n\u0019CaaT\u0002!\u0002\u00139\u0005b\u0002)\u0004\u0005\u0004%I!\u0015\u0005\u0007/\u000e\u0001\u000b\u0011\u0002*\t\u000ba\u001bA\u0011I-\t\u000b\u0019\u001cA\u0011I4\u0007\t-\fA\u0001\u001c\u0005\tq5\u0011\t\u0011)A\u0005[\")Q%\u0004C\u0001a\")\u0001,\u0004C!g\")a-\u0004C!O\")a/\u0001C\u0001o\u0006\u0011\")\u001e7l%\u0016lwN^3s\r\u0006\u001cGo\u001c:z\u0015\t)b#A\u0004dY&,g\u000e^:\u000b\u0005]A\u0012!\u0003;sK\u00164XM]:f\u0015\u0005I\u0012AA5p\u0007\u0001\u0001\"\u0001H\u0001\u000e\u0003Q\u0011!CQ;mWJ+Wn\u001c<fe\u001a\u000b7\r^8ssN\u0011\u0011a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Y\"!D*4\u0005Vd7NU3n_Z,'oE\u0002\u0004?%\u0002\"\u0001\b\u0016\n\u0005-\"\"a\u0003\"vY.\u0014V-\\8wKJ\f\u0001c\u001d;pe\u0006<WMT1nKN\u0004\u0018mY3\u0011\u00059*dBA\u00184!\t\u0001\u0014%D\u00012\u0015\t\u0011$$\u0001\u0004=e>|GOP\u0005\u0003i\u0005\na\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\u0019\u0019FO]5oO*\u0011A'I\u0001\u0007G2LWM\u001c;\u0011\u0005ijdB\u0001\u000f<\u0013\taD#\u0001\bTi>\u0014\u0018mZ3DY&,g\u000e^:\n\u0005yz$AA*4\u0015\taD\u0003F\u0002B\u0007\u0012\u0003\"AQ\u0002\u000e\u0003\u0005AQ\u0001\f\u0004A\u00025BQ\u0001\u000f\u0004A\u0002e\n1!\u001e:j+\u00059\u0005C\u0001%N\u001b\u0005I%B\u0001&L\u0003\rqW\r\u001e\u0006\u0002\u0019\u0006!!.\u0019<b\u0013\tq\u0015JA\u0002V%&\u000bA!\u001e:jA\u00051!-^2lKR,\u0012A\u0015\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+.\u000bA\u0001\\1oO&\u0011a\u0007V\u0001\bEV\u001c7.\u001a;!\u00035!W\r\\3uK>\u0013'.Z2ugR\u0019!lY3\u0011\u0007m\u0003WF\u0004\u0002]=:\u0011\u0001'X\u0005\u0002E%\u0011q,I\u0001\ba\u0006\u001c7.Y4f\u0013\t\t'MA\u0002TKFT!aX\u0011\t\u000b\u0011\\\u0001\u0019\u0001.\u0002\t-,\u0017p\u001d\u0005\u0006Y-\u0001\r!L\u0001\u000fO\u0016$X*\u0019=Ck2\\7+\u001b>f)\u0005A\u0007C\u0001\u0011j\u0013\tQ\u0017EA\u0002J]R\u0014A#\u0011>ve\u0016\u0014En\u001c2Ck2\\'+Z7pm\u0016\u00148cA\u0007 SA\u0011!H\\\u0005\u0003_~\u0012Q!\u0011>ve\u0016$\"!\u001d:\u0011\u0005\tk\u0001\"\u0002\u001d\u0010\u0001\u0004iGc\u0001.uk\")A\r\u0005a\u00015\")A\u0006\u0005a\u0001[\u0005)\u0011\r\u001d9msR\u0019\u0011\u0006_?\t\u000be\u0014\u0002\u0019\u0001>\u0002\u001bM$xN]1hK\u000ec\u0017.\u001a8u!\ta20\u0003\u0002})\ti1\u000b^8sC\u001e,7\t\\5f]RDQ\u0001\f\nA\u00025\u0002")
public final class BulkRemoverFactory {
    public static BulkRemover apply(StorageClient storageClient, String string) {
        return BulkRemoverFactory$.MODULE$.apply(storageClient, string);
    }

    public static class AzureBlobBulkRemover
    implements BulkRemover {
        private final StorageClients.Azure client;

        @Override
        public Seq<String> constructRemoveKeyNames(Seq<String> keys, String storageNamespace, boolean keepNsSchemeAndHost, boolean applyUTF8Encoding) {
            return BulkRemover.constructRemoveKeyNames$(this, keys, storageNamespace, keepNsSchemeAndHost, applyUTF8Encoding);
        }

        @Override
        public Seq<String> deleteObjects(Seq<String> keys, String storageNamespace) {
            Seq seq;
            Seq<String> removeKeyNames = this.constructRemoveKeyNames(keys, storageNamespace, true, true);
            Predef$.MODULE$.println((Object)new StringBuilder(13).append("Remove keys: ").append(((TraversableOnce)removeKeyNames.take(100)).mkString(", ")).toString());
            List removeKeys = (List)JavaConverters$.MODULE$.seqAsJavaListConverter(removeKeyNames).asJava();
            BlobBatchClient blobBatchClient = this.client.blobBatchClient();
            Function<Response<Void>, URI> extractUrlIfBlobDeleted = new Function<Response<Void>, URI>(null){

                public <V> Function<V, URI> compose(Function<? super V, ? extends Response<Void>> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<Response<Void>, V> andThen(Function<? super URI, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public URI apply(Response<Void> response) {
                    Object object = response.getStatusCode() == 200 ? response.getRequest().getUrl() : BoxedUnit.UNIT;
                    return new URI("");
                }
            };
            Function<URI, String> uriToString = new Function<URI, String>(null){

                public <V> Function<V, String> compose(Function<? super V, ? extends URI> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<URI, V> andThen(Function<? super String, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public String apply(URI uri) {
                    return uri.toString();
                }
            };
            Predicate<String> isNonEmptyString = new Predicate<String>(null){

                public Predicate<String> and(Predicate<? super String> x$1) {
                    return Predicate.super.and(x$1);
                }

                public Predicate<String> negate() {
                    return Predicate.super.negate();
                }

                public Predicate<String> or(Predicate<? super String> x$1) {
                    return Predicate.super.or(x$1);
                }

                public boolean test(String s) {
                    return new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty();
                }
            };
            try {
                PagedIterable responses = blobBatchClient.deleteBlobs(removeKeys, DeleteSnapshotsOptionType.INCLUDE);
                seq = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(responses.stream().map(extractUrlIfBlobDeleted).map(uriToString).filter(isNonEmptyString).collect(Collectors.toList())).asScala()).toSeq();
            }
            catch (Throwable e) {
                e.printStackTrace();
                seq = (Seq)Nil$.MODULE$;
            }
            return seq;
        }

        @Override
        public int getMaxBulkSize() {
            return StorageUtils$AzureBlob$.MODULE$.AzureBlobMaxBulkSize();
        }

        public AzureBlobBulkRemover(StorageClients.Azure client) {
            this.client = client;
            BulkRemover.$init$(this);
        }
    }

    public static class S3BulkRemover
    implements BulkRemover {
        private final StorageClients.S3 client;
        private final URI uri;
        private final String bucket;

        @Override
        public Seq<String> constructRemoveKeyNames(Seq<String> keys, String storageNamespace, boolean keepNsSchemeAndHost, boolean applyUTF8Encoding) {
            return BulkRemover.constructRemoveKeyNames$(this, keys, storageNamespace, keepNsSchemeAndHost, applyUTF8Encoding);
        }

        private URI uri() {
            return this.uri;
        }

        private String bucket() {
            return this.bucket;
        }

        @Override
        public Seq<String> deleteObjects(Seq<String> keys, String storageNamespace) {
            Seq seq;
            Seq<String> removeKeyNames = this.constructRemoveKeyNames(keys, storageNamespace, false, false);
            Predef$.MODULE$.println((Object)new StringBuilder(19).append("Remove keys from ").append(this.bucket()).append(": ").append(((TraversableOnce)removeKeyNames.take(100)).mkString(", ")).toString());
            List removeKeys = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)removeKeyNames.map((Function1 & Serializable & scala.Serializable)k -> new DeleteObjectsRequest.KeyVersion(k), Seq$.MODULE$.canBuildFrom())).asJava();
            DeleteObjectsRequest delObjReq = new DeleteObjectsRequest(this.bucket()).withKeys(removeKeys);
            AmazonS3 s3Client = this.client.s3Client();
            try {
                DeleteObjectsResult res = s3Client.deleteObjects(delObjReq);
                seq = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res.getDeletedObjects()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getKey(), Buffer$.MODULE$.canBuildFrom());
            }
            catch (MultiObjectDeleteException mde) {
                List errors = mde.getErrors();
                Predef$.MODULE$.println((Object)new StringBuilder(41).append("deleteObjects: Partial failure: ").append(errors.size()).append(" errors: ").append(errors).toString());
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(errors).asScala()).foreach((Function1 & Serializable & scala.Serializable)de -> {
                    Predef$.MODULE$.println((Object)new StringBuilder(6).append("\t").append(de.getKey()).append(": [").append(de.getCode()).append("] ").append(de.getMessage()).toString());
                    return BoxedUnit.UNIT;
                });
                seq = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(mde.getDeletedObjects()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getKey(), Buffer$.MODULE$.canBuildFrom());
            }
            catch (Exception e) {
                Predef$.MODULE$.println((Object)new StringBuilder(22).append("deleteObjects failed: ").append(e).toString());
                throw e;
            }
            return seq;
        }

        @Override
        public int getMaxBulkSize() {
            return StorageUtils$S3$.MODULE$.S3MaxBulkSize();
        }

        public S3BulkRemover(String storageNamespace, StorageClients.S3 client) {
            this.client = client;
            BulkRemover.$init$(this);
            this.uri = new URI(storageNamespace);
            this.bucket = this.uri().getHost();
        }
    }
}

