/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import io.lakefs.clients.api.model.GarbageCollectionPrepareResponse;
import io.treeverse.clients.APIConfigurations;
import io.treeverse.clients.ApiClient;
import io.treeverse.clients.ApiClient$;
import io.treeverse.clients.BulkRemover;
import io.treeverse.clients.BulkRemoverFactory$;
import io.treeverse.clients.ConfigMapper;
import io.treeverse.clients.GarbageCollector;
import io.treeverse.clients.GarbageCollector$;
import io.treeverse.clients.HadoopUtils$;
import io.treeverse.clients.LakeFSContext$;
import io.treeverse.clients.LakeFSRangeGetter;
import io.treeverse.clients.StorageClientType$;
import io.treeverse.clients.StorageUtils$;
import java.io.Serializable;
import java.net.URI;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import scala.Array$;
import scala.Console$;
import scala.Function1;
import scala.Function5;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class GarbageCollector$
implements scala.Serializable {
    public static GarbageCollector$ MODULE$;
    private SparkSession spark;
    private volatile boolean bitmap$0;

    static {
        new GarbageCollector$();
    }

    public final String GARBAGE_COLLECTOR_SOURCE_NAME() {
        return "gc";
    }

    private SparkSession spark$lzycompute() {
        GarbageCollector$ garbageCollector$ = this;
        synchronized (garbageCollector$) {
            if (!this.bitmap$0) {
                this.spark = SparkSession$.MODULE$.builder().appName("GarbageCollector").getOrCreate();
                this.bitmap$0 = true;
            }
        }
        return this.spark;
    }

    public SparkSession spark() {
        return !this.bitmap$0 ? this.spark$lzycompute() : this.spark;
    }

    public ConfigMapper getHadoopConfigMapper(Configuration hc, Seq<String> prefixes) {
        return new ConfigMapper((Broadcast<Tuple2<String, String>[]>)this.spark().sparkContext().broadcast(HadoopUtils$.MODULE$.getHadoopConfigurationValues(hc, prefixes), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class))));
    }

    private void validateArgsByStorageType(String storageType, String[] args) {
        block1: {
            block0: {
                String string = storageType;
                String string2 = StorageUtils$.MODULE$.StorageTypeS3();
                if ((string != null ? !string.equals(string2) : string2 != null) || args.length == 2) break block0;
                Console$.MODULE$.err().println("Usage: ... <repo_name> <region>");
                System.exit(1);
                break block1;
            }
            String string = storageType;
            String string3 = StorageUtils$.MODULE$.StorageTypeAzure();
            if ((string != null ? !string.equals(string3) : string3 != null) || args.length == 1) break block1;
            Console$.MODULE$.err().println("Usage: ... <repo_name>");
        }
    }

    private void validateRunModeConfigs(boolean noDeleteFlag, boolean shouldMark, boolean shouldSweep, String markID) {
        block2: {
            block1: {
                if (noDeleteFlag) {
                    Console$.MODULE$.err().printf("The \"%s\" configuration is deprecated. Use \"%s=false\" instead", LakeFSContext$.MODULE$.LAKEFS_CONF_DEBUG_GC_NO_DELETE_KEY(), LakeFSContext$.MODULE$.LAKEFS_CONF_GC_DO_SWEEP());
                    System.exit(1);
                }
                if (shouldMark || shouldSweep) break block1;
                Console$.MODULE$.out().println("Nothing to do, must specify at least one of mark, sweep. Exiting...");
                System.exit(2);
                break block2;
            }
            if (shouldMark || !markID.isEmpty()) break block2;
            Console$.MODULE$.out().printf("Please provide a mark ID (%s) for sweep-only mode. Exiting...\n", LakeFSContext$.MODULE$.LAKEFS_CONF_GC_MARK_ID());
            System.exit(2);
        }
    }

    public void main(String[] args) {
        Dataset<Row> removed;
        Dataset<Row> dataset;
        String string;
        Configuration hc = this.spark().sparkContext().hadoopConfiguration();
        String apiURL = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_URL_KEY());
        String accessKey = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_ACCESS_KEY_KEY());
        String secretKey = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_SECRET_KEY_KEY());
        String connectionTimeout = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_CONNECTION_TIMEOUT_SEC_KEY());
        String readTimeout = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_READ_TIMEOUT_SEC_KEY());
        String maxCommitIsoDatetime = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_DEBUG_GC_MAX_COMMIT_ISO_DATETIME_KEY(), "");
        boolean shouldMark = hc.getBoolean(LakeFSContext$.MODULE$.LAKEFS_CONF_GC_DO_MARK(), true);
        boolean shouldSweep = hc.getBoolean(LakeFSContext$.MODULE$.LAKEFS_CONF_GC_DO_SWEEP(), true);
        this.validateRunModeConfigs(hc.getBoolean(LakeFSContext$.MODULE$.LAKEFS_CONF_DEBUG_GC_NO_DELETE_KEY(), false), shouldMark, shouldSweep, hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_GC_MARK_ID(), ""));
        String markID = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_GC_MARK_ID(), UUID.randomUUID().toString());
        if (!maxCommitIsoDatetime.isEmpty()) {
            hc.setLong(LakeFSContext$.MODULE$.LAKEFS_CONF_DEBUG_GC_MAX_COMMIT_EPOCH_SECONDS_KEY(), LocalDateTime.parse(hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_DEBUG_GC_MAX_COMMIT_ISO_DATETIME_KEY()), DateTimeFormatter.ISO_DATE_TIME).toEpochSecond(ZoneOffset.UTC));
        }
        APIConfigurations apiConf = new APIConfigurations(apiURL, accessKey, secretKey, connectionTimeout, readTimeout, "gc");
        ApiClient apiClient = ApiClient$.MODULE$.get(apiConf);
        String storageType = apiClient.getBlockstoreType();
        this.validateArgsByStorageType(storageType, args);
        String repo = args[0];
        try {
            string = apiClient.getGarbageCollectionRules(repo);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Predef$.MODULE$.println((Object)new StringBuilder(34).append("No GC rules found for repository: ").append(repo).toString());
            throw scala.sys.package$.MODULE$.exit(2);
        }
        String gcRules = string;
        Broadcast hcValues = this.spark().sparkContext().broadcast(HadoopUtils$.MODULE$.getHadoopConfigurationValues(hc, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fs.", "lakefs."})), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
        ConfigMapper configMapper = new ConfigMapper((Broadcast<Tuple2<String, String>[]>)hcValues);
        GarbageCollector gc = new GarbageCollector(new LakeFSRangeGetter(apiConf, configMapper));
        String storageNSForHadoopFS = apiClient.getStorageNamespace(repo, StorageClientType$.MODULE$.HadoopFS());
        if (!storageNSForHadoopFS.endsWith("/")) {
            storageNSForHadoopFS = new StringBuilder(1).append(storageNSForHadoopFS).append("/").toString();
        }
        String gcAddressesLocation = "";
        String gcCommitsLocation = "";
        String runID = "";
        Dataset<Row> expiredAddresses = null;
        String storageNSForSdkClient = this.getStorageNSForSdkClient(apiClient, repo);
        if (shouldMark) {
            Tuple4<String, String, Dataset<Row>, String> markInfo = this.markAddresses(gc, apiClient, repo, hc, storageType, apiURL, markID, storageNSForSdkClient, storageNSForHadoopFS);
            gcAddressesLocation = (String)markInfo._1();
            gcCommitsLocation = (String)markInfo._2();
            expiredAddresses = (Dataset<Row>)markInfo._3();
            runID = (String)markInfo._4();
        }
        StructType schema = new StructType((StructField[])((Object[])new StructField[]{new StructField("addresses", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}));
        if (shouldSweep) {
            if (gcAddressesLocation.isEmpty()) {
                gcAddressesLocation = this.getAddressesLocation(storageNSForHadoopFS);
            }
            if (expiredAddresses == null) {
                expiredAddresses = this.readExpiredAddresses(gcAddressesLocation, markID);
            }
            String region = this.getRegion(args);
            dataset = this.remove(configMapper, storageNSForSdkClient, gcAddressesLocation, expiredAddresses, markID, region, storageType, schema);
        } else {
            dataset = removed = this.spark().createDataFrame(this.spark().sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), schema);
        }
        if (!shouldMark) {
            String[] runIDAndCommitsLocation = this.populateRunIDAndCommitsLocation(markID, gcAddressesLocation);
            runID = runIDAndCommitsLocation[0];
            gcCommitsLocation = runIDAndCommitsLocation[1];
        }
        Dataset<Row> commitsDF = gc.getCommitsDF(gcCommitsLocation);
        this.writeReports(storageNSForHadoopFS, gcRules, runID, markID, commitsDF, expiredAddresses, removed, configMapper);
        this.spark().close();
    }

    private Tuple4<String, String, Dataset<Row>, String> markAddresses(GarbageCollector gc, ApiClient apiClient, String repo, Configuration hc, String storageType, String apiURL, String markID, String storageNS, String storageNSForHadoopFS) {
        String runIDToReproduce = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_DEBUG_GC_REPRODUCE_RUN_ID_KEY(), "");
        String previousRunID = "";
        GarbageCollectionPrepareResponse prepareResult = null;
        String runID = "";
        String gcCommitsLocation = "";
        String gcAddressesLocation = "";
        String string = runIDToReproduce;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            prepareResult = apiClient.prepareGarbageCollectionCommits(repo, previousRunID);
            runID = prepareResult.getRunId();
            gcCommitsLocation = ApiClient$.MODULE$.translateURI(new URI(prepareResult.getGcCommitsLocation()), storageType).toString();
            Predef$.MODULE$.println((Object)new StringBuilder(19).append("gcCommitsLocation: ").append(gcCommitsLocation).toString());
            gcAddressesLocation = ApiClient$.MODULE$.translateURI(new URI(prepareResult.getGcAddressesLocation()), storageType).toString();
            Predef$.MODULE$.println((Object)new StringBuilder(21).append("gcAddressesLocation: ").append(gcAddressesLocation).toString());
        } else {
            runID = UUID.randomUUID().toString();
            gcCommitsLocation = new StringBuilder(49).append(new StringOps(Predef$.MODULE$.augmentString(storageNSForHadoopFS)).stripSuffix("/")).append("/_lakefs/retention/gc/commits/run_id=").append(runIDToReproduce).append("/commits.csv").toString();
            gcAddressesLocation = new StringBuilder(32).append(new StringOps(Predef$.MODULE$.augmentString(storageNSForHadoopFS)).stripSuffix("/")).append("/_lakefs/retention/gc/addresses/").toString();
        }
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("apiURL: ").append(apiURL).toString());
        int numCommitPartitions = hc.getInt(LakeFSContext$.MODULE$.LAKEFS_CONF_GC_NUM_COMMIT_PARTITIONS(), LakeFSContext$.MODULE$.DEFAULT_LAKEFS_CONF_GC_NUM_COMMIT_PARTITIONS());
        int numRangePartitions = hc.getInt(LakeFSContext$.MODULE$.LAKEFS_CONF_GC_NUM_RANGE_PARTITIONS(), LakeFSContext$.MODULE$.DEFAULT_LAKEFS_CONF_GC_NUM_RANGE_PARTITIONS());
        int numAddressPartitions = hc.getInt(LakeFSContext$.MODULE$.LAKEFS_CONF_GC_NUM_ADDRESS_PARTITIONS(), LakeFSContext$.MODULE$.DEFAULT_LAKEFS_CONF_GC_NUM_ADDRESS_PARTITIONS());
        Dataset expiredAddresses = gc.getExpiredAddresses(repo, storageNS, runID, gcCommitsLocation, numCommitPartitions, numRangePartitions, numAddressPartitions).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"address"})).withColumn(LakeFSContext$.MODULE$.MARK_ID_KEY(), functions$.MODULE$.lit((Object)markID)).cache();
        this.spark().conf().set("spark.sql.sources.partitionOverwriteMode", "dynamic");
        expiredAddresses.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LakeFSContext$.MODULE$.MARK_ID_KEY()})).mode(SaveMode.Overwrite).parquet(gcAddressesLocation);
        Predef$.MODULE$.println((Object)"Expired addresses:");
        expiredAddresses.show();
        Path gcAddressesPath = new Path(gcAddressesLocation);
        Path gcTextAddressesPath = new Path(gcAddressesPath.getParent(), new StringBuilder(5).append(gcAddressesPath.getName()).append(".text").toString());
        expiredAddresses.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LakeFSContext$.MODULE$.MARK_ID_KEY()})).mode(SaveMode.Overwrite).text(gcTextAddressesPath.toString());
        this.writeAddressesMarkMetadata(runID, markID, gcAddressesLocation, gcCommitsLocation);
        return new Tuple4((Object)gcAddressesLocation, (Object)gcCommitsLocation, (Object)expiredAddresses, (Object)runID);
    }

    /*
     * WARNING - void declaration
     */
    public String getStorageNSForSdkClient(ApiClient apiClient, String repo) {
        void var3_3;
        block0: {
            String storageNSForSdkClient = apiClient.getStorageNamespace(repo, StorageClientType$.MODULE$.SDKClient());
            if (storageNSForSdkClient.endsWith("/")) break block0;
            storageNSForSdkClient = new StringBuilder(1).append(storageNSForSdkClient).append("/").toString();
        }
        return var3_3;
    }

    public String getRegion(String[] args) {
        return args.length == 2 ? args[1] : null;
    }

    private Dataset<Row> readExpiredAddresses(String addressesLocation, String markID) {
        return this.spark().read().parquet(new StringBuilder(2).append(addressesLocation).append("/").append(LakeFSContext$.MODULE$.MARK_ID_KEY()).append("=").append(markID).toString()).withColumn(LakeFSContext$.MODULE$.MARK_ID_KEY(), functions$.MODULE$.lit((Object)markID));
    }

    private void writeReports(String storageNSForHadoopFS, String gcRules, String runID, String markID, Dataset<Row> commitsDF, Dataset<Row> expiredAddresses, Dataset<Row> removed, ConfigMapper configMapper) {
        String reportLogsDst = this.concatToGCLogsPrefix(storageNSForHadoopFS, "summary");
        String reportExpiredDst = this.concatToGCLogsPrefix(storageNSForHadoopFS, "expired_addresses");
        String deletedObjectsDst = this.concatToGCLogsPrefix(storageNSForHadoopFS, "deleted_objects");
        String time = DateTimeFormatter.ISO_INSTANT.format(Clock.systemUTC().instant());
        this.writeParquetReport(commitsDF, reportLogsDst, time, "commits.parquet");
        try {
            this.writeParquetReport(expiredAddresses, reportExpiredDst, time, this.writeParquetReport$default$4());
            String arg$macro$1 = reportExpiredDst;
            String arg$macro$2 = time;
            Dataset expiredDF = this.spark().read().parquet(new StringOps("%s/dt=%s/").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2})));
            Long arg$macro$3 = BoxesRunTime.boxToLong((long)expiredDF.count());
            Predef$.MODULE$.println((Object)new StringOps("Total expired addresses: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$3})));
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)"Error when trying to get expired addresses count, moving on:");
            e.printStackTrace();
        }
        try {
            long removedCount = removed.count();
            this.writeJsonSummary(configMapper, reportLogsDst, removedCount, gcRules, time);
            String arg$macro$4 = deletedObjectsDst;
            String arg$macro$5 = time;
            removed.withColumn(LakeFSContext$.MODULE$.MARK_ID_KEY(), functions$.MODULE$.lit((Object)markID)).withColumn(LakeFSContext$.MODULE$.RUN_ID_KEY(), functions$.MODULE$.lit((Object)runID)).write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LakeFSContext$.MODULE$.MARK_ID_KEY(), LakeFSContext$.MODULE$.RUN_ID_KEY()})).mode(SaveMode.Overwrite).parquet(new StringOps("%s/dt=%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$4, arg$macro$5})));
            Long arg$macro$6 = BoxesRunTime.boxToLong((long)removedCount);
            Predef$.MODULE$.println((Object)new StringOps("Total objects deleted (or already had been deleted): %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$6})));
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)"Error when trying to write the summary, moving on:");
            e.printStackTrace();
        }
    }

    private String concatToGCLogsPrefix(String storageNameSpace, String key) {
        String strippedKey = new StringOps(Predef$.MODULE$.augmentString(key)).stripPrefix("/");
        return new StringBuilder(16).append(storageNameSpace).append("_lakefs/logs/gc/").append(strippedKey).toString();
    }

    private Dataset<Row> repartitionBySize(Dataset<Row> df, int maxSize, String column) {
        long nRows = df.count();
        int nPartitions = (int)scala.math.package$.MODULE$.max(1.0, scala.math.package$.MODULE$.ceil((double)(nRows / (long)maxSize)));
        return df.repartitionByRange(nPartitions, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(column)}));
    }

    public Dataset<String> bulkRemove(ConfigMapper configMapper, Dataset<Row> readKeysDF, String storageNamespace, String region, String storageType) {
        BulkRemover bulkRemover = BulkRemoverFactory$.MODULE$.apply(storageType, configMapper.configuration(), storageNamespace, region);
        int bulkSize = bulkRemover.getMaxBulkSize();
        Dataset<Row> repartitionedKeys = this.repartitionBySize(readKeysDF, bulkSize, "address");
        Dataset bulkedKeyStrings = repartitionedKeys.select("address", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getString(0), this.spark().implicits().newStringEncoder());
        return bulkedKeyStrings.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            BulkRemover bulkRemover = BulkRemoverFactory$.MODULE$.apply(storageType, configMapper.configuration(), storageNamespace, region);
            return iter.grouped(bulkSize).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> bulkRemover.deleteObjects((Seq<String>)x$4, storageNamespace));
        }, this.spark().implicits().newStringEncoder());
    }

    public Dataset<Row> remove(ConfigMapper configMapper, String storageNamespace, String addressDFLocation, Dataset<Row> expiredAddresses, String markID, String region, String storageType, StructType schema) {
        Predef$.MODULE$.println((Object)new StringBuilder(19).append("addressDFLocation: ").append(addressDFLocation).toString());
        Dataset df = expiredAddresses.where(functions$.MODULE$.col(LakeFSContext$.MODULE$.MARK_ID_KEY()).$eq$eq$eq((Object)markID));
        return this.bulkRemove(configMapper, (Dataset<Row>)df, storageNamespace, region, storageType).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])schema.fieldNames()));
    }

    private String getMetadataMarkLocation(String markId, String gcAddressesLocation) {
        return new StringBuilder(6).append(gcAddressesLocation).append("/").append(markId).append(".meta").toString();
    }

    private Dataset<Row> getMarkMetadata(String markId, String gcAddressesLocation) {
        String addressesMarkMetadataLocation = this.getMetadataMarkLocation(markId, gcAddressesLocation);
        return this.spark().read().json(addressesMarkMetadataLocation);
    }

    private String[] populateRunIDAndCommitsLocation(String markID, String gcAddressesLocation) {
        Dataset<Row> markMetadataDF = this.getMarkMetadata(markID, gcAddressesLocation);
        return (String[])markMetadataDF.select(LakeFSContext$.MODULE$.RUN_ID_KEY(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LakeFSContext$.MODULE$.COMMITS_LOCATION_KEY()})).map((Function1 & Serializable & scala.Serializable)row -> {
            ObjectRef arr = ObjectRef.create((Object)((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                arr$1.elem = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String[])arr$1.elem))).$colon$plus((Object)row.getString(i), ClassTag$.MODULE$.apply(String.class));
            });
            return (String[])arr.elem;
        }, this.spark().implicits().newStringArrayEncoder()).first();
    }

    private Dataset<Row> generateMarkMetadataDataframe(String runId, String commitsLocation) {
        Seq metadata = (Seq)new .colon.colon((Object)new Tuple2((Object)runId, (Object)commitsLocation), (List)Nil$.MODULE$);
        StructField[] fields = (StructField[])((Object[])new StructField[]{new StructField(LakeFSContext$.MODULE$.RUN_ID_KEY(), (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField(LakeFSContext$.MODULE$.COMMITS_LOCATION_KEY(), (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())});
        StructType schema = new StructType(fields);
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Io_treeverse_clients_GarbageCollector$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator1$1() {
            }
        }
        return this.spark().createDataFrame(metadata, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator1$1())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])schema.fieldNames()));
    }

    private void writeAddressesMarkMetadata(String runID, String markId, String gcAddressesLocation, String gcCommitsLocation) {
        this.generateMarkMetadataDataframe(runID, gcCommitsLocation).write().mode(SaveMode.Overwrite).json(this.getMetadataMarkLocation(markId, gcAddressesLocation));
    }

    private String getAddressesLocation(String storageNSForHadoopFS) {
        return new StringBuilder(32).append(new StringOps(Predef$.MODULE$.augmentString(storageNSForHadoopFS)).stripSuffix("/")).append("/_lakefs/retention/gc/addresses/").toString();
    }

    private void writeParquetReport(Dataset<Row> df, String dstRoot, String time, String suffix) {
        String dstPath = new StringBuilder(5).append(dstRoot).append("/dt=").append(time).append("/").append(suffix).toString();
        df.write().parquet(dstPath);
    }

    private String writeParquetReport$default$4() {
        return "";
    }

    private void writeJsonSummary(ConfigMapper configMapper, String dstRoot, long numDeletedObjects, String gcRules, String time) {
        Path dstPath = new Path(new StringBuilder(17).append(dstRoot).append("/dt=").append(time).append("/summary.json").toString());
        FileSystem dstFS = dstPath.getFileSystem(configMapper.configuration());
        JsonAST.JObject jsonSummary = package$.MODULE$.JObject().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gc_rules"), (Object)JsonDSL$.MODULE$.string2jvalue(gcRules)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"num_deleted_objects"), (Object)JsonDSL$.MODULE$.long2jvalue(numDeletedObjects))}));
        try (FSDataOutputStream stream = dstFS.create(dstPath);){
            JsonAST.JObject x$1 = jsonSummary;
            Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
            byte[] bytes = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2)).getBytes("UTF-8");
            stream.write(bytes);
        }
    }

    public Function5<ConfigMapper, String, Object, String, String, BoxedUnit> writeJsonSummaryForTesting() {
        return (Function5 & Serializable & scala.Serializable)(configMapper, dstRoot, numDeletedObjects, gcRules, time) -> {
            GarbageCollector$.MODULE$.writeJsonSummary(configMapper, dstRoot, BoxesRunTime.unboxToLong((Object)numDeletedObjects), gcRules, time);
            return BoxedUnit.UNIT;
        };
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GarbageCollector$() {
        MODULE$ = this;
    }
}

