/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import io.treeverse.clients.LakeFSAllRangesInputFormat;
import io.treeverse.clients.LakeFSCommitInputFormat;
import io.treeverse.clients.LakeFSJobParams;
import io.treeverse.clients.LakeFSJobParams$;
import io.treeverse.clients.WithIdentifier;
import io.treeverse.lakefs.catalog.Entry;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class LakeFSContext$ {
    public static LakeFSContext$ MODULE$;
    private final String LAKEFS_CONF_API_URL_KEY;
    private final String LAKEFS_CONF_API_ACCESS_KEY_KEY;
    private final String LAKEFS_CONF_API_SECRET_KEY_KEY;
    private final String LAKEFS_CONF_API_CONNECTION_TIMEOUT_SEC_KEY;
    private final String LAKEFS_CONF_API_READ_TIMEOUT_SEC_KEY;
    private final String LAKEFS_CONF_JOB_REPO_NAME_KEY;
    private final String LAKEFS_CONF_JOB_STORAGE_NAMESPACE_KEY;
    private final String LAKEFS_CONF_JOB_COMMIT_ID_KEY;
    private final String LAKEFS_CONF_JOB_SOURCE_NAME_KEY;
    private final String LAKEFS_CONF_GC_NUM_COMMIT_PARTITIONS;
    private final String LAKEFS_CONF_GC_NUM_RANGE_PARTITIONS;
    private final String LAKEFS_CONF_GC_NUM_ADDRESS_PARTITIONS;
    private final String LAKEFS_CONF_DEBUG_GC_MAX_COMMIT_ISO_DATETIME_KEY;
    private final String LAKEFS_CONF_DEBUG_GC_MAX_COMMIT_EPOCH_SECONDS_KEY;
    private final String LAKEFS_CONF_DEBUG_GC_REPRODUCE_RUN_ID_KEY;
    private final String LAKEFS_CONF_DEBUG_GC_UNCOMMITTED_MIN_AGE_SECONDS_KEY;
    private final String LAKEFS_CONF_GC_DO_MARK;
    private final String LAKEFS_CONF_GC_DO_SWEEP;
    private final String LAKEFS_CONF_GC_MARK_ID;
    private final String LAKEFS_CONF_DEBUG_GC_NO_DELETE_KEY;
    private final String MARK_ID_KEY;
    private final String RUN_ID_KEY;
    private final String COMMITS_LOCATION_KEY;
    private final int DEFAULT_LAKEFS_CONF_GC_NUM_COMMIT_PARTITIONS;
    private final int DEFAULT_LAKEFS_CONF_GC_NUM_RANGE_PARTITIONS;
    private final int DEFAULT_LAKEFS_CONF_GC_NUM_ADDRESS_PARTITIONS;
    private final int DEFAULT_GC_UNCOMMITTED_MIN_AGE_SECONDS;

    static {
        new LakeFSContext$();
    }

    public String LAKEFS_CONF_API_URL_KEY() {
        return this.LAKEFS_CONF_API_URL_KEY;
    }

    public String LAKEFS_CONF_API_ACCESS_KEY_KEY() {
        return this.LAKEFS_CONF_API_ACCESS_KEY_KEY;
    }

    public String LAKEFS_CONF_API_SECRET_KEY_KEY() {
        return this.LAKEFS_CONF_API_SECRET_KEY_KEY;
    }

    public String LAKEFS_CONF_API_CONNECTION_TIMEOUT_SEC_KEY() {
        return this.LAKEFS_CONF_API_CONNECTION_TIMEOUT_SEC_KEY;
    }

    public String LAKEFS_CONF_API_READ_TIMEOUT_SEC_KEY() {
        return this.LAKEFS_CONF_API_READ_TIMEOUT_SEC_KEY;
    }

    public String LAKEFS_CONF_JOB_REPO_NAME_KEY() {
        return this.LAKEFS_CONF_JOB_REPO_NAME_KEY;
    }

    public String LAKEFS_CONF_JOB_STORAGE_NAMESPACE_KEY() {
        return this.LAKEFS_CONF_JOB_STORAGE_NAMESPACE_KEY;
    }

    public String LAKEFS_CONF_JOB_COMMIT_ID_KEY() {
        return this.LAKEFS_CONF_JOB_COMMIT_ID_KEY;
    }

    public String LAKEFS_CONF_JOB_SOURCE_NAME_KEY() {
        return this.LAKEFS_CONF_JOB_SOURCE_NAME_KEY;
    }

    public String LAKEFS_CONF_GC_NUM_COMMIT_PARTITIONS() {
        return this.LAKEFS_CONF_GC_NUM_COMMIT_PARTITIONS;
    }

    public String LAKEFS_CONF_GC_NUM_RANGE_PARTITIONS() {
        return this.LAKEFS_CONF_GC_NUM_RANGE_PARTITIONS;
    }

    public String LAKEFS_CONF_GC_NUM_ADDRESS_PARTITIONS() {
        return this.LAKEFS_CONF_GC_NUM_ADDRESS_PARTITIONS;
    }

    public String LAKEFS_CONF_DEBUG_GC_MAX_COMMIT_ISO_DATETIME_KEY() {
        return this.LAKEFS_CONF_DEBUG_GC_MAX_COMMIT_ISO_DATETIME_KEY;
    }

    public String LAKEFS_CONF_DEBUG_GC_MAX_COMMIT_EPOCH_SECONDS_KEY() {
        return this.LAKEFS_CONF_DEBUG_GC_MAX_COMMIT_EPOCH_SECONDS_KEY;
    }

    public String LAKEFS_CONF_DEBUG_GC_REPRODUCE_RUN_ID_KEY() {
        return this.LAKEFS_CONF_DEBUG_GC_REPRODUCE_RUN_ID_KEY;
    }

    public String LAKEFS_CONF_DEBUG_GC_UNCOMMITTED_MIN_AGE_SECONDS_KEY() {
        return this.LAKEFS_CONF_DEBUG_GC_UNCOMMITTED_MIN_AGE_SECONDS_KEY;
    }

    public String LAKEFS_CONF_GC_DO_MARK() {
        return this.LAKEFS_CONF_GC_DO_MARK;
    }

    public String LAKEFS_CONF_GC_DO_SWEEP() {
        return this.LAKEFS_CONF_GC_DO_SWEEP;
    }

    public String LAKEFS_CONF_GC_MARK_ID() {
        return this.LAKEFS_CONF_GC_MARK_ID;
    }

    public String LAKEFS_CONF_DEBUG_GC_NO_DELETE_KEY() {
        return this.LAKEFS_CONF_DEBUG_GC_NO_DELETE_KEY;
    }

    public String MARK_ID_KEY() {
        return this.MARK_ID_KEY;
    }

    public String RUN_ID_KEY() {
        return this.RUN_ID_KEY;
    }

    public String COMMITS_LOCATION_KEY() {
        return this.COMMITS_LOCATION_KEY;
    }

    public int DEFAULT_LAKEFS_CONF_GC_NUM_COMMIT_PARTITIONS() {
        return this.DEFAULT_LAKEFS_CONF_GC_NUM_COMMIT_PARTITIONS;
    }

    public int DEFAULT_LAKEFS_CONF_GC_NUM_RANGE_PARTITIONS() {
        return this.DEFAULT_LAKEFS_CONF_GC_NUM_RANGE_PARTITIONS;
    }

    public int DEFAULT_LAKEFS_CONF_GC_NUM_ADDRESS_PARTITIONS() {
        return this.DEFAULT_LAKEFS_CONF_GC_NUM_ADDRESS_PARTITIONS;
    }

    public int DEFAULT_GC_UNCOMMITTED_MIN_AGE_SECONDS() {
        return this.DEFAULT_GC_UNCOMMITTED_MIN_AGE_SECONDS;
    }

    public RDD<Tuple2<byte[], WithIdentifier<Entry>>> newRDD(SparkContext sc, LakeFSJobParams params) {
        Class inputFormatClass = StringUtils.isNotBlank((CharSequence)params.commitID()) ? LakeFSCommitInputFormat.class : LakeFSAllRangesInputFormat.class;
        Configuration conf = new Configuration(sc.hadoopConfiguration());
        conf.set(this.LAKEFS_CONF_JOB_REPO_NAME_KEY(), params.repoName());
        conf.set(this.LAKEFS_CONF_JOB_COMMIT_ID_KEY(), params.commitID());
        conf.set(this.LAKEFS_CONF_JOB_STORAGE_NAMESPACE_KEY(), params.storageNamespace());
        if (StringUtils.isBlank((CharSequence)conf.get(this.LAKEFS_CONF_API_URL_KEY()))) {
            throw new InvalidJobConfException(new StringBuilder(18).append(this.LAKEFS_CONF_API_URL_KEY()).append(" must not be empty").toString());
        }
        if (StringUtils.isBlank((CharSequence)conf.get(this.LAKEFS_CONF_API_ACCESS_KEY_KEY()))) {
            throw new InvalidJobConfException(new StringBuilder(18).append(this.LAKEFS_CONF_API_ACCESS_KEY_KEY()).append(" must not be empty").toString());
        }
        if (StringUtils.isBlank((CharSequence)conf.get(this.LAKEFS_CONF_API_SECRET_KEY_KEY()))) {
            throw new InvalidJobConfException(new StringBuilder(18).append(this.LAKEFS_CONF_API_SECRET_KEY_KEY()).append(" must not be empty").toString());
        }
        conf.set(this.LAKEFS_CONF_JOB_SOURCE_NAME_KEY(), params.sourceName());
        return sc.newAPIHadoopRDD(conf, inputFormatClass, byte[].class, WithIdentifier.class);
    }

    public RDD<Tuple2<byte[], WithIdentifier<Entry>>> newRDD(SparkContext sc, String repoName, String commitID) {
        Class inputFormatClass = StringUtils.isNotBlank((CharSequence)commitID) ? LakeFSCommitInputFormat.class : LakeFSAllRangesInputFormat.class;
        return this.newRDD(sc, LakeFSJobParams$.MODULE$.forCommit(repoName, commitID, LakeFSJobParams$.MODULE$.forCommit$default$3()));
    }

    public String newRDD$default$3() {
        return "";
    }

    public Dataset<Row> newDF(SparkSession spark, LakeFSJobParams params) {
        RDD rdd = this.newRDD(spark.sparkContext(), params).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] k = (byte[])tuple2._1();
            WithIdentifier v = (WithIdentifier)tuple2._2();
            Entry entry = (Entry)v.message();
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String(k), entry.address(), entry.eTag(), new Timestamp(TimeUnit.SECONDS.toMillis(entry.getLastModified().seconds())), BoxesRunTime.boxToLong((long)entry.size()), new String(v.rangeID()), entry.addressType().toString()}));
            return row;
        }, ClassTag$.MODULE$.apply(Row.class));
        StructType schema = new StructType().add(new StructField("key", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("address", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("etag", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("last_modified", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("size", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("range_id", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("address_type", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
        return spark.createDataFrame(rdd, schema);
    }

    public Dataset<Row> newDF(SparkSession spark, String storageNamespace) {
        return this.newDF(spark, LakeFSJobParams$.MODULE$.forStorageNamespace(storageNamespace, LakeFSJobParams$.MODULE$.forStorageNamespace$default$2()));
    }

    public Dataset<Row> newDF(SparkSession spark, String repoName, String commitID) {
        Class inputFormatClass = StringUtils.isNotBlank((CharSequence)commitID) ? LakeFSCommitInputFormat.class : LakeFSAllRangesInputFormat.class;
        return this.newDF(spark, LakeFSJobParams$.MODULE$.forCommit(repoName, commitID, LakeFSJobParams$.MODULE$.forCommit$default$3()));
    }

    public String newDF$default$3() {
        return "";
    }

    private LakeFSContext$() {
        MODULE$ = this;
        this.LAKEFS_CONF_API_URL_KEY = "lakefs.api.url";
        this.LAKEFS_CONF_API_ACCESS_KEY_KEY = "lakefs.api.access_key";
        this.LAKEFS_CONF_API_SECRET_KEY_KEY = "lakefs.api.secret_key";
        this.LAKEFS_CONF_API_CONNECTION_TIMEOUT_SEC_KEY = "lakefs.api.connection.timeout_seconds";
        this.LAKEFS_CONF_API_READ_TIMEOUT_SEC_KEY = "lakefs.api.read.timeout_seconds";
        this.LAKEFS_CONF_JOB_REPO_NAME_KEY = "lakefs.job.repo_name";
        this.LAKEFS_CONF_JOB_STORAGE_NAMESPACE_KEY = "lakefs.job.storage_namespace";
        this.LAKEFS_CONF_JOB_COMMIT_ID_KEY = "lakefs.job.commit_id";
        this.LAKEFS_CONF_JOB_SOURCE_NAME_KEY = "lakefs.job.source_name";
        this.LAKEFS_CONF_GC_NUM_COMMIT_PARTITIONS = "lakefs.gc.commit.num_partitions";
        this.LAKEFS_CONF_GC_NUM_RANGE_PARTITIONS = "lakefs.gc.range.num_partitions";
        this.LAKEFS_CONF_GC_NUM_ADDRESS_PARTITIONS = "lakefs.gc.address.num_partitions";
        this.LAKEFS_CONF_DEBUG_GC_MAX_COMMIT_ISO_DATETIME_KEY = "lakefs.debug.gc.max_commit_iso_datetime";
        this.LAKEFS_CONF_DEBUG_GC_MAX_COMMIT_EPOCH_SECONDS_KEY = "lakefs.debug.gc.max_commit_epoch_seconds";
        this.LAKEFS_CONF_DEBUG_GC_REPRODUCE_RUN_ID_KEY = "lakefs.debug.gc.reproduce_run_id";
        this.LAKEFS_CONF_DEBUG_GC_UNCOMMITTED_MIN_AGE_SECONDS_KEY = "lakefs.debug.gc.uncommitted_min_age_seconds";
        this.LAKEFS_CONF_GC_DO_MARK = "lakefs.gc.do_mark";
        this.LAKEFS_CONF_GC_DO_SWEEP = "lakefs.gc.do_sweep";
        this.LAKEFS_CONF_GC_MARK_ID = "lakefs.gc.mark_id";
        this.LAKEFS_CONF_DEBUG_GC_NO_DELETE_KEY = "lakefs.debug.gc.no_delete";
        this.MARK_ID_KEY = "mark_id";
        this.RUN_ID_KEY = "run_id";
        this.COMMITS_LOCATION_KEY = "commits_location";
        this.DEFAULT_LAKEFS_CONF_GC_NUM_COMMIT_PARTITIONS = 24;
        this.DEFAULT_LAKEFS_CONF_GC_NUM_RANGE_PARTITIONS = 50;
        this.DEFAULT_LAKEFS_CONF_GC_NUM_ADDRESS_PARTITIONS = 200;
        this.DEFAULT_GC_UNCOMMITTED_MIN_AGE_SECONDS = 21600;
    }
}

