/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.gc;

import io.treeverse.clients.LakeFSContext$;
import io.treeverse.clients.LakeFSJobParams;
import io.treeverse.clients.LakeFSJobParams$;
import io.treeverse.gc.CommittedAddressLister;
import io.treeverse.lakefs.catalog.Entry$AddressType$RELATIVE$;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u000193A\u0001B\u0003\u0001\u0019!)q\u0003\u0001C\u00011!)!\u0004\u0001C!7!)q\t\u0001C\u0001\u0011\nYb*Y5wK\u000e{W.\\5ui\u0016$\u0017\t\u001a3sKN\u001cH*[:uKJT!AB\u0004\u0002\u0005\u001d\u001c'B\u0001\u0005\n\u0003%!(/Z3wKJ\u001cXMC\u0001\u000b\u0003\tIwn\u0001\u0001\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)Ui\u0011!B\u0005\u0003-\u0015\u0011acQ8n[&$H/\u001a3BI\u0012\u0014Xm]:MSN$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"\u0001\u0006\u0001\u0002-1L7\u000f^\"p[6LG\u000f^3e\u0003\u0012$'/Z:tKN$B\u0001\b\u001c<\u000bB\u0011Qd\r\b\u0003=Ar!aH\u0017\u000f\u0005\u0001RcBA\u0011(\u001d\t\u0011S%D\u0001$\u0015\t!3\"\u0001\u0004=e>|GOP\u0005\u0002M\u0005\u0019qN]4\n\u0005!J\u0013AB1qC\u000eDWMC\u0001'\u0013\tYC&A\u0003ta\u0006\u00148N\u0003\u0002)S%\u0011afL\u0001\u0004gFd'BA\u0016-\u0013\t\t$'A\u0004qC\u000e\\\u0017mZ3\u000b\u00059z\u0013B\u0001\u001b6\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u00022e!)1F\u0001a\u0001oA\u0011\u0001(O\u0007\u0002e%\u0011!H\r\u0002\r'B\f'o[*fgNLwN\u001c\u0005\u0006y\t\u0001\r!P\u0001\u0011gR|'/Y4f\u001d\u0006lWm\u001d9bG\u0016\u0004\"A\u0010\"\u000f\u0005}\u0002\u0005C\u0001\u0012\u0010\u0013\t\tu\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007\u0012\u0013aa\u0015;sS:<'BA!\u0010\u0011\u00151%\u00011\u0001>\u0003Y\u0019G.[3oiN#xN]1hK:\u000bW.Z:qC\u000e,\u0017a\u00044jYR,'/\u00113ee\u0016\u001c8/Z:\u0015\tqI%\n\u0014\u0005\u0006W\r\u0001\ra\u000e\u0005\u0006\u0017\u000e\u0001\r\u0001H\u0001\u0003I\u001aDQ!T\u0002A\u0002u\n\u0001E\\8s[\u0006d\u0017N_3e\u00072LWM\u001c;Ti>\u0014\u0018mZ3OC6,7\u000f]1dK\u0002")
public class NaiveCommittedAddressLister
implements CommittedAddressLister {
    @Override
    public Dataset<Row> listCommittedAddresses(SparkSession spark, String storageNamespace, String clientStorageNamespace) {
        String normalizedStorageNamespace = storageNamespace.endsWith("/") ? storageNamespace : new StringBuilder(1).append(storageNamespace).append("/").toString();
        LakeFSJobParams params = LakeFSJobParams$.MODULE$.forStorageNamespace(normalizedStorageNamespace, "uncommitted_gc");
        Dataset<Row> df = LakeFSContext$.MODULE$.newDF(spark, params);
        String normalizedClientStorageNamespace = clientStorageNamespace.endsWith("/") ? clientStorageNamespace : new StringBuilder(1).append(clientStorageNamespace).append("/").toString();
        return this.filterAddresses(spark, df, normalizedClientStorageNamespace);
    }

    public Dataset<Row> filterAddresses(SparkSession spark, Dataset<Row> df, String normalizedClientStorageNamespace) {
        ObjectRef storageScheme = ObjectRef.create((Object)new Path(normalizedClientStorageNamespace).toUri().getScheme());
        if (((String)storageScheme.elem).isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(43).append("Invalid storage namespace - missing scheme ").append(normalizedClientStorageNamespace).toString());
        }
        storageScheme.elem = new StringBuilder(1).append((String)storageScheme.elem).append(":").toString();
        return df.select("address_type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"address"})).filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)NaiveCommittedAddressLister.$anonfun$filterAddresses$1(normalizedClientStorageNamespace, storageScheme, row))).map((Function1 & Serializable & scala.Serializable)row -> {
            Tuple2 tuple2 = new Tuple2((Object)row.getString(0), (Object)row.getString(1));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String addrType = (String)tuple2._1();
            String addr = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)addrType, (Object)addr);
            Tuple2 tuple23 = tuple22;
            String addrType2 = (String)tuple23._1();
            String addr2 = (String)tuple23._2();
            boolean relativeType = addrType2.equals(Entry$AddressType$RELATIVE$.MODULE$.name());
            return !relativeType && addr2.startsWith(normalizedClientStorageNamespace) ? addr2.substring(normalizedClientStorageNamespace.length()) : addr2;
        }, spark.implicits().newStringEncoder()).distinct().toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"address"}));
    }

    public static final /* synthetic */ boolean $anonfun$filterAddresses$1(String normalizedClientStorageNamespace$1, ObjectRef storageScheme$1, Row row) {
        Tuple2 tuple2 = new Tuple2((Object)row.getString(0), (Object)row.getString(1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String addrType = (String)tuple2._1();
        String addr = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)addrType, (Object)addr);
        Tuple2 tuple23 = tuple22;
        String addrType2 = (String)tuple23._1();
        String addr2 = (String)tuple23._2();
        return addrType2.equals(Entry$AddressType$RELATIVE$.MODULE$.name()) || addr2.startsWith(normalizedClientStorageNamespace$1) || !addr2.startsWith((String)storageScheme$1.elem);
    }
}

