/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.azure.core.http.HttpClient;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.batch.BlobBatchClient;
import com.azure.storage.blob.batch.BlobBatchClientBuilder;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.policy.RequestRetryOptions;
import io.treeverse.clients.BulkRemover;
import io.treeverse.clients.BulkRemoverFactory$;
import io.treeverse.clients.StorageUtils$AzureBlob$;
import io.treeverse.clients.StorageUtils$S3$;
import io.treeverse.clients.conditional.S3ClientBuilder$;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Mt!B\u0010!\u0011\u00039c!B\u0015!\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011d\u0001B\u001a\u0002\tQB\u0001\u0002O\u0002\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u000b\u000e\u0011\t\u0011)A\u0005\r\"A\u0011k\u0001B\u0001B\u0003%a\tC\u00032\u0007\u0011\u0005!\u000bC\u0004Y\u0007\t\u0007I\u0011A-\t\r\t\u001c\u0001\u0015!\u0003[\u0011\u001d\u00197A1A\u0005\u0002\u0011DaA[\u0002!\u0002\u0013)\u0007\"B6\u0004\t\u0003b\u0007\"B=\u0004\t\u0013Q\bbBA\u0010\u0007\u0011\u0005\u0013\u0011\u0005\u0004\u0007\u0003G\tA!!\n\t\u0011az!\u0011!Q\u0001\neB\u0001\"R\b\u0003\u0002\u0003\u0006IA\u0012\u0005\u0007c=!\t!a\n\t\u0011\u0005=rB1A\u0005\u0002\u0011Dq!!\r\u0010A\u0003%Q\rC\u0004Y\u001f\t\u0007I\u0011A-\t\r\t|\u0001\u0015!\u0003[\u0011%\t\u0019d\u0004b\u0001\n\u0003\t)\u0004C\u0004\u00028=\u0001\u000b\u0011\u0002$\t\u0013\u0005erB1A\u0005\u0002\u0005U\u0002bBA\u001e\u001f\u0001\u0006IA\u0012\u0005\u0007W>!\t%!\u0010\t\u000f\u0005\rs\u0002\"\u0003\u0002F!9\u0011qD\b\u0005B\u0005\u0005\u0002bBA3\u0003\u0011\u0005\u0011qM\u0001\u0013\u0005Vd7NU3n_Z,'OR1di>\u0014\u0018P\u0003\u0002\"E\u000591\r\\5f]R\u001c(BA\u0012%\u0003%!(/Z3wKJ\u001cXMC\u0001&\u0003\tIwn\u0001\u0001\u0011\u0005!\nQ\"\u0001\u0011\u0003%\t+Hn\u001b*f[>4XM\u001d$bGR|'/_\n\u0003\u0003-\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001(\u00055\u00196GQ;mWJ+Wn\u001c<feN\u00191aK\u001b\u0011\u0005!2\u0014BA\u001c!\u0005-\u0011U\u000f\\6SK6|g/\u001a:\u0002\u0005!\u001c\u0007C\u0001\u001eD\u001b\u0005Y$B\u0001\u001f>\u0003\u0011\u0019wN\u001c4\u000b\u0005yz\u0014A\u00025bI>|\u0007O\u0003\u0002A\u0003\u00061\u0011\r]1dQ\u0016T\u0011AQ\u0001\u0004_J<\u0017B\u0001#<\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006\u00012\u000f^8sC\u001e,g*Y7fgB\f7-\u001a\t\u0003\u000f:s!\u0001\u0013'\u0011\u0005%kS\"\u0001&\u000b\u0005-3\u0013A\u0002\u001fs_>$h(\u0003\u0002N[\u00051\u0001K]3eK\u001aL!a\u0014)\u0003\rM#(/\u001b8h\u0015\tiU&\u0001\u0004sK\u001eLwN\u001c\u000b\u0005'V3v\u000b\u0005\u0002U\u00075\t\u0011\u0001C\u00039\u000f\u0001\u0007\u0011\bC\u0003F\u000f\u0001\u0007a\tC\u0003R\u000f\u0001\u0007a)A\u0002ve&,\u0012A\u0017\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000b1A\\3u\u0015\u0005y\u0016\u0001\u00026bm\u0006L!!\u0019/\u0003\u0007U\u0013\u0016*\u0001\u0003ve&\u0004\u0013A\u00022vG.,G/F\u0001f!\t1\u0017.D\u0001h\u0015\tAg,\u0001\u0003mC:<\u0017BA(h\u0003\u001d\u0011WoY6fi\u0002\nQ\u0002Z3mKR,wJ\u00196fGR\u001cHcA7wqB\u0019an\u001d$\u000f\u0005=\fhBA%q\u0013\u0005q\u0013B\u0001:.\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001^;\u0003\u0007M+\u0017O\u0003\u0002s[!)q\u000f\u0004a\u0001[\u0006!1.Z=t\u0011\u0015)E\u00021\u0001G\u0003-9W\r^*4\u00072LWM\u001c;\u0015\u0013m\fy!!\u0005\u0002\u0014\u0005U\u0001c\u0001?\u0002\f5\tQP\u0003\u0002\u007f\u007f\u0006\u00111o\r\u0006\u0005\u0003\u0003\t\u0019!\u0001\u0005tKJ4\u0018nY3t\u0015\u0011\t)!a\u0002\u0002\u0013\u0005l\u0017M_8oC^\u001c(BAA\u0005\u0003\r\u0019w.\\\u0005\u0004\u0003\u001bi(\u0001C!nCj|gnU\u001a\t\u000baj\u0001\u0019A\u001d\t\u000b\rl\u0001\u0019\u0001$\t\u000bEk\u0001\u0019\u0001$\t\u000f\u0005]Q\u00021\u0001\u0002\u001a\u0005Qa.^7SKR\u0014\u0018.Z:\u0011\u00071\nY\"C\u0002\u0002\u001e5\u00121!\u00138u\u000399W\r^'bq\n+Hn[*ju\u0016$\"!!\u0007\u0003)\u0005SXO]3CY>\u0014')\u001e7l%\u0016lwN^3s'\ry1&\u000e\u000b\u0007\u0003S\tY#!\f\u0011\u0005Q{\u0001\"\u0002\u001d\u0013\u0001\u0004I\u0004\"B#\u0013\u0001\u00041\u0015aC#naRL8\u000b\u001e:j]\u001e\fA\"R7qif\u001cFO]5oO\u0002\n\u0011c\u001d;pe\u0006<W-Q2d_VtG/\u0016:m+\u00051\u0015AE:u_J\fw-Z!dG>,h\u000e^+sY\u0002\n!c\u001d;pe\u0006<W-Q2d_VtGOT1nK\u0006\u00192\u000f^8sC\u001e,\u0017iY2pk:$h*Y7fAQ)Q.a\u0010\u0002B!)qo\u0007a\u0001[\")Qi\u0007a\u0001\r\u0006\u0011r-\u001a;CY>\u0014')\u0019;dQ\u000ec\u0017.\u001a8u)!\t9%a\u0018\u0002b\u0005\r\u0004\u0003BA%\u00037j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\u0006E\u0006$8\r\u001b\u0006\u0005\u0003#\n\u0019&\u0001\u0003cY>\u0014'\u0002BA+\u0003/\nqa\u001d;pe\u0006<WM\u0003\u0003\u0002Z\u0005\u001d\u0011!B1{kJ,\u0017\u0002BA/\u0003\u0017\u0012qB\u00117pE\n\u000bGo\u00195DY&,g\u000e\u001e\u0005\u0006qq\u0001\r!\u000f\u0005\u0007\u0003ga\u0002\u0019\u0001$\t\r\u0005eB\u00041\u0001G\u0003\u0015\t\u0007\u000f\u001d7z)%)\u0014\u0011NA7\u0003_\n\t\b\u0003\u0004\u0002ly\u0001\rAR\u0001\fgR|'/Y4f)f\u0004X\rC\u00039=\u0001\u0007\u0011\bC\u0003F=\u0001\u0007a\tC\u0003R=\u0001\u0007a\t")
public final class BulkRemoverFactory {
    public static BulkRemover apply(String string, Configuration configuration, String string2, String string3) {
        return BulkRemoverFactory$.MODULE$.apply(string, configuration, string2, string3);
    }

    public static class AzureBlobBulkRemover
    implements BulkRemover {
        private final Configuration hc;
        private final String EmptyString;
        private final URI uri;
        private final String storageAccountUrl;
        private final String storageAccountName;

        @Override
        public Seq<String> constructRemoveKeyNames(Seq<String> keys, String storageNamespace, boolean keepNsSchemeAndHost, boolean applyUTF8Encoding) {
            return BulkRemover.constructRemoveKeyNames$(this, keys, storageNamespace, keepNsSchemeAndHost, applyUTF8Encoding);
        }

        public String EmptyString() {
            return this.EmptyString;
        }

        public URI uri() {
            return this.uri;
        }

        public String storageAccountUrl() {
            return this.storageAccountUrl;
        }

        public String storageAccountName() {
            return this.storageAccountName;
        }

        @Override
        public Seq<String> deleteObjects(Seq<String> keys, String storageNamespace) {
            Seq seq;
            Seq<String> removeKeyNames = this.constructRemoveKeyNames(keys, storageNamespace, true, true);
            Predef$.MODULE$.println((Object)new Tuple2((Object)"Remove keys:", (Object)((TraversableOnce)removeKeyNames.take(100)).mkString(", ")));
            List removeKeys = (List)JavaConverters$.MODULE$.seqAsJavaListConverter(removeKeyNames).asJava();
            BlobBatchClient blobBatchClient = this.getBlobBatchClient(this.hc, this.storageAccountUrl(), this.storageAccountName());
            Function<Response<Void>, URI> extractUrlIfBlobDeleted = new Function<Response<Void>, URI>(this){
                private final /* synthetic */ AzureBlobBulkRemover $outer;

                public <V> Function<V, URI> compose(Function<? super V, ? extends Response<Void>> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<Response<Void>, V> andThen(Function<? super URI, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public URI apply(Response<Void> response) {
                    Object object = response.getStatusCode() == 200 ? response.getRequest().getUrl() : BoxedUnit.UNIT;
                    return new URI(this.$outer.EmptyString());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            Function<URI, String> uriToString = new Function<URI, String>(null){

                public <V> Function<V, String> compose(Function<? super V, ? extends URI> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<URI, V> andThen(Function<? super String, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public String apply(URI uri) {
                    return uri.toString();
                }
            };
            Predicate<String> isNonEmptyString = new Predicate<String>(this){
                private final /* synthetic */ AzureBlobBulkRemover $outer;

                public Predicate<String> and(Predicate<? super String> x$1) {
                    return Predicate.super.and(x$1);
                }

                public Predicate<String> negate() {
                    return Predicate.super.negate();
                }

                public Predicate<String> or(Predicate<? super String> x$1) {
                    return Predicate.super.or(x$1);
                }

                public boolean test(String s) {
                    return !this.$outer.EmptyString().equals(s);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            try {
                PagedIterable responses = blobBatchClient.deleteBlobs(removeKeys, DeleteSnapshotsOptionType.INCLUDE);
                seq = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(responses.stream().map(extractUrlIfBlobDeleted).map(uriToString).filter(isNonEmptyString).collect(Collectors.toList())).asScala()).toSeq();
            }
            catch (Throwable e) {
                e.printStackTrace();
                seq = (Seq)Nil$.MODULE$;
            }
            return seq;
        }

        private BlobBatchClient getBlobBatchClient(Configuration hc, String storageAccountUrl, String storageAccountName) {
            String storageAccountKeyPropName = StorageUtils$AzureBlob$.MODULE$.StorageAccountKeyPropertyPattern().replaceFirst(StorageUtils$AzureBlob$.MODULE$.StorageAccNamePlaceHolder(), storageAccountName);
            String storageAccountKey = hc.get(storageAccountKeyPropName);
            BlobServiceClient blobServiceClientSharedKey = new BlobServiceClientBuilder().endpoint(storageAccountUrl).credential(new StorageSharedKeyCredential(storageAccountName, storageAccountKey)).retryOptions(new RequestRetryOptions()).httpClient(HttpClient.createDefault()).buildClient();
            return new BlobBatchClientBuilder(blobServiceClientSharedKey).buildClient();
        }

        @Override
        public int getMaxBulkSize() {
            return StorageUtils$AzureBlob$.MODULE$.AzureBlobMaxBulkSize();
        }

        public AzureBlobBulkRemover(Configuration hc, String storageNamespace) {
            this.hc = hc;
            BulkRemover.$init$(this);
            this.EmptyString = "";
            this.uri = new URI(storageNamespace);
            this.storageAccountUrl = StorageUtils$AzureBlob$.MODULE$.uriToStorageAccountUrl(this.uri());
            this.storageAccountName = StorageUtils$AzureBlob$.MODULE$.uriToStorageAccountName(this.uri());
        }
    }

    public static class S3BulkRemover
    implements BulkRemover {
        private final Configuration hc;
        private final String region;
        private final URI uri;
        private final String bucket;

        @Override
        public Seq<String> constructRemoveKeyNames(Seq<String> keys, String storageNamespace, boolean keepNsSchemeAndHost, boolean applyUTF8Encoding) {
            return BulkRemover.constructRemoveKeyNames$(this, keys, storageNamespace, keepNsSchemeAndHost, applyUTF8Encoding);
        }

        public URI uri() {
            return this.uri;
        }

        public String bucket() {
            return this.bucket;
        }

        @Override
        public Seq<String> deleteObjects(Seq<String> keys, String storageNamespace) {
            Seq<String> removeKeyNames = this.constructRemoveKeyNames(keys, storageNamespace, false, false);
            Predef$.MODULE$.println((Object)new Tuple2((Object)"Remove keys:", (Object)((TraversableOnce)removeKeyNames.take(100)).mkString(", ")));
            List removeKeys = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)removeKeyNames.map((Function1 & Serializable & scala.Serializable)k -> new DeleteObjectsRequest.KeyVersion(k), Seq$.MODULE$.canBuildFrom())).asJava();
            DeleteObjectsRequest delObjReq = new DeleteObjectsRequest(this.bucket()).withKeys(removeKeys);
            AmazonS3 s3Client = this.getS3Client(this.hc, this.bucket(), this.region, StorageUtils$S3$.MODULE$.S3NumRetries());
            DeleteObjectsResult res = s3Client.deleteObjects(delObjReq);
            return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res.getDeletedObjects()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getKey(), Buffer$.MODULE$.canBuildFrom());
        }

        private AmazonS3 getS3Client(Configuration hc, String bucket, String region, int numRetries) {
            return S3ClientBuilder$.MODULE$.build(hc, bucket, region, numRetries);
        }

        @Override
        public int getMaxBulkSize() {
            return StorageUtils$S3$.MODULE$.S3MaxBulkSize();
        }

        public S3BulkRemover(Configuration hc, String storageNamespace, String region) {
            this.hc = hc;
            this.region = region;
            BulkRemover.$init$(this);
            this.uri = new URI(storageNamespace);
            this.bucket = this.uri().getHost();
        }
    }
}

