/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import io.treeverse.clients.APIConfigurations;
import io.treeverse.clients.ApiClient;
import io.treeverse.clients.ApiClient$;
import io.treeverse.clients.Conf;
import io.treeverse.clients.Exporter;
import io.treeverse.clients.LakeFSContext$;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Predef$;
import scala.collection.Seq;

public final class Main$ {
    public static Main$ MODULE$;

    static {
        new Main$();
    }

    public void main(String[] args) {
        String s3Prefix;
        Conf conf = new Conf((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        SparkContext sc = spark.sparkContext();
        String endpoint = sc.hadoopConfiguration().get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_URL_KEY());
        String accessKey = sc.hadoopConfiguration().get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_ACCESS_KEY_KEY());
        String secretKey = sc.hadoopConfiguration().get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_SECRET_KEY_KEY());
        String connectionTimeout = sc.hadoopConfiguration().get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_CONNECTION_TIMEOUT_SEC_KEY());
        String readTimeout = sc.hadoopConfiguration().get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_READ_TIMEOUT_SEC_KEY());
        String rawLocation = (String)conf.rootLocation().apply();
        String rootLocation = rawLocation.startsWith(s3Prefix = "s3://") ? new StringBuilder(6).append("s3a://").append(rawLocation.substring(s3Prefix.length())).toString() : rawLocation;
        ApiClient apiClient = ApiClient$.MODULE$.get(new APIConfigurations(endpoint, accessKey, secretKey, connectionTimeout, readTimeout, "exporter"));
        Exporter exporter = new Exporter(spark, apiClient, (String)conf.repo().apply(), rootLocation);
        if (conf.commit_id().isSupplied()) {
            exporter.exportAllFromCommit((String)conf.commit_id().apply());
            return;
        }
        if (conf.prev_commit_id().isSupplied()) {
            exporter.exportFrom((String)conf.branch().apply(), (String)conf.prev_commit_id().apply());
            return;
        }
        exporter.exportAllFromBranch((String)conf.branch().apply());
    }

    private Main$() {
        MODULE$ = this;
    }
}

