/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.jpebble;

import io.treeverse.jpebble.BadFileFormatException;
import io.treeverse.jpebble.BadFileFormatException$;
import io.treeverse.jpebble.BlockHandle;
import io.treeverse.jpebble.BlockReadable;
import io.treeverse.jpebble.CountedIterator;
import io.treeverse.jpebble.DataBlockIterator;
import io.treeverse.jpebble.Entry;
import io.treeverse.jpebble.IndexBlockHandles;
import io.treeverse.jpebble.IndexedBytes;
import io.treeverse.jpebble.IndexedBytes$;
import java.io.IOException;
import java.io.Serializable;
import java.util.zip.Checksum;
import org.xerial.snappy.PureJavaCrc32C;
import org.xerial.snappy.Snappy;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class BlockParser$ {
    public static BlockParser$ MODULE$;
    private final int footerLength;
    private final Seq<Object> footerMagic;
    private final int blockTrailerLen;
    private final int COMPRESSION_BLOCK_TYPE_NONE;
    private final int COMPRESSION_BLOCK_TYPE_SNAPPY;
    private final byte[] INDEX_TYPE_KEY;
    private final int INDEX_TYPE_TWO_LEVEL;

    static {
        new BlockParser$();
    }

    public int footerLength() {
        return this.footerLength;
    }

    public Seq<Object> footerMagic() {
        return this.footerMagic;
    }

    public int blockTrailerLen() {
        return this.blockTrailerLen;
    }

    public int COMPRESSION_BLOCK_TYPE_NONE() {
        return this.COMPRESSION_BLOCK_TYPE_NONE;
    }

    public int COMPRESSION_BLOCK_TYPE_SNAPPY() {
        return this.COMPRESSION_BLOCK_TYPE_SNAPPY;
    }

    public byte[] INDEX_TYPE_KEY() {
        return this.INDEX_TYPE_KEY;
    }

    public int INDEX_TYPE_TWO_LEVEL() {
        return this.INDEX_TYPE_TWO_LEVEL;
    }

    public void update(Checksum checksum, byte[] buf, int offset, int length) {
        checksum.update((byte[])Predef$.MODULE$.wrapByteArray(buf).array(), offset, length);
    }

    public void readEnd(Iterator<Object> bytes) {
        if (bytes.hasNext()) {
            throw new BadFileFormatException("Input too long", BadFileFormatException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void readMagic(Iterator<Object> bytes) {
        byte[] magic = (byte[])bytes.take(this.footerMagic().length()).toArray(ClassTag$.MODULE$.Byte());
        boolean isMatch = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(magic)).zip(this.footerMagic(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BlockParser$.$anonfun$readMagic$1(x0$1))))).isEmpty();
        if (!isMatch) {
            throw new BadFileFormatException(new StringBuilder(10).append("Bad magic ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(magic)).map((Function1 & Serializable & scala.Serializable)x$2 -> BlockParser$.$anonfun$readMagic$2(BoxesRunTime.unboxToByte((Object)x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(" ")).toString(), BadFileFormatException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public int readInt32(Iterator<Object> bytes) {
        return (int)((long)(BoxesRunTime.unboxToByte((Object)bytes.next()) & 0xFF) + 256L * ((long)(BoxesRunTime.unboxToByte((Object)bytes.next()) & 0xFF) + 256L * ((long)(BoxesRunTime.unboxToByte((Object)bytes.next()) & 0xFF) + 256L * (long)(BoxesRunTime.unboxToByte((Object)bytes.next()) & 0xFF))));
    }

    public long readUnsignedVarLong(Iterator<Object> bytes) {
        Tuple2 tuple2 = bytes.span((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)BlockParser$.$anonfun$readUnsignedVarLong$1(BoxesRunTime.unboxToByte((Object)b))));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterator continuedBytes = (Iterator)tuple2._1();
        Iterator rest = (Iterator)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)continuedBytes, (Object)rest);
        Tuple2 tuple23 = tuple22;
        Iterator continuedBytes2 = (Iterator)tuple23._1();
        Iterator rest2 = (Iterator)tuple23._2();
        Tuple2 tuple24 = (Tuple2)continuedBytes2.foldLeft((Object)new Tuple2.mcIJ.sp(0, 0L), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BlockParser$.$anonfun$readUnsignedVarLong$2(x0$1, BoxesRunTime.unboxToByte((Object)x1$1)));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        int i = tuple24._1$mcI$sp();
        long v = tuple24._2$mcJ$sp();
        Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(i, v);
        Tuple2.mcIJ.sp sp3 = sp2;
        int i2 = sp3._1$mcI$sp();
        long v2 = sp3._2$mcJ$sp();
        if (i2 > 63) {
            throw new BadFileFormatException("Variable length quantity is too long", BadFileFormatException$.MODULE$.$lessinit$greater$default$2());
        }
        return v2 | (long)BoxesRunTime.unboxToByte((Object)rest2.next()) << i2;
    }

    public long readSignedVarLong(Iterator<Object> bytes) {
        long raw = this.readUnsignedVarLong(bytes);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    public Seq<Object> readBytes(Iterator<Object> bytes, long size) {
        return bytes.take((int)size).toSeq();
    }

    public BlockHandle readBlockHandle(Iterator<Object> bytes) {
        return new BlockHandle(this.readUnsignedVarLong(bytes), this.readUnsignedVarLong(bytes));
    }

    /*
     * WARNING - void declaration
     */
    public IndexBlockHandles readFooter(Iterator<Object> bytes) {
        void var3_3;
        CountedIterator<Object> countedBytes = new CountedIterator<Object>(bytes);
        IndexBlockHandles ret = new IndexBlockHandles(this.readBlockHandle(countedBytes), this.readBlockHandle(countedBytes));
        int skip = this.footerLength() - countedBytes.count() - this.footerMagic().length();
        if (skip < 0) {
            throw new BadFileFormatException("[I] Footer overflow (bad varint parser?)", BadFileFormatException$.MODULE$.$lessinit$greater$default$2());
        }
        Iterator after = bytes.drop(skip);
        this.readMagic((Iterator<Object>)after);
        return var3_3;
    }

    public int readFixedInt(Iterator<Object> bytes) {
        return (BoxesRunTime.unboxToByte((Object)bytes.next()) & 0xFF) + 256 * ((BoxesRunTime.unboxToByte((Object)bytes.next()) & 0xFF) + 256 * ((BoxesRunTime.unboxToByte((Object)bytes.next()) & 0xFF) + 256 * (BoxesRunTime.unboxToByte((Object)bytes.next()) & 0xFF)));
    }

    public int fixupCRC(int crc) {
        return (crc >>> 15 | crc << 17) + -1568478504;
    }

    public IndexedBytes startBlockParse(IndexedBytes block) {
        IndexedBytes indexedBytes;
        PureJavaCrc32C crc = new PureJavaCrc32C();
        this.update((Checksum)crc, block.bytes(), block.from(), block.size() - this.blockTrailerLen() + 1);
        int computedCRC = this.fixupCRC((int)crc.getValue());
        int expectedCRC = this.readFixedInt(block.slice(block.size() - this.blockTrailerLen() + 1, block.size()).iterator());
        if (computedCRC != expectedCRC) {
            throw new BadFileFormatException(new StringOps(Predef$.MODULE$.augmentString("Bad CRC got %08x != stored %08x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)computedCRC), BoxesRunTime.boxToInteger((int)expectedCRC)})), BadFileFormatException$.MODULE$.$lessinit$greater$default$2());
        }
        byte compressionType = block.apply(block.size() - this.blockTrailerLen());
        IndexedBytes data = block.slice(0, block.size() - this.blockTrailerLen());
        byte by = compressionType;
        if (this.COMPRESSION_BLOCK_TYPE_NONE() == by) {
            indexedBytes = data;
        } else if (this.COMPRESSION_BLOCK_TYPE_SNAPPY() == by) {
            IndexedBytes indexedBytes2;
            byte[] dataBytes = data.bytes();
            try {
                int uncompressedLength = Snappy.uncompressedLength((byte[])dataBytes, (int)data.from(), (int)data.size());
                byte[] uncompressed = new byte[uncompressedLength];
                Snappy.uncompress((byte[])dataBytes, (int)data.from(), (int)data.size(), (byte[])uncompressed, (int)0);
                indexedBytes2 = IndexedBytes$.MODULE$.create(uncompressed);
            }
            catch (IOException e) {
                throw new BadFileFormatException("Bad Snappy-compressed data", e);
            }
            indexedBytes = indexedBytes2;
        } else {
            throw new BadFileFormatException(new StringBuilder(25).append("Unknown compression type ").append(compressionType).toString(), BadFileFormatException$.MODULE$.$lessinit$greater$default$2());
        }
        return indexedBytes;
    }

    public DataBlockIterator parseDataBlock(IndexedBytes block) {
        int numRestarts = this.readInt32(block.slice(block.size() - 4, block.size()).iterator());
        IndexedBytes blockWithoutTrailer = block.slice(0, block.size() - 4 * (numRestarts + 1));
        return new DataBlockIterator(blockWithoutTrailer.iterator());
    }

    public Map<Seq<Object>, byte[]> readProperties(BlockReadable file, IndexBlockHandles footer) {
        IndexedBytes bytes = file.readBlock(footer.metaIndex().offset(), footer.metaIndex().size() + (long)this.blockTrailerLen());
        IndexedBytes block = this.startBlockParse(bytes);
        Map<Seq<Object>, byte[]> metaIndex = this.parseDataBlock(block).toMap();
        Iterator propBHIt = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])metaIndex.apply((Object)Predef$.MODULE$.wrapByteArray("rocksdb.properties".getBytes())))).iterator();
        BlockHandle propBH = this.readBlockHandle((Iterator<Object>)propBHIt);
        this.readEnd((Iterator<Object>)propBHIt);
        IndexedBytes bytes2 = file.readBlock(propBH.offset(), propBH.size() + (long)this.blockTrailerLen());
        IndexedBytes block2 = this.startBlockParse(bytes2);
        return this.parseDataBlock(block2).toMap();
    }

    public Iterator<Entry> entryIterator(BlockReadable in) {
        if (in.length() < (long)this.footerLength()) {
            throw new BadFileFormatException(new StringBuilder(51).append("Block of length ").append(in.length()).append(" too short: not enough footer bytes").toString(), BadFileFormatException$.MODULE$.$lessinit$greater$default$2());
        }
        Iterator<Object> bytes = in.iterate(in.length() - (long)this.footerLength(), this.footerLength());
        IndexBlockHandles footer = this.readFooter(bytes);
        this.readEnd(bytes);
        Map<Seq<Object>, byte[]> props = this.readProperties(in, footer);
        Iterator typeIt = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])props.apply((Object)Predef$.MODULE$.wrapByteArray(this.INDEX_TYPE_KEY())))).iterator();
        int typ = this.readFixedInt((Iterator<Object>)typeIt);
        this.readEnd((Iterator<Object>)typeIt);
        int blockIndexType = typ;
        IndexedBytes bytes2 = in.readBlock(footer.index().offset(), footer.index().size() + (long)this.blockTrailerLen());
        IndexedBytes block = this.startBlockParse(bytes2);
        Iterator indexIt = this.parseDataBlock(block);
        Iterator index2It = blockIndexType == this.INDEX_TYPE_TWO_LEVEL() ? indexIt.flatMap((Function1 & Serializable & scala.Serializable)data -> {
            Iterator it = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data.value())).iterator();
            BlockHandle bh = MODULE$.readBlockHandle((Iterator<Object>)it);
            MODULE$.readEnd((Iterator<Object>)it);
            IndexedBytes bytes = in.readBlock(bh.offset(), bh.size() + (long)MODULE$.blockTrailerLen());
            IndexedBytes block = MODULE$.startBlockParse(bytes);
            return MODULE$.parseDataBlock(block);
        }) : indexIt;
        Iterator entryIt = index2It.flatMap((Function1 & Serializable & scala.Serializable)data -> {
            Iterator it = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data.value())).iterator();
            BlockHandle bh = MODULE$.readBlockHandle((Iterator<Object>)it);
            MODULE$.readEnd((Iterator<Object>)it);
            IndexedBytes bytes = in.readBlock(bh.offset(), bh.size() + (long)MODULE$.blockTrailerLen());
            IndexedBytes block = MODULE$.startBlockParse(bytes);
            return MODULE$.parseDataBlock(block);
        });
        return entryIt.map((Function1 & Serializable & scala.Serializable)entry -> MODULE$.stripInternalKey((Entry)entry));
    }

    private Entry stripInternalKey(Entry entry) {
        return new Entry((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(entry.key())).slice(0, entry.key().length - 8), entry.value());
    }

    public static final /* synthetic */ byte $anonfun$footerMagic$1(int x$1) {
        return (byte)x$1;
    }

    public static final /* synthetic */ boolean $anonfun$readMagic$1(Tuple2 x0$1) {
        byte b;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte a = BoxesRunTime.unboxToByte((Object)tuple2._1());
        boolean bl = a != (b = BoxesRunTime.unboxToByte((Object)tuple2._2()));
        return bl;
    }

    public static final /* synthetic */ String $anonfun$readMagic$2(byte x$2) {
        return new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$2)}));
    }

    public static final /* synthetic */ boolean $anonfun$readUnsignedVarLong$1(byte b) {
        return ((long)b & 0x80L) != 0L;
    }

    public static final /* synthetic */ Tuple2 $anonfun$readUnsignedVarLong$2(Tuple2 x0$1, byte x1$1) {
        byte b;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToByte((byte)x1$1));
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                b = BoxesRunTime.unboxToByte((Object)tuple22._2());
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        int i = tuple2._1$mcI$sp();
        long v = tuple2._2$mcJ$sp();
        Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(i + 7, v | (long)(b & 0x7F) << i);
        return sp2;
    }

    private BlockParser$() {
        MODULE$ = this;
        this.footerLength = 52;
        this.footerMagic = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{247, 207, 244, 133, 183, 65, 226, 136}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)BlockParser$.$anonfun$footerMagic$1(BoxesRunTime.unboxToInt((Object)x$1))), Seq$.MODULE$.canBuildFrom());
        this.blockTrailerLen = 5;
        this.COMPRESSION_BLOCK_TYPE_NONE = 0;
        this.COMPRESSION_BLOCK_TYPE_SNAPPY = 1;
        this.INDEX_TYPE_KEY = "rocksdb.block.based.table.index.type".getBytes();
        this.INDEX_TYPE_TWO_LEVEL = 2;
    }
}

