/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import io.treeverse.clients.ApiClient$;
import io.treeverse.clients.HadoopUtils$;
import io.treeverse.clients.StorageUtils$;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.tools.DistCp;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;

public final class GCBackupAndRestore$ {
    public static GCBackupAndRestore$ MODULE$;
    private SparkSession spark;
    private final String S3AccessKeyName;
    private final String S3SecretKeyName;
    private final String AzureStorageAccountKeyName;
    private volatile boolean bitmap$0;

    static {
        new GCBackupAndRestore$();
    }

    public String S3AccessKeyName() {
        return this.S3AccessKeyName;
    }

    public String S3SecretKeyName() {
        return this.S3SecretKeyName;
    }

    public String AzureStorageAccountKeyName() {
        return this.AzureStorageAccountKeyName;
    }

    private SparkSession spark$lzycompute() {
        GCBackupAndRestore$ gCBackupAndRestore$ = this;
        synchronized (gCBackupAndRestore$) {
            if (!this.bitmap$0) {
                this.spark = SparkSession$.MODULE$.builder().appName("GCBackupAndRestore").getOrCreate();
                this.bitmap$0 = true;
            }
        }
        return this.spark;
    }

    public SparkSession spark() {
        return !this.bitmap$0 ? this.spark$lzycompute() : this.spark;
    }

    public Dataset<String> constructAbsoluteObjectPaths(Dataset<Row> objectsRelativePathsDF, String srcNamespace, String storageType) {
        ObjectRef storageNSForFS;
        block0: {
            storageNSForFS = ObjectRef.create((Object)ApiClient$.MODULE$.translateURI(URI.create(srcNamespace), storageType).normalize().toString());
            if (((String)storageNSForFS.elem).endsWith("/")) break block0;
            storageNSForFS.elem = new StringBuilder(1).append((String)storageNSForFS.elem).append("/").toString();
        }
        return objectsRelativePathsDF.select("address", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(this.spark().implicits().newStringEncoder()).flatMap((Function1 & Serializable & scala.Serializable)x -> StorageUtils$.MODULE$.concatKeysToStorageNamespace((Seq<String>)((Seq)new .colon.colon(x, (List)Nil$.MODULE$)), (String)storageNSForFS$1.elem, storageType), this.spark().implicits().newStringEncoder());
    }

    public Tuple2<String, String>[] validateAndParseHadoopConfig(Configuration hc, String storageType) {
        Tuple2<String, String>[] tuple2Array;
        String string = storageType;
        String string2 = StorageUtils$.MODULE$.StorageTypeS3();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            Tuple2<String, String>[] hadoopProps = HadoopUtils$.MODULE$.getHadoopConfigurationValues(hc, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.S3AccessKeyName(), this.S3SecretKeyName()}));
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hadoopProps)).iterator().filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)GCBackupAndRestore$.$anonfun$validateAndParseHadoopConfig$1(x))).length() != 1) {
                Console$.MODULE$.err().println(new StringBuilder(34).append("missing required hadoop property. ").append(this.S3AccessKeyName()).toString());
                System.exit(1);
            }
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hadoopProps)).iterator().filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)GCBackupAndRestore$.$anonfun$validateAndParseHadoopConfig$2(x))).length() != 1) {
                Console$.MODULE$.err().println(new StringBuilder(34).append("missing required hadoop property. ").append(this.S3SecretKeyName()).toString());
                System.exit(1);
            }
            tuple2Array = hadoopProps;
        } else {
            String string4 = StorageUtils$.MODULE$.StorageTypeAzure();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                Tuple2<String, String>[] hadoopProps = HadoopUtils$.MODULE$.getHadoopConfigurationValues(hc, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.AzureStorageAccountKeyName()}));
                if (hadoopProps == null || hadoopProps.length != 1) {
                    Console$.MODULE$.err().println(new StringBuilder(34).append("missing required hadoop property. ").append(this.AzureStorageAccountKeyName()).toString());
                    System.exit(1);
                }
                tuple2Array = hadoopProps;
            } else {
                throw new MatchError((Object)string);
            }
        }
        return tuple2Array;
    }

    public String[] constructDistCpCommand(Tuple2<String, String>[] hadoopProps, String absoluteAddressesTextFilePath, String dstNamespaceForHadoopFs) {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hadoopProps)).map((Function1 & Serializable & scala.Serializable)prop -> new StringBuilder(3).append("-D").append(prop._1()).append("=").append(prop._2()).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new .colon.colon((Object)"-f", (List)new .colon.colon((Object)absoluteAddressesTextFilePath, (List)new .colon.colon((Object)dstNamespaceForHadoopFs, (List)Nil$.MODULE$))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public String getTextFileLocation(String prefix, Configuration hc) {
        FileSystem fs = FileSystem.get((URI)URI.create(prefix), (Configuration)hc);
        RemoteIterator dirIterator = fs.listFiles(new Path(prefix), false);
        ObjectRef textFilePath = ObjectRef.create((Object)"");
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            while (dirIterator.hasNext()) {
                LocatedFileStatus curFile = (LocatedFileStatus)dirIterator.next();
                String curPath = curFile.getPath().toString();
                if (!curPath.endsWith("txt")) continue;
                textFilePath$1.elem = curPath;
                throw Breaks$.MODULE$.break();
            }
        });
        return (String)textFilePath.elem;
    }

    public void main(String[] args) {
        if (args.length != 4) {
            Console$.MODULE$.err().println("Usage: ... <objects list location> <src namespace> <dst namespace> <storage type>");
            System.exit(1);
        }
        String relativeAddressesLocation = args[0];
        String srcNamespace = args[1];
        String dstNamespace = args[2];
        String storageType = args[3];
        Configuration hc = this.spark().sparkContext().hadoopConfiguration();
        Tuple2<String, String>[] hadoopProps = this.validateAndParseHadoopConfig(hc, storageType);
        String relativeAddressesLocationForHadoopFs = ApiClient$.MODULE$.translateURI(URI.create(relativeAddressesLocation), storageType).toString();
        String dstNamespaceForHadoopFs = ApiClient$.MODULE$.translateURI(URI.create(dstNamespace), storageType).toString();
        Predef$.MODULE$.print((Object)new StringBuilder(26).append("translated dstNamespace: ").append(dstNamespaceForHadoopFs).append("\n").toString());
        Dataset objectsRelativePathsDF = this.spark().read().parquet(relativeAddressesLocationForHadoopFs);
        Dataset<String> objectsAbsolutePathsDF = this.constructAbsoluteObjectPaths((Dataset<Row>)objectsRelativePathsDF, srcNamespace, storageType);
        String absoluteAddressesLocation = new StringBuilder(39).append(dstNamespaceForHadoopFs).append("/_gc-backup-restore/absolute_addresses/").toString();
        Predef$.MODULE$.print((Object)new StringBuilder(28).append("absoluteAddressesLocation: ").append(absoluteAddressesLocation).append("\n").toString());
        objectsAbsolutePathsDF.repartition(1).write().text(absoluteAddressesLocation);
        String absoluteAddressesTextFilePath = this.getTextFileLocation(absoluteAddressesLocation, hc);
        Predef$.MODULE$.print((Object)new StringBuilder(14).append("txtFilePath: ").append(absoluteAddressesTextFilePath).append("\n").toString());
        String[] distCpCommand = this.constructDistCpCommand(hadoopProps, absoluteAddressesTextFilePath, dstNamespaceForHadoopFs);
        DistCp.main((String[])distCpCommand);
    }

    public static final /* synthetic */ boolean $anonfun$validateAndParseHadoopConfig$1(Tuple2 x) {
        return MODULE$.S3AccessKeyName().equals(x._1());
    }

    public static final /* synthetic */ boolean $anonfun$validateAndParseHadoopConfig$2(Tuple2 x) {
        return MODULE$.S3SecretKeyName().equals(x._1());
    }

    private GCBackupAndRestore$() {
        MODULE$ = this;
        this.S3AccessKeyName = "fs.s3a.access.key";
        this.S3SecretKeyName = "fs.s3a.secret.key";
        this.AzureStorageAccountKeyName = "fs.azure.account.key";
    }
}

