/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.azure.core.http.HttpClient;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.batch.BlobBatchClient;
import com.azure.storage.blob.batch.BlobBatchClientBuilder;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.policy.RequestRetryOptions;
import io.treeverse.clients.BulkRemover;
import io.treeverse.clients.BulkRemoverFactory$;
import io.treeverse.clients.StorageUtils$AzureBlob$;
import io.treeverse.clients.StorageUtils$S3$;
import io.treeverse.clients.conditional.S3ClientBuilder$;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015u!B\u0011#\u0011\u0003Ic!B\u0016#\u0011\u0003a\u0003\"B\u001a\u0002\t\u0003!d\u0001B\u001b\u0002\tYB\u0001BO\u0002\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u000f\u000e\u0011\t\u0011)A\u0005\u0011\"A1k\u0001B\u0001B\u0003%\u0001\nC\u00034\u0007\u0011\u0005A\u000bC\u0004[\u0007\t\u0007I\u0011A.\t\r\u0011\u001c\u0001\u0015!\u0003]\u0011\u001d)7A1A\u0005\u0002\u0019Da\u0001\\\u0002!\u0002\u00139\u0007\"B7\u0004\t\u0003r\u0007\"B>\u0004\t\u0013a\bbBA\u0012\u0007\u0011\u0005\u0013Q\u0005\u0005\b\u0003W\u0019A\u0011IA\u0017\r\u0019\ty#\u0001\u0003\u00022!A!\b\u0005B\u0001B\u0003%1\b\u0003\u0005H!\t\u0005\t\u0015!\u0003I\u0011\u0019\u0019\u0004\u0003\"\u0001\u00024!A\u00111\b\tC\u0002\u0013\u0005a\rC\u0004\u0002>A\u0001\u000b\u0011B4\t\u000fi\u0003\"\u0019!C\u00017\"1A\r\u0005Q\u0001\nqC\u0011\"a\u0010\u0011\u0005\u0004%\t!!\u0011\t\u000f\u0005\r\u0003\u0003)A\u0005\u0011\"I\u0011Q\t\tC\u0002\u0013\u0005\u0011\u0011\t\u0005\b\u0003\u000f\u0002\u0002\u0015!\u0003I\u0011\u0019i\u0007\u0003\"\u0011\u0002J!9\u0011q\n\t\u0005\n\u0005E\u0003bBA\u0012!\u0011\u0005\u0013\u0011\u000f\u0005\b\u0003W\u0001B\u0011IA\u0017\u0011\u001d\t9(\u0001C\u0001\u0003s\n!CQ;mWJ+Wn\u001c<fe\u001a\u000b7\r^8ss*\u00111\u0005J\u0001\bG2LWM\u001c;t\u0015\t)c%A\u0005ue\u0016,g/\u001a:tK*\tq%\u0001\u0002j_\u000e\u0001\u0001C\u0001\u0016\u0002\u001b\u0005\u0011#A\u0005\"vY.\u0014V-\\8wKJ4\u0015m\u0019;pef\u001c\"!A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011FA\u0007Tg\t+Hn\u001b*f[>4XM]\n\u0004\u00075:\u0004C\u0001\u00169\u0013\tI$EA\u0006Ck2\\'+Z7pm\u0016\u0014\u0018A\u00015d!\taT)D\u0001>\u0015\tqt(\u0001\u0003d_:4'B\u0001!B\u0003\u0019A\u0017\rZ8pa*\u0011!iQ\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\u000b1a\u001c:h\u0013\t1UHA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0011gR|'/Y4f\u001d\u0006lWm\u001d9bG\u0016\u0004\"!\u0013)\u000f\u0005)s\u0005CA&0\u001b\u0005a%BA')\u0003\u0019a$o\\8u}%\u0011qjL\u0001\u0007!J,G-\u001a4\n\u0005E\u0013&AB*ue&twM\u0003\u0002P_\u00051!/Z4j_:$B!V,Y3B\u0011akA\u0007\u0002\u0003!)!h\u0002a\u0001w!)qi\u0002a\u0001\u0011\")1k\u0002a\u0001\u0011\u0006\u0019QO]5\u0016\u0003q\u0003\"!\u00182\u000e\u0003yS!a\u00181\u0002\u00079,GOC\u0001b\u0003\u0011Q\u0017M^1\n\u0005\rt&aA+S\u0013\u0006!QO]5!\u0003\u0019\u0011WoY6fiV\tq\r\u0005\u0002iW6\t\u0011N\u0003\u0002kA\u0006!A.\u00198h\u0013\t\t\u0016.A\u0004ck\u000e\\W\r\u001e\u0011\u0002\u001b\u0011,G.\u001a;f\u001f\nTWm\u0019;t)\ry\u0007P\u001f\t\u0004aVDeBA9t\u001d\tY%/C\u00011\u0013\t!x&A\u0004qC\u000e\\\u0017mZ3\n\u0005Y<(aA*fc*\u0011Ao\f\u0005\u0006s2\u0001\ra\\\u0001\u0005W\u0016L8\u000fC\u0003H\u0019\u0001\u0007\u0001*A\u0006hKR\u001c6g\u00117jK:$H#C?\u0002\u0014\u0005U\u0011qCA\r!\rq\u0018qB\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\t\u00198G\u0003\u0003\u0002\u0006\u0005\u001d\u0011\u0001C:feZL7-Z:\u000b\t\u0005%\u00111B\u0001\nC6\f'p\u001c8boNT!!!\u0004\u0002\u0007\r|W.C\u0002\u0002\u0012}\u0014\u0001\"Q7bu>t7k\r\u0005\u0006u5\u0001\ra\u000f\u0005\u0006K6\u0001\r\u0001\u0013\u0005\u0006'6\u0001\r\u0001\u0013\u0005\b\u00037i\u0001\u0019AA\u000f\u0003)qW/\u001c*fiJLWm\u001d\t\u0004]\u0005}\u0011bAA\u0011_\t\u0019\u0011J\u001c;\u0002/\r|gn\u001d;sk\u000e$(+Z7pm\u0016\\U-\u001f(b[\u0016\u001cH#B8\u0002(\u0005%\u0002\"B=\u000f\u0001\u0004y\u0007\"B$\u000f\u0001\u0004A\u0015AD4fi6\u000b\u0007PQ;mWNK'0\u001a\u000b\u0003\u0003;\u0011A#\u0011>ve\u0016\u0014En\u001c2Ck2\\'+Z7pm\u0016\u00148c\u0001\t.oQ1\u0011QGA\u001c\u0003s\u0001\"A\u0016\t\t\u000bi\u001a\u0002\u0019A\u001e\t\u000b\u001d\u001b\u0002\u0019\u0001%\u0002\u0017\u0015k\u0007\u000f^=TiJLgnZ\u0001\r\u000b6\u0004H/_*ue&tw\rI\u0001\u0012gR|'/Y4f\u0003\u000e\u001cw.\u001e8u+JdW#\u0001%\u0002%M$xN]1hK\u0006\u001b7m\\;oiV\u0013H\u000eI\u0001\u0013gR|'/Y4f\u0003\u000e\u001cw.\u001e8u\u001d\u0006lW-A\nti>\u0014\u0018mZ3BG\u000e|WO\u001c;OC6,\u0007\u0005F\u0003p\u0003\u0017\ni\u0005C\u0003z9\u0001\u0007q\u000eC\u0003H9\u0001\u0007\u0001*\u0001\nhKR\u0014En\u001c2CCR\u001c\u0007n\u00117jK:$H\u0003CA*\u0003W\ni'a\u001c\u0011\t\u0005U\u0013qM\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005)!-\u0019;dQ*!\u0011QLA0\u0003\u0011\u0011Gn\u001c2\u000b\t\u0005\u0005\u00141M\u0001\bgR|'/Y4f\u0015\u0011\t)'a\u0003\u0002\u000b\u0005TXO]3\n\t\u0005%\u0014q\u000b\u0002\u0010\u00052|'MQ1uG\"\u001cE.[3oi\")!(\ba\u0001w!1\u0011qH\u000fA\u0002!Ca!!\u0012\u001e\u0001\u0004AE#B8\u0002t\u0005U\u0004\"B=\u001f\u0001\u0004y\u0007\"B$\u001f\u0001\u0004A\u0015!B1qa2LH#C\u001c\u0002|\u0005}\u0014\u0011QAB\u0011\u0019\ti\b\ta\u0001\u0011\u0006Y1\u000f^8sC\u001e,G+\u001f9f\u0011\u0015Q\u0004\u00051\u0001<\u0011\u00159\u0005\u00051\u0001I\u0011\u0015\u0019\u0006\u00051\u0001I\u0001")
public final class BulkRemoverFactory {
    public static BulkRemover apply(String string, Configuration configuration, String string2, String string3) {
        return BulkRemoverFactory$.MODULE$.apply(string, configuration, string2, string3);
    }

    public static class AzureBlobBulkRemover
    implements BulkRemover {
        private final Configuration hc;
        private final String EmptyString;
        private final URI uri;
        private final String storageAccountUrl;
        private final String storageAccountName;

        public String EmptyString() {
            return this.EmptyString;
        }

        public URI uri() {
            return this.uri;
        }

        public String storageAccountUrl() {
            return this.storageAccountUrl;
        }

        public String storageAccountName() {
            return this.storageAccountName;
        }

        @Override
        public Seq<String> deleteObjects(Seq<String> keys, String storageNamespace) {
            Seq seq;
            Seq<String> removeKeyNames = this.constructRemoveKeyNames(keys, storageNamespace);
            Predef$.MODULE$.println((Object)new Tuple2((Object)"Remove keys:", (Object)((TraversableOnce)removeKeyNames.take(100)).mkString(", ")));
            List removeKeys = (List)JavaConverters$.MODULE$.seqAsJavaListConverter(removeKeyNames).asJava();
            BlobBatchClient blobBatchClient = this.getBlobBatchClient(this.hc, this.storageAccountUrl(), this.storageAccountName());
            Function<Response<Void>, URI> extractUrlIfBlobDeleted = new Function<Response<Void>, URI>(this){
                private final /* synthetic */ AzureBlobBulkRemover $outer;

                public <V> Function<V, URI> compose(Function<? super V, ? extends Response<Void>> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<Response<Void>, V> andThen(Function<? super URI, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public URI apply(Response<Void> response) {
                    Object object = response.getStatusCode() == 200 ? response.getRequest().getUrl() : BoxedUnit.UNIT;
                    return new URI(this.$outer.EmptyString());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            Function<URI, String> uriToString = new Function<URI, String>(null){

                public <V> Function<V, String> compose(Function<? super V, ? extends URI> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<URI, V> andThen(Function<? super String, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public String apply(URI uri) {
                    return uri.toString();
                }
            };
            Predicate<String> isNonEmptyString = new Predicate<String>(this){
                private final /* synthetic */ AzureBlobBulkRemover $outer;

                public Predicate<String> and(Predicate<? super String> x$1) {
                    return Predicate.super.and(x$1);
                }

                public Predicate<String> negate() {
                    return Predicate.super.negate();
                }

                public Predicate<String> or(Predicate<? super String> x$1) {
                    return Predicate.super.or(x$1);
                }

                public boolean test(String s) {
                    return !this.$outer.EmptyString().equals(s);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            try {
                PagedIterable responses = blobBatchClient.deleteBlobs(removeKeys, DeleteSnapshotsOptionType.INCLUDE);
                seq = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(responses.stream().map(extractUrlIfBlobDeleted).map(uriToString).filter(isNonEmptyString).collect(Collectors.toList())).asScala()).toSeq();
            }
            catch (Throwable e) {
                e.printStackTrace();
                seq = (Seq)Nil$.MODULE$;
            }
            return seq;
        }

        private BlobBatchClient getBlobBatchClient(Configuration hc, String storageAccountUrl, String storageAccountName) {
            String storageAccountKeyPropName = StorageUtils$AzureBlob$.MODULE$.StorageAccountKeyPropertyPattern().replaceFirst(StorageUtils$AzureBlob$.MODULE$.StorageAccNamePlaceHolder(), storageAccountName);
            String storageAccountKey = hc.get(storageAccountKeyPropName);
            BlobServiceClient blobServiceClientSharedKey = new BlobServiceClientBuilder().endpoint(storageAccountUrl).credential(new StorageSharedKeyCredential(storageAccountName, storageAccountKey)).retryOptions(new RequestRetryOptions()).httpClient(HttpClient.createDefault()).buildClient();
            return new BlobBatchClientBuilder(blobServiceClientSharedKey).buildClient();
        }

        @Override
        public Seq<String> constructRemoveKeyNames(Seq<String> keys, String storageNamespace) {
            String addSuffixSlash;
            Predef$.MODULE$.println((Object)new StringBuilder(18).append("storageNamespace: ").append(storageNamespace).toString());
            String string = addSuffixSlash = storageNamespace.endsWith("/") ? storageNamespace : storageNamespace.concat("/");
            if (keys.isEmpty()) {
                return (Seq)Nil$.MODULE$;
            }
            return (Seq)((TraversableLike)((TraversableLike)keys.map((Function1 & Serializable & scala.Serializable)x -> addSuffixSlash.concat((String)x), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> x.getBytes(Charset.forName("UTF-8")), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> new String((byte[])x), Seq$.MODULE$.canBuildFrom());
        }

        @Override
        public int getMaxBulkSize() {
            return StorageUtils$AzureBlob$.MODULE$.AzureBlobMaxBulkSize();
        }

        public AzureBlobBulkRemover(Configuration hc, String storageNamespace) {
            this.hc = hc;
            this.EmptyString = "";
            this.uri = new URI(storageNamespace);
            this.storageAccountUrl = StorageUtils$AzureBlob$.MODULE$.uriToStorageAccountUrl(this.uri());
            this.storageAccountName = StorageUtils$AzureBlob$.MODULE$.uriToStorageAccountName(this.uri());
        }
    }

    public static class S3BulkRemover
    implements BulkRemover {
        private final Configuration hc;
        private final String region;
        private final URI uri;
        private final String bucket;

        public URI uri() {
            return this.uri;
        }

        public String bucket() {
            return this.bucket;
        }

        @Override
        public Seq<String> deleteObjects(Seq<String> keys, String storageNamespace) {
            Seq<String> removeKeyNames = this.constructRemoveKeyNames(keys, storageNamespace);
            Predef$.MODULE$.println((Object)new Tuple2((Object)"Remove keys:", (Object)((TraversableOnce)removeKeyNames.take(100)).mkString(", ")));
            List removeKeys = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)removeKeyNames.map((Function1 & Serializable & scala.Serializable)k -> new DeleteObjectsRequest.KeyVersion(k), Seq$.MODULE$.canBuildFrom())).asJava();
            DeleteObjectsRequest delObjReq = new DeleteObjectsRequest(this.bucket()).withKeys(removeKeys);
            AmazonS3 s3Client = this.getS3Client(this.hc, this.bucket(), this.region, StorageUtils$S3$.MODULE$.S3NumRetries());
            DeleteObjectsResult res = s3Client.deleteObjects(delObjReq);
            return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res.getDeletedObjects()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getKey(), Buffer$.MODULE$.canBuildFrom());
        }

        private AmazonS3 getS3Client(Configuration hc, String bucket, String region, int numRetries) {
            return S3ClientBuilder$.MODULE$.build(hc, bucket, region, numRetries);
        }

        @Override
        public Seq<String> constructRemoveKeyNames(Seq<String> keys, String storageNamespace) {
            String snPrefix;
            Predef$.MODULE$.println((Object)new StringBuilder(18).append("storageNamespace: ").append(storageNamespace).toString());
            URI uri = new URI(storageNamespace);
            String key = uri.getPath();
            String addSuffixSlash = key.endsWith("/") ? key : key.concat("/");
            String string = snPrefix = addSuffixSlash.startsWith("/") ? addSuffixSlash.substring(1) : addSuffixSlash;
            if (keys.isEmpty()) {
                return (Seq)Nil$.MODULE$;
            }
            return (Seq)keys.map((Function1 & Serializable & scala.Serializable)x -> snPrefix.concat((String)x), Seq$.MODULE$.canBuildFrom());
        }

        @Override
        public int getMaxBulkSize() {
            return StorageUtils$S3$.MODULE$.S3MaxBulkSize();
        }

        public S3BulkRemover(Configuration hc, String storageNamespace, String region) {
            this.hc = hc;
            this.region = region;
            this.uri = new URI(storageNamespace);
            this.bucket = this.uri().getHost();
        }
    }
}

