/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.treeverse.clients.APIConfigurations;
import io.treeverse.clients.ApiClient;
import io.treeverse.clients.StorageUtils$;
import io.treeverse.clients.StorageUtils$AzureBlob$;
import java.net.URI;
import java.util.concurrent.Callable;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.SeqLike;

public final class ApiClient$ {
    public static ApiClient$ MODULE$;
    private final int NUM_CACHED_API_CLIENTS;
    private final int TIMEOUT_NOT_SET;
    private final Cache<ApiClient.ClientKey, ApiClient> clients;

    static {
        new ApiClient$();
    }

    public int NUM_CACHED_API_CLIENTS() {
        return this.NUM_CACHED_API_CLIENTS;
    }

    public int TIMEOUT_NOT_SET() {
        return this.TIMEOUT_NOT_SET;
    }

    public Cache<ApiClient.ClientKey, ApiClient> clients() {
        return this.clients;
    }

    public ApiClient get(APIConfigurations conf) {
        return (ApiClient)this.clients().get((Object)new ApiClient.ClientKey(conf.apiUrl(), conf.accessKey()), (Callable)new Callable<ApiClient>(conf){
            private final APIConfigurations conf$1;

            public ApiClient call() {
                return new ApiClient(new APIConfigurations(this.conf$1.apiUrl(), this.conf$1.accessKey(), this.conf$1.secretKey(), this.conf$1.connectionTimeoutSec(), this.conf$1.readTimeoutSec()));
            }
            {
                this.conf$1 = conf$1;
            }
        });
    }

    public URI translateURI(URI uri, String storageType) {
        String string = storageType;
        String string2 = StorageUtils$.MODULE$.StorageTypeS3();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = uri.getScheme();
            String string4 = "s3";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                return new URI("s3a", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
        }
        String string5 = storageType;
        String string6 = StorageUtils$.MODULE$.StorageTypeAzure();
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            String storageAccountName = StorageUtils$AzureBlob$.MODULE$.uriToStorageAccountName(uri);
            String[] stringArray = uri.getPath().split("/", 3);
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(3) != 0) {
                throw new MatchError((Object)stringArray);
            }
            String container = (String)((SeqLike)option.get()).apply(1);
            String blobPath = (String)((SeqLike)option.get()).apply(2);
            Tuple2 tuple2 = new Tuple2((Object)container, (Object)blobPath);
            Tuple2 tuple22 = tuple2;
            String container2 = (String)tuple22._1();
            String blobPath2 = (String)tuple22._2();
            return new URI(new StringBuilder(30).append("abfs://").append(container2).append("@").append(storageAccountName).append(".dfs.core.windows.net/").append(blobPath2).toString());
        }
        return uri;
    }

    private ApiClient$() {
        MODULE$ = this;
        this.NUM_CACHED_API_CLIENTS = 30;
        this.TIMEOUT_NOT_SET = -1;
        this.clients = CacheBuilder.newBuilder().maximumSize((long)this.NUM_CACHED_API_CLIENTS()).build();
    }
}

