/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import io.treeverse.clients.ApiClient;
import io.treeverse.clients.ExportStatus;
import io.treeverse.clients.Exporter$;
import io.treeverse.clients.Handler;
import io.treeverse.clients.KeyFilter;
import io.treeverse.clients.LakeFSContext$;
import io.treeverse.clients.SparkFilter;
import io.treeverse.clients.StorageClientType$;
import io.treeverse.clients.URLResolver$;
import java.io.Serializable;
import java.net.URI;
import java.time.Clock;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.spark.SerializableWritable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Stream;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u000e\u001d\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!Y\u0005A!A!\u0002\u0013\u0001\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u000bA\u0003A\u0011A)\t\u000bA\u0003A\u0011A-\t\u000by\u0003A\u0011A0\t\u000b\u0015\u0004A\u0011\u00014\t\u000f%\u0004!\u0019!C\u0007U\"1Q\u000e\u0001Q\u0001\u000e-DQA\u001c\u0001\u0005\n=Dq!a\u0006\u0001\t\u0003\tI\u0002C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0004\u0002$!A\u00111\u0006\u0001!\u0002\u001b\t)\u0003C\u0004\u0002.\u0001!I!a\f\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>!I\u0011\u0011\n\u0001C\u0002\u00135\u00111\n\u0005\t\u0003#\u0002\u0001\u0015!\u0004\u0002N!9\u00111\u000b\u0001\u0005\n\u0005UsaBA,9!\u0005\u0011\u0011\f\u0004\u00077qA\t!a\u0017\t\rA;B\u0011AA/\u0011%\tyf\u0006b\u0001\n\u000b\t\t\u0007\u0003\u0005\u0002h]\u0001\u000bQBA2\u0005!)\u0005\u0010]8si\u0016\u0014(BA\u000f\u001f\u0003\u001d\u0019G.[3oiNT!a\b\u0011\u0002\u0013Q\u0014X-\u001a<feN,'\"A\u0011\u0002\u0005%|7\u0001A\n\u0003\u0001\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0017!B:qCJ\\\u0007C\u0001\u00175\u001b\u0005i#B\u0001\u00180\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003UAR!!\r\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0014aA8sO&\u0011Q'\f\u0002\r'B\f'o[*fgNLwN\\\u0001\nCBL7\t\\5f]R\u0004\"\u0001O\u001d\u000e\u0003qI!A\u000f\u000f\u0003\u0013\u0005\u0003\u0018n\u00117jK:$\u0018A\u00024jYR,'\u000f\u0005\u00029{%\u0011a\b\b\u0002\n\u0017\u0016Lh)\u001b7uKJ\f\u0001B]3q_:\u000bW.\u001a\t\u0003\u0003\"s!A\u0011$\u0011\u0005\r3S\"\u0001#\u000b\u0005\u0015\u0013\u0013A\u0002\u001fs_>$h(\u0003\u0002HM\u00051\u0001K]3eK\u001aL!!\u0013&\u0003\rM#(/\u001b8h\u0015\t9e%A\u0004egR\u0014vn\u001c;\u0002\u0017A\f'/\u00197mK2L7/\u001c\t\u0003K9K!a\u0014\u0014\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\b%N#VKV,Y!\tA\u0004\u0001C\u0003+\u000f\u0001\u00071\u0006C\u00037\u000f\u0001\u0007q\u0007C\u0003<\u000f\u0001\u0007A\bC\u0003@\u000f\u0001\u0007\u0001\tC\u0003L\u000f\u0001\u0007\u0001\tC\u0003M\u000f\u0001\u0007Q\nF\u0003S5ncV\fC\u0003+\u0011\u0001\u00071\u0006C\u00037\u0011\u0001\u0007q\u0007C\u0003@\u0011\u0001\u0007\u0001\tC\u0003L\u0011\u0001\u0007\u0001)A\nfqB|'\u000f^!mY\u001a\u0013x.\u001c\"sC:\u001c\u0007\u000e\u0006\u0002aGB\u0011Q%Y\u0005\u0003E\u001a\u0012A!\u00168ji\")A-\u0003a\u0001\u0001\u00061!M]1oG\"\f1#\u001a=q_J$\u0018\t\u001c7Ge>l7i\\7nSR$\"\u0001Y4\t\u000b!T\u0001\u0019\u0001!\u0002\u0011\r|W.\\5u\u0013\u0012\u000bq\"\\1y\u0019><w-\u001a3FeJ|'o]\u000b\u0002W>\tA.\b\u0002(!\u0005\u0001R.\u0019=M_\u001e<W\rZ#se>\u00148\u000fI\u0001\u0007Kb\u0004xN\u001d;\u0015\rA\u001cXo^={!\t)\u0013/\u0003\u0002sM\t9!i\\8mK\u0006t\u0007\"\u0002;\u000e\u0001\u0004i\u0015!\u0002:pk:$\u0007\"\u0002<\u000e\u0001\u0004\u0001\u0015A\u00018t\u0011\u0015AX\u00021\u0001A\u0003\r\u0011X\r\u001c\u0005\u0006Q6\u0001\r\u0001\u0011\u0005\u0006w6\u0001\r\u0001`\u0001\nC\u000e$\u0018n\u001c8t\t\u001a\u00032!`A\t\u001d\rq\u0018Q\u0002\b\u0004\u007f\u0006-a\u0002BA\u0001\u0003\u0013qA!a\u0001\u0002\b9\u00191)!\u0002\n\u0003MJ!!\r\u001a\n\u0005)\u0002\u0014B\u0001\u00180\u0013\r\ty!L\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019\"!\u0006\u0003\u0013\u0011\u000bG/\u0019$sC6,'bAA\b[\u0005QQ\r\u001f9peR4%o\\7\u0015\u000b\u0001\fY\"!\b\t\u000b\u0011t\u0001\u0019\u0001!\t\r\u0005}a\u00021\u0001A\u00031\u0001(/\u001a<D_6l\u0017\u000e^%E\u0003)\u0019XoY2fgNl5oZ\u000b\u0003\u0003Ky!!a\n\"\u0005\u0005%\u0012AH#ya>\u0014H\u000fI2p[BdW\r^3eAM,8mY3tg\u001a,H\u000e\\=\"\u0003-\u0019XoY2fgNl5o\u001a\u0011\u0002\u0019\u0005\u001cGo\u00148BGRLwN\\:\u0015\u0013\u0001\f\t$a\r\u00028\u0005e\u0002\"\u0002<\u0012\u0001\u0004\u0001\u0005BBA\u001b#\u0001\u0007\u0001)A\u0002egRDQ\u0001[\tA\u0002\u0001CQa_\tA\u0002q\f\u0001c\u001e:ji\u0016\u001cV/\\7bef4\u0015\u000e\\3\u0015\u000f\u0001\fy$a\u0011\u0002F!1\u0011\u0011\t\nA\u0002A\fqa];dG\u0016\u001c8\u000fC\u0003i%\u0001\u0007\u0001\t\u0003\u0004\u0002HI\u0001\r\u0001Q\u0001\bG>tG/\u001a8u\u0003%\u0001(/\u001a4jq2+g.\u0006\u0002\u0002N=\u0011\u0011qJ\u000f\u0002\u0011\u0005Q\u0001O]3gSbdUM\u001c\u0011\u0002\u0015I\fg\u000e\u001a)sK\u001aL\u0007\u0010F\u0001A\u0003!)\u0005\u0010]8si\u0016\u0014\bC\u0001\u001d\u0018'\t9B\u0005\u0006\u0002\u0002Z\u0005\u0011B-\u001a4bk2$\b+\u0019:bY2,G.[:n+\t\t\u0019g\u0004\u0002\u0002fu\t!\"A\neK\u001a\fW\u000f\u001c;QCJ\fG\u000e\\3mSNl\u0007\u0005")
public class Exporter {
    private final SparkSession spark;
    private final ApiClient apiClient;
    private final KeyFilter filter;
    private final String repoName;
    private final String dstRoot;
    private final int parallelism;

    public static int defaultParallelism() {
        return Exporter$.MODULE$.defaultParallelism();
    }

    public void exportAllFromBranch(String branch) {
        String commitID = this.apiClient.getBranchHEADCommit(this.repoName, branch);
        this.exportAllFromCommit(commitID);
    }

    public void exportAllFromCommit(String commitID) {
        String ns = this.apiClient.getStorageNamespace(this.repoName, StorageClientType$.MODULE$.HadoopFS());
        Dataset<Row> df = LakeFSContext$.MODULE$.newDF(this.spark, this.repoName, commitID);
        String tableName = new StringBuilder(7).append(this.randPrefix()).append("_commit").toString();
        df.createOrReplaceTempView(tableName);
        String dst = this.dstRoot;
        Dataset actionsDF = this.spark.sql(new StringBuilder(32).append("SELECT 'copy' as action, * FROM ").append(tableName).toString());
        this.actOnActions(ns, dst, commitID, (Dataset<Row>)actionsDF);
    }

    private final int maxLoggedErrors() {
        return 10000;
    }

    private boolean export(int round, String ns, String rel, String commitID, Dataset<Row> actionsDF) {
        public final class Io_treeverse_clients_Exporter$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("io.treeverse.clients.ExportStatus").asType().toTypeConstructor();
            }

            public Io_treeverse_clients_Exporter$$typecreator4$1(Exporter $outer) {
            }
        }
        Configuration hadoopConf = this.spark.sparkContext().hadoopConfiguration();
        SerializableWritable serializedConf = new SerializableWritable((Writable)hadoopConf);
        KeyFilter f = this.filter;
        int par = this.parallelism;
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Exporter.class.getClassLoader());
        Dataset errs = actionsDF.mapPartitions((Function1 & Serializable & scala.Serializable)part -> {
            ExecutorService pool = Executors.newFixedThreadPool(par);
            Iterator res = ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pool.invokeAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)part.map((Function1 & Serializable & scala.Serializable)row -> new Handler(f, round, ns, rel, (SerializableWritable<Configuration>)serializedConf, (Row)row)).toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)fut -> (ExportStatus)fut.get(), Buffer$.MODULE$.canBuildFrom())).iterator();
            pool.shutdown();
            return res;
        }, this.spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_treeverse_clients_Exporter$$typecreator4$1(null)))).filter((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)Exporter.$anonfun$export$4(status)));
        if (errs.isEmpty()) {
            return true;
        }
        long count = errs.count();
        this.writeSummaryFile(false, commitID, (String)errs.sample(scala.math.package$.MODULE$.min(1.0, (double)10000 / (double)count)).map((Function1 & Serializable & scala.Serializable)s -> s.msg(), this.spark.implicits().newStringEncoder()).reduce((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> new StringBuilder(1).append((String)x$1).append("\n").append((String)x$2).toString()));
        return false;
    }

    public void exportFrom(String branch, String prevCommitID) {
        String commitID = this.apiClient.getBranchHEADCommit(this.repoName, branch);
        String ns = this.apiClient.getStorageNamespace(this.repoName, StorageClientType$.MODULE$.HadoopFS());
        Dataset<Row> newDF = LakeFSContext$.MODULE$.newDF(this.spark, this.repoName, commitID);
        Dataset<Row> prevDF = LakeFSContext$.MODULE$.newDF(this.spark, this.repoName, prevCommitID);
        String newTableName = new StringBuilder(11).append(this.randPrefix()).append("_new_commit").toString();
        String prevTableName = new StringBuilder(12).append(this.randPrefix()).append("_prev_commit").toString();
        newDF.createOrReplaceTempView(newTableName);
        prevDF.createOrReplaceTempView(prevTableName);
        String dst = this.dstRoot;
        Dataset actionsDF = this.spark.sql(new StringBuilder(552).append("\n    SELECT\n      CASE WHEN nkey is null THEN 'delete' ELSE 'copy' END as action,\n      CASE WHEN nkey is null THEN pkey ELSE nkey END as key,\n      CASE WHEN naddress is null THEN paddress ELSE naddress END as address,\n      CASE WHEN netag is null THEN petag ELSE netag END as etag\n    FROM\n    (SELECT n.key as nkey, n.address as naddress, n.etag as netag,\n      p.key as pkey, p.address as paddress, p.etag as petag\n      FROM ").append(newTableName).append(" n\n      FULL OUTER JOIN ").append(prevTableName).append(" p\n      ON n.key = p.key\n      WHERE n.etag <> p.etag OR n.etag is null or p.etag is null)\n    ").toString());
        this.actOnActions(ns, dst, commitID, (Dataset<Row>)actionsDF);
    }

    private final String successMsg() {
        return "Export completed successfully!";
    }

    private void actOnActions(String ns, String dst, String commitID, Dataset<Row> actionsDF) {
        Object object = new Object();
        try {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.filter.rounds()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                if (!this.export(i, ns, dst, commitID, actionsDF)) {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
            });
            this.writeSummaryFile(true, commitID, "Export completed successfully!");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void writeSummaryFile(boolean success, String commitID, String content) {
        String suffix = success ? "SUCCESS" : "FAILURE";
        String time = DateTimeFormatter.ISO_INSTANT.format(Clock.systemUTC().instant());
        Path dstPath = URLResolver$.MODULE$.resolveURL(new URI(this.dstRoot), new StringBuilder(9).append("EXPORT_").append(commitID).append("_").append(time).append("_").append(suffix).toString());
        FileSystem dstFS = dstPath.getFileSystem(this.spark.sparkContext().hadoopConfiguration());
        FSDataOutputStream stream = dstFS.create(dstPath);
        stream.writeChars(content);
        stream.close();
    }

    private final int prefixLen() {
        return 8;
    }

    private String randPrefix() {
        Stream gen = Random$.MODULE$.alphanumeric().dropWhile((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$3)))));
        return gen.take(8).mkString("");
    }

    public static final /* synthetic */ boolean $anonfun$export$4(ExportStatus status) {
        return !status.success();
    }

    public Exporter(SparkSession spark, ApiClient apiClient, KeyFilter filter, String repoName, String dstRoot, int parallelism) {
        this.spark = spark;
        this.apiClient = apiClient;
        this.filter = filter;
        this.repoName = repoName;
        this.dstRoot = dstRoot;
        this.parallelism = parallelism;
    }

    public Exporter(SparkSession spark, ApiClient apiClient, String repoName, String dstRoot) {
        this(spark, apiClient, new SparkFilter(), repoName, dstRoot, 10);
    }
}

