/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import io.treeverse.clients.ExportStatus;
import io.treeverse.clients.KeyFilter;
import io.treeverse.clients.URLResolver$;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SerializableWritable;
import org.apache.spark.sql.Row;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E4AAC\u0006\u0001%!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011!9\u0004A!A!\u0002\u0013A\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015C\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\u0006=\u0002!\ta\u0018\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006S\u0002!\tA\u001b\u0002\b\u0011\u0006tG\r\\3s\u0015\taQ\"A\u0004dY&,g\u000e^:\u000b\u00059y\u0011!\u0003;sK\u00164XM]:f\u0015\u0005\u0001\u0012AA5p\u0007\u0001\u0019B\u0001A\n\u001cOA\u0011A#G\u0007\u0002+)\u0011acF\u0001\u0005Y\u0006twMC\u0001\u0019\u0003\u0011Q\u0017M^1\n\u0005i)\"AB(cU\u0016\u001cG\u000fE\u0002\u001dC\rj\u0011!\b\u0006\u0003=}\t!bY8oGV\u0014(/\u001a8u\u0015\t\u0001s#\u0001\u0003vi&d\u0017B\u0001\u0012\u001e\u0005!\u0019\u0015\r\u001c7bE2,\u0007C\u0001\u0013&\u001b\u0005Y\u0011B\u0001\u0014\f\u00051)\u0005\u0010]8siN#\u0018\r^;t!\tA#&D\u0001*\u0015\t\u0001r#\u0003\u0002,S\ta1+\u001a:jC2L'0\u00192mK\u00061a-\u001b7uKJ\u0004\"\u0001\n\u0018\n\u0005=Z!!C&fs\u001aKG\u000e^3s\u0003\u0015\u0011x.\u001e8e!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\rIe\u000e^\u0001\u0003]N\u0004\"!\u000f!\u000f\u0005ir\u0004CA\u001e4\u001b\u0005a$BA\u001f\u0012\u0003\u0019a$o\\8u}%\u0011qhM\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@g\u00059!o\\8u\tN$\u0018AD:fe&\fG.\u001b>fI\u000e{gN\u001a\t\u0004\r6{U\"A$\u000b\u0005!K\u0015!B:qCJ\\'B\u0001&L\u0003\u0019\t\u0007/Y2iK*\tA*A\u0002pe\u001eL!AT$\u0003)M+'/[1mSj\f'\r\\3Xe&$\u0018M\u00197f!\t\u0001V+D\u0001R\u0015\t\u00116+\u0001\u0003d_:4'B\u0001+J\u0003\u0019A\u0017\rZ8pa&\u0011a+\u0015\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0007I|w\u000f\u0005\u0002Z96\t!L\u0003\u0002\\\u000f\u0006\u00191/\u001d7\n\u0005uS&a\u0001*po\u00061A(\u001b8jiz\"r\u0001Y1cG\u0012,g\r\u0005\u0002%\u0001!)Af\u0002a\u0001[!)\u0001g\u0002a\u0001c!)qg\u0002a\u0001q!)1i\u0002a\u0001q!)Ai\u0002a\u0001\u000b\")qk\u0002a\u00011\u0006!1-\u00197m)\u0005\u0019\u0013!\u00035b]\u0012dWMU8x)\u001d\u00193\u000e\\7o_BDQ\u0001L\u0005A\u00025BQ\u0001M\u0005A\u0002EBQaN\u0005A\u0002aBQaQ\u0005A\u0002aBQ\u0001R\u0005A\u0002\u0015CQaV\u0005A\u0002a\u0003")
public class Handler
implements Callable<ExportStatus>,
Serializable {
    private final KeyFilter filter;
    private final int round;
    private final String ns;
    private final String rootDst;
    private final SerializableWritable<Configuration> serializedConf;
    private final Row row;

    @Override
    public ExportStatus call() {
        return this.handleRow(this.filter, this.round, this.ns, this.rootDst, this.serializedConf, this.row);
    }

    public ExportStatus handleRow(KeyFilter filter, int round, String ns, String rootDst, SerializableWritable<Configuration> serializedConf, Row row) {
        ExportStatus exportStatus;
        Object action = row.apply(0);
        String key = row.apply(1).toString();
        String address = row.apply(2).toString();
        if (filter.roundForKey(key) != round) {
            return new ExportStatus(key, true, "skipped");
        }
        Configuration conf = (Configuration)serializedConf.value();
        Path srcPath = URLResolver$.MODULE$.resolveURL(new URI(ns), address);
        Path dstPath = URLResolver$.MODULE$.resolveURL(new URI(rootDst), key);
        FileSystem dstFS = dstPath.getFileSystem(conf);
        Object object = action;
        if ("delete".equals(object)) {
            ExportStatus exportStatus2;
            try {
                dstFS.delete(dstPath, false);
                exportStatus2 = new ExportStatus(key, true, "");
            }
            catch (IOException e) {
                exportStatus2 = new ExportStatus(dstPath.toString(), false, new StringBuilder(24).append("Unable to delete file ").append(dstPath).append(": ").append(e).toString());
            }
            exportStatus = exportStatus2;
        } else if ("copy".equals(object)) {
            ExportStatus exportStatus3;
            try {
                FileUtil.copy((FileSystem)srcPath.getFileSystem(conf), (Path)srcPath, (FileSystem)dstFS, (Path)dstPath, (boolean)false, (Configuration)conf);
                exportStatus3 = new ExportStatus(key, true, "");
            }
            catch (FileNotFoundException e) {
                exportStatus3 = new ExportStatus(dstPath.toString(), true, new StringBuilder(64).append("Unable to copy file ").append(dstPath).append(" from source ").append(srcPath).append(" since source file is missing: ").append(e).toString());
            }
            catch (IOException e) {
                exportStatus3 = new ExportStatus(dstPath.toString(), false, new StringBuilder(35).append("Unable to copy file ").append(dstPath).append(" from source ").append(srcPath).append(": ").append(e).toString());
            }
            exportStatus = exportStatus3;
        } else {
            throw new MatchError(object);
        }
        return exportStatus;
    }

    public Handler(KeyFilter filter, int round, String ns, String rootDst, SerializableWritable<Configuration> serializedConf, Row row) {
        this.filter = filter;
        this.round = round;
        this.ns = ns;
        this.rootDst = rootDst;
        this.serializedConf = serializedConf;
        this.row = row;
    }
}

