/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.google.protobuf.timestamp.Timestamp;
import io.lakefs.clients.api.model.GarbageCollectionPrepareResponse;
import io.treeverse.clients.ApiClient;
import io.treeverse.clients.ApiClient$;
import io.treeverse.clients.GarbageCollector;
import io.treeverse.clients.GarbageCollector$;
import io.treeverse.clients.LakeFSContext$;
import io.treeverse.clients.SSTableReader$;
import io.treeverse.clients.conditional.S3ClientBuilder$;
import io.treeverse.lakefs.catalog.Entry;
import io.treeverse.lakefs.graveler.committed.RangeData;
import java.io.Serializable;
import java.net.URI;
import java.time.Clock;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.native.JsonMethods$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class GarbageCollector$ {
    public static GarbageCollector$ MODULE$;

    static {
        new GarbageCollector$();
    }

    public List<Tuple2<String, String>> getHadoopConfigurationValues(Configuration hc, String prefix) {
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(hc.iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GarbageCollector$.$anonfun$getHadoopConfigurationValues$1(prefix, x$1))).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2(entry.getKey(), entry.getValue())).toList();
    }

    /*
     * WARNING - void declaration
     */
    public Configuration configurationFromValues(Broadcast<List<Tuple2<String, String>>> v) {
        void var2_2;
        Configuration hc = new Configuration();
        ((List)v.value()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            GarbageCollector$.$anonfun$configurationFromValues$1(hc, x0$1);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public Dataset<Row> getCommitsDF(String runID, String commitDFLocation, SparkSession spark) {
        return spark.read().option("header", true).option("inferSchema", true).csv(commitDFLocation);
    }

    private Set<Tuple3<String, byte[], byte[]>> getRangeTuples(String commitID, String repo, GarbageCollector.APIConfigurations apiConf, Broadcast<List<Tuple2<String, String>>> hcValues) {
        String location;
        String string = location = new ApiClient(apiConf.apiURL(), apiConf.accessKey(), apiConf.secretKey()).getMetaRangeURL(repo, commitID);
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null) ? (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$) : SSTableReader$.MODULE$.forMetaRange(this.configurationFromValues(hcValues), location).newIterator().map((Function1 & Serializable & scala.Serializable)range -> new Tuple3((Object)new String(range.id()), (Object)((RangeData)range.message()).minKey().toByteArray(), (Object)((RangeData)range.message()).maxKey().toByteArray())).toSet();
    }

    public Dataset<Row> getRangesDFFromCommits(Dataset<Row> commits, String repo, GarbageCollector.APIConfigurations apiConf, Broadcast<List<Tuple2<String, String>>> hcValues) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Io_treeverse_clients_GarbageCollector$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))), (List)Nil$.MODULE$));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator1$1() {
            }
        }
        public final class Io_treeverse_clients_GarbageCollector$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator2$1() {
            }
        }
        UserDefinedFunction get_range_tuples = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)commitID -> MODULE$.getRangeTuples((String)commitID, repo, apiConf, hcValues).toSeq(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator2$1()));
        return commits.distinct().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("expired"), functions$.MODULE$.explode(get_range_tuples.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("commit_id")}))).as("range_data")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("expired"), functions$.MODULE$.col("range_data._1").as("range_id"), functions$.MODULE$.col("range_data._2").as("min_key"), functions$.MODULE$.col("range_data._3").as("max_key")})).distinct();
    }

    public Seq<String> getRangeAddresses(String rangeID, GarbageCollector.APIConfigurations apiConf, String repo, Broadcast<List<Tuple2<String, String>>> hcValues) {
        String location = new ApiClient(apiConf.apiURL(), apiConf.accessKey(), apiConf.secretKey()).getRangeURL(repo, rangeID);
        return SSTableReader$.MODULE$.forRange(this.configurationFromValues(hcValues), location).newIterator().map((Function1 & Serializable & scala.Serializable)a -> ((Entry)a.message()).address()).toSeq();
    }

    public Set<Tuple4<String, String, Object, Object>> getEntryTuples(String rangeID, GarbageCollector.APIConfigurations apiConf, String repo, Broadcast<List<Tuple2<String, String>>> hcValues) {
        String location = new ApiClient(apiConf.apiURL(), apiConf.accessKey(), apiConf.secretKey()).getRangeURL(repo, rangeID);
        return SSTableReader$.MODULE$.forRange(this.configurationFromValues(hcValues), location).newIterator().map((Function1 & Serializable & scala.Serializable)a -> new Tuple4((Object)new String(a.key()), (Object)new String(((Entry)a.message()).address()), (Object)BoxesRunTime.boxToBoolean((boolean)((Entry)a.message()).addressType().isRelative()), (Object)BoxesRunTime.boxToLong((long)GarbageCollector$.getSeconds$1(((Entry)a.message()).lastModified())))).toSet();
    }

    public Set<Tuple4<String, String, Object, Object>> leftAntiJoinAddresses(Set<String> leftRangeIDs, Set<String> rightRangeIDs, GarbageCollector.APIConfigurations apiConf, String repo, Broadcast<List<Tuple2<String, String>>> hcValues) {
        this.distinctEntryTuples(leftRangeIDs, apiConf, repo, hcValues);
        Set<Tuple4<String, String, Object, Object>> leftTuples = this.distinctEntryTuples(leftRangeIDs, apiConf, repo, hcValues);
        Set<Tuple4<String, String, Object, Object>> rightTuples = this.distinctEntryTuples(rightRangeIDs, apiConf, repo, hcValues);
        return (Set)leftTuples.$minus$minus(rightTuples);
    }

    private Set<Tuple4<String, String, Object, Object>> distinctEntryTuples(Set<String> rangeIDs, GarbageCollector.APIConfigurations apiConf, String repo, Broadcast<List<Tuple2<String, String>>> hcValues) {
        Set tuples = (Set)rangeIDs.map((Function1 & Serializable & scala.Serializable)rangeID -> MODULE$.getEntryTuples((String)rangeID, apiConf, repo, hcValues), Set$.MODULE$.canBuildFrom());
        return tuples.isEmpty() ? (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$) : (Set)tuples.reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> (Set)x$2.union((GenSet)x$3));
    }

    public Dataset<Row> getExpiredEntriesFromRanges(Dataset<Row> ranges, GarbageCollector.APIConfigurations apiConf, String repo, Broadcast<List<Tuple2<String, String>>> hcValues) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Io_treeverse_clients_GarbageCollector$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Boolean").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$))))), (List)Nil$.MODULE$));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator1$2() {
            }
        }
        public final class Io_treeverse_clients_GarbageCollector$$typecreator2$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator2$2() {
            }
        }
        public final class Io_treeverse_clients_GarbageCollector$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator3$1() {
            }
        }
        UserDefinedFunction left_anti_join_addresses = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(x, y) -> MODULE$.leftAntiJoinAddresses((Set<String>)x.toSet(), (Set<String>)y.toSet(), apiConf, repo, hcValues).toSeq(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator1$2()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator2$2()), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator3$1()));
        Dataset expiredRangesDF = ranges.where("expired");
        Dataset activeRangesDF = ranges.where("!expired");
        Dataset uniqueExpiredRangesDF = expiredRangesDF.join(activeRangesDF, expiredRangesDF.apply("range_id").$eq$eq$eq((Object)activeRangesDF.apply("range_id")), "leftanti");
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u6 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u7 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m7 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Io_treeverse_clients_GarbageCollector$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator4$1() {
            }
        }
        public final class Io_treeverse_clients_GarbageCollector$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator5$1() {
            }
        }
        public final class Io_treeverse_clients_GarbageCollector$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator6$1() {
            }
        }
        public final class Io_treeverse_clients_GarbageCollector$$typecreator7$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator7$1() {
            }
        }
        UserDefinedFunction intersecting = functions$.MODULE$.udf((Function4 & Serializable & scala.Serializable)(aMin, aMax, bMin, bMax) -> BoxesRunTime.boxToBoolean((boolean)GarbageCollector$.$anonfun$getExpiredEntriesFromRanges$2(aMin, aMax, bMin, bMax)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Boolean(), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator4$1()), ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator5$1()), ((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator6$1()), ((TypeTags)$u7).TypeTag().apply((Mirror)$m7, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator7$1()));
        JavaUniverse $u8 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m8 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u9 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m9 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u10 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m10 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Io_treeverse_clients_GarbageCollector$$typecreator8$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator8$1() {
            }
        }
        public final class Io_treeverse_clients_GarbageCollector$$typecreator9$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator9$1() {
            }
        }
        public final class Io_treeverse_clients_GarbageCollector$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator10$1() {
            }
        }
        UserDefinedFunction minMax = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(min, max) -> new Tuple2(min, max), ((TypeTags)$u8).TypeTag().apply((Mirror)$m8, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator8$1()), ((TypeTags)$u9).TypeTag().apply((Mirror)$m9, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator9$1()), ((TypeTags)$u10).TypeTag().apply((Mirror)$m10, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator10$1()));
        Dataset joinActiveByRange = uniqueExpiredRangesDF.as("u").join(activeRangesDF.as("a"), intersecting.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a.min_key"), functions$.MODULE$.col("a.max_key"), functions$.MODULE$.col("u.min_key"), functions$.MODULE$.col("u.max_key")})), "left").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("u.range_id").as("unique_range"), functions$.MODULE$.col("a.range_id").as("active_range"), minMax.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("u.min_key"), functions$.MODULE$.col("u.max_key")})).as("min-max")}));
        Dataset groupByMinMax = joinActiveByRange.groupBy("min-max", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.collect_set("unique_range").alias("unique_ranges"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.collect_set("active_range").alias("active_ranges")}));
        Dataset addresses = groupByMinMax.withColumn("addresses", left_anti_join_addresses.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("unique_ranges"), functions$.MODULE$.col("active_ranges")})));
        return addresses.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(functions$.MODULE$.col("addresses")).as("addresses")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("addresses._1").as("key"), functions$.MODULE$.col("addresses._2").as("address"), functions$.MODULE$.col("addresses._3").as("relative"), functions$.MODULE$.col("addresses._4").as("last_modified")}));
    }

    public Dataset<Row> getExpiredAddresses(String repo, String runID, String commitDFLocation, SparkSession spark, GarbageCollector.APIConfigurations apiConf, Broadcast<List<Tuple2<String, String>>> hcValues) {
        Dataset<Row> commitsDF = this.getCommitsDF(runID, commitDFLocation, spark);
        Dataset<Row> rangesDF = this.getRangesDFFromCommits(commitsDF, repo, apiConf, hcValues);
        Dataset<Row> expired = this.getExpiredEntriesFromRanges(rangesDF, apiConf, repo, hcValues);
        Dataset activeRangesDF = rangesDF.where("!expired");
        return this.subtractDeduplications(expired, (Dataset<Row>)activeRangesDF, apiConf, repo, spark, hcValues);
    }

    private Dataset<Row> subtractDeduplications(Dataset<Row> expired, Dataset<Row> activeRangesDF, GarbageCollector.APIConfigurations apiConf, String repo, SparkSession spark, Broadcast<List<Tuple2<String, String>>> hcValues) {
        RDD activeRangesRDD = activeRangesDF.select("range_id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().distinct().map((Function1 & Serializable & scala.Serializable)x -> x.getString(0), ClassTag$.MODULE$.apply(String.class));
        RDD activeAddresses = activeRangesRDD.flatMap((Function1 & Serializable & scala.Serializable)range -> MODULE$.getRangeAddresses((String)range, apiConf, repo, hcValues), ClassTag$.MODULE$.apply(String.class)).distinct();
        RDD activeAddressesRows = activeAddresses.map((Function1 & Serializable & scala.Serializable)x -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x})), ClassTag$.MODULE$.apply(Row.class));
        StructType schema = new StructType().add(new StructField("address", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
        Dataset activeDF = spark.createDataFrame(activeAddressesRows, schema);
        return expired.join(activeDF, expired.apply("address").$eq$eq$eq((Object)activeDF.apply("address")), "leftanti");
    }

    public void main(String[] args) {
        if (args.length != 2) {
            Console$.MODULE$.err().println("Usage: ... <repo_name> <region>");
            System.exit(1);
        }
        SparkSession spark = SparkSession$.MODULE$.builder().appName("GarbageCollector").getOrCreate();
        String repo = args[0];
        String region = args[1];
        String previousRunID = "";
        Configuration hc = spark.sparkContext().hadoopConfiguration();
        Broadcast hcValues = spark.sparkContext().broadcast(this.getHadoopConfigurationValues(hc, "fs."), ClassTag$.MODULE$.apply(List.class));
        String apiURL = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_URL_KEY());
        String accessKey = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_ACCESS_KEY_KEY());
        String secretKey = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_SECRET_KEY_KEY());
        ApiClient apiClient = new ApiClient(apiURL, accessKey, secretKey);
        String gcRules = apiClient.getGarbageCollectionRules(repo);
        GarbageCollectionPrepareResponse res = apiClient.prepareGarbageCollectionCommits(repo, previousRunID);
        String runID = res.getRunId();
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("apiURL: ").append(apiURL).toString());
        String gcCommitsLocation = ApiClient$.MODULE$.translateS3(new URI(res.getGcCommitsLocation())).toString();
        Predef$.MODULE$.println((Object)new StringBuilder(19).append("gcCommitsLocation: ").append(gcCommitsLocation).toString());
        String gcAddressesLocation = ApiClient$.MODULE$.translateS3(new URI(res.getGcAddressesLocation())).toString();
        Predef$.MODULE$.println((Object)new StringBuilder(21).append("gcAddressesLocation: ").append(gcAddressesLocation).toString());
        Dataset expiredAddresses = this.getExpiredAddresses(repo, runID, gcCommitsLocation, spark, new GarbageCollector.APIConfigurations(apiURL, accessKey, secretKey), (Broadcast<List<Tuple2<String, String>>>)hcValues).withColumn("run_id", functions$.MODULE$.lit((Object)runID));
        spark.conf().set("spark.sql.sources.partitionOverwriteMode", "dynamic");
        expiredAddresses.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"run_id"})).mode(SaveMode.Overwrite).parquet(gcAddressesLocation);
        Predef$.MODULE$.println((Object)"Expired addresses:");
        expiredAddresses.show();
        String storageNamespace = new ApiClient(apiURL, accessKey, secretKey).getStorageNamespace(repo);
        if (!storageNamespace.endsWith("/")) {
            storageNamespace = new StringBuilder(1).append(storageNamespace).append("/").toString();
        }
        Dataset<Row> removed = this.remove(storageNamespace, gcAddressesLocation, (Dataset<Row>)expiredAddresses, runID, region, (Broadcast<List<Tuple2<String, String>>>)hcValues);
        Dataset<Row> commitsDF = this.getCommitsDF(runID, gcCommitsLocation, spark);
        String reportLogsDst = this.concatToGCLogsPrefix(storageNamespace, "summary");
        String reportExpiredDst = this.concatToGCLogsPrefix(storageNamespace, "expired_addresses");
        String time = DateTimeFormatter.ISO_INSTANT.format(Clock.systemUTC().instant());
        this.writeParquetReport(commitsDF, reportLogsDst, time, "commits.parquet");
        this.writeParquetReport((Dataset<Row>)expiredAddresses, reportExpiredDst, time, this.writeParquetReport$default$4());
        this.writeJsonSummary(reportLogsDst, removed.count(), gcRules, (Broadcast<List<Tuple2<String, String>>>)hcValues, time);
        removed.withColumn("run_id", functions$.MODULE$.lit((Object)runID)).write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"run_id"})).mode(SaveMode.Overwrite).parquet(this.concatToGCLogsPrefix(storageNamespace, new StringBuilder(32).append("deleted_objects/").append(time).append("/deleted.parquet").toString()));
        spark.close();
    }

    private String concatToGCLogsPrefix(String storageNameSpace, String key) {
        String strippedKey = new StringOps(Predef$.MODULE$.augmentString(key)).stripPrefix("/");
        return new StringBuilder(16).append(storageNameSpace).append("_lakefs/logs/gc/").append(strippedKey).toString();
    }

    private Dataset<Row> repartitionBySize(Dataset<Row> df, int maxSize, String column) {
        long nRows = df.count();
        int nPartitions = (int)scala.math.package$.MODULE$.max(1.0, scala.math.package$.MODULE$.ceil((double)(nRows / (long)maxSize)));
        return df.repartitionByRange(nPartitions, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(column)}));
    }

    private Seq<String> delObjIteration(String bucket, Seq<String> keys, AmazonS3 s3Client, String snPrefix) {
        if (keys.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        Seq removeKeyNames = (Seq)keys.map((Function1 & Serializable & scala.Serializable)x -> snPrefix.concat((String)x), Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)new Tuple2((Object)"Remove keys:", (Object)((TraversableOnce)removeKeyNames.take(100)).mkString(", ")));
        java.util.List removeKeys = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)removeKeyNames.map((Function1 & Serializable & scala.Serializable)k -> new DeleteObjectsRequest.KeyVersion(k), Seq$.MODULE$.canBuildFrom())).asJava();
        DeleteObjectsRequest delObjReq = new DeleteObjectsRequest(bucket).withKeys(removeKeys);
        DeleteObjectsResult res = s3Client.deleteObjects(delObjReq);
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res.getDeletedObjects()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getKey(), Buffer$.MODULE$.canBuildFrom());
    }

    private AmazonS3 getS3Client(Configuration hc, String bucket, String region, int numRetries) {
        return S3ClientBuilder$.MODULE$.build(hc, bucket, region, numRetries);
    }

    public Dataset<String> bulkRemove(Dataset<Row> readKeysDF, int bulkSize, String bucket, String region, int numRetries, String snPrefix, Broadcast<List<Tuple2<String, String>>> hcValues) {
        SparkSession spark = SparkSession$.MODULE$.active();
        Dataset<Row> repartitionedKeys = this.repartitionBySize(readKeysDF, bulkSize, "address");
        Dataset bulkedKeyStrings = repartitionedKeys.select("address", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getString(0), spark.implicits().newStringEncoder());
        return bulkedKeyStrings.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            AmazonS3 s3Client = MODULE$.getS3Client(MODULE$.configurationFromValues(hcValues), bucket, region, numRetries);
            return iter.grouped(bulkSize).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.delObjIteration(bucket, (Seq<String>)x$7, s3Client, snPrefix));
        }, spark.implicits().newStringEncoder());
    }

    public Dataset<Row> remove(String storageNamespace, String addressDFLocation, Dataset<Row> expiredAddresses, String runID, String region, Broadcast<List<Tuple2<String, String>>> hcValues) {
        int MaxBulkSize = 1000;
        int awsRetries = 1000;
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("storageNamespace: ").append(storageNamespace).toString());
        URI uri = new URI(storageNamespace);
        String bucket = uri.getHost();
        String key = uri.getPath();
        String addSuffixSlash = key.endsWith("/") ? key : key.concat("/");
        String snPrefix = addSuffixSlash.startsWith("/") ? addSuffixSlash.substring(1) : addSuffixSlash;
        Predef$.MODULE$.println((Object)new StringBuilder(19).append("addressDFLocation: ").append(addressDFLocation).toString());
        Dataset df = expiredAddresses.where(functions$.MODULE$.col("run_id").$eq$eq$eq((Object)runID)).where(functions$.MODULE$.col("relative").$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        return this.bulkRemove((Dataset<Row>)df, MaxBulkSize, bucket, region, awsRetries, snPrefix, hcValues).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"addresses"}));
    }

    private void writeParquetReport(Dataset<Row> df, String dstRoot, String time, String suffix) {
        String dstPath = new StringBuilder(5).append(dstRoot).append("/dt=").append(time).append("/").append(suffix).toString();
        df.write().parquet(dstPath);
    }

    private String writeParquetReport$default$4() {
        return "";
    }

    private void writeJsonSummary(String dstRoot, long numDeletedObjects, String gcRules, Broadcast<List<Tuple2<String, String>>> hcValues, String time) {
        Path dstPath = new Path(new StringBuilder(17).append(dstRoot).append("/dt=").append(time).append("/summary.json").toString());
        FileSystem dstFS = dstPath.getFileSystem(this.configurationFromValues(hcValues));
        JsonAST.JObject jsonSummary = org.json4s.package$.MODULE$.JObject().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gc_rules"), (Object)JsonDSL$.MODULE$.string2jvalue(gcRules)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"num_deleted_objects"), (Object)JsonDSL$.MODULE$.long2jvalue(numDeletedObjects))}));
        try (FSDataOutputStream stream = dstFS.create(dstPath);){
            JsonAST.JObject x$1 = jsonSummary;
            Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
            stream.writeChars(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2)));
        }
    }

    public static final /* synthetic */ boolean $anonfun$getHadoopConfigurationValues$1(String prefix$1, Map.Entry x$1) {
        return ((String)x$1.getKey()).startsWith(prefix$1);
    }

    public static final /* synthetic */ void $anonfun$configurationFromValues$1(Configuration hc$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        hc$1.set(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final long getSeconds$1(Option ts) {
        return ((Timestamp)ts.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)).seconds();
    }

    public static final /* synthetic */ boolean $anonfun$getExpiredEntriesFromRanges$2(byte[] aMin, byte[] aMax, byte[] bMin, byte[] bMax) {
        Ordering byteArrayOrdering = scala.package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$4 -> new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$4)).toIterable(), Ordering$.MODULE$.Iterable((Ordering)Ordering.Byte$.MODULE$));
        return byteArrayOrdering.compare((Object)aMin, (Object)bMax) <= 0 && byteArrayOrdering.compare((Object)bMin, (Object)aMax) <= 0;
    }

    private GarbageCollector$() {
        MODULE$ = this;
    }
}

