/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.lakefs.clients.api.BranchesApi;
import io.lakefs.clients.api.CommitsApi;
import io.lakefs.clients.api.MetadataApi;
import io.lakefs.clients.api.RepositoriesApi;
import io.lakefs.clients.api.RetentionApi;
import io.lakefs.clients.api.model.Commit;
import io.lakefs.clients.api.model.GarbageCollectionPrepareRequest;
import io.lakefs.clients.api.model.GarbageCollectionPrepareResponse;
import io.lakefs.clients.api.model.GarbageCollectionRules;
import io.lakefs.clients.api.model.Repository;
import io.lakefs.clients.api.model.StorageURI;
import io.treeverse.clients.ApiClient$;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]u!\u0002\u0012$\u0011\u0013Qc!\u0002\u0017$\u0011\u0013i\u0003\"\u0002\u001b\u0002\t\u0003)\u0004\"\u0002\u001c\u0002\t\u00039d\u0001\u0002\u0017$\u0001\tC\u0001b\u0011\u0003\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u001f\u0012\u0011\t\u0011)A\u0005\t\"A\u0001\u000b\u0002B\u0001B\u0003%A\tC\u00035\t\u0011\u0005\u0011\u000bC\u0004W\t\t\u0007I\u0011B,\t\r\u0001$\u0001\u0015!\u0003Y\u0011\u001d\tGA1A\u0005\n\tDaA\u001a\u0003!\u0002\u0013\u0019\u0007bB4\u0005\u0005\u0004%I\u0001\u001b\u0005\u0007Y\u0012\u0001\u000b\u0011B5\t\u000f5$!\u0019!C\u0005]\"1!\u000f\u0002Q\u0001\n=Dqa\u001d\u0003C\u0002\u0013%A\u000f\u0003\u0004y\t\u0001\u0006I!\u001e\u0005\bs\u0012\u0011\r\u0011\"\u0003{\u0011\u0019qH\u0001)A\u0005w\"Aq\u0010\u0002b\u0001\n\u0013\t\t\u0001\u0003\u0005\u0002\u001c\u0011\u0001\u000b\u0011BA\u0002\r\u0019\ti\u0002\u0002\u0003\u0002 !Q\u0011QH\f\u0003\u0006\u0004%\t!a\u0010\t\u0015\u0005\u001dsC!A!\u0002\u0013\t\t\u0005\u0003\u00045/\u0011\u0005\u0011\u0011\n\u0005\b\u0003#:B\u0011AA*\u0011\u001d\t)\u0006\u0002C\u0001\u0003/Bq!!\u0018\u0005\t\u0003\ty\u0006C\u0004\u0002t\u0011!\t!!\u001e\t\u000f\u0005eD\u0001\"\u0001\u0002|!9\u00111\u0011\u0003\u0005\u0002\u0005\u0015\u0005bBAG\t\u0011\u0005\u0011qR\u0001\n\u0003BL7\t\\5f]RT!\u0001J\u0013\u0002\u000f\rd\u0017.\u001a8ug*\u0011aeJ\u0001\niJ,WM^3sg\u0016T\u0011\u0001K\u0001\u0003S>\u001c\u0001\u0001\u0005\u0002,\u00035\t1EA\u0005Ba&\u001cE.[3oiN\u0011\u0011A\f\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Q\u0013a\u0003;sC:\u001cH.\u0019;f'N\"\"\u0001\u000f!\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014a\u00018fi*\tQ(\u0001\u0003kCZ\f\u0017BA ;\u0005\r)&+\u0013\u0005\u0006\u0003\u000e\u0001\r\u0001O\u0001\u0004kJL7C\u0001\u0003/\u0003\u0019\t\u0007/[+sYB\u0011Q\t\u0014\b\u0003\r*\u0003\"a\u0012\u0019\u000e\u0003!S!!S\u0015\u0002\rq\u0012xn\u001c;?\u0013\tY\u0005'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&1\u0003%\t7mY3tg.+\u00170A\u0005tK\u000e\u0014X\r^&fsR!!k\u0015+V!\tYC\u0001C\u0003D\u0011\u0001\u0007A\tC\u0003P\u0011\u0001\u0007A\tC\u0003Q\u0011\u0001\u0007A)\u0001\u0004dY&,g\u000e^\u000b\u00021B\u0011\u0011lX\u0007\u00025*\u00111\fX\u0001\u0004CBL'B\u0001\u0013^\u0015\tqv%\u0001\u0004mC.,gm]\u0005\u0003Yi\u000bqa\u00197jK:$\b%A\bsKB|7/\u001b;pe&,7/\u00119j+\u0005\u0019\u0007CA-e\u0013\t)'LA\bSKB|7/\u001b;pe&,7/\u00119j\u0003A\u0011X\r]8tSR|'/[3t\u0003BL\u0007%\u0001\u0006d_6l\u0017\u000e^:Ba&,\u0012!\u001b\t\u00033*L!a\u001b.\u0003\u0015\r{W.\\5ug\u0006\u0003\u0018.A\u0006d_6l\u0017\u000e^:Ba&\u0004\u0013aC7fi\u0006$\u0017\r^1Ba&,\u0012a\u001c\t\u00033BL!!\u001d.\u0003\u00175+G/\u00193bi\u0006\f\u0005/[\u0001\r[\u0016$\u0018\rZ1uC\u0006\u0003\u0018\u000eI\u0001\fEJ\fgn\u00195fg\u0006\u0003\u0018.F\u0001v!\tIf/\u0003\u0002x5\nY!I]1oG\",7/\u00119j\u00031\u0011'/\u00198dQ\u0016\u001c\u0018\t]5!\u00031\u0011X\r^3oi&|g.\u00119j+\u0005Y\bCA-}\u0013\ti(L\u0001\u0007SKR,g\u000e^5p]\u0006\u0003\u0018.A\u0007sKR,g\u000e^5p]\u0006\u0003\u0018\u000eI\u0001\u0016gR|'/Y4f\u001d\u0006lWm\u001d9bG\u0016\u001c\u0015m\u00195f+\t\t\u0019\u0001\u0005\u0004\u0002\u0006\u0005]A\tR\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005)1-Y2iK*!\u0011QBA\b\u0003\u0019\u0019w.\\7p]*!\u0011\u0011CA\n\u0003\u00199wn\\4mK*\u0011\u0011QC\u0001\u0004G>l\u0017\u0002BA\r\u0003\u000f\u0011QaQ1dQ\u0016\fac\u001d;pe\u0006<WMT1nKN\u0004\u0018mY3DC\u000eDW\r\t\u0002\u000b\u0007\u0006dG.\u00192mK\u001as7#B\f\u0002\"\u00055\u0002\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001dB(\u0001\u0003mC:<\u0017\u0002BA\u0016\u0003K\u0011aa\u00142kK\u000e$\b#BA\u0018\u0003s!UBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u00028q\nA!\u001e;jY&!\u00111HA\u0019\u0005!\u0019\u0015\r\u001c7bE2,\u0017A\u00014o+\t\t\t\u0005\u0005\u00030\u0003\u0007\"\u0015bAA#a\tIa)\u001e8di&|g\u000eM\u0001\u0004M:\u0004C\u0003BA&\u0003\u001f\u00022!!\u0014\u0018\u001b\u0005!\u0001bBA\u001f5\u0001\u0007\u0011\u0011I\u0001\u0005G\u0006dG\u000eF\u0001E\u0003M9W\r^*u_J\fw-\u001a(b[\u0016\u001c\b/Y2f)\r!\u0015\u0011\f\u0005\u0007\u00037b\u0002\u0019\u0001#\u0002\u0011I,\u0007o\u001c(b[\u0016\fq\u0004\u001d:fa\u0006\u0014XmR1sE\u0006<WmQ8mY\u0016\u001cG/[8o\u0007>lW.\u001b;t)\u0019\t\t'!\u001c\u0002pA!\u00111MA5\u001b\t\t)GC\u0002\u0002hi\u000bQ!\\8eK2LA!a\u001b\u0002f\t\u0001s)\u0019:cC\u001e,7i\u001c7mK\u000e$\u0018n\u001c8Qe\u0016\u0004\u0018M]3SKN\u0004xN\\:f\u0011\u0019\tY&\ba\u0001\t\"1\u0011\u0011O\u000fA\u0002\u0011\u000bQ\u0002\u001d:fm&|Wo\u001d*v]&#\u0015!G4fi\u001e\u000b'OY1hK\u000e{G\u000e\\3di&|gNU;mKN$2\u0001RA<\u0011\u0019\tYF\ba\u0001\t\u0006yq-\u001a;NKR\f'+\u00198hKV\u0013F\nF\u0003E\u0003{\ny\b\u0003\u0004\u0002\\}\u0001\r\u0001\u0012\u0005\u0007\u0003\u0003{\u0002\u0019\u0001#\u0002\u0011\r|W.\\5u\u0013\u0012\u000b1bZ3u%\u0006tw-Z+S\u0019R)A)a\"\u0002\n\"1\u00111\f\u0011A\u0002\u0011Ca!a#!\u0001\u0004!\u0015a\u0002:b]\u001e,\u0017\nR\u0001\u0014O\u0016$(I]1oG\"DU)\u0011#D_6l\u0017\u000e\u001e\u000b\u0006\t\u0006E\u00151\u0013\u0005\u0007\u00037\n\u0003\u0019\u0001#\t\r\u0005U\u0015\u00051\u0001E\u0003\u0019\u0011'/\u00198dQ\u0002")
public class ApiClient {
    private final io.lakefs.clients.api.ApiClient client = new io.lakefs.clients.api.ApiClient();
    private final RepositoriesApi repositoriesApi;
    private final CommitsApi commitsApi;
    private final MetadataApi metadataApi;
    private final BranchesApi branchesApi;
    private final RetentionApi retentionApi;
    private final Cache<String, String> storageNamespaceCache;

    public static URI translateS3(URI uRI) {
        return ApiClient$.MODULE$.translateS3(uRI);
    }

    private io.lakefs.clients.api.ApiClient client() {
        return this.client;
    }

    private RepositoriesApi repositoriesApi() {
        return this.repositoriesApi;
    }

    private CommitsApi commitsApi() {
        return this.commitsApi;
    }

    private MetadataApi metadataApi() {
        return this.metadataApi;
    }

    private BranchesApi branchesApi() {
        return this.branchesApi;
    }

    private RetentionApi retentionApi() {
        return this.retentionApi;
    }

    private Cache<String, String> storageNamespaceCache() {
        return this.storageNamespaceCache;
    }

    public String getStorageNamespace(String repoName) {
        return (String)this.storageNamespaceCache().get((Object)repoName, (Callable)new CallableFn(this, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            Repository repo = this.repositoriesApi().getRepository(repoName);
            return ApiClient$.MODULE$.translateS3(URI.create(repo.getStorageNamespace())).normalize().toString();
        }));
    }

    public GarbageCollectionPrepareResponse prepareGarbageCollectionCommits(String repoName, String previousRunID) {
        return this.retentionApi().prepareGarbageCollectionCommits(repoName, new GarbageCollectionPrepareRequest().previousRunId(previousRunID));
    }

    public String getGarbageCollectionRules(String repoName) {
        GarbageCollectionRules gcRules = this.retentionApi().getGarbageCollectionRules(repoName);
        return gcRules.toString();
    }

    public String getMetaRangeURL(String repoName, String commitID) {
        String string;
        String metaRangeID;
        Commit commit = this.commitsApi().getCommit(repoName, commitID);
        String string2 = metaRangeID = commit.getMetaRangeId();
        String string3 = "";
        if (string2 == null ? string3 != null : !string2.equals(string3)) {
            StorageURI metaRange = this.metadataApi().getMetaRange(repoName, metaRangeID);
            String location = metaRange.getLocation();
            string = URI.create(new StringBuilder(1).append(this.getStorageNamespace(repoName)).append("/").toString()).resolve(location).normalize().toString();
        } else {
            string = "";
        }
        return string;
    }

    public String getRangeURL(String repoName, String rangeID) {
        StorageURI range = this.metadataApi().getRange(repoName, rangeID);
        String location = range.getLocation();
        return URI.create(new StringBuilder(1).append(this.getStorageNamespace(repoName)).append("/").append(location).toString()).normalize().toString();
    }

    public String getBranchHEADCommit(String repoName, String branch) {
        return this.branchesApi().getBranch(repoName, branch).getCommitId();
    }

    public ApiClient(String apiUrl, String accessKey, String secretKey) {
        this.client().setUsername(accessKey);
        this.client().setPassword(secretKey);
        this.client().setBasePath(new StringOps(Predef$.MODULE$.augmentString(apiUrl)).stripSuffix("/"));
        this.repositoriesApi = new RepositoriesApi(this.client());
        this.commitsApi = new CommitsApi(this.client());
        this.metadataApi = new MetadataApi(this.client());
        this.branchesApi = new BranchesApi(this.client());
        this.retentionApi = new RetentionApi(this.client());
        this.storageNamespaceCache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).build();
    }

    public class CallableFn
    implements Callable<String> {
        private final Function0<String> fn;
        public final /* synthetic */ ApiClient $outer;

        public Function0<String> fn() {
            return this.fn;
        }

        @Override
        public String call() {
            return (String)this.fn().apply();
        }

        public /* synthetic */ ApiClient io$treeverse$clients$ApiClient$CallableFn$$$outer() {
            return this.$outer;
        }

        public CallableFn(ApiClient $outer, Function0<String> fn) {
            this.fn = fn;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

