/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import io.treeverse.clients.ApiClient;
import io.treeverse.clients.LakeFSContext$;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import scala.Console$;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;

public final class S3BulkDeleter$ {
    public static S3BulkDeleter$ MODULE$;

    static {
        new S3BulkDeleter$();
    }

    private Dataset<Row> repartitionBySize(Dataset<Row> df, int maxSize, String column) {
        long nRows = df.count();
        int nPartitions = (int)package$.MODULE$.max(1.0, package$.MODULE$.floor((double)(nRows / (long)maxSize)));
        return df.repartitionByRange(nPartitions, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(column)}));
    }

    private Seq<String> delObjIteration(String bucket, Seq<String> keys, S3Client s3Client, String snPrefix) {
        Object object = keys.isEmpty() ? None$.MODULE$ : BoxedUnit.UNIT;
        List removeKeys = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)keys.map((Function1 & Serializable & scala.Serializable)x -> (ObjectIdentifier)ObjectIdentifier.builder().key(snPrefix.concat((String)x)).build(), Seq$.MODULE$.canBuildFrom())).asJava();
        Delete delObj = (Delete)Delete.builder().objects((Collection)removeKeys).build();
        DeleteObjectsRequest delObjReq = (DeleteObjectsRequest)DeleteObjectsRequest.builder().delete(delObj).bucket(bucket).build();
        DeleteObjectsResponse res = s3Client.deleteObjects(delObjReq);
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res.deleted()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.key(), Buffer$.MODULE$.canBuildFrom());
    }

    private S3Client getS3Client(String region, int numRetries) {
        RetryPolicy retryPolicy = RetryPolicy.builder().backoffStrategy(BackoffStrategy.defaultThrottlingStrategy()).numRetries(Predef$.MODULE$.int2Integer(numRetries)).build();
        ClientOverrideConfiguration configuration = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(retryPolicy).build();
        return (S3Client)S3Client.builder().region(Region.of((String)region)).overrideConfiguration(configuration).build();
    }

    public Dataset<String> bulkRemove(Dataset<Row> readKeysDF, int bulkSize, SparkSession spark, String bucket, String region, int numRetries, String snPrefix) {
        Dataset<Row> repartitionedKeys = this.repartitionBySize(readKeysDF, bulkSize, "address");
        Dataset bulkedKeyStrings = repartitionedKeys.select("address", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getString(0), spark.implicits().newStringEncoder());
        return bulkedKeyStrings.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> iter.grouped(bulkSize).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.delObjIteration(bucket, (Seq<String>)x$6, MODULE$.getS3Client(region, numRetries), snPrefix)), spark.implicits().newStringEncoder());
    }

    public void remove(String repo, String addressDFLocation, String runID, String region, SparkSession spark) {
        int MaxBulkSize = 1000;
        int awsRetries = 1000;
        Configuration hc = spark.sparkContext().hadoopConfiguration();
        String apiURL = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_URL_KEY());
        String accessKey = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_ACCESS_KEY_KEY());
        String secretKey = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_SECRET_KEY_KEY());
        String storageNamespace = new ApiClient(apiURL, accessKey, secretKey).getStorageNamespace(repo);
        URI uri = new URI(storageNamespace);
        String bucket = uri.getHost();
        String key = uri.getPath();
        String addSuffixSlash = key.endsWith("/") ? key : key.concat("/");
        String snPrefix = addSuffixSlash.startsWith("/") ? addSuffixSlash.substring(1) : addSuffixSlash;
        Dataset df = spark.read().parquet(addressDFLocation).where(functions$.MODULE$.col("run_id").$eq$eq$eq((Object)runID)).where(functions$.MODULE$.col("relative").$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        Row[] res = (Row[])this.bulkRemove((Dataset<Row>)df, MaxBulkSize, spark, bucket, region, awsRetries, snPrefix).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"addresses"})).collect();
    }

    public void main(String[] args) {
        if (args.length != 4) {
            Console$.MODULE$.err().println("Usage: ... <repo_name> <runID> <region> s3://storageNamespace/prepared_addresses_table");
            System.exit(1);
        }
        String repo = args[0];
        String runID = args[1];
        String region = args[2];
        String addressesDFLocation = args[3];
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        this.remove(repo, addressesDFLocation, runID, region, spark);
    }

    private S3BulkDeleter$() {
        MODULE$ = this;
    }
}

