/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import io.treeverse.clients.LakeFSInputFormat;
import io.treeverse.clients.WithIdentifier;
import io.treeverse.lakefs.catalog.Entry;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class LakeFSContext$ {
    public static LakeFSContext$ MODULE$;
    private final String LAKEFS_CONF_API_URL_KEY;
    private final String LAKEFS_CONF_API_ACCESS_KEY_KEY;
    private final String LAKEFS_CONF_API_SECRET_KEY_KEY;
    private final String LAKEFS_CONF_JOB_REPO_NAME_KEY;
    private final String LAKEFS_CONF_JOB_COMMIT_ID_KEY;

    static {
        new LakeFSContext$();
    }

    public String LAKEFS_CONF_API_URL_KEY() {
        return this.LAKEFS_CONF_API_URL_KEY;
    }

    public String LAKEFS_CONF_API_ACCESS_KEY_KEY() {
        return this.LAKEFS_CONF_API_ACCESS_KEY_KEY;
    }

    public String LAKEFS_CONF_API_SECRET_KEY_KEY() {
        return this.LAKEFS_CONF_API_SECRET_KEY_KEY;
    }

    public String LAKEFS_CONF_JOB_REPO_NAME_KEY() {
        return this.LAKEFS_CONF_JOB_REPO_NAME_KEY;
    }

    public String LAKEFS_CONF_JOB_COMMIT_ID_KEY() {
        return this.LAKEFS_CONF_JOB_COMMIT_ID_KEY;
    }

    public RDD<Tuple2<byte[], WithIdentifier<Entry>>> newRDD(SparkContext sc, String repoName, String commitID) {
        Configuration conf = new Configuration(sc.hadoopConfiguration());
        conf.set(this.LAKEFS_CONF_JOB_REPO_NAME_KEY(), repoName);
        conf.set(this.LAKEFS_CONF_JOB_COMMIT_ID_KEY(), commitID);
        if (StringUtils.isBlank((CharSequence)conf.get(this.LAKEFS_CONF_API_URL_KEY()))) {
            throw new InvalidJobConfException(new StringBuilder(18).append(this.LAKEFS_CONF_API_URL_KEY()).append(" must not be empty").toString());
        }
        if (StringUtils.isBlank((CharSequence)conf.get(this.LAKEFS_CONF_API_ACCESS_KEY_KEY()))) {
            throw new InvalidJobConfException(new StringBuilder(18).append(this.LAKEFS_CONF_API_ACCESS_KEY_KEY()).append(" must not be empty").toString());
        }
        if (StringUtils.isBlank((CharSequence)conf.get(this.LAKEFS_CONF_API_SECRET_KEY_KEY()))) {
            throw new InvalidJobConfException(new StringBuilder(18).append(this.LAKEFS_CONF_API_SECRET_KEY_KEY()).append(" must not be empty").toString());
        }
        return sc.newAPIHadoopRDD(conf, LakeFSInputFormat.class, byte[].class, WithIdentifier.class);
    }

    public Dataset<Row> newDF(SparkSession spark, String repoName, String commitID) {
        RDD rdd = this.newRDD(spark.sparkContext(), repoName, commitID).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] k = (byte[])tuple2._1();
            WithIdentifier v = (WithIdentifier)tuple2._2();
            Entry entry = (Entry)v.message();
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new String(k), entry.address(), entry.eTag(), new Timestamp(TimeUnit.SECONDS.toMillis(entry.getLastModified().seconds())), BoxesRunTime.boxToLong((long)entry.size())}));
            return row;
        }, ClassTag$.MODULE$.apply(Row.class));
        StructType schema = new StructType().add(new StructField("key", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("address", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("etag", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("last_modified", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("size", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
        return spark.createDataFrame(rdd, schema);
    }

    private LakeFSContext$() {
        MODULE$ = this;
        this.LAKEFS_CONF_API_URL_KEY = "lakefs.api.url";
        this.LAKEFS_CONF_API_ACCESS_KEY_KEY = "lakefs.api.access_key";
        this.LAKEFS_CONF_API_SECRET_KEY_KEY = "lakefs.api.secret_key";
        this.LAKEFS_CONF_JOB_REPO_NAME_KEY = "lakefs.job.repo_name";
        this.LAKEFS_CONF_JOB_COMMIT_ID_KEY = "lakefs.job.commit_id";
    }
}

