/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import com.google.protobuf.timestamp.Timestamp;
import io.lakefs.clients.api.model.GarbageCollectionPrepareResponse;
import io.treeverse.clients.ApiClient;
import io.treeverse.clients.ApiClient$;
import io.treeverse.clients.GarbageCollector;
import io.treeverse.clients.GarbageCollector$;
import io.treeverse.clients.LakeFSContext$;
import io.treeverse.clients.S3BulkDeleter$;
import io.treeverse.clients.SSTableReader$;
import io.treeverse.lakefs.catalog.Entry;
import io.treeverse.lakefs.graveler.committed.RangeData;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class GarbageCollector$ {
    public static GarbageCollector$ MODULE$;

    static {
        new GarbageCollector$();
    }

    public Dataset<Row> getCommitsDF(String runID, String commitDFLocation, SparkSession spark) {
        return spark.read().option("header", true).option("inferSchema", true).csv(commitDFLocation);
    }

    private Set<Tuple3<String, byte[], byte[]>> getRangeTuples(String commitID, String repo, GarbageCollector.APIConfigurations conf) {
        String location;
        String string = location = new ApiClient(conf.apiURL(), conf.accessKey(), conf.secretKey()).getMetaRangeURL(repo, commitID);
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null) ? (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$) : SSTableReader$.MODULE$.forMetaRange(new Configuration(), location).newIterator().map((Function1 & Serializable & scala.Serializable)range -> new Tuple3((Object)new String(range.id()), (Object)((RangeData)range.message()).minKey().toByteArray(), (Object)((RangeData)range.message()).maxKey().toByteArray())).toSet();
    }

    public Dataset<Row> getRangesDFFromCommits(Dataset<Row> commits, String repo, GarbageCollector.APIConfigurations conf) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Io_treeverse_clients_GarbageCollector$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))), (List)Nil$.MODULE$));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator1$1() {
            }
        }
        public final class Io_treeverse_clients_GarbageCollector$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator2$1() {
            }
        }
        UserDefinedFunction get_range_tuples = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)commitID -> MODULE$.getRangeTuples((String)commitID, repo, conf).toSeq(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator2$1()));
        return commits.distinct().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("expired"), functions$.MODULE$.explode(get_range_tuples.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("commit_id")}))).as("range_data")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("expired"), functions$.MODULE$.col("range_data._1").as("range_id"), functions$.MODULE$.col("range_data._2").as("min_key"), functions$.MODULE$.col("range_data._3").as("max_key")})).distinct();
    }

    public Seq<String> getRangeAddresses(String rangeID, GarbageCollector.APIConfigurations conf, String repo) {
        String location = new ApiClient(conf.apiURL(), conf.accessKey(), conf.secretKey()).getRangeURL(repo, rangeID);
        return SSTableReader$.MODULE$.forRange(new Configuration(), location).newIterator().map((Function1 & Serializable & scala.Serializable)a -> ((Entry)a.message()).address()).toSeq();
    }

    public Set<Tuple4<String, String, Object, Object>> getEntryTuples(String rangeID, GarbageCollector.APIConfigurations conf, String repo) {
        String location = new ApiClient(conf.apiURL(), conf.accessKey(), conf.secretKey()).getRangeURL(repo, rangeID);
        return SSTableReader$.MODULE$.forRange(new Configuration(), location).newIterator().map((Function1 & Serializable & scala.Serializable)a -> new Tuple4((Object)new String(a.key()), (Object)new String(((Entry)a.message()).address()), (Object)BoxesRunTime.boxToBoolean((boolean)((Entry)a.message()).addressType().isRelative()), (Object)BoxesRunTime.boxToLong((long)GarbageCollector$.getSeconds$1(((Entry)a.message()).lastModified())))).toSet();
    }

    public Set<Tuple4<String, String, Object, Object>> leftAntiJoinAddresses(Set<String> leftRangeIDs, Set<String> rightRangeIDs, GarbageCollector.APIConfigurations conf, String repo) {
        this.distinctEntryTuples(leftRangeIDs, conf, repo);
        Set<Tuple4<String, String, Object, Object>> leftTuples = this.distinctEntryTuples(leftRangeIDs, conf, repo);
        Set<Tuple4<String, String, Object, Object>> rightTuples = this.distinctEntryTuples(rightRangeIDs, conf, repo);
        return (Set)leftTuples.$minus$minus(rightTuples);
    }

    private Set<Tuple4<String, String, Object, Object>> distinctEntryTuples(Set<String> rangeIDs, GarbageCollector.APIConfigurations conf, String repo) {
        Set tuples = (Set)rangeIDs.map((Function1 & Serializable & scala.Serializable)rangeID -> MODULE$.getEntryTuples((String)rangeID, conf, repo), Set$.MODULE$.canBuildFrom());
        return tuples.isEmpty() ? (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$) : (Set)tuples.reduce((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> (Set)x$1.union((GenSet)x$2));
    }

    public Dataset<Row> getExpiredEntriesFromRanges(Dataset<Row> ranges, GarbageCollector.APIConfigurations conf, String repo) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Io_treeverse_clients_GarbageCollector$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Boolean").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$))))), (List)Nil$.MODULE$));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator1$2() {
            }
        }
        public final class Io_treeverse_clients_GarbageCollector$$typecreator2$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator2$2() {
            }
        }
        public final class Io_treeverse_clients_GarbageCollector$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator3$1() {
            }
        }
        UserDefinedFunction left_anti_join_addresses = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(x, y) -> MODULE$.leftAntiJoinAddresses((Set<String>)x.toSet(), (Set<String>)y.toSet(), conf, repo).toSeq(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator1$2()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator2$2()), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator3$1()));
        Dataset expiredRangesDF = ranges.where("expired");
        Dataset activeRangesDF = ranges.where("!expired");
        Dataset uniqueExpiredRangesDF = expiredRangesDF.join(activeRangesDF, expiredRangesDF.apply("range_id").$eq$eq$eq((Object)activeRangesDF.apply("range_id")), "leftanti");
        JavaUniverse $u4 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u5 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u6 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m6 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u7 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m7 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Io_treeverse_clients_GarbageCollector$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator4$1() {
            }
        }
        public final class Io_treeverse_clients_GarbageCollector$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator5$1() {
            }
        }
        public final class Io_treeverse_clients_GarbageCollector$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator6$1() {
            }
        }
        public final class Io_treeverse_clients_GarbageCollector$$typecreator7$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator7$1() {
            }
        }
        UserDefinedFunction intersecting = functions$.MODULE$.udf((Function4 & Serializable & scala.Serializable)(aMin, aMax, bMin, bMax) -> BoxesRunTime.boxToBoolean((boolean)GarbageCollector$.$anonfun$getExpiredEntriesFromRanges$2(aMin, aMax, bMin, bMax)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Boolean(), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator4$1()), ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator5$1()), ((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator6$1()), ((TypeTags)$u7).TypeTag().apply((Mirror)$m7, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator7$1()));
        JavaUniverse $u8 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m8 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u9 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m9 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u10 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m10 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Io_treeverse_clients_GarbageCollector$$typecreator8$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator8$1() {
            }
        }
        public final class Io_treeverse_clients_GarbageCollector$$typecreator9$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator9$1() {
            }
        }
        public final class Io_treeverse_clients_GarbageCollector$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Io_treeverse_clients_GarbageCollector$$typecreator10$1() {
            }
        }
        UserDefinedFunction minMax = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(min, max) -> new Tuple2(min, max), ((TypeTags)$u8).TypeTag().apply((Mirror)$m8, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator8$1()), ((TypeTags)$u9).TypeTag().apply((Mirror)$m9, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator9$1()), ((TypeTags)$u10).TypeTag().apply((Mirror)$m10, (TypeCreator)new Io_treeverse_clients_GarbageCollector$$typecreator10$1()));
        Dataset joinActiveByRange = uniqueExpiredRangesDF.as("u").join(activeRangesDF.as("a"), intersecting.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("a.min_key"), functions$.MODULE$.col("a.max_key"), functions$.MODULE$.col("u.min_key"), functions$.MODULE$.col("u.max_key")})), "left").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("u.range_id").as("unique_range"), functions$.MODULE$.col("a.range_id").as("active_range"), minMax.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("u.min_key"), functions$.MODULE$.col("u.max_key")})).as("min-max")}));
        Dataset groupByMinMax = joinActiveByRange.groupBy("min-max", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.collect_set("unique_range").alias("unique_ranges"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.collect_set("active_range").alias("active_ranges")}));
        Dataset addresses = groupByMinMax.withColumn("addresses", left_anti_join_addresses.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("unique_ranges"), functions$.MODULE$.col("active_ranges")})));
        return addresses.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(functions$.MODULE$.col("addresses")).as("addresses")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("addresses._1").as("key"), functions$.MODULE$.col("addresses._2").as("address"), functions$.MODULE$.col("addresses._3").as("relative"), functions$.MODULE$.col("addresses._4").as("last_modified")}));
    }

    public Dataset<Row> getExpiredAddresses(String repo, String runID, String commitDFLocation, SparkSession spark, GarbageCollector.APIConfigurations conf) {
        Dataset<Row> commitsDF = this.getCommitsDF(runID, commitDFLocation, spark);
        Dataset<Row> rangesDF = this.getRangesDFFromCommits(commitsDF, repo, conf);
        Dataset<Row> expired = this.getExpiredEntriesFromRanges(rangesDF, conf, repo);
        Dataset activeRangesDF = rangesDF.where("!expired");
        return this.subtractDeduplications(expired, (Dataset<Row>)activeRangesDF, conf, repo, spark);
    }

    private Dataset<Row> subtractDeduplications(Dataset<Row> expired, Dataset<Row> activeRangesDF, GarbageCollector.APIConfigurations conf, String repo, SparkSession spark) {
        RDD activeRangesRDD = activeRangesDF.select("range_id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().distinct().map((Function1 & Serializable & scala.Serializable)x -> x.getString(0), ClassTag$.MODULE$.apply(String.class));
        RDD activeAddresses = activeRangesRDD.flatMap((Function1 & Serializable & scala.Serializable)range -> MODULE$.getRangeAddresses((String)range, conf, repo), ClassTag$.MODULE$.apply(String.class)).distinct();
        RDD activeAddressesRows = activeAddresses.map((Function1 & Serializable & scala.Serializable)x -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x})), ClassTag$.MODULE$.apply(Row.class));
        StructType schema = new StructType().add(new StructField("address", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
        Dataset activeDF = spark.createDataFrame(activeAddressesRows, schema);
        return expired.join(activeDF, expired.apply("address").$eq$eq$eq((Object)activeDF.apply("address")), "leftanti");
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        if (args.length != 2) {
            Console$.MODULE$.err().println("Usage: ... <repo_name> <region>");
            System.exit(1);
        }
        String repo = args[0];
        String region = args[1];
        String previousRunID = "";
        Configuration hc = spark.sparkContext().hadoopConfiguration();
        String apiURL = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_URL_KEY());
        String accessKey = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_ACCESS_KEY_KEY());
        String secretKey = hc.get(LakeFSContext$.MODULE$.LAKEFS_CONF_API_SECRET_KEY_KEY());
        GarbageCollectionPrepareResponse res = new ApiClient(apiURL, accessKey, secretKey).prepareGarbageCollectionCommits(repo, previousRunID);
        String runID = res.getRunId();
        String gcCommitsLocation = ApiClient$.MODULE$.translateS3(new URI(res.getGcCommitsLocation())).toString();
        String gcAddressesLocation = ApiClient$.MODULE$.translateS3(new URI(res.getGcAddressesLocation())).toString();
        Dataset expiredAddresses = this.getExpiredAddresses(repo, runID, gcCommitsLocation, spark, new GarbageCollector.APIConfigurations(apiURL, accessKey, secretKey)).withColumn("run_id", functions$.MODULE$.lit((Object)runID));
        spark.conf().set("spark.sql.sources.partitionOverwriteMode", "dynamic");
        expiredAddresses.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"run_id"})).mode(SaveMode.Overwrite).parquet(gcAddressesLocation);
        S3BulkDeleter$.MODULE$.remove(repo, gcAddressesLocation, runID, region, spark);
    }

    private static final long getSeconds$1(Option ts) {
        return ((Timestamp)ts.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)).seconds();
    }

    public static final /* synthetic */ boolean $anonfun$getExpiredEntriesFromRanges$2(byte[] aMin, byte[] aMax, byte[] bMin, byte[] bMax) {
        Ordering byteArrayOrdering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$3)).toIterable(), Ordering$.MODULE$.Iterable((Ordering)Ordering.Byte$.MODULE$));
        return byteArrayOrdering.compare((Object)aMin, (Object)bMax) <= 0 && byteArrayOrdering.compare((Object)bMin, (Object)aMax) <= 0;
    }

    private GarbageCollector$() {
        MODULE$ = this;
    }
}

