/*
 * Decompiled with CFR 0.152.
 */
package io.treeverse.clients;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.lakefs.clients.api.BranchesApi;
import io.lakefs.clients.api.CommitsApi;
import io.lakefs.clients.api.MetadataApi;
import io.lakefs.clients.api.RepositoriesApi;
import io.lakefs.clients.api.RetentionApi;
import io.lakefs.clients.api.model.Commit;
import io.lakefs.clients.api.model.GarbageCollectionPrepareRequest;
import io.lakefs.clients.api.model.GarbageCollectionPrepareResponse;
import io.lakefs.clients.api.model.Repository;
import io.lakefs.clients.api.model.StorageURI;
import io.treeverse.clients.ApiClient$;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=u!B\u0011#\u0011\u0013Ic!B\u0016#\u0011\u0013a\u0003\"B\u001a\u0002\t\u0003!\u0004\"B\u001b\u0002\t\u00031d\u0001B\u0016#\u0001\u0005C\u0001B\u0011\u0003\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u001d\u0012\u0011\t\u0011)A\u0005\u0007\"Aq\n\u0002B\u0001B\u0003%1\tC\u00034\t\u0011\u0005\u0001\u000bC\u0004V\t\t\u0007I\u0011\u0002,\t\r}#\u0001\u0015!\u0003X\u0011\u001d\u0001GA1A\u0005\n\u0005Da!\u001a\u0003!\u0002\u0013\u0011\u0007b\u00024\u0005\u0005\u0004%Ia\u001a\u0005\u0007W\u0012\u0001\u000b\u0011\u00025\t\u000f1$!\u0019!C\u0005[\"1\u0011\u000f\u0002Q\u0001\n9DqA\u001d\u0003C\u0002\u0013%1\u000f\u0003\u0004x\t\u0001\u0006I\u0001\u001e\u0005\bq\u0012\u0011\r\u0011\"\u0003z\u0011\u0019iH\u0001)A\u0005u\"9a\u0010\u0002b\u0001\n\u0013y\b\u0002CA\r\t\u0001\u0006I!!\u0001\u0007\r\u0005mA\u0001BA\u000f\u0011)\tYd\u0006BC\u0002\u0013\u0005\u0011Q\b\u0005\u000b\u0003\u000b:\"\u0011!Q\u0001\n\u0005}\u0002BB\u001a\u0018\t\u0003\t9\u0005C\u0004\u0002P]!\t!!\u0015\t\u000f\u0005MC\u0001\"\u0001\u0002V!9\u00111\f\u0003\u0005\u0002\u0005u\u0003bBA9\t\u0011\u0005\u00111\u000f\u0005\b\u0003w\"A\u0011AA?\u0011\u001d\t)\t\u0002C\u0001\u0003\u000f\u000b\u0011\"\u00119j\u00072LWM\u001c;\u000b\u0005\r\"\u0013aB2mS\u0016tGo\u001d\u0006\u0003K\u0019\n\u0011\u0002\u001e:fKZ,'o]3\u000b\u0003\u001d\n!![8\u0004\u0001A\u0011!&A\u0007\u0002E\tI\u0011\t]5DY&,g\u000e^\n\u0003\u00035\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001*\u0003-!(/\u00198tY\u0006$XmU\u001a\u0015\u0005]z\u0004C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\rqW\r\u001e\u0006\u0002y\u0005!!.\u0019<b\u0013\tq\u0014HA\u0002V%&CQ\u0001Q\u0002A\u0002]\n1!\u001e:j'\t!Q&\u0001\u0004ba&,&\u000f\u001c\t\u0003\t.s!!R%\u0011\u0005\u0019{S\"A$\u000b\u0005!C\u0013A\u0002\u001fs_>$h(\u0003\u0002K_\u00051\u0001K]3eK\u001aL!\u0001T'\u0003\rM#(/\u001b8h\u0015\tQu&A\u0005bG\u000e,7o]&fs\u0006I1/Z2sKR\\U-\u001f\u000b\u0005#J\u001bF\u000b\u0005\u0002+\t!)!\t\u0003a\u0001\u0007\")a\n\u0003a\u0001\u0007\")q\n\u0003a\u0001\u0007\u000611\r\\5f]R,\u0012a\u0016\t\u00031zk\u0011!\u0017\u0006\u00035n\u000b1!\u00199j\u0015\t\u0019CL\u0003\u0002^M\u00051A.Y6fMNL!aK-\u0002\u000f\rd\u0017.\u001a8uA\u0005y!/\u001a9pg&$xN]5fg\u0006\u0003\u0018.F\u0001c!\tA6-\u0003\u0002e3\ny!+\u001a9pg&$xN]5fg\u0006\u0003\u0018.\u0001\tsKB|7/\u001b;pe&,7/\u00119jA\u0005Q1m\\7nSR\u001c\u0018\t]5\u0016\u0003!\u0004\"\u0001W5\n\u0005)L&AC\"p[6LGo]!qS\u0006Y1m\\7nSR\u001c\u0018\t]5!\u0003-iW\r^1eCR\f\u0017\t]5\u0016\u00039\u0004\"\u0001W8\n\u0005AL&aC'fi\u0006$\u0017\r^1Ba&\fA\"\\3uC\u0012\fG/Y!qS\u0002\n1B\u0019:b]\u000eDWm]!qSV\tA\u000f\u0005\u0002Yk&\u0011a/\u0017\u0002\f\u0005J\fgn\u00195fg\u0006\u0003\u0018.\u0001\u0007ce\u0006t7\r[3t\u0003BL\u0007%\u0001\u0007sKR,g\u000e^5p]\u0006\u0003\u0018.F\u0001{!\tA60\u0003\u0002}3\na!+\u001a;f]RLwN\\!qS\u0006i!/\u001a;f]RLwN\\!qS\u0002\nQc\u001d;pe\u0006<WMT1nKN\u0004\u0018mY3DC\u000eDW-\u0006\u0002\u0002\u0002A1\u00111AA\u000b\u0007\u000ek!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0005\u0003\u0017\ti!\u0001\u0004d_6lwN\u001c\u0006\u0005\u0003\u001f\t\t\"\u0001\u0004h_><G.\u001a\u0006\u0003\u0003'\t1aY8n\u0013\u0011\t9\"!\u0002\u0003\u000b\r\u000b7\r[3\u0002-M$xN]1hK:\u000bW.Z:qC\u000e,7)Y2iK\u0002\u0012!bQ1mY\u0006\u0014G.\u001a$o'\u00159\u0012qDA\u0016!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013w\u0005!A.\u00198h\u0013\u0011\tI#a\t\u0003\r=\u0013'.Z2u!\u0015\ti#a\u000eD\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012AC2p]\u000e,(O]3oi*\u0019\u0011QG\u001e\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003s\tyC\u0001\u0005DC2d\u0017M\u00197f\u0003\t1g.\u0006\u0002\u0002@A!a&!\u0011D\u0013\r\t\u0019e\f\u0002\n\rVt7\r^5p]B\n1A\u001a8!)\u0011\tI%!\u0014\u0011\u0007\u0005-s#D\u0001\u0005\u0011\u001d\tYD\u0007a\u0001\u0003\u007f\tAaY1mYR\t1)A\nhKR\u001cFo\u001c:bO\u0016t\u0015-\\3ta\u0006\u001cW\rF\u0002D\u0003/Ba!!\u0017\u001d\u0001\u0004\u0019\u0015\u0001\u0003:fa>t\u0015-\\3\u0002?A\u0014X\r]1sK\u001e\u000b'OY1hK\u000e{G\u000e\\3di&|gnQ8n[&$8\u000f\u0006\u0004\u0002`\u0005-\u0014Q\u000e\t\u0005\u0003C\n9'\u0004\u0002\u0002d)\u0019\u0011QM-\u0002\u000b5|G-\u001a7\n\t\u0005%\u00141\r\u0002!\u000f\u0006\u0014(-Y4f\u0007>dG.Z2uS>t\u0007K]3qCJ,'+Z:q_:\u001cX\r\u0003\u0004\u0002Zu\u0001\ra\u0011\u0005\u0007\u0003_j\u0002\u0019A\"\u0002\u001bA\u0014XM^5pkN\u0014VO\\%E\u0003=9W\r^'fi\u0006\u0014\u0016M\\4f+JcE#B\"\u0002v\u0005]\u0004BBA-=\u0001\u00071\t\u0003\u0004\u0002zy\u0001\raQ\u0001\tG>lW.\u001b;J\t\u0006Yq-\u001a;SC:<W-\u0016*M)\u0015\u0019\u0015qPAA\u0011\u0019\tIf\ba\u0001\u0007\"1\u00111Q\u0010A\u0002\r\u000bqA]1oO\u0016LE)A\nhKR\u0014%/\u00198dQ\"+\u0015\tR\"p[6LG\u000fF\u0003D\u0003\u0013\u000bY\t\u0003\u0004\u0002Z\u0001\u0002\ra\u0011\u0005\u0007\u0003\u001b\u0003\u0003\u0019A\"\u0002\r\t\u0014\u0018M\\2i\u0001")
public class ApiClient {
    private final io.lakefs.clients.api.ApiClient client = new io.lakefs.clients.api.ApiClient();
    private final RepositoriesApi repositoriesApi;
    private final CommitsApi commitsApi;
    private final MetadataApi metadataApi;
    private final BranchesApi branchesApi;
    private final RetentionApi retentionApi;
    private final Cache<String, String> storageNamespaceCache;

    public static URI translateS3(URI uRI) {
        return ApiClient$.MODULE$.translateS3(uRI);
    }

    private io.lakefs.clients.api.ApiClient client() {
        return this.client;
    }

    private RepositoriesApi repositoriesApi() {
        return this.repositoriesApi;
    }

    private CommitsApi commitsApi() {
        return this.commitsApi;
    }

    private MetadataApi metadataApi() {
        return this.metadataApi;
    }

    private BranchesApi branchesApi() {
        return this.branchesApi;
    }

    private RetentionApi retentionApi() {
        return this.retentionApi;
    }

    private Cache<String, String> storageNamespaceCache() {
        return this.storageNamespaceCache;
    }

    public String getStorageNamespace(String repoName) {
        return (String)this.storageNamespaceCache().get((Object)repoName, (Callable)new CallableFn(this, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            Repository repo = this.repositoriesApi().getRepository(repoName);
            return ApiClient$.MODULE$.translateS3(URI.create(repo.getStorageNamespace())).normalize().toString();
        }));
    }

    public GarbageCollectionPrepareResponse prepareGarbageCollectionCommits(String repoName, String previousRunID) {
        return this.retentionApi().prepareGarbageCollectionCommits(repoName, new GarbageCollectionPrepareRequest().previousRunId(previousRunID));
    }

    public String getMetaRangeURL(String repoName, String commitID) {
        String string;
        String metaRangeID;
        Commit commit = this.commitsApi().getCommit(repoName, commitID);
        String string2 = metaRangeID = commit.getMetaRangeId();
        String string3 = "";
        if (string2 == null ? string3 != null : !string2.equals(string3)) {
            StorageURI metaRange = this.metadataApi().getMetaRange(repoName, metaRangeID);
            String location = metaRange.getLocation();
            string = URI.create(new StringBuilder(1).append(this.getStorageNamespace(repoName)).append("/").toString()).resolve(location).normalize().toString();
        } else {
            string = "";
        }
        return string;
    }

    public String getRangeURL(String repoName, String rangeID) {
        StorageURI range = this.metadataApi().getRange(repoName, rangeID);
        String location = range.getLocation();
        return URI.create(new StringBuilder(1).append(this.getStorageNamespace(repoName)).append("/").append(location).toString()).normalize().toString();
    }

    public String getBranchHEADCommit(String repoName, String branch) {
        return this.branchesApi().getBranch(repoName, branch).getCommitId();
    }

    public ApiClient(String apiUrl, String accessKey, String secretKey) {
        this.client().setUsername(accessKey);
        this.client().setPassword(secretKey);
        this.client().setBasePath(new StringOps(Predef$.MODULE$.augmentString(apiUrl)).stripSuffix("/"));
        this.repositoriesApi = new RepositoriesApi(this.client());
        this.commitsApi = new CommitsApi(this.client());
        this.metadataApi = new MetadataApi(this.client());
        this.branchesApi = new BranchesApi(this.client());
        this.retentionApi = new RetentionApi(this.client());
        this.storageNamespaceCache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).build();
    }

    public class CallableFn
    implements Callable<String> {
        private final Function0<String> fn;
        public final /* synthetic */ ApiClient $outer;

        public Function0<String> fn() {
            return this.fn;
        }

        @Override
        public String call() {
            return (String)this.fn().apply();
        }

        public /* synthetic */ ApiClient io$treeverse$clients$ApiClient$CallableFn$$$outer() {
            return this.$outer;
        }

        public CallableFn(ApiClient $outer, Function0<String> fn) {
            this.fn = fn;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

