/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.auth;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import io.lakefs.auth.GeneratePresignGetCallerIdentityRequest;
import io.lakefs.auth.GeneratePresignGetCallerIdentityResponse;
import io.lakefs.auth.GetCallerIdentityV4Presigner;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;

public class GetCallerIdentityV4PresignerTest {
    public static AWSSessionCredentials newMockAWSCreds() {
        return new AWSSessionCredentials(){

            public String getSessionToken() {
                return "sessionToken";
            }

            public String getAWSAccessKeyId() {
                return "accessKeyId";
            }

            public String getAWSSecretKey() {
                return "secretKey";
            }
        };
    }

    public static Map<String, String> getQueryParams(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                String[] keyValue = pair.split("=");
                if (keyValue.length != 2) continue;
                String key = keyValue[0];
                String value = keyValue[1];
                params.put(key, value);
            }
        }
        return params;
    }

    @Test
    public void testPresignAsURL() throws Exception {
        final AWSSessionCredentials awsCreds = GetCallerIdentityV4PresignerTest.newMockAWSCreds();
        GetCallerIdentityV4Presigner stsPresigner = new GetCallerIdentityV4Presigner();
        GeneratePresignGetCallerIdentityRequest stsReq = new GeneratePresignGetCallerIdentityRequest(new URI("https://sts.amazonaws.com"), (AWSCredentials)awsCreds, (Map)new HashMap<String, String>(){
            {
                this.put("X-Lakefs-Server-ID", "lakefs-host");
            }
        }, 60);
        GeneratePresignGetCallerIdentityResponse signedRequest = stsPresigner.presignRequest(stsReq);
        URL url = new URL(signedRequest.convertToURL());
        Assert.assertEquals((Object)"https", (Object)url.getProtocol());
        Assert.assertEquals((Object)"sts.amazonaws.com", (Object)url.getHost());
        Map<String, String> generatedQueryParams = GetCallerIdentityV4PresignerTest.getQueryParams(url.getQuery());
        HashMap paramsExpected = new HashMap(){
            {
                this.put("X-Amz-Date", "\\d{8}T\\d{6}Z");
                this.put("Action", "GetCallerIdentity");
                this.put("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
                this.put("X-Amz-Signature", "[a-f0-9]{64}");
                this.put("Version", "2011-06-15");
                this.put("X-Amz-SignedHeaders", "host%3Bx-lakefs-server-id");
                this.put("X-Amz-Security-Token", GetCallerIdentityV4Presigner.urlEncode((String)awsCreds.getSessionToken(), (boolean)false));
                this.put("X-Amz-Credential", awsCreds.getAWSAccessKeyId() + "%2F\\d{8}%2Fus-east-1%2Fsts%2Faws4_request");
                this.put("X-Amz-Expires", "60");
            }
        };
        for (Map.Entry entry : paramsExpected.entrySet()) {
            String expectedKey = (String)entry.getKey();
            String expectedValuePattern = (String)entry.getValue();
            Assert.assertEquals((String)String.format("missing param %s in URL %s", expectedKey, url), (Object)true, (Object)generatedQueryParams.containsKey(expectedKey));
            Pattern compiledPattern = Pattern.compile(expectedValuePattern);
            Matcher matcher = compiledPattern.matcher(generatedQueryParams.get(expectedKey));
            Assert.assertEquals((String)String.format("Query param %s does not match \npattern: %s", generatedQueryParams.get(expectedKey), expectedValuePattern), (Object)true, (Object)matcher.matches());
        }
    }
}

