/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.auth;

import io.lakefs.FSConfiguration;
import io.lakefs.auth.AWSLakeFSTokenProvider;
import io.lakefs.auth.LakeFSExternalPrincipalIdentityRequest;
import io.lakefs.auth.LakeFSTokenProviderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class AWSLakeFSTokenProviderTest {
    @Test
    public void testProviderIdentityTokenSerde() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("fs.lakefs.auth.provider", "io.lakefs.auth.TemporaryAWSCredentialsLakeFSTokenProvider");
        conf.set("fs.lakefs.token.aws.access.key", "accessKeyId");
        conf.set("fs.lakefs.token.aws.secret.key", "secretAccessKey");
        conf.set("fs.lakefs.token.aws.session.token", "sessionToken");
        conf.set("fs.lakefs.token.aws.sts.endpoint", "https://sts.amazonaws.com");
        AWSLakeFSTokenProvider provider = (AWSLakeFSTokenProvider)LakeFSTokenProviderFactory.newLakeFSTokenProvider((String)"lakefs", (Configuration)conf);
        String identityToken = provider.newPresignedGetCallerIdentityToken();
        String decodedToken = new String(Base64.decodeBase64((byte[])identityToken.getBytes()));
        LakeFSExternalPrincipalIdentityRequest request = LakeFSExternalPrincipalIdentityRequest.fromJSON((String)decodedToken);
        Assert.assertEquals((Object)"POST", (Object)request.getMethod());
        Assert.assertEquals((Object)"sts.amazonaws.com", (Object)request.getHost());
        Assert.assertEquals((Object)"us-east-1", (Object)request.getRegion());
        Assert.assertEquals((Object)"GetCallerIdentity", (Object)request.getAction());
        Assert.assertTrue((boolean)request.getDate().matches("\\d{8}T\\d{6}Z"));
        Assert.assertEquals((Object)"60", (Object)request.getExpirationDuration());
        Assert.assertEquals((Object)FSConfiguration.get((Configuration)conf, (String)"lakefs", (String)"token.aws.access.key"), (Object)request.getAccessKeyId());
        Assert.assertTrue((boolean)request.getSignature().matches("[0-9a-fA-F]{64}"));
        Assert.assertEquals((Object)"host", request.getSignedHeaders().get(0));
        Assert.assertEquals((Object)"x-lakefs-server-id", request.getSignedHeaders().get(1));
        Assert.assertEquals((Object)"2011-06-15", (Object)request.getVersion());
        Assert.assertEquals((Object)"AWS4-HMAC-SHA256", (Object)request.getAlgorithm());
        Assert.assertEquals((Object)FSConfiguration.get((Configuration)conf, (String)"lakefs", (String)"token.aws.session.token"), (Object)request.getSecurityToken());
    }
}

