/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import io.lakefs.LakeFSClient;
import io.lakefs.LakeFSFileSystem;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.StagingApi;
import io.lakefs.clients.sdk.model.StagingLocation;
import io.lakefs.clients.sdk.model.StagingMetadata;
import io.lakefs.utils.ObjectLocation;
import java.io.IOException;
import org.apache.hadoop.fs.Path;

public class LakeFSLinker {
    private final StagingLocation stagingLocation;
    private final ObjectLocation objectLoc;
    private final LakeFSFileSystem lfs;
    private final LakeFSClient lakeFSClient;
    private final boolean overwrite;

    public LakeFSLinker(LakeFSFileSystem lfs, LakeFSClient lfsClient, ObjectLocation objectLoc, StagingLocation stagingLocation, boolean overwrite) {
        this.objectLoc = objectLoc;
        this.stagingLocation = stagingLocation;
        this.lfs = lfs;
        this.lakeFSClient = lfsClient;
        this.overwrite = overwrite;
    }

    public void link(String eTag, long byteSize) throws IOException {
        StagingApi staging = this.lakeFSClient.getStagingApi();
        StagingMetadata stagingMetadata = new StagingMetadata().checksum(eTag).sizeBytes(Long.valueOf(byteSize)).staging(this.stagingLocation);
        try {
            StagingApi.APIlinkPhysicalAddressRequest request = staging.linkPhysicalAddress(this.objectLoc.getRepository(), this.objectLoc.getRef(), this.objectLoc.getPath(), stagingMetadata);
            if (!this.overwrite) {
                request.ifNoneMatch("*");
            }
            request.execute();
        }
        catch (ApiException e) {
            throw new IOException("link lakeFS path to physical address", e);
        }
        this.lfs.deleteEmptyDirectoryMarkers(new Path(this.objectLoc.toString()).getParent());
    }
}

