/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.model.ObjectErrorList;
import io.lakefs.clients.sdk.model.PathList;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class BulkDeleter
implements Closeable {
    private static final int defaultBulkSize = 1000;
    private final ExecutorService executor;
    private final Callback callback;
    private final String repository;
    private final String branch;
    private final int bulkSize;
    private PathList pathList;
    private final int concurrency = 1;
    private Queue<Future<ObjectErrorList>> deletions = new ArrayDeque<Future<ObjectErrorList>>();

    BulkDeleter(ExecutorService executor, Callback callback, String repository, String branch, int bulkSize) {
        this.executor = executor;
        this.callback = callback;
        this.repository = repository;
        this.branch = branch;
        if (bulkSize <= 0) {
            bulkSize = 1000;
        }
        this.bulkSize = bulkSize;
    }

    BulkDeleter(ExecutorService executor, Callback callback, String repository, String branch) {
        this(executor, callback, repository, branch, 1000);
    }

    public synchronized void add(String key) throws IOException, DeleteFailuresException {
        if (this.pathList == null) {
            this.pathList = new PathList();
        }
        this.pathList.addPathsItem(key);
        if (this.pathList.getPaths().size() >= this.bulkSize) {
            this.startDeletingUnlocked();
        }
    }

    @Override
    public synchronized void close() throws IOException, DeleteFailuresException {
        if (this.pathList != null && !this.pathList.getPaths().isEmpty()) {
            this.startDeletingUnlocked();
        }
        this.drainDeletionsUnlocked();
    }

    private void startDeletingUnlocked() throws IOException, DeleteFailuresException {
        this.maybeWaitForDeletionUnlocked();
        final PathList toDelete = this.pathList;
        this.pathList = null;
        this.deletions.add(this.executor.submit(new Callable(){

            public ObjectErrorList call() throws ApiException, InterruptedException, DeleteFailuresException {
                ObjectErrorList ret = BulkDeleter.this.callback.apply(BulkDeleter.this.repository, BulkDeleter.this.branch, toDelete);
                return ret;
            }
        }));
    }

    private void maybeWaitForDeletionUnlocked() throws DeleteFailuresException, IOException {
        while (this.deletions.size() >= 1) {
            this.waitForOneDeletionUnlocked();
        }
    }

    private void drainDeletionsUnlocked() throws DeleteFailuresException, IOException {
        while (!this.deletions.isEmpty()) {
            this.waitForOneDeletionUnlocked();
        }
    }

    private void waitForOneDeletionUnlocked() throws DeleteFailuresException, IOException {
        try {
            Future<ObjectErrorList> deletion = this.deletions.poll();
            if (deletion == null) {
                return;
            }
            ObjectErrorList errors = deletion.get();
            if (errors != null && errors.getErrors() != null && !errors.getErrors().isEmpty()) {
                throw new DeleteFailuresException(errors);
            }
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new IOException("failed to wait for bulk delete", cause);
        }
        catch (InterruptedException ie) {
            throw new IOException("wait for deletion", ie);
        }
    }

    public static class DeleteFailuresException
    extends IOException {
        public DeleteFailuresException(ObjectErrorList errorList) {
            super("failed to delete: " + errorList.toString());
        }
    }

    public static interface Callback {
        public ObjectErrorList apply(String var1, String var2, PathList var3) throws ApiException;
    }
}

