/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.storage;

import io.lakefs.storage.HttpRangeInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HttpRangeInputStreamTest {
    final Dispatcher dispatcher = new Dispatcher(){
        Map<Integer, String> contentByLength = new HashMap<Integer, String>();

        public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
            int contentLength = Integer.valueOf(StringUtils.substringAfterLast((String)request.getPath(), (String)"/"));
            String content = this.contentByLength.get(contentLength);
            if (content == null) {
                content = RandomStringUtils.randomAlphanumeric((int)contentLength);
            }
            String[] range = StringUtils.substringAfter((String)request.getHeader("Range"), (String)"bytes=").split("-");
            int start = Integer.valueOf(range[0]);
            int end = Integer.valueOf(range[1]);
            return new MockResponse().setHeader("Content-Range", (Object)String.format("bytes %d-%d/%d", start, end, contentLength)).setResponseCode(200).setBody(content.substring(start, end));
        }
    };
    private MockWebServer server;

    @Before
    public void init() throws Exception {
        this.server = new MockWebServer();
        this.server.setDispatcher(this.dispatcher);
        this.server.start(1080);
    }

    @After
    public void tearDown() throws Exception {
        this.server.shutdown();
    }

    @Test
    public void testReadBigBuffer() throws IOException {
        HttpUrl url = this.server.url("/100");
        HttpRangeInputStream stream = new HttpRangeInputStream(url.toString(), 1000);
        byte[] buffer = new byte[25];
        IOUtils.readFully((InputStream)stream, (byte[])buffer);
        Assert.assertEquals((long)25L, (long)stream.getPos());
        Assert.assertEquals((long)75L, (long)stream.available());
        buffer = new byte[75];
        IOUtils.readFully((InputStream)stream, (byte[])buffer);
        Assert.assertEquals((long)100L, (long)stream.getPos());
        Assert.assertEquals((long)0L, (long)stream.available());
        stream.close();
    }

    @Test
    public void testReadSmallBuffer() throws IOException {
        HttpUrl url = this.server.url("/100");
        HttpRangeInputStream stream = new HttpRangeInputStream(url.toString(), 7);
        byte[] buffer = new byte[25];
        IOUtils.readFully((InputStream)stream, (byte[])buffer);
        Assert.assertEquals((long)25L, (long)stream.getPos());
        Assert.assertEquals((long)75L, (long)stream.available());
        buffer = new byte[75];
        IOUtils.readFully((InputStream)stream, (byte[])buffer);
        Assert.assertEquals((long)100L, (long)stream.getPos());
        Assert.assertEquals((long)0L, (long)stream.available());
        stream.close();
    }

    @Test
    public void testEmptyFile() throws IOException {
        HttpUrl url = this.server.url("/0");
        HttpRangeInputStream stream = new HttpRangeInputStream(url.toString(), 1000);
        Assert.assertEquals((long)0L, (long)stream.getPos());
        Assert.assertEquals((long)0L, (long)stream.available());
        byte[] buffer = new byte[]{};
        IOUtils.readFully((InputStream)stream, (byte[])buffer);
        Assert.assertEquals((long)0L, (long)stream.getPos());
        Assert.assertEquals((long)0L, (long)stream.available());
        stream.close();
    }

    @Test
    public void testSeek() throws IOException {
        HttpUrl url = this.server.url("/100");
        HttpRangeInputStream stream = new HttpRangeInputStream(url.toString(), 7);
        byte[] buffer = new byte[3];
        stream.seek(20L);
        Assert.assertEquals((long)20L, (long)stream.getPos());
        Assert.assertEquals((long)80L, (long)stream.available());
        IOUtils.readFully((InputStream)stream, (byte[])buffer);
        Assert.assertEquals((long)23L, (long)stream.getPos());
        Assert.assertEquals((long)77L, (long)stream.available());
        stream.seek(60L);
        Assert.assertEquals((long)60L, (long)stream.getPos());
        Assert.assertEquals((long)40L, (long)stream.available());
        IOUtils.readFully((InputStream)stream, (byte[])buffer);
        Assert.assertEquals((long)63L, (long)stream.getPos());
        Assert.assertEquals((long)37L, (long)stream.available());
        stream.seek(97L);
        Assert.assertEquals((long)97L, (long)stream.getPos());
        Assert.assertEquals((long)3L, (long)stream.available());
        IOUtils.readFully((InputStream)stream, (byte[])buffer);
        Assert.assertEquals((long)100L, (long)stream.getPos());
        Assert.assertEquals((long)0L, (long)stream.available());
        Assert.assertEquals((long)4L, (long)this.server.getRequestCount());
        stream.close();
    }

    @Test
    public void testSeekAfterEnd() throws IOException {
        HttpUrl url = this.server.url("/100");
        HttpRangeInputStream stream = new HttpRangeInputStream(url.toString(), 7);
        stream.seek(101L);
        Assert.assertEquals((long)-1L, (long)stream.read());
        stream.close();
    }

    @Test
    public void testSeekBeforeStart() throws IOException {
        HttpUrl url = this.server.url("/100");
        HttpRangeInputStream stream = new HttpRangeInputStream(url.toString(), 7);
        Exception exception = (Exception)Assert.assertThrows(EOFException.class, () -> stream.seek(-1L));
        Assert.assertTrue((String)String.format("Exception message should contain %s", "Cannot seek to a negative offset"), (boolean)exception.getMessage().contains("Cannot seek to a negative offset"));
        stream.close();
    }
}

