/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.lakefs.FSTestBase;
import io.lakefs.clients.sdk.model.StagingLocation;
import java.io.InputStream;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.utility.DockerImageName;

public abstract class S3FSTestBase
extends FSTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(S3FSTestBase.class);
    protected String s3Endpoint;
    protected AmazonS3 s3Client;
    private static final DockerImageName MINIO = DockerImageName.parse((String)"minio/minio:RELEASE.2021-06-07T21-40-51Z");
    @Rule
    public final GenericContainer s3 = new GenericContainer(MINIO.toString()).withCommand(new String[]{"minio", "server", "/data"}).withEnv("MINIO_ROOT_USER", "AKIArootkey").withEnv("MINIO_ROOT_PASSWORD", "secret/minio/key=").withEnv("MINIO_DOMAIN", "s3.local.lakefs.io").withEnv("MINIO_UPDATE", "off").withExposedPorts(new Integer[]{9000});

    @Before
    public void logS3Container() {
        Logger s3Logger = LoggerFactory.getLogger((String)"s3 container");
        Slf4jLogConsumer logConsumer = new Slf4jLogConsumer(s3Logger).withMdc("container", "s3").withSeparateOutputStreams();
        this.s3.followOutput((Consumer)logConsumer);
    }

    public void s3ClientSetup() {
        BasicAWSCredentials creds = new BasicAWSCredentials("AKIArootkey", "secret/minio/key=");
        ClientConfiguration clientConfiguration = new ClientConfiguration().withSignerOverride("AWSS3V4SignerType");
        this.s3Endpoint = String.format("http://s3.local.lakefs.io:%d", this.s3.getMappedPort(9000));
        this.s3Client = new AmazonS3Client((AWSCredentials)creds, clientConfiguration);
        S3ClientOptions s3ClientOptions = new S3ClientOptions().withPathStyleAccess(true);
        this.s3Client.setS3ClientOptions(s3ClientOptions);
        this.s3Client.setEndpoint(this.s3Endpoint);
        this.s3Bucket = S3FSTestBase.makeS3BucketName();
        this.s3Base = String.format("s3://%s/", this.s3Bucket);
        LOG.info("S3: bucket {} => base URL {}", (Object)this.s3Bucket, (Object)this.s3Base);
        CreateBucketRequest cbr = new CreateBucketRequest(this.s3Bucket);
        this.s3Client.createBucket(cbr);
    }

    protected List<String> getS3FilesByPrefix(String prefix) {
        ListObjectsRequest req = new ListObjectsRequest().withBucketName(this.s3Bucket).withPrefix(prefix).withDelimiter(null);
        ObjectListing listing = this.s3Client.listObjects(req);
        List summaries = listing.getObjectSummaries();
        if (listing.isTruncated()) {
            Assert.fail((String)String.format("[internal] no support for test that creates >%d S3 objects", listing.getMaxKeys()));
        }
        return Lists.transform((List)summaries, S3ObjectSummary::getKey);
    }

    protected void assertS3Object(StagingLocation stagingLocation, String contents) {
        String s3Key = this.getS3Key(stagingLocation);
        Object actualFiles = ImmutableList.of((Object)"<not yet listed>");
        try (S3Object obj = this.s3Client.getObject(new GetObjectRequest(this.s3Bucket, "/" + s3Key));){
            actualFiles = this.getS3FilesByPrefix("");
            String actual = IOUtils.toString((InputStream)obj.getObjectContent());
            Assert.assertEquals((Object)contents, (Object)actual);
            Assert.assertEquals((Object)ImmutableList.of((Object)s3Key), (Object)actualFiles);
        }
        catch (Exception e) {
            throw new RuntimeException("Files " + actualFiles + "; read key " + s3Key + " failed", e);
        }
    }

    @Override
    protected void moreHadoopSetup() {
        this.s3ClientSetup();
        this.conf.set("fs.s3a.impl", "org.apache.hadoop.fs.s3a.S3AFileSystem");
        this.conf.set("fs.s3a.access.key", "AKIArootkey");
        this.conf.set("fs.s3a.secret.key", "secret/minio/key=");
        this.conf.set("fs.s3a.endpoint", this.s3Endpoint);
        this.conf.set("fs.s3a.buffer.dir", "/tmp/s3a");
    }
}

