/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import com.google.common.collect.ImmutableMap;
import io.lakefs.FSTestBase;
import io.lakefs.ImmutablePagination;
import io.lakefs.LakeFSFileStatus;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.model.ObjectCopyCreation;
import io.lakefs.clients.sdk.model.ObjectError;
import io.lakefs.clients.sdk.model.ObjectStats;
import io.lakefs.clients.sdk.model.PathList;
import io.lakefs.utils.ObjectLocation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Test;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;
import org.mockserver.model.RequestDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LakeFSFileSystemServerTest
extends FSTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(LakeFSFileSystemServerTest.class);

    protected String objectLocToS3ObjKey(ObjectLocation objectLoc) {
        return String.format("/%s/%s/%s", objectLoc.getRepository(), objectLoc.getRef(), objectLoc.getPath());
    }

    @Test
    public void getUri() {
        URI u = this.fs.getUri();
        Assert.assertNotNull((Object)u);
    }

    @Test
    public void testUnknownProperties() throws IOException {
        Path path = new Path("lakefs://repo/main/file");
        ImmutableMap fakeObjectStats = ImmutableMap.of((Object)"unknown-key", (Object)"ignored", (Object)"checksum", (Object)"0", (Object)"physical_address", (Object)"/i", (Object)"path", (Object)"file", (Object)"path_type", (Object)"object", (Object)"mtime", (Object)"0");
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("GET").withPath("/repositories/repo/refs/main/objects/stat").withQueryStringParameter("path", new String[]{"file"})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody((BodyWithContentType)JsonBody.json((String)this.gson.toJson((Object)fakeObjectStats))));
        LakeFSFileStatus fileStatus = this.fs.getFileStatus(path);
        Assert.assertEquals((Object)path, (Object)fileStatus.getPath());
    }

    @Test
    public void testGetFileStatus_ExistingFile() throws IOException {
        Path path = new Path("lakefs://repo/main/mock/exists");
        this.mockStatObject("repo", "main", "mock/exists", this.makeObjectStats("mock/exists"));
        LakeFSFileStatus fileStatus = this.fs.getFileStatus(path);
        Assert.assertTrue((boolean)fileStatus.isFile());
        Assert.assertEquals((Object)path, (Object)fileStatus.getPath());
    }

    @Test
    public void testGetFileStatus_NoFile() {
        Path noFilePath = new Path("lakefs://repo/main/no.file");
        this.mockStatObjectNotFound("repo", "main", "no.file");
        this.mockStatObjectNotFound("repo", "main", "no.file/");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("no.file/").amount(1).build(), new ObjectStats[0]);
        Assert.assertThrows(FileNotFoundException.class, () -> this.fs.getFileStatus(noFilePath));
    }

    @Test
    public void testGetFileStatus_DirectoryMarker() throws IOException {
        Path dirPath = new Path("lakefs://repo/main/dir1/dir2");
        this.mockStatObjectNotFound("repo", "main", "dir1/dir2");
        ObjectStats stats = this.makeObjectStats("dir1/dir2/");
        this.mockStatObject("repo", "main", "dir1/dir2/", stats);
        LakeFSFileStatus dirStatus = this.fs.getFileStatus(dirPath);
        Assert.assertTrue((boolean)dirStatus.isDirectory());
        Assert.assertEquals((Object)dirPath, (Object)dirStatus.getPath());
    }

    @Test
    public void testExists_ExistsAsObject() throws IOException {
        Path path = new Path("lakefs://repo/main/exis.ts");
        ObjectStats stats = this.makeObjectStats("exis.ts");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("exis.ts").build(), stats);
        Assert.assertTrue((boolean)this.fs.exists(path));
    }

    @Test
    public void testExists_ExistsAsDirectoryMarker() throws IOException {
        Path path = new Path("lakefs://repo/main/exis.ts");
        ObjectStats stats = this.makeObjectStats("exis.ts");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("exis.ts").build(), stats);
        Assert.assertTrue((boolean)this.fs.exists(path));
    }

    @Test
    public void testExists_ExistsAsDirectoryContents() throws IOException {
        Path path = new Path("lakefs://repo/main/exis.ts");
        ObjectStats stats = this.makeObjectStats("exis.ts/object-inside-the-path");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("exis.ts").build(), stats);
        Assert.assertTrue((boolean)this.fs.exists(path));
    }

    @Test
    public void testExists_ExistsAsDirectoryInSecondList() throws IOException {
        Path path = new Path("lakefs://repo/main/exis.ts");
        ObjectStats beforeStats1 = this.makeObjectStats("exis.ts!");
        ObjectStats beforeStats2 = this.makeObjectStats("exis.ts$x");
        ObjectStats indirStats = this.makeObjectStats("exis.ts/object-inside-the-path");
        this.mockListingWithHasMore("repo", "main", ImmutablePagination.builder().prefix("exis.ts").build(), true, beforeStats1, beforeStats2);
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("exis.ts/").build(), indirStats);
        Assert.assertTrue((boolean)this.fs.exists(path));
    }

    @Test
    public void testExists_NotExistsNoPrefix() throws IOException {
        Path path = new Path("lakefs://repo/main/doesNotExi.st");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("doesNotExi.st").build(), new ObjectStats[0]);
        Assert.assertFalse((boolean)this.fs.exists(path));
    }

    @Test
    public void testExists_NotExistsPrefixWithNoSlash() {
    }

    @Test
    public void testExists_NotExistsPrefixWithNoSlashTwoLists() {
    }

    @Test
    public void testDelete_FileExists() throws IOException {
        String[] arrDirs;
        this.mockStatObject("repo", "main", "no/place/file.txt", this.makeObjectStats("delete/sample/file.txt"));
        for (String dir : arrDirs = new String[]{"no/place", "no"}) {
            this.mockStatObjectNotFound("repo", "main", dir);
            this.mockStatObjectNotFound("repo", "main", dir + "/");
            this.mockListing("repo", "main", ImmutablePagination.builder().build(), new ObjectStats[0]);
        }
        this.mockDeleteObject("repo", "main", "no/place/file.txt");
        this.mockUploadObject("repo", "main", "no/place/");
        Path path = new Path("lakefs://repo/main/no/place/file.txt");
        this.mockDirectoryMarker(ObjectLocation.pathToObjectLocation(null, (Path)path.getParent()));
        Assert.assertTrue((boolean)this.fs.delete(path, false));
    }

    @Test
    public void testDelete_FileNotExists() throws IOException {
        this.mockDeleteObjectNotFound("repo", "main", "no/place/file.txt");
        this.mockStatObjectNotFound("repo", "main", "no/place/file.txt");
        this.mockStatObjectNotFound("repo", "main", "no/place/file.txt/");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("no/place/file.txt/").build(), new ObjectStats[0]);
        this.mockUploadObject("repo", "main", "no/place/");
        Assert.assertFalse((boolean)this.fs.delete(new Path("lakefs://repo/main/no/place/file.txt"), false));
    }

    @Test
    public void testDelete_EmptyDirectoryExists() throws IOException {
        ObjectLocation dirObjLoc = new ObjectLocation("lakefs", "repo", "main", "delete/me");
        this.mockStatObjectNotFound(dirObjLoc.getRepository(), dirObjLoc.getRef(), dirObjLoc.getPath());
        ObjectStats srcStats = this.makeObjectStats(dirObjLoc.getPath() + "/");
        this.mockStatObject(dirObjLoc.getRepository(), dirObjLoc.getRef(), dirObjLoc.getPath() + "/", srcStats);
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("delete/me/").build(), srcStats);
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("delete/").build(), new ObjectStats[0]);
        this.mockDirectoryMarker(dirObjLoc.getParent());
        this.mockStatObject(dirObjLoc.getRepository(), dirObjLoc.getRef(), dirObjLoc.getPath(), srcStats);
        this.mockDeleteObject("repo", "main", "delete/me/");
        this.mockUploadObject("repo", "main", "delete/");
        Path path = new Path("lakefs://repo/main/delete/me");
        Assert.assertTrue((boolean)this.fs.delete(path, false));
    }

    @Test
    public void testDelete_DirectoryWithFile() throws IOException {
        String directoryPath = "delete/sample";
        String existingPath = "delete/sample/file.txt";
        String directoryToDelete = "lakefs://repo/main/delete/sample";
        this.mockStatObjectNotFound("repo", "main", directoryPath);
        this.mockStatObjectNotFound("repo", "main", directoryPath + "/");
        ObjectStats srcStats = this.makeObjectStats(existingPath);
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix(directoryPath + "/").build(), srcStats);
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("DELETE")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(400)).withBody("Should not delete anything"));
        Exception e = (Exception)Assert.assertThrows(IOException.class, () -> this.fs.delete(new Path(directoryToDelete), false));
        String failureMessage = String.format("Path is a non-empty directory: %s", directoryToDelete);
        Assert.assertThat((Object)e.getMessage(), (Matcher)new StringContains(failureMessage));
    }

    @Test
    public void testDelete_NotExistsRecursive() throws IOException {
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("GET").withPath("/repositories/repo/refs/main/objects/stat")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(404)));
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("no/place/file.txt/").build(), new ObjectStats[0]);
        Assert.assertFalse((boolean)this.fs.delete(new Path("lakefs://repo/main/no/place/file.txt"), true));
    }

    @Test
    public void testDelete_DirectoryWithFileRecursive() throws IOException {
        this.mockStatObjectNotFound("repo", "main", "delete/sample");
        this.mockStatObjectNotFound("repo", "main", "delete/sample/");
        ObjectStats stats = this.makeObjectStats("delete/sample/file.txt");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("delete/sample/").build(), stats);
        this.mockDeleteObjects("repo", "main", "delete/sample/file.txt", new ObjectError[0]);
        Path path = new Path("lakefs://repo/main/delete/sample");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("delete/").build(), new ObjectStats[0]);
        this.mockDirectoryMarker(ObjectLocation.pathToObjectLocation(null, (Path)path.getParent()));
        this.mockUploadObject("repo", "main", "delete/");
        boolean delete = this.fs.delete(path, true);
        Assert.assertTrue((boolean)delete);
    }

    protected void caseDeleteDirectoryRecursive(int bulkSize, int numObjects) throws IOException {
        this.conf.setInt("fs.lakefs.delete.bulk_size", bulkSize);
        this.mockStatObjectNotFound("repo", "main", "delete/sample");
        this.mockStatObjectNotFound("repo", "main", "delete/sample/");
        ObjectStats[] objects = new ObjectStats[numObjects];
        for (int i = 0; i < numObjects; ++i) {
            objects[i] = this.makeObjectStats(String.format("delete/sample/file%04d.txt", i));
        }
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("delete/sample/").build(), objects);
        for (int start = 0; start < numObjects; start += bulkSize) {
            PathList pl = new PathList();
            for (int i = start; i < numObjects && i < start + bulkSize; ++i) {
                pl.addPathsItem(String.format("delete/sample/file%04d.txt", i));
            }
            this.mockDeleteObjects("repo", "main", pl, new ObjectError[0]);
        }
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("delete/").build(), new ObjectStats[0]);
        this.mockUploadObject("repo", "main", "delete/");
        Assert.assertTrue((boolean)this.fs.delete(new Path("lakefs://repo/main/delete/sample"), true));
    }

    @Test
    public void testDeleteDirectoryRecursiveBatch1() throws IOException {
        this.caseDeleteDirectoryRecursive(1, 123);
    }

    @Test
    public void testDeleteDirectoryRecursiveBatch2() throws IOException {
        this.caseDeleteDirectoryRecursive(2, 123);
    }

    @Test
    public void testDeleteDirectoryRecursiveBatch3() throws IOException {
        this.caseDeleteDirectoryRecursive(3, 123);
    }

    @Test
    public void testDeleteDirectoryRecursiveBatch5() throws IOException {
        this.caseDeleteDirectoryRecursive(5, 123);
    }

    @Test
    public void testDeleteDirectoryRecursiveBatch120() throws IOException {
        this.caseDeleteDirectoryRecursive(120, 123);
    }

    @Test
    public void testDeleteDirectoryRecursiveBatch123() throws IOException {
        this.caseDeleteDirectoryRecursive(123, 123);
    }

    @Test
    public void testListStatusFile() throws IOException {
        ObjectStats objectStats = this.makeObjectStats("status/file");
        this.mockStatObject("repo", "main", "status/file", objectStats);
        Path path = new Path("lakefs://repo/main/status/file");
        Object[] fileStatuses = this.fs.listStatus(path);
        LakeFSFileStatus expectedFileStatus = new LakeFSFileStatus.Builder(path).length(STATUS_FILE_SIZE.longValue()).checksum("status").mTime(STATUS_MTIME.longValue()).physicalAddress(this.s3Url("/repo-base/status")).blockSize(0x2000000L).build();
        Object[] expectedFileStatuses = new LakeFSFileStatus[]{expectedFileStatus};
        Assert.assertArrayEquals((Object[])expectedFileStatuses, (Object[])fileStatuses);
    }

    @Test
    public void testListStatusNotFound() throws ApiException {
        this.mockStatObjectNotFound("repo", "main", "status/file");
        this.mockStatObjectNotFound("repo", "main", "status/file/");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("status/file/").build(), new ObjectStats[0]);
        Path path = new Path("lakefs://repo/main/status/file");
        Assert.assertThrows(FileNotFoundException.class, () -> this.fs.listStatus(path));
    }

    @Test
    public void testListStatusDirectory() throws IOException {
        int totalObjectsCount = 3;
        ObjectStats[] objects = new ObjectStats[3];
        for (int i = 0; i < totalObjectsCount; ++i) {
            objects[i] = this.makeObjectStats("status/file" + i);
        }
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("status/").build(), objects);
        this.mockStatObjectNotFound("repo", "main", "status");
        Path dir = new Path("lakefs://repo/main/status");
        Object[] fileStatuses = this.fs.listStatus(dir);
        Object[] expectedFileStatuses = new LocatedFileStatus[totalObjectsCount];
        for (int i = 0; i < totalObjectsCount; ++i) {
            Path p = new Path(dir + "/file" + i);
            LakeFSFileStatus fileStatus = new LakeFSFileStatus.Builder(p).length(STATUS_FILE_SIZE.longValue()).checksum("status").mTime(STATUS_MTIME.longValue()).blockSize(0x2000000L).physicalAddress(this.s3Url("/repo-base/status" + i)).build();
            expectedFileStatuses[i] = new LocatedFileStatus((FileStatus)fileStatus, null);
        }
        Assert.assertArrayEquals((Object[])expectedFileStatuses, (Object[])fileStatuses);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAppend() throws IOException {
        this.fs.append(null, 0, null);
    }

    @Test
    public void testRename_existingFileToNonExistingDst() throws IOException, ApiException {
        Path src = new Path("lakefs://repo/main/existing.src");
        ObjectStats stats = this.makeObjectStats("existing.src");
        this.mockStatObject("repo", "main", "existing.src", stats);
        Path dst = new Path("lakefs://repo/main/non-existing/new");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("non-existing/").build(), new ObjectStats[0]);
        this.mockStatObjectNotFound("repo", "main", "non-existing/new");
        this.mockStatObjectNotFound("repo", "main", "non-existing/new/");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("non-existing/new/").build(), new ObjectStats[0]);
        this.mockStatObjectNotFound("repo", "main", "non-existing");
        this.mockStatObjectNotFound("repo", "main", "non-existing/");
        boolean renamed = this.fs.rename(src, dst);
        Assert.assertFalse((boolean)renamed);
    }

    @Test
    public void testRename_existingFileToExistingFileName() throws IOException {
        Path src = new Path("lakefs://repo/main/existing.src");
        ObjectStats srcStats = this.makeObjectStats("existing.src");
        this.mockStatObject("repo", "main", "existing.src", srcStats);
        Path dst = new Path("lakefs://repo/main/existing.dst");
        ObjectStats dstStats = this.makeObjectStats("existing.dst");
        this.mockStatObject("repo", "main", "existing.dst", dstStats);
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("POST").withPath("/repositories/repo/branches/main/objects/copy").withQueryStringParameter("dest_path", new String[]{"existing.dst"}).withBody((Body)JsonBody.json((String)this.gson.toJson((Object)new ObjectCopyCreation().srcRef("main").srcPath("existing.src"))))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(201)).withBody((BodyWithContentType)JsonBody.json((String)this.gson.toJson((Object)dstStats))));
        this.mockDeleteObject("repo", "main", "existing.src");
        Assert.assertTrue((boolean)this.fs.rename(src, dst));
    }

    @Test
    public void testRename_existingDirToExistingFileName() throws IOException {
        Path fileInSrcDir = new Path("lakefs://repo/main/existing-dir/existing.src");
        ObjectStats srcStats = this.makeObjectStats("existing-dir/existing.src");
        Path srcDir = new Path("lakefs://repo/main/existing-dir");
        this.mockStatObjectNotFound("repo", "main", "existing-dir");
        this.mockStatObjectNotFound("repo", "main", "existing-dir/");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("existing-dir/").build(), srcStats);
        Path dst = new Path("lakefs://repo/main/existingdst.file");
        ObjectStats dstStats = this.makeObjectStats("existingdst.file");
        this.mockStatObject("repo", "main", "existingdst.file", dstStats);
        Assert.assertFalse((boolean)this.fs.rename(srcDir, dst));
    }

    @Test
    public void testRename_existingFileToExistingDirName() throws IOException {
        Path src = new Path("lakefs://repo/main/existing-dir1/existing.src");
        ObjectStats srcStats = this.makeObjectStats("existing-dir1/existing.src");
        this.mockStatObject("repo", "main", "existing-dir1/existing.src", srcStats);
        ObjectStats dstStats = this.makeObjectStats("existing-dir2/existing.src");
        this.mockFileDoesNotExist("repo", "main", "existing-dir2");
        this.mockFileDoesNotExist("repo", "main", "existing-dir2/");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("existing-dir2/").build(), dstStats);
        Path dst = new Path("lakefs://repo/main/existing-dir2/");
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("POST").withPath("/repositories/repo/branches/main/objects/copy").withQueryStringParameter("dest_path", new String[]{"existing-dir2/existing.src"}).withBody((Body)JsonBody.json((String)this.gson.toJson((Object)new ObjectCopyCreation().srcRef("main").srcPath("existing-dir1/existing.src"))))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(201)).withBody((BodyWithContentType)JsonBody.json((String)this.gson.toJson((Object)dstStats))));
        this.mockGetBranch("repo", "main");
        this.mockDeleteObject("repo", "main", "existing-dir1/existing.src");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("existing-dir1/").build(), new ObjectStats[0]);
        this.mockUploadObject("repo", "main", "existing-dir1/");
        Assert.assertTrue((boolean)this.fs.rename(src, dst));
    }

    @Test
    public void testRename_existingDirToNonExistingDirWithoutParent() throws IOException {
        Path fileInSrcDir = new Path("lakefs://repo/main/existing-dir/existing.src");
        Path srcDir = new Path("lakefs://repo/main/existing-dir");
        this.mockFilesInDir("repo", "main", "existing-dir", "existing.src");
        this.mockFileDoesNotExist("repo", "main", "x/non-existing-dir");
        this.mockFileDoesNotExist("repo", "main", "x/non-existing-dir/new");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("x/non-existing-dir/").build(), new ObjectStats[0]);
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("x/non-existing-dir/new/").build(), new ObjectStats[0]);
        this.mockStatObject("repo", "main", "x", this.makeObjectStats("x"));
        Path dst = new Path("lakefs://repo/main/x/non-existing-dir/new");
        Assert.assertFalse((boolean)this.fs.rename(srcDir, dst));
    }

    @Test
    public void testRename_existingDirToNonExistingDirWithParent() throws ApiException, IOException {
        Path fileInSrcDir = new Path("lakefs://repo/main/existing-dir/existing.src");
        Path srcDir = new Path("lakefs://repo/main/existing-dir");
        Path dst = new Path("lakefs://repo/main/existing-dir2/new");
        ObjectStats srcStats = this.makeObjectStats("existing-dir/existing.src");
        this.mockStatObjectNotFound("repo", "main", "existing-dir");
        this.mockStatObjectNotFound("repo", "main", "existing-dir/");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("existing-dir/").build(), srcStats);
        this.mockStatObjectNotFound("repo", "main", "existing-dir2");
        this.mockStatObject("repo", "main", "existing-dir2/", this.makeObjectStats("existing-dir2/"));
        this.mockStatObjectNotFound("repo", "main", "existing-dir2/new");
        this.mockStatObjectNotFound("repo", "main", "existing-dir2/new/");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("existing-dir2/new/").build(), new ObjectStats[0]);
        ObjectStats dstStats = this.makeObjectStats("existing-dir2/new/existing.src");
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("POST").withPath("/repositories/repo/branches/main/objects/copy").withQueryStringParameter("dest_path", new String[]{"existing-dir2/new/existing.src"}).withBody((Body)JsonBody.json((String)this.gson.toJson((Object)new ObjectCopyCreation().srcRef("main").srcPath("existing-dir/existing.src"))))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(201)).withBody((BodyWithContentType)JsonBody.json((String)this.gson.toJson((Object)dstStats))));
        this.mockDeleteObject("repo", "main", "existing-dir/existing.src");
        this.mockDeleteObject("repo", "main", "existing-dir2/");
        boolean renamed = this.fs.rename(srcDir, dst);
        Assert.assertTrue((boolean)renamed);
    }

    @Test
    public void testRename_existingDirToExistingNonEmptyDirName() throws IOException {
        Path firstSrcFile = new Path("lakefs://repo/main/existing-dir1/a.src");
        ObjectStats firstSrcFileStats = this.makeObjectStats("existing-dir1/a.src");
        Path secSrcFile = new Path("lakefs://repo/main/existing-dir1/b.src");
        ObjectStats secSrcFileStats = this.makeObjectStats("existing-dir1/b.src");
        Path srcDir = new Path("lakefs://repo/main/existing-dir1");
        this.mockStatObjectNotFound("repo", "main", "existing-dir1");
        this.mockStatObjectNotFound("repo", "main", "existing-dir1/");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("existing-dir1/").build(), firstSrcFileStats, secSrcFileStats);
        Path fileInDstDir = new Path("lakefs://repo/main/existing-dir2/file.dst");
        ObjectStats fileInDstDirStats = this.makeObjectStats("existing-dir2/file.dst");
        Path dstDir = new Path("lakefs://repo/main/existing-dir2");
        this.mockStatObjectNotFound("repo", "main", "existing-dir2");
        this.mockStatObjectNotFound("repo", "main", "existing-dir2/");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("existing-dir2/").build(), fileInDstDirStats);
        boolean renamed = this.fs.rename(srcDir, dstDir);
        Assert.assertFalse((boolean)renamed);
    }

    @Test
    public void testRename_srcAndDstOnDifferentBranch() throws IOException {
        Path src = new Path("lakefs://repo/branch/existing.src");
        Path dst = new Path("lakefs://repo/another-branch/existing.dst");
        boolean renamed = this.fs.rename(src, dst);
        Assert.assertFalse((boolean)renamed);
    }

    @Test
    public void testRename_srcEqualsDst() throws IOException {
        Path src = new Path("lakefs://repo/main/existing.src");
        Path dst = new Path("lakefs://repo/main/existing.src");
        boolean renamed = this.fs.rename(src, dst);
        Assert.assertTrue((boolean)renamed);
    }

    @Test
    public void testRename_nonExistingSrcFile() throws IOException {
        Path src = new Path("lakefs://repo/main/non-existing.src");
        this.mockStatObjectNotFound("repo", "main", "non-existing.src");
        this.mockStatObjectNotFound("repo", "main", "non-existing.src/");
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix("non-existing.src/").build(), new ObjectStats[0]);
        Path dst = new Path("lakefs://repo/main/existing.dst");
        this.mockStatObject("repo", "main", "existing.dst", this.makeObjectStats("existing.dst"));
        boolean success = this.fs.rename(src, dst);
        Assert.assertFalse((boolean)success);
    }

    @Test
    public void testGlobStatus_SingleFile() throws IOException {
        Path path = new Path("lakefs://repo/main/existing");
        this.mockStatObject("repo", "main", "existing", this.makeObjectStats("existing"));
        Object[] statuses = this.fs.globStatus(path);
        Assert.assertArrayEquals((Object[])new FileStatus[]{new LakeFSFileStatus.Builder(path).build()}, (Object[])statuses);
    }
}

