/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.lakefs.FSTestBase;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FSTestBase.Pagination", generator="Immutables")
@Immutable
public final class ImmutablePagination
implements FSTestBase.Pagination {
    private final Optional<Integer> amount;
    private final Optional<String> after;
    private final Optional<String> prefix;

    private ImmutablePagination(Optional<Integer> amount, Optional<String> after, Optional<String> prefix) {
        this.amount = amount;
        this.after = after;
        this.prefix = prefix;
    }

    private ImmutablePagination(ImmutablePagination original, Optional<Integer> amount, Optional<String> after, Optional<String> prefix) {
        this.amount = amount;
        this.after = after;
        this.prefix = prefix;
    }

    @Override
    public Optional<Integer> amount() {
        return this.amount;
    }

    @Override
    public Optional<String> after() {
        return this.after;
    }

    @Override
    public Optional<String> prefix() {
        return this.prefix;
    }

    public final ImmutablePagination withAmount(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.amount.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePagination(this, (Optional<Integer>)newValue, this.after, this.prefix);
    }

    public final ImmutablePagination withAmount(Optional<Integer> optional) {
        Optional<Integer> value = optional;
        if (this.amount.equals(value)) {
            return this;
        }
        return new ImmutablePagination(this, value, this.after, this.prefix);
    }

    public final ImmutablePagination withAfter(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.after.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePagination(this, this.amount, (Optional<String>)newValue, this.prefix);
    }

    public final ImmutablePagination withAfter(Optional<String> optional) {
        Optional<String> value = optional;
        if (this.after.equals(value)) {
            return this;
        }
        return new ImmutablePagination(this, this.amount, value, this.prefix);
    }

    public final ImmutablePagination withPrefix(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.prefix.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePagination(this, this.amount, this.after, (Optional<String>)newValue);
    }

    public final ImmutablePagination withPrefix(Optional<String> optional) {
        Optional<String> value = optional;
        if (this.prefix.equals(value)) {
            return this;
        }
        return new ImmutablePagination(this, this.amount, this.after, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePagination && this.equalTo(0, (ImmutablePagination)another);
    }

    private boolean equalTo(int synthetic, ImmutablePagination another) {
        return this.amount.equals(another.amount) && this.after.equals(another.after) && this.prefix.equals(another.prefix);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + this.after.hashCode();
        h += (h << 5) + this.prefix.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Pagination").omitNullValues().add("amount", this.amount.orNull()).add("after", this.after.orNull()).add("prefix", this.prefix.orNull()).toString();
    }

    public static ImmutablePagination of(Optional<Integer> amount, Optional<String> after, Optional<String> prefix) {
        return new ImmutablePagination(amount, after, prefix);
    }

    public static ImmutablePagination copyOf(FSTestBase.Pagination instance) {
        if (instance instanceof ImmutablePagination) {
            return (ImmutablePagination)instance;
        }
        return ImmutablePagination.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FSTestBase.Pagination", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private Optional<Integer> amount = Optional.absent();
        private Optional<String> after = Optional.absent();
        private Optional<String> prefix = Optional.absent();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FSTestBase.Pagination instance) {
            Optional<String> prefixOptional;
            Optional<String> afterOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Integer> amountOptional = instance.amount();
            if (amountOptional.isPresent()) {
                this.amount(amountOptional);
            }
            if ((afterOptional = instance.after()).isPresent()) {
                this.after(afterOptional);
            }
            if ((prefixOptional = instance.prefix()).isPresent()) {
                this.prefix(prefixOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder amount(int amount) {
            this.amount = Optional.of((Object)amount);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder amount(Optional<Integer> amount) {
            this.amount = amount;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder after(String after) {
            this.after = Optional.of((Object)after);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder after(Optional<String> after) {
            this.after = after;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prefix(String prefix) {
            this.prefix = Optional.of((Object)prefix);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prefix(Optional<String> prefix) {
            this.prefix = prefix;
            return this;
        }

        public ImmutablePagination build() {
            return new ImmutablePagination(null, this.amount, this.after, this.prefix);
        }
    }
}

