/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import io.lakefs.BulkDeleter;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.model.ObjectErrorList;
import io.lakefs.clients.sdk.model.PathList;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class BulkDeleterTest {
    protected ExecutorService executorService = Executors.newFixedThreadPool(3);

    @After
    public void shutdownExecutor() {
        this.executorService.shutdown();
    }

    @Test
    public void nothing() throws IOException {
        BulkDeleter deleter = new BulkDeleter(this.executorService, new BulkDeleter.Callback(){

            public ObjectErrorList apply(String repository, String branch, PathList pathList) throws ApiException {
                throw new ApiException("failed for testing");
            }
        }, "repo", "branch", 50);
        deleter.close();
    }

    protected void goodBulkCase(int bulkSize, int numPaths) throws IOException {
        HashSet<String> toDelete = new HashSet<String>();
        for (int i = 0; i < numPaths; ++i) {
            toDelete.add(String.format("%d", i));
        }
        Callback callback = new Callback(bulkSize, toDelete);
        BulkDeleter deleter = new BulkDeleter(this.executorService, (BulkDeleter.Callback)callback, "repo", "branch", 50);
        for (int i = 0; i < numPaths; ++i) {
            deleter.add(String.format("%d", i));
        }
        deleter.close();
        callback.verify();
    }

    @Test
    public void exactGoodBatches() throws IOException {
        this.goodBulkCase(50, 100);
    }

    @Test
    public void inexactGoodBatches() throws IOException {
        this.goodBulkCase(50, 103);
    }

    @Test
    public void exactGoodSingleBatch() throws IOException {
        this.goodBulkCase(50, 50);
    }

    @Test
    public void inexactGoodSingleBatch() throws IOException {
        this.goodBulkCase(50, 47);
    }

    @Test
    public void exactGoodManyBatches() throws IOException {
        this.goodBulkCase(50, 500);
    }

    @Test
    public void inexactGoodManyBatches() throws IOException {
        this.goodBulkCase(50, 493);
    }

    class Callback
    implements BulkDeleter.Callback {
        private int bulkSize;
        private Set<String> expected;

        Callback(int bulkSize, Set<String> expected) {
            this.bulkSize = bulkSize;
            this.expected = new HashSet<String>(expected);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectErrorList apply(String repository, String branch, PathList pathList) throws ApiException {
            Assert.assertNotNull((Object)pathList);
            Assert.assertTrue((String)String.format("expected at most %d paths but got %d", this.bulkSize, pathList.getPaths().size()), (pathList.getPaths().size() <= this.bulkSize ? 1 : 0) != 0);
            Set<String> set = this.expected;
            synchronized (set) {
                for (String p : pathList.getPaths()) {
                    Assert.assertTrue((boolean)this.expected.remove(p));
                }
            }
            return new ObjectErrorList();
        }

        public void verify() {
            Assert.assertEquals(Collections.emptySet(), this.expected);
        }
    }
}

