/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.storage;

import com.amazonaws.services.s3.model.ObjectMetadata;
import io.lakefs.LakeFSLinker;
import io.lakefs.storage.MetadataClient;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;

class LinkOnCloseOutputStream
extends OutputStream {
    private final URI physicalUri;
    private final MetadataClient metadataClient;
    private final OutputStream out;
    private final AtomicBoolean isLinked = new AtomicBoolean(false);
    private final LakeFSLinker linker;

    LinkOnCloseOutputStream(URI physicalUri, MetadataClient metadataClient, OutputStream out, LakeFSLinker linker) {
        this.physicalUri = physicalUri;
        this.metadataClient = metadataClient;
        this.out = out;
        this.linker = linker;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        if (!this.isLinked.getAndSet(true)) {
            ObjectMetadata objectMetadata = this.metadataClient.getObjectMetadata(this.physicalUri);
            this.linker.link(objectMetadata.getETag(), objectMetadata.getContentLength());
        }
    }
}

