/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import com.amazonaws.HttpMethod;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import io.lakefs.ImmutablePagination;
import io.lakefs.S3FSTestBase;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.model.ObjectStats;
import io.lakefs.clients.sdk.model.StagingLocation;
import io.lakefs.clients.sdk.model.StagingMetadata;
import io.lakefs.utils.ObjectLocation;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Path;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockserver.matchers.MatchType;
import org.mockserver.model.Body;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;
import org.mockserver.model.RequestDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class LakeFSFileSystemServerS3Test
extends S3FSTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(LakeFSFileSystemServerS3Test.class);
    @Parameterized.Parameter(value=1)
    public String unusedAddressCreatorType;
    @Parameterized.Parameter(value=0)
    public PhysicalAddressCreator pac;

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({new SimplePhysicalAddressCreator(), "simple"}, {new PresignedPhysicalAddressCreator(), "presigned"});
    }

    @Override
    protected void moreHadoopSetup() {
        super.moreHadoopSetup();
        this.pac.initConfiguration(this.conf);
    }

    protected StagingLocation mockGetPhysicalAddress(String repo, String branch, String path, String namespace) {
        StagingLocation stagingLocation = this.pac.createPutStagingLocation(this, namespace, repo, branch, path);
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("GET").withPath(String.format("/repositories/%s/branches/%s/staging/backing", repo, branch)).withQueryStringParameter("path", new String[]{path})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody(this.gson.toJson((Object)stagingLocation)));
        return stagingLocation;
    }

    @Test
    public void testCreate() throws IOException {
        String contents = "The quick brown fox jumps over the lazy dog.";
        long contentsLength = contents.getBytes().length;
        Path path = new Path("lakefs://repo/main/sub1/sub2/create.me");
        this.mockDirectoryMarker(ObjectLocation.pathToObjectLocation(null, (Path)path));
        StagingLocation stagingLocation = this.mockGetPhysicalAddress("repo", "main", "sub1/sub2/create.me", "repo-base/create");
        this.mockFileDoesNotExist("repo", "main", "sub1/sub2/create.me");
        this.mockStatObjectNotFound("repo", "main", "sub1/sub2/");
        ObjectStats newStats = this.makeObjectStats("sub1/sub2/create.me").pathType(ObjectStats.PathTypeEnum.OBJECT).physicalAddress(stagingLocation.getPhysicalAddress()).checksum("unused").mtime(UNUSED_MTIME).sizeBytes(UNUSED_FILE_SIZE);
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("PUT").withPath("/repositories/repo/branches/main/staging/backing").withBody((Body)JsonBody.json((String)this.gson.toJson((Object)new StagingMetadata().staging(stagingLocation).sizeBytes(Long.valueOf(contentsLength))), (MatchType)MatchType.ONLY_MATCHING_FIELDS))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody(this.gson.toJson((Object)newStats)));
        this.mockDeleteObject("repo", "main", "sub1/sub2/");
        FSDataOutputStream out = this.fs.create(path);
        out.write(contents.getBytes());
        out.close();
        this.assertS3Object(stagingLocation, contents);
    }

    @Test
    public void testMkdirs() throws IOException {
        Path path = new Path("dir1/dir2/dir3");
        for (Path p = new Path(path.toString()); p != null && !p.isRoot(); p = p.getParent()) {
            this.mockStatObjectNotFound("repo", "main", p.toString());
            this.mockStatObjectNotFound("repo", "main", p + "/");
            this.mockListing("repo", "main", ImmutablePagination.builder().prefix(p + "/").build(), new ObjectStats[0]);
        }
        StagingLocation stagingLocation = this.mockGetPhysicalAddress("repo", "main", "dir1/dir2/dir3/", "repo-base/emptyDir");
        ObjectStats newStats = this.makeObjectStats("dir1/dir2/dir3/").physicalAddress(this.pac.createGetPhysicalAddress(this, "repo-base/dir12"));
        this.mockStatObject("repo", "main", "dir1/dir2/dir3/", newStats);
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("PUT").withPath("/repositories/repo/branches/main/staging/backing").withQueryStringParameter("path", new String[]{"dir1/dir2/dir3/"}).withBody((Body)JsonBody.json((String)this.gson.toJson((Object)new StagingMetadata().staging(stagingLocation).sizeBytes(Long.valueOf(0L))), (MatchType)MatchType.ONLY_MATCHING_FIELDS))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody(this.gson.toJson((Object)newStats)));
        Assert.assertTrue((boolean)this.fs.mkdirs(new Path("lakefs://repo/main/", path)));
        this.assertS3Object(stagingLocation, "");
    }

    @Test
    public void testCreateExistingDirectory() throws IOException {
        Path path = new Path("lakefs://repo/main/sub1/sub2/create.me");
        this.mockStatObjectNotFound("repo", "main", "sub1/sub2/create.me");
        ObjectStats stats = this.makeObjectStats("sub1/sub2/create.me/").physicalAddress(this.pac.createGetPhysicalAddress(this, "repo-base/sub1/sub2/create.me"));
        this.mockStatObject("repo", "main", "sub1/sub2/create.me/", stats);
        Exception e = (Exception)Assert.assertThrows(FileAlreadyExistsException.class, () -> this.fs.create(path, false));
        Assert.assertThat((Object)e.getMessage(), (Matcher)new StringContains("is a directory"));
    }

    @Test
    public void testCreateExistingFile() throws IOException {
        Path path = new Path("lakefs://repo/main/sub1/sub2/create.me");
        ObjectLocation dir = new ObjectLocation("lakefs", "repo", "main", "sub1/sub2");
        this.mockStatObject("repo", "main", "sub1/sub2/create.me", this.makeObjectStats("sub1/sub2/create.me"));
        Exception e = (Exception)Assert.assertThrows(FileAlreadyExistsException.class, () -> this.fs.create(path, false));
        Assert.assertThat((Object)e.getMessage(), (Matcher)new StringContains("already exists"));
    }

    @Test
    public void testOpen() throws IOException, ApiException {
        String contents = "The quick brown fox jumps over the lazy dog.";
        byte[] contentsBytes = contents.getBytes();
        String physicalPath = this.sessionId() + "/repo-base/open";
        String physicalKey = this.pac.createGetPhysicalAddress(this, physicalPath);
        int readBufferSize = 5;
        Path path = new Path("lakefs://repo/main/read.me");
        this.mockStatObject("repo", "main", "read.me", this.makeObjectStats("read.me").physicalAddress(physicalKey).checksum("unused").mtime(UNUSED_MTIME).sizeBytes(Long.valueOf(contentsBytes.length)));
        ObjectMetadata s3Metadata = new ObjectMetadata();
        s3Metadata.setContentLength((long)contentsBytes.length);
        this.s3Client.putObject(this.s3Bucket, physicalPath, (InputStream)new ByteArrayInputStream(contentsBytes), s3Metadata);
        try (FSDataInputStream in = this.fs.open(path, readBufferSize);){
            String actual = IOUtils.toString((InputStream)in);
            Assert.assertEquals((Object)contents, (Object)actual);
        }
        catch (Exception e) {
            String actualFiles = String.join((CharSequence)", ", this.getS3FilesByPrefix(""));
            throw new RuntimeException("Files " + actualFiles + "; read " + path.toString() + " from " + physicalKey, e);
        }
    }

    @Test
    public void testOpenWithInvalidUriChars() throws IOException, ApiException {
        String[] suffixes;
        String contents = "The quick brown fox jumps over the lazy dog.";
        byte[] contentsBytes = contents.getBytes();
        int readBufferSize = 5;
        for (String suffix : suffixes = new String[]{"with space/open", "wi:th$cha&rs#/%op;e?n", "\u05e2\u05db\u05e9\u05d9\u05d5/\u05d1\u05e2\u05d1\u05e8\u05d9\u05ea/open", "\ud83e\udd2f/imoji/open"}) {
            String key = "/repo-base/" + suffix;
            ObjectMetadata s3Metadata = new ObjectMetadata();
            s3Metadata.setContentLength((long)contentsBytes.length);
            this.s3Client.putObject(new PutObjectRequest(this.s3Bucket, key, (InputStream)new ByteArrayInputStream(contentsBytes), s3Metadata));
            String path = String.format("lakefs://repo/main/%s-x", suffix);
            ObjectStats stats = this.makeObjectStats(suffix + "-x").physicalAddress(this.pac.createGetPhysicalAddress(this, key)).sizeBytes(Long.valueOf(contentsBytes.length));
            this.mockStatObject("repo", "main", suffix + "-x", stats);
            try (FSDataInputStream in = this.fs.open(new Path(path), readBufferSize);){
                String actual = IOUtils.toString((InputStream)in);
                Assert.assertEquals((Object)contents, (Object)actual);
            }
        }
    }

    @Test
    public void testOpen_NotExists() throws IOException, ApiException {
        Path path = new Path("lakefs://repo/main/doesNotExi.st");
        this.mockStatObjectNotFound("repo", "main", "doesNotExi.st");
        Assert.assertThrows(FileNotFoundException.class, () -> this.fs.open(path));
    }

    private static class PresignedPhysicalAddressCreator
    implements PhysicalAddressCreator {
        private PresignedPhysicalAddressCreator() {
        }

        @Override
        public void initConfiguration(Configuration conf) {
            conf.set("fs.lakefs.access.mode", "presigned");
        }

        protected Date getExpiration() {
            return new Date(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L));
        }

        @Override
        public String createGetPhysicalAddress(S3FSTestBase o, String key) {
            Date expiration = this.getExpiration();
            URL presignedUrl = o.s3Client.generatePresignedUrl(new GeneratePresignedUrlRequest(o.s3Bucket, key).withMethod(HttpMethod.GET).withExpiration(expiration));
            return presignedUrl.toString();
        }

        @Override
        public StagingLocation createPutStagingLocation(S3FSTestBase o, String namespace, String repo, String branch, String path) {
            String fullPath = String.format("%s/%s/%s/%s/%s-object", o.sessionId(), namespace, repo, branch, path);
            Date expiration = this.getExpiration();
            URL presignedUrl = o.s3Client.generatePresignedUrl(new GeneratePresignedUrlRequest(o.s3Bucket, fullPath).withMethod(HttpMethod.PUT).withExpiration(expiration));
            return new StagingLocation().physicalAddress(o.s3Url(fullPath)).presignedUrl(presignedUrl.toString());
        }
    }

    private static class SimplePhysicalAddressCreator
    implements PhysicalAddressCreator {
        private SimplePhysicalAddressCreator() {
        }

        @Override
        public String createGetPhysicalAddress(S3FSTestBase o, String key) {
            return o.s3Url(key);
        }

        @Override
        public StagingLocation createPutStagingLocation(S3FSTestBase o, String namespace, String repo, String branch, String path) {
            String fullPath = String.format("%s/%s/%s/%s/%s-object", o.sessionId(), namespace, repo, branch, path);
            return new StagingLocation().physicalAddress(o.s3Url(fullPath));
        }
    }

    public static interface PhysicalAddressCreator {
        default public void initConfiguration(Configuration conf) {
        }

        public String createGetPhysicalAddress(S3FSTestBase var1, String var2);

        public StagingLocation createPutStagingLocation(S3FSTestBase var1, String var2, String var3, String var4, String var5);
    }
}

