/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import com.aventrix.jnanoid.jnanoid.NanoIdUtils;
import com.google.common.base.Optional;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.lakefs.ImmutablePagination;
import io.lakefs.LakeFSFileSystem;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.model.ObjectError;
import io.lakefs.clients.sdk.model.ObjectErrorList;
import io.lakefs.clients.sdk.model.ObjectStats;
import io.lakefs.clients.sdk.model.ObjectStatsList;
import io.lakefs.clients.sdk.model.PathList;
import io.lakefs.clients.sdk.model.Ref;
import io.lakefs.clients.sdk.model.Repository;
import io.lakefs.clients.sdk.model.StagingLocation;
import io.lakefs.clients.sdk.model.StorageConfig;
import io.lakefs.utils.ObjectLocation;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.immutables.value.Value;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.mockserver.client.MockServerClient;
import org.mockserver.junit.MockServerRule;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.model.Cookie;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RequestDefinition;

public abstract class FSTestBase {
    protected static final Long UNUSED_FILE_SIZE = 1L;
    protected static final Long UNUSED_MTIME = 0L;
    protected static final String UNUSED_CHECKSUM = "unused";
    protected static final Long STATUS_FILE_SIZE = 2L;
    protected static final Long STATUS_MTIME = 123456789L;
    protected static final String STATUS_CHECKSUM = "status";
    protected Configuration conf;
    protected final LakeFSFileSystem fs = new LakeFSFileSystem();
    protected String s3Base;
    protected String s3Bucket;
    protected static final String S3_ACCESS_KEY_ID = "AKIArootkey";
    protected static final String S3_SECRET_ACCESS_KEY = "secret/minio/key=";
    protected static final ApiException noSuchFile = new ApiException(404, "no such file");
    protected final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    @Rule
    public MockServerRule mockServerRule = new MockServerRule((Object)this);
    protected MockServerClient mockServerClient;
    @Rule
    public TestName name = new TestName();

    protected String sessionId() {
        return this.name.getMethodName();
    }

    protected HttpRequest request() {
        return HttpRequest.request().withCookie(new Cookie("sessionId", this.sessionId()));
    }

    protected static String makeS3BucketName() {
        String slug = NanoIdUtils.randomNanoId((Random)NanoIdUtils.DEFAULT_NUMBER_GENERATOR, (char[])"abcdefghijklmnopqrstuvwxyz-0123456789".toCharArray(), (int)14);
        return String.format("bucket-%s-x", slug);
    }

    protected String s3Url(String s3Path) {
        return this.s3Base + s3Path;
    }

    protected String getS3Key(StagingLocation stagingLocation) {
        return StringUtils.removeStart((String)stagingLocation.getPhysicalAddress(), (String)this.s3Base);
    }

    protected void addHadoopConfiguration(Configuration conf) {
    }

    @Before
    public void hadoopSetup() throws IOException, URISyntaxException {
        this.s3Base = "s3a://UNUSED/";
        this.conf = new Configuration(false);
        this.addHadoopConfiguration(this.conf);
        this.conf.set("fs.lakefs.impl", "io.lakefs.LakeFSFileSystem");
        this.conf.set("fs.lakefs.access.key", "unused-but-checked");
        this.conf.set("fs.lakefs.secret.key", "unused-but-checked");
        this.conf.set("fs.lakefs.endpoint", String.format("http://localhost:%d/", this.mockServerClient.getPort()));
        this.conf.set("fs.lakefs.session_id", this.sessionId());
        System.setProperty("hadoop.home.dir", "/");
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("GET").withPath("/config/storage"), Times.unlimited()).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody(this.gson.toJson((Object)new StorageConfig().blockstoreType("s3").blockstoreNamespaceExample("/not/really").blockstoreNamespaceValidityRegex(".*").preSignSupport(Boolean.valueOf(false)).preSignSupportUi(Boolean.valueOf(false)).importSupport(Boolean.valueOf(false)).importValidityRegex(".*"))));
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("GET").withPath("/repositories/repo")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody(this.gson.toJson((Object)new Repository().id("repo").creationDate(Long.valueOf(1234L)).defaultBranch("main").storageNamespace("s3a://FIX/ME?"))));
        this.mockServerClient.when((RequestDefinition)this.request(), Times.unlimited(), TimeToLive.unlimited(), Integer.valueOf(-10000)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(418)));
        this.moreHadoopSetup();
        this.fs.initialize(new URI("lakefs://repo/main/file.txt"), this.conf);
    }

    protected void moreHadoopSetup() {
    }

    protected ObjectStats makeObjectStats(String path) {
        return new ObjectStats().pathType(ObjectStats.PathTypeEnum.OBJECT).path(path).checksum(UNUSED_CHECKSUM).physicalAddress("physical://unused/" + path).mtime(UNUSED_MTIME);
    }

    protected void mockStatObjectNotFound(String repo, String ref, String path) {
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("GET").withPath(String.format("/repositories/%s/refs/%s/objects/stat", repo, ref)).withQueryStringParameter("path", new String[]{path})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(404)).withBody(String.format("{message: \"%s/%s/%s not found\"}", repo, ref, path, this.sessionId())));
    }

    protected void mockStatObject(String repo, String ref, String path, ObjectStats stats) {
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("GET").withPath(String.format("/repositories/%s/refs/%s/objects/stat", repo, ref)).withQueryStringParameter("path", new String[]{path})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody(this.gson.toJson((Object)stats)));
    }

    protected void mockFileDoesNotExist(String repo, String ref, String path) {
        this.mockStatObjectNotFound(repo, ref, path);
        this.mockStatObjectNotFound(repo, ref, path + "/");
    }

    protected void mockFilesInDir(String repo, String main, String dir, String ... files) {
        ObjectStats[] allStats;
        if (files.length == 0) {
            Path dirPath = new Path(String.format("lakefs://%s/%s/%s", repo, main, dir));
            ObjectLocation dirLoc = ObjectLocation.pathToObjectLocation((Path)dirPath);
            ObjectStats dirStats = this.mockDirectoryMarker(dirLoc);
            allStats = new ObjectStats[]{dirStats};
        } else {
            this.mockStatObjectNotFound(repo, main, dir);
            this.mockStatObjectNotFound(repo, main, dir + "/");
            allStats = new ObjectStats[files.length];
            for (int i = 0; i < files.length; ++i) {
                allStats[i] = this.makeObjectStats(dir + "/" + files[i]);
            }
        }
        this.mockListing("repo", "main", ImmutablePagination.builder().prefix(dir + "/").build(), allStats);
    }

    protected void mockUploadObject(String repo, String branch, String path) {
        ObjectStats uploadedStats = this.makeObjectStats(path).physicalAddress(this.s3Url(String.format("repo-base/dir-marker/%s/%s/%s/%s", this.sessionId(), repo, branch, path)));
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("POST").withPath(String.format("/repositories/%s/branches/%s/objects", repo, branch)).withQueryStringParameter("path", new String[]{path})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody(this.gson.toJson((Object)uploadedStats)));
    }

    protected void mockGetBranch(String repo, String branch) {
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("GET").withPath(String.format("/repositories/%s/branches/%s", repo, branch))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody(this.gson.toJson((Object)new Ref().id("123").commitId("456"))));
    }

    protected void mockDeleteObject(String repo, String branch, String path) {
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("DELETE").withPath(String.format("/repositories/%s/branches/%s/objects", repo, branch)).withQueryStringParameter("path", new String[]{path})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(204)));
    }

    protected void mockDeleteObjectNotFound(String repo, String branch, String path) {
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("DELETE").withPath(String.format("/repositories/%s/branches/%s/objects", repo, branch)).withQueryStringParameter("path", new String[]{path})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(404)));
    }

    protected void mockDeleteObjects(String repo, String branch, String path, ObjectError ... errors) {
        PathList pathList = new PathList().addPathsItem(path);
        this.mockDeleteObjects(repo, branch, pathList, errors);
    }

    protected void mockDeleteObjects(String repo, String branch, PathList pathList, ObjectError ... errors) {
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("POST").withPath(String.format("/repositories/%s/branches/%s/objects/delete", repo, branch)).withBody(this.gson.toJson((Object)pathList)), Times.once()).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody(this.gson.toJson((Object)new ObjectErrorList().errors(Arrays.asList(errors)))));
    }

    protected ObjectStats mockDirectoryMarker(ObjectLocation objectLoc) {
        ObjectStats markerStats = this.makeObjectStats(objectLoc.getPath()).pathType(ObjectStats.PathTypeEnum.OBJECT);
        this.mockServerClient.when((RequestDefinition)this.request().withMethod("GET").withPath(String.format("/repositories/%s/refs/%s/objects/stat", objectLoc.getRepository(), objectLoc.getRef())).withQueryStringParameter("path", new String[]{objectLoc.getPath()})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody(this.gson.toJson((Object)markerStats)));
        return markerStats;
    }

    protected void mockListing(String repo, String ref, ImmutablePagination pagination, ObjectStats ... stats) {
        this.mockListingWithHasMore(repo, ref, pagination, false, stats);
    }

    protected void mockListingWithHasMore(String repo, String ref, ImmutablePagination pagination, boolean hasMore, ObjectStats ... stats) {
        HttpRequest req = this.request().withMethod("GET").withPath(String.format("/repositories/%s/refs/%s/objects/ls", repo, ref));
        if (pagination.after().isPresent()) {
            req = req.withQueryStringParameter("after", new String[]{(String)pagination.after().or((Object)"")});
        }
        if (pagination.amount().isPresent()) {
            req = req.withQueryStringParameter("amount", new String[]{((Integer)pagination.amount().get()).toString()});
        }
        if (pagination.prefix().isPresent()) {
            req = req.withQueryStringParameter("prefix", new String[]{(String)pagination.prefix().or((Object)"")});
        }
        ObjectStatsList resp = new ObjectStatsList().results(Arrays.asList(stats)).pagination(new io.lakefs.clients.sdk.model.Pagination().hasMore(Boolean.valueOf(hasMore)).maxPerPage(Integer.valueOf(10000)).results(Integer.valueOf(stats.length)).nextOffset("zz"));
        this.mockServerClient.when((RequestDefinition)req).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)).withBody(this.gson.toJson((Object)resp)));
    }

    @Value.Immutable
    public static interface Pagination {
        @Value.Parameter
        public Optional<Integer> amount();

        @Value.Parameter
        public Optional<String> after();

        @Value.Parameter
        public Optional<String> prefix();
    }
}

