/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import io.lakefs.FSConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class FSConfigurationTest {
    @Test
    public void testGet() {
        Configuration conf = new Configuration(false);
        conf.set("fs.lakefs.key1", "lakefs1");
        conf.set("fs.scheme.key1", "scheme1");
        conf.set("fs.lakefs.key2", "lakefs2");
        conf.set("fs.scheme.key3", "scheme3");
        Assert.assertEquals((Object)"lakefs1", (Object)FSConfiguration.get((Configuration)conf, (String)"lakefs", (String)"key1"));
        Assert.assertEquals((Object)"lakefs1", (Object)FSConfiguration.get((Configuration)conf, (String)"lakefs", (String)"key1", (String)"default"));
        Assert.assertEquals((Object)"scheme1", (Object)FSConfiguration.get((Configuration)conf, (String)"scheme", (String)"key1"));
        Assert.assertEquals((Object)"scheme1", (Object)FSConfiguration.get((Configuration)conf, (String)"scheme", (String)"key1", (String)"default"));
        Assert.assertEquals((Object)"lakefs2", (Object)FSConfiguration.get((Configuration)conf, (String)"scheme", (String)"key2"));
        Assert.assertEquals((Object)"lakefs2", (Object)FSConfiguration.get((Configuration)conf, (String)"scheme", (String)"key2", (String)"default"));
        Assert.assertEquals((Object)"lakefs2", (Object)FSConfiguration.get((Configuration)conf, (String)"lakefs", (String)"key2"));
        Assert.assertEquals((Object)"lakefs2", (Object)FSConfiguration.get((Configuration)conf, (String)"lakefs", (String)"key2", (String)"default"));
        Assert.assertEquals((Object)"scheme3", (Object)FSConfiguration.get((Configuration)conf, (String)"scheme", (String)"key3"));
        Assert.assertEquals((Object)"scheme3", (Object)FSConfiguration.get((Configuration)conf, (String)"scheme", (String)"key3", (String)"default"));
        Assert.assertNull((Object)FSConfiguration.get((Configuration)conf, (String)"lakefs", (String)"key3"));
        Assert.assertEquals((Object)"default", (Object)FSConfiguration.get((Configuration)conf, (String)"lakefs", (String)"key3", (String)"default"));
        Assert.assertNull((Object)FSConfiguration.get((Configuration)conf, (String)"lakefs", (String)"missing"));
        Assert.assertEquals((Object)"default", (Object)FSConfiguration.get((Configuration)conf, (String)"lakefs", (String)"missing", (String)"default"));
    }

    @Test
    public void testGetInt() {
        Configuration conf = new Configuration(false);
        conf.setInt("fs.lakefs.key1", 1);
        conf.setInt("fs.scheme.key1", 11);
        conf.setInt("fs.lakefs.key2", 2);
        conf.setInt("fs.scheme.key3", 33);
        conf.set("fs.lakefs.bad.key", "bad");
        Assert.assertEquals((long)1L, (long)FSConfiguration.getInt((Configuration)conf, (String)"lakefs", (String)"key1", (int)99));
        Assert.assertEquals((long)11L, (long)FSConfiguration.getInt((Configuration)conf, (String)"scheme", (String)"key1", (int)99));
        Assert.assertEquals((long)2L, (long)FSConfiguration.getInt((Configuration)conf, (String)"scheme", (String)"key2", (int)99));
        Assert.assertEquals((long)2L, (long)FSConfiguration.getInt((Configuration)conf, (String)"lakefs", (String)"key2", (int)99));
        Assert.assertEquals((long)33L, (long)FSConfiguration.getInt((Configuration)conf, (String)"scheme", (String)"key3", (int)99));
        Assert.assertEquals((long)99L, (long)FSConfiguration.getInt((Configuration)conf, (String)"lakefs", (String)"key3", (int)99));
        Assert.assertEquals((long)99L, (long)FSConfiguration.getInt((Configuration)conf, (String)"lakefs", (String)"missing", (int)99));
        Assert.assertThrows(NumberFormatException.class, () -> FSConfiguration.getInt((Configuration)conf, (String)"lakefs", (String)"bad.key", (int)99));
    }
}

