/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.storage;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;

public class PhysicalAddressTranslator {
    private String blockstoreType;
    private String validityRegex;

    public PhysicalAddressTranslator(String blockstoreType, String validityRegex) {
        this.blockstoreType = blockstoreType;
        this.validityRegex = validityRegex;
    }

    public Path translate(String address) throws URISyntaxException {
        if (!Pattern.compile(this.validityRegex).matcher(address).find()) {
            throw new RuntimeException(String.format("address %s does not match blockstore namespace regex %s", address, this.validityRegex));
        }
        URI uri = new Path(address).toUri();
        switch (this.blockstoreType) {
            case "s3": {
                return new Path(new URI("s3a", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()));
            }
        }
        throw new RuntimeException(String.format("lakeFS blockstore type %s unsupported by this FileSystem", this.blockstoreType));
    }
}

