/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import org.apache.hadoop.conf.Configuration;

public final class FSConfiguration {
    private static String formatFSConfigurationKey(String scheme, String key) {
        return "fs." + scheme + "." + key;
    }

    public static String get(Configuration conf, String scheme, String keySuffix) {
        String key = FSConfiguration.formatFSConfigurationKey(scheme, keySuffix);
        String value = conf.get(key);
        if (value == null && !scheme.equals("lakefs")) {
            key = FSConfiguration.formatFSConfigurationKey("lakefs", keySuffix);
            value = conf.get(key);
        }
        return value;
    }

    public static String get(Configuration conf, String scheme, String keySuffix, String defaultValue) {
        String value = FSConfiguration.get(conf, scheme, keySuffix);
        return value == null ? defaultValue : value;
    }

    public static int getInt(Configuration conf, String scheme, String keySuffix, int defaultValue) {
        String valueString = FSConfiguration.get(conf, scheme, keySuffix);
        return valueString == null ? defaultValue : Integer.parseInt(valueString);
    }
}

