/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.storage;

import io.lakefs.LakeFSClient;
import io.lakefs.LakeFSFileSystem;
import io.lakefs.LakeFSLinker;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ObjectsApi;
import io.lakefs.clients.sdk.StagingApi;
import io.lakefs.clients.sdk.model.ObjectStats;
import io.lakefs.clients.sdk.model.StagingLocation;
import io.lakefs.storage.CreateOutputStreamParams;
import io.lakefs.storage.HttpRangeInputStream;
import io.lakefs.storage.LakeFSFileSystemOutputStream;
import io.lakefs.storage.StorageAccessStrategy;
import io.lakefs.utils.ObjectLocation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;

public class PresignedStorageAccessStrategy
implements StorageAccessStrategy {
    private LakeFSFileSystem lakeFSFileSystem;
    private LakeFSClient lfsClient;

    public PresignedStorageAccessStrategy(LakeFSFileSystem lakeFSFileSystem, LakeFSClient lfsClient) {
        this.lakeFSFileSystem = lakeFSFileSystem;
        this.lfsClient = lfsClient;
    }

    @Override
    public FSDataOutputStream createDataOutputStream(ObjectLocation objectLocation, CreateOutputStreamParams params) throws ApiException, IOException {
        StagingApi stagingApi = this.lfsClient.getStagingApi();
        StagingLocation stagingLocation = stagingApi.getPhysicalAddress(objectLocation.getRepository(), objectLocation.getRef(), objectLocation.getPath()).presign(Boolean.valueOf(true)).execute();
        URL presignedUrl = new URL(stagingLocation.getPresignedUrl());
        HttpURLConnection connection = (HttpURLConnection)presignedUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setRequestMethod("PUT");
        LakeFSLinker linker = new LakeFSLinker(this.lakeFSFileSystem, this.lfsClient, objectLocation, stagingLocation);
        LakeFSFileSystemOutputStream out = new LakeFSFileSystemOutputStream(connection, linker);
        return new FSDataOutputStream((OutputStream)out, null);
    }

    @Override
    public FSDataInputStream createDataInputStream(ObjectLocation objectLocation, int bufSize) throws ApiException, IOException {
        ObjectsApi objectsApi = this.lfsClient.getObjectsApi();
        ObjectStats stats = objectsApi.statObject(objectLocation.getRepository(), objectLocation.getRef(), objectLocation.getPath()).userMetadata(Boolean.valueOf(false)).presign(Boolean.valueOf(true)).execute();
        return new FSDataInputStream((InputStream)((Object)new HttpRangeInputStream(stats.getPhysicalAddress(), bufSize)));
    }
}

