/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.storage;

import io.lakefs.LakeFSClient;
import io.lakefs.LakeFSFileSystem;
import io.lakefs.LakeFSLinker;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ObjectsApi;
import io.lakefs.clients.sdk.StagingApi;
import io.lakefs.clients.sdk.model.ObjectStats;
import io.lakefs.clients.sdk.model.StagingLocation;
import io.lakefs.storage.CreateOutputStreamParams;
import io.lakefs.storage.LinkOnCloseOutputStream;
import io.lakefs.storage.MetadataClient;
import io.lakefs.storage.PhysicalAddressTranslator;
import io.lakefs.storage.StorageAccessStrategy;
import io.lakefs.utils.ObjectLocation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class SimpleStorageAccessStrategy
implements StorageAccessStrategy {
    private PhysicalAddressTranslator physicalAddressTranslator;
    private LakeFSFileSystem lakeFSFileSystem;
    private LakeFSClient lfsClient;
    private Configuration conf;

    public SimpleStorageAccessStrategy(LakeFSFileSystem lakeFSFileSystem, LakeFSClient lfsClient, Configuration conf, PhysicalAddressTranslator physicalAddressTranslator) {
        this.lakeFSFileSystem = lakeFSFileSystem;
        this.lfsClient = lfsClient;
        this.conf = conf;
        this.physicalAddressTranslator = physicalAddressTranslator;
    }

    @Override
    public FSDataOutputStream createDataOutputStream(ObjectLocation objectLocation, CreateOutputStreamParams params) throws ApiException, IOException {
        Path physicalPath;
        StagingApi staging = this.lfsClient.getStagingApi();
        StagingLocation stagingLocation = staging.getPhysicalAddress(objectLocation.getRepository(), objectLocation.getRef(), objectLocation.getPath()).presign(Boolean.valueOf(false)).execute();
        try {
            physicalPath = this.physicalAddressTranslator.translate(Objects.requireNonNull(stagingLocation.getPhysicalAddress()));
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to parse object phystical address", e);
        }
        FileSystem physicalFs = physicalPath.getFileSystem(this.conf);
        FSDataOutputStream physicalOut = params != null ? physicalFs.create(physicalPath, false, params.bufferSize, physicalFs.getDefaultReplication(physicalPath), params.blockSize) : physicalFs.create(physicalPath);
        MetadataClient metadataClient = new MetadataClient(physicalFs);
        LakeFSLinker linker = new LakeFSLinker(this.lakeFSFileSystem, this.lfsClient, objectLocation, stagingLocation);
        LinkOnCloseOutputStream out = new LinkOnCloseOutputStream(physicalPath.toUri(), metadataClient, (OutputStream)physicalOut, linker);
        return new FSDataOutputStream((OutputStream)out, null);
    }

    @Override
    public FSDataInputStream createDataInputStream(ObjectLocation objectLocation, int bufSize) throws ApiException, IOException {
        Path physicalPath;
        ObjectsApi objects = this.lfsClient.getObjectsApi();
        ObjectStats stats = objects.statObject(objectLocation.getRepository(), objectLocation.getRef(), objectLocation.getPath()).userMetadata(Boolean.valueOf(false)).presign(Boolean.valueOf(false)).execute();
        try {
            physicalPath = this.physicalAddressTranslator.translate(Objects.requireNonNull(stats.getPhysicalAddress()));
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to parse object physical address", e);
        }
        FileSystem physicalFs = physicalPath.getFileSystem(this.conf);
        return physicalFs.open(physicalPath, bufSize);
    }
}

